/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.core.connection;

import java.util.Properties;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.tests.core.RSECoreTestCase;
import org.eclipse.rse.tests.core.connection.IRSEConnectionManager;
import org.eclipse.rse.tests.core.connection.IRSEConnectionProperties;
import org.eclipse.rse.tests.internal.RSEConnectionManager;

public class RSEBaseConnectionTestCase
extends RSECoreTestCase {
    private final IRSEConnectionManager connectionManager = new RSEConnectionManager();
    private final IRSEConnectionProperties localSystemConnectionProperties;

    public RSEBaseConnectionTestCase() {
        this(null);
    }

    public RSEBaseConnectionTestCase(String name) {
        super(name);
        Properties properties = new Properties();
        properties.setProperty("system_type_id", "org.eclipse.rse.systemtype.local");
        properties.setProperty("address", "localhost");
        properties.setProperty("name", "Local");
        this.localSystemConnectionProperties = this.getConnectionManager().loadConnectionProperties(properties, false);
    }

    protected IRSEConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    protected IHost getLocalSystemConnection() {
        RSEBaseConnectionTestCase.assertNotNull((String)"Local system connection properties are not available!", (Object)this.localSystemConnectionProperties);
        Exception exception = null;
        String cause = null;
        IHost connection = null;
        try {
            connection = this.getConnectionManager().findOrCreateConnection(this.localSystemConnectionProperties);
        }
        catch (Exception e) {
            exception = e;
            cause = exception.getLocalizedMessage();
        }
        RSEBaseConnectionTestCase.assertNull((String)("Failed to find and create local system connection! Possible cause: " + cause), (Object)exception);
        RSEBaseConnectionTestCase.assertNotNull((String)"Failed to find and create local system connection! Cause unknown!", (Object)connection);
        return connection;
    }

    protected IHost getRemoteSystemConnection(String systemTypeID, String systemAddress, String systemName, String userID, String password) {
        Exception exception = null;
        String cause = null;
        Properties properties = new Properties();
        properties.setProperty("system_type_id", systemTypeID);
        properties.setProperty("address", systemAddress);
        properties.setProperty("name", systemName);
        properties.setProperty("userid", userID);
        properties.setProperty("password", password);
        IRSEConnectionProperties remoteSystemConnectionProperties = this.getConnectionManager().loadConnectionProperties(properties, false);
        IHost connection = null;
        try {
            connection = this.getConnectionManager().findOrCreateConnection(remoteSystemConnectionProperties);
        }
        catch (Exception e) {
            exception = e;
            cause = exception.getLocalizedMessage();
        }
        RSEBaseConnectionTestCase.assertNull((String)("Failed to find and create remote system connection! Possible cause: " + cause), (Object)exception);
        RSEBaseConnectionTestCase.assertNotNull((String)"Failed to find and create remote system connection! Cause unknown!", (Object)connection);
        return connection;
    }
}

