/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.actions;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.swt.widgets.Shell;

public class SystemWorkOfflineAction
extends SystemBaseAction {
    public SystemWorkOfflineAction(Shell shell) {
        super(SystemResources.RESID_OFFLINE_WORKOFFLINE_LABEL, SystemResources.RESID_OFFLINE_WORKOFFLINE_TOOLTIP, shell);
        this.allowOnMultipleSelection(false);
        this.setContextMenuGroup("group.connection");
        this.setHelp("org.eclipse.rse.ui.wofa0000");
    }

    public boolean checkObjectType(Object obj) {
        return obj instanceof IHost;
    }

    public void run() {
        IHost conn = (IHost)this.getFirstSelection();
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        if (conn.isOffline()) {
            this.setChecked(false);
            sr.setHostOffline(conn, false);
        } else {
            sr.setHostOffline(conn, true);
            this.setChecked(true);
            ISubSystem[] subsystems = sr.getSubSystems(conn);
            if (subsystems != null) {
                boolean cancelled = false;
                int i = 0;
                while (i < subsystems.length && !cancelled) {
                    try {
                        subsystems[i].disconnect(false);
                    }
                    catch (InterruptedException interruptedException) {
                        cancelled = true;
                    }
                    catch (Exception e) {
                        SystemBasePlugin.logError("SystemWorkOfflineAction.run", e);
                    }
                    ++i;
                }
            }
            if (sr.isAnySubSystemConnected(conn) && !conn.getSystemType().isLocal()) {
                this.setChecked(false);
                sr.setHostOffline(conn, false);
            }
        }
    }

    public boolean updateSelection(IStructuredSelection selection) {
        if (super.updateSelection(selection)) {
            this.setChecked(((IHost)selection.getFirstElement()).isOffline());
            return true;
        }
        return false;
    }
}

