/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.internal.model;

import java.util.Vector;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.ISystemResourceChangeListener;
import org.eclipse.rse.ui.internal.model.SystemPostableEventNotifier;

public class SystemResourceChangeManager {
    private Vector listeners = new Vector();

    public void addSystemResourceChangeListener(ISystemResourceChangeListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.addElement(l);
        }
    }

    public void removeSystemResourceChangeListener(ISystemResourceChangeListener l) {
        if (this.listeners.contains(l)) {
            this.listeners.removeElement(l);
        }
    }

    public boolean isRegisteredSystemResourceChangeListener(ISystemResourceChangeListener l) {
        return this.listeners.contains(l);
    }

    public void notify(ISystemResourceChangeEvent event) {
        int idx = 0;
        while (idx < this.listeners.size()) {
            ISystemResourceChangeListener l = (ISystemResourceChangeListener)this.listeners.elementAt(idx);
            l.systemResourceChanged(event);
            ++idx;
        }
    }

    public void postNotify(ISystemResourceChangeEvent event) {
        int idx = 0;
        while (idx < this.listeners.size()) {
            ISystemResourceChangeListener listener = (ISystemResourceChangeListener)this.listeners.elementAt(idx);
            new SystemPostableEventNotifier(listener, event);
            ++idx;
        }
    }
}

