/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.dstore.shells;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.model.IDataStoreProvider;
import org.eclipse.rse.dstore.universal.miners.CommandMiner;
import org.eclipse.rse.dstore.universal.miners.EnvironmentMiner;
import org.eclipse.rse.internal.services.dstore.ServiceResources;
import org.eclipse.rse.internal.services.dstore.shells.DStoreHostShell;
import org.eclipse.rse.services.clientserver.messages.ISystemMessageProvider;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.dstore.AbstractDStoreService;
import org.eclipse.rse.services.dstore.util.DStoreStatusMonitor;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IShellService;

public class DStoreShellService
extends AbstractDStoreService
implements IShellService {
    protected String[] _envVars;
    protected DataElement _envMinerElement;
    protected DataElement _envMinerStatus;

    public DStoreShellService(IDataStoreProvider dataStoreProvider, ISystemMessageProvider msgProvider) {
        super(dataStoreProvider, msgProvider);
    }

    public String getName() {
        return ServiceResources.DStore_Shell_Service_Label;
    }

    public String getDescription() {
        return ServiceResources.DStore_Shell_Service_Description;
    }

    public IHostShell launchShell(String initialWorkingDirectory, String[] environment, IProgressMonitor monitor) {
        if (!this.isInitialized()) {
            this.waitForInitialize(null);
        }
        return this.launchShell(initialWorkingDirectory, null, environment, monitor);
    }

    public IHostShell launchShell(String initialWorkingDirectory, String encoding, String[] environment, IProgressMonitor monitor) {
        if (!this.isInitialized()) {
            this.waitForInitialize(null);
        }
        return new DStoreHostShell(this.getStatusMonitor(this.getDataStore()), this.getDataStore(), initialWorkingDirectory, ">", encoding, environment);
    }

    public IHostShell runCommand(String initialWorkingDirectory, String command, String[] environment, IProgressMonitor monitor) {
        if (!this.isInitialized()) {
            this.waitForInitialize(null);
        }
        return this.runCommand(initialWorkingDirectory, command, null, environment, monitor);
    }

    public IHostShell runCommand(String initialWorkingDirectory, String command, String encoding, String[] environment, IProgressMonitor monitor) {
        if (!this.isInitialized()) {
            this.waitForInitialize(null);
        }
        return new DStoreHostShell(this.getStatusMonitor(this.getDataStore()), this.getDataStore(), initialWorkingDirectory, command, encoding, environment);
    }

    public String[] getHostEnvironment() {
        if (this._envVars == null || this._envVars.length == 0) {
            DataElement systemEnvironment;
            ArrayList<String> envVars = new ArrayList<String>();
            DataStore ds = this.getDataStore();
            DataElement envMinerData = ds.findMinerInformation(this.getEnvSystemMinerId());
            if (envMinerData != null && (systemEnvironment = ds.find(envMinerData, 2, "System Environment", 1)) != null && systemEnvironment.getNestedSize() > 0) {
                int i = 0;
                while (i < systemEnvironment.getNestedSize()) {
                    DataElement var = systemEnvironment.get(i);
                    envVars.add(var.getValue());
                    ++i;
                }
            }
            this._envVars = envVars.toArray(new String[envVars.size()]);
        }
        return this._envVars;
    }

    protected String getMinerId() {
        return CommandMiner.MINER_ID;
    }

    protected String getEnvSystemMinerId() {
        return EnvironmentMiner.MINER_ID;
    }

    public boolean isInitialized() {
        if (this._initializeStatus != null) {
            DStoreStatusMonitor smon = this.getStatusMonitor(this.getDataStore());
            return smon.determineStatusDone(this._initializeStatus);
        }
        return false;
    }

    protected void waitForInitialize(IProgressMonitor monitor) {
        if (this._envMinerStatus != null) {
            block3: {
                DStoreStatusMonitor smon = this.getStatusMonitor(this.getDataStore());
                try {
                    smon.waitForUpdate(this._envMinerStatus, monitor);
                }
                catch (InterruptedException interruptedException) {
                    if (monitor == null || monitor.isCanceled()) break block3;
                    monitor.setCanceled(true);
                }
            }
            this.getMinerElement(this.getEnvSystemMinerId());
        }
        super.waitForInitialize(monitor);
    }

    public void uninitService(IProgressMonitor monitor) {
        super.uninitService(monitor);
        this._envMinerElement = null;
        this._envMinerStatus = null;
    }

    protected void initMiner(IProgressMonitor monitor) {
        if (this.getServerVersion() >= 8) {
            String minerId = this.getEnvSystemMinerId();
            String message = SystemMessage.sub((String)ServiceResources.DStore_Service_ProgMon_Initializing_Message, (String)"&1", (String)minerId);
            monitor.beginTask(message, -1);
            DataStore ds = this.getDataStore();
            if ((this._envMinerElement == null || this._envMinerElement.getDataStore() != ds) && ds != null && this._envMinerStatus == null) {
                this._envMinerStatus = ds.activateMiner(minerId);
            }
            super.initMiner(monitor);
        }
    }
}

