/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.efs.ui;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.rse.internal.efs.Activator;
import org.eclipse.rse.internal.efs.RSEFileSystem;
import org.eclipse.rse.internal.efs.ui.Messages;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class CreateRemoteProjectActionDelegate
implements IActionDelegate {
    protected IStructuredSelection fSelection;
    private IStatus errorStatus;

    public void run(IAction action) {
        this.errorStatus = null;
        IRemoteFile directory = (IRemoteFile)this.fSelection.getFirstElement();
        boolean completed = this.performCreateRemoteProject(directory);
        if (!completed) {
            return;
        }
        if (this.errorStatus != null) {
            ErrorDialog.openError((Shell)this.getShell(), (String)this.getErrorsTitle(), null, (IStatus)this.errorStatus);
            this.errorStatus = null;
        }
    }

    final void recordError(CoreException error) {
        this.errorStatus = error.getStatus();
    }

    void displayError(String message) {
        MessageDialog.openError((Shell)this.getShell(), (String)this.getErrorsTitle(), (String)message);
    }

    protected String getErrorsTitle() {
        return "Error creating remote project";
    }

    boolean performCreateRemoteProject(final IRemoteFile directory) {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                try {
                    CreateRemoteProjectActionDelegate.this.createRemoteProject(directory, monitor);
                }
                catch (InvocationTargetException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (e.getCause() instanceof CoreException) {
                        CreateRemoteProjectActionDelegate.this.recordError((CoreException)e.getCause());
                    }
                    Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), -1, e.getMessage(), (Throwable)e));
                    CreateRemoteProjectActionDelegate.this.displayError(e.getMessage());
                }
            }
        };
        try {
            ProgressMonitorDialog mon = new ProgressMonitorDialog(this.getShell()){

                protected void configureShell(Shell shell) {
                    super.configureShell(shell);
                    shell.setText(Messages.CreateRemoteProjectActionDelegate_CREATING_TITLE);
                }
            };
            mon.run(true, true, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            this.displayError("Internal Error: " + e.getTargetException().getMessage());
            return false;
        }
        return true;
    }

    private IProject createRemoteProject(IRemoteFile directory, IProgressMonitor monitor) throws InvocationTargetException {
        IWorkspaceRoot root = SystemBasePlugin.getWorkspaceRoot();
        String projectName = String.valueOf(directory.getSystemConnection().getAliasName()) + '_' + directory.getName();
        projectName = projectName.replaceAll("[/:*?\"<>|\\\\]", "");
        IProject editProject = root.getProject(projectName);
        try {
            IProjectDescription description = root.getWorkspace().newProjectDescription(projectName);
            String hostNameOrAddr = directory.getParentRemoteFileSubSystem().getHost().getHostName();
            String absolutePath = directory.getAbsolutePath();
            URI location = RSEFileSystem.getURIFor((String)hostNameOrAddr, (String)absolutePath);
            description.setLocationURI(location);
            editProject.create(description, monitor);
            editProject.open(monitor);
            editProject.refreshLocal(1, monitor);
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
        return editProject;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : StructuredSelection.EMPTY;
    }

    protected IRemoteFile getRemoteFile(IStructuredSelection selection) {
        return (IRemoteFile)selection.getFirstElement();
    }

    protected IRemoteFile[] getRemoteFiles(IStructuredSelection selection) {
        IRemoteFile[] files = new IRemoteFile[selection.size()];
        Iterator iter = selection.iterator();
        int i = 0;
        while (iter.hasNext()) {
            files[i++] = (IRemoteFile)iter.next();
        }
        return files;
    }

    protected IFile getDescriptionFile(IStructuredSelection selection) {
        return (IFile)selection.getFirstElement();
    }

    protected IFile[] getDescriptionFiles(IStructuredSelection selection) {
        IFile[] files = new IFile[selection.size()];
        Iterator iter = selection.iterator();
        int i = 0;
        while (iter.hasNext()) {
            files[i++] = (IFile)iter.next();
        }
        return files;
    }

    protected IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    protected Shell getShell() {
        return Display.getDefault().getActiveShell();
    }

    protected IStructuredSelection getSelection() {
        return this.fSelection;
    }
}

