/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.connectorservice.ssh;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jsch.core.IJSchService;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.SystemSignonInformation;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.SubSystemConfiguration;
import org.eclipse.rse.internal.connectorservice.ssh.Activator;
import org.eclipse.rse.internal.connectorservice.ssh.KeyboardInteractiveDialog;
import org.eclipse.rse.internal.connectorservice.ssh.SshConnectorResources;
import org.eclipse.rse.internal.connectorservice.ssh.UserValidationDialog;
import org.eclipse.rse.internal.services.ssh.ISshSessionProvider;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.subsystems.StandardConnectorService;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SshConnectorService
extends StandardConnectorService
implements ISshSessionProvider {
    private static final int SSH_DEFAULT_PORT = 22;
    private static final int CONNECT_DEFAULT_TIMEOUT = 60;
    private Session session;
    private SessionLostHandler fSessionLostHandler = null;
    private static String _defaultEncoding = new InputStreamReader(new ByteArrayInputStream(new byte[0])).getEncoding();

    public SshConnectorService(IHost host) {
        super(SshConnectorResources.SshConnectorService_Name, SshConnectorResources.SshConnectorService_Description, host, 22);
    }

    protected Session createSession(String username, String password, String hostname, int port, UserInfo wrapperUI, IProgressMonitor monitor) throws JSchException {
        IJSchService service = Activator.getDefault().getJSchService();
        if (service == null) {
            return null;
        }
        Session session = service.createSession(hostname, port, username);
        session.setTimeout(0);
        session.setServerAliveInterval(300000);
        session.setServerAliveCountMax(6);
        if (password != null) {
            session.setPassword(password);
        }
        session.setUserInfo(wrapperUI);
        return session;
    }

    static void shutdown() {
    }

    protected int getSshPort() {
        int port = this.getPort();
        if (port <= 0) {
            port = 22;
        }
        return port;
    }

    protected void internalConnect(IProgressMonitor monitor) throws Exception {
        this.fireCommunicationsEvent(1);
        String host = this.getHostName();
        String user = this.getUserId();
        String password = "";
        SystemSignonInformation ssi = this.getSignonInformation();
        if (ssi != null) {
            password = this.getSignonInformation().getPassword();
        }
        MyUserInfo userInfo = new MyUserInfo(user, password);
        userInfo.aboutToConnect();
        try {
            this.session = this.createSession(user, password, host, this.getSshPort(), userInfo, monitor);
            userInfo.aboutToConnect();
            Activator.trace("SshConnectorService.connecting...");
            this.session.connect(60000);
            Activator.trace("SshConnectorService.connected");
        }
        catch (JSchException e) {
            Activator.trace("SshConnectorService.connect failed: " + e.toString());
            this.sessionDisconnect();
            if (e.toString().indexOf("Auth cancel") >= 0) {
                throw new OperationCanceledException();
            }
            throw e;
        }
        userInfo.connectionMade();
        this.fSessionLostHandler = new SessionLostHandler((IConnectorService)this);
        this.notifyConnection();
    }

    private synchronized void sessionDisconnect() {
        block3: {
            Activator.trace("SshConnectorService.sessionDisconnect");
            try {
                if (this.session.isConnected()) {
                    this.session.disconnect();
                }
            }
            catch (Exception e) {
                if (!Activator.isTracingOn()) break block3;
                e.printStackTrace();
            }
        }
    }

    protected void internalDisconnect(IProgressMonitor monitor) throws Exception {
        Activator.trace("SshConnectorService.disconnect");
        try {
            if (this.session != null) {
                boolean sessionLost = this.fSessionLostHandler != null && this.fSessionLostHandler.isSessionLost();
                this.fSessionLostHandler = null;
                if (sessionLost) {
                    this.notifyError();
                } else {
                    this.fireCommunicationsEvent(3);
                }
                this.sessionDisconnect();
                this.notifyDisconnection();
                this.clearPassword(false, true);
            }
        }
        catch (Exception exc) {
            throw new InvocationTargetException(exc);
        }
    }

    public Session getSession() {
        return this.session;
    }

    public String getControlEncoding() {
        String encoding = this.getHost().getDefaultEncoding(false);
        if (encoding == null) {
            encoding = this.getHost().getDefaultEncoding(true);
        }
        if (encoding == null) {
            encoding = _defaultEncoding;
        }
        return encoding;
    }

    public void handleSessionLost() {
        Activator.trace("SshConnectorService: handleSessionLost");
        if (this.fSessionLostHandler != null) {
            this.fSessionLostHandler.sessionLost();
        }
    }

    protected static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public boolean isConnected() {
        if (this.session != null) {
            if (this.session.isConnected()) {
                return true;
            }
            if (this.fSessionLostHandler != null) {
                Activator.trace("SshConnectorService.isConnected: false -> sessionLost");
                this.fSessionLostHandler.sessionLost();
            }
        }
        return false;
    }

    public boolean requiresPassword() {
        return false;
    }

    public boolean requiresUserId() {
        return false;
    }

    private static class MyUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        private String fPassphrase;
        private String fPassword;
        private int fAttemptCount;
        private final String fUser;

        public MyUserInfo(String user, String password) {
            this.fUser = user;
            this.fPassword = password;
        }

        public String getPassword() {
            return this.fPassword;
        }

        public boolean promptYesNo(String str) {
            boolean[] retval = new boolean[1];
            SshConnectorService.getStandardDisplay().syncExec(new Runnable(this, retval, str){
                final /* synthetic */ MyUserInfo this$1;
                private final /* synthetic */ boolean[] val$retval;
                private final /* synthetic */ String val$str;
                {
                    this.this$1 = myUserInfo;
                    this.val$retval = blArray;
                    this.val$str = string;
                }

                public void run() {
                    this.val$retval[0] = MessageDialog.openQuestion(null, (String)SshConnectorResources.SshConnectorService_Warning, (String)this.val$str);
                }
            });
            return retval[0];
        }

        private String promptSecret(String message) {
            String[] retval = new String[1];
            String finUser = this.fUser;
            SshConnectorService.getStandardDisplay().syncExec(new Runnable(this, finUser, message, retval){
                final /* synthetic */ MyUserInfo this$1;
                private final /* synthetic */ String val$finUser;
                private final /* synthetic */ String val$message;
                private final /* synthetic */ String[] val$retval;
                {
                    this.this$1 = myUserInfo;
                    this.val$finUser = string;
                    this.val$message = string2;
                    this.val$retval = stringArray;
                }

                public void run() {
                    UserValidationDialog uvd = new UserValidationDialog(null, null, this.val$finUser, this.val$message);
                    uvd.setUsernameMutable(false);
                    this.val$retval[0] = uvd.open() == 0 ? uvd.getPassword() : null;
                }
            });
            return retval[0];
        }

        public String getPassphrase() {
            return this.fPassphrase;
        }

        public boolean promptPassphrase(String message) {
            this.fPassphrase = this.promptSecret(message);
            return this.fPassphrase != null;
        }

        public boolean promptPassword(String message) {
            String _password = this.promptSecret(message);
            if (_password != null) {
                this.fPassword = _password;
                return true;
            }
            return false;
        }

        public void showMessage(String message) {
            SshConnectorService.getStandardDisplay().syncExec(new Runnable(this, message){
                final /* synthetic */ MyUserInfo this$1;
                private final /* synthetic */ String val$message;
                {
                    this.this$1 = myUserInfo;
                    this.val$message = string;
                }

                public void run() {
                    MessageDialog.openInformation(null, (String)SshConnectorResources.SshConnectorService_Info, (String)this.val$message);
                }
            });
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            String[] result;
            block6: {
                if (prompt.length == 0) {
                    return new String[0];
                }
                try {
                    if (this.fAttemptCount == 0 && this.fPassword != null && prompt.length == 1 && prompt[0].trim().equalsIgnoreCase("password:")) {
                        ++this.fAttemptCount;
                        return new String[]{this.fPassword};
                    }
                    String[][] finResult = new String[1][];
                    SshConnectorService.getStandardDisplay().syncExec(new Runnable(this, destination, name, instruction, prompt, echo, finResult){
                        final /* synthetic */ MyUserInfo this$1;
                        private final /* synthetic */ String val$destination;
                        private final /* synthetic */ String val$name;
                        private final /* synthetic */ String val$instruction;
                        private final /* synthetic */ String[] val$prompt;
                        private final /* synthetic */ boolean[] val$echo;
                        private final /* synthetic */ String[][] val$finResult;
                        {
                            this.this$1 = myUserInfo;
                            this.val$destination = string;
                            this.val$name = string2;
                            this.val$instruction = string3;
                            this.val$prompt = stringArray;
                            this.val$echo = blArray;
                            this.val$finResult = stringArray2;
                        }

                        public void run() {
                            KeyboardInteractiveDialog dialog = new KeyboardInteractiveDialog(null, null, this.val$destination, this.val$name, this.val$instruction, this.val$prompt, this.val$echo);
                            dialog.open();
                            this.val$finResult[0] = dialog.getResult();
                        }
                    });
                    result = finResult[0];
                    if (result != null) break block6;
                    return null;
                }
                catch (OperationCanceledException operationCanceledException) {
                    return null;
                }
            }
            if (result.length == 1 && prompt.length == 1 && prompt[0].trim().equalsIgnoreCase("password:")) {
                this.fPassword = result[0];
            }
            ++this.fAttemptCount;
            return result;
        }

        public void aboutToConnect() {
            this.fAttemptCount = 0;
        }

        public void connectionMade() {
            this.fAttemptCount = 0;
        }
    }

    public static class SessionLostHandler
    implements Runnable,
    IRunnableWithProgress {
        private IConnectorService _connection;
        private boolean fSessionLost;

        public SessionLostHandler(IConnectorService cs) {
            this._connection = cs;
            this.fSessionLost = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sessionLost() {
            boolean showSessionLostDlg = false;
            SessionLostHandler sessionLostHandler = this;
            synchronized (sessionLostHandler) {
                if (!this.fSessionLost) {
                    this.fSessionLost = true;
                    showSessionLostDlg = true;
                }
            }
            if (showSessionLostDlg) {
                Display.getDefault().asyncExec((Runnable)this);
            }
        }

        public synchronized boolean isSessionLost() {
            return this.fSessionLost;
        }

        public void run() {
            Shell shell = this.getShell();
            SystemMessage msg = RSEUIPlugin.getPluginMessage((String)"RSEG1058");
            msg.makeSubstitution((Object)this._connection.getPrimarySubSystem().getHost().getAliasName());
            SystemMessageDialog dialog = new SystemMessageDialog(this.getShell(), msg);
            dialog.open();
            try {
                IRunnableContext runnableContext = this.getRunnableContext(this.getShell());
                runnableContext.run(true, true, (IRunnableWithProgress)this);
                this._connection.reset();
                ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
                sr.connectedStatusChange(this._connection.getPrimarySubSystem(), false, true, true);
            }
            catch (InterruptedException interruptedException) {
                if (shell != null) {
                    this.showDisconnectCancelledMessage(shell, this._connection.getHostName(), this._connection.getPort());
                }
            }
            catch (InvocationTargetException invokeExc) {
                Exception exc = (Exception)invokeExc.getTargetException();
                if (shell != null) {
                    this.showDisconnectErrorMessage(shell, this._connection.getHostName(), this._connection.getPort(), exc);
                }
            }
            catch (Exception e) {
                SystemBasePlugin.logError((String)SshConnectorResources.SshConnectorService_ErrorDisconnecting, (Throwable)e);
            }
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            String message = null;
            message = SubSystemConfiguration.getDisconnectingMessage((String)this._connection.getHostName(), (int)this._connection.getPort());
            monitor.beginTask(message, -1);
            try {
                try {
                    this._connection.disconnect(monitor);
                }
                catch (Exception exc) {
                    if (exc instanceof InvocationTargetException) {
                        throw (InvocationTargetException)exc;
                    }
                    if (exc instanceof InterruptedException) {
                        throw (InterruptedException)exc;
                    }
                    throw new InvocationTargetException(exc);
                }
            }
            finally {
                monitor.done();
            }
        }

        public Shell getShell() {
            Shell activeShell = SystemBasePlugin.getActiveWorkbenchShell();
            if (activeShell != null) {
                return activeShell;
            }
            IWorkbenchWindow window = null;
            try {
                window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            }
            catch (Exception exception) {
                return null;
            }
            if (window == null) {
                IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                if (windows != null && windows.length > 0) {
                    return windows[0].getShell();
                }
            } else {
                return window.getShell();
            }
            return null;
        }

        protected IRunnableContext getRunnableContext(Shell rshell) {
            Shell shell = this.getShell();
            IWorkbenchWindow win = SystemBasePlugin.getActiveWorkbenchWindow();
            if (win != null) {
                Shell winShell = RSEUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
                if (winShell != null && !winShell.isDisposed() && winShell.isVisible()) {
                    SystemBasePlugin.logInfo((String)"Using active workbench window as runnable context");
                    shell = winShell;
                    return win;
                }
                win = null;
            }
            if (shell == null || shell.isDisposed() || !shell.isVisible()) {
                SystemBasePlugin.logInfo((String)"Using progress monitor dialog with given shell as parent");
                shell = rshell;
            }
            ProgressMonitorDialog dlg = new ProgressMonitorDialog(rshell);
            return dlg;
        }

        protected void showDisconnectErrorMessage(Shell shell, String hostName, int port, Exception exc) {
            SystemMessageDialog msgDlg = new SystemMessageDialog(shell, RSEUIPlugin.getPluginMessage((String)"RSEG1061").makeSubstitution((Object)hostName, (Object)exc));
            msgDlg.setException((Throwable)exc);
            msgDlg.open();
        }

        protected void showDisconnectCancelledMessage(Shell shell, String hostName, int port) {
            SystemMessageDialog msgDlg = new SystemMessageDialog(shell, RSEUIPlugin.getPluginMessage((String)"RSEG1062").makeSubstitution((Object)hostName));
            msgDlg.open();
        }
    }
}

