/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.dstore.universal.miners.command;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.dstore.core.model.Handler;

public class ProcessTracker
extends Handler {
    private Process _psShell;
    private BufferedReader _psReader;
    private BufferedWriter _psWriter;
    private boolean _updateFlag;
    private ProcessDescriptor _newestProcess;
    private String _psCommand;
    private boolean _isEnabled;
    private List _currentProcesses = new ArrayList();

    public ProcessTracker() {
        this.init();
    }

    private String getFormatOptions(String theOS) {
        String formatOptions = "";
        if (theOS.startsWith("z")) {
            formatOptions = "-o pid,comm";
        } else if (theOS.startsWith("linux")) {
            formatOptions = "--format pid,ucomm";
        } else if (theOS.startsWith("aix")) {
            formatOptions = "-F pid,ucomm";
        }
        return formatOptions;
    }

    private void init() {
        String userID = System.getProperty("user.name");
        String userOptions = "-u " + userID;
        String theOS = System.getProperty("os.name").toLowerCase();
        String formatOptions = this.getFormatOptions(theOS);
        this._isEnabled = formatOptions.length() != 0;
        if (this._isEnabled) {
            this._psCommand = "ps " + userOptions + " " + formatOptions;
            try {
                if (this._psShell == null) {
                    this._psShell = Runtime.getRuntime().exec("sh");
                    String specialEncoding = System.getProperty("dstore.stdin.encoding");
                    if (specialEncoding != null) {
                        this._psReader = new BufferedReader(new InputStreamReader(this._psShell.getInputStream(), specialEncoding));
                        try {
                            this._psWriter = new BufferedWriter(new OutputStreamWriter(this._psShell.getOutputStream(), specialEncoding));
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            this._psWriter = new BufferedWriter(new OutputStreamWriter(this._psShell.getOutputStream()));
                        }
                    } else {
                        this._psReader = new BufferedReader(new InputStreamReader(this._psShell.getInputStream()));
                        this._psWriter = new BufferedWriter(new OutputStreamWriter(this._psShell.getOutputStream()));
                    }
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readLine(BufferedReader reader) {
        StringBuffer theLine = new StringBuffer();
        boolean done = false;
        while (!done) {
            try {
                BufferedReader bufferedReader = reader;
                synchronized (bufferedReader) {
                    if (!reader.ready()) {
                        return theLine.toString();
                    }
                    int ch = reader.read();
                    switch (ch) {
                        case -1: {
                            if (theLine.length() == 0) {
                                return null;
                            }
                            done = true;
                            break;
                        }
                        case 65535: {
                            if (theLine.length() == 0) {
                                return null;
                            }
                            done = true;
                            break;
                        }
                        case 10: {
                            done = true;
                            break;
                        }
                        case 13: {
                            done = true;
                            break;
                        }
                        default: {
                            char tch = (char)ch;
                            if (!Character.isISOControl(tch)) {
                                theLine.append(tch);
                                break;
                            }
                            if (!reader.ready()) break;
                            reader.read();
                        }
                    }
                    if (!reader.ready()) {
                        done = true;
                    }
                }
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return theLine.toString();
    }

    private void getCurrentProcesses() {
        try {
            this._psWriter.write(this._psCommand);
            this._psWriter.write("\n");
            this._psWriter.flush();
            String line = this._psReader.readLine();
            ArrayList<ProcessDescriptor> newPIDs = new ArrayList<ProcessDescriptor>();
            line = ProcessTracker.readLine(this._psReader);
            while (line != null && line.length() > 0) {
                String cmd;
                String pid;
                ProcessDescriptor descriptor;
                int firstBlank = (line = line.trim()).indexOf(32);
                if (firstBlank != -1 && !(descriptor = new ProcessDescriptor(pid = line.substring(0, firstBlank), cmd = line.substring(firstBlank + 1, line.length()))).hasCMD("ps")) {
                    newPIDs.add(descriptor);
                }
                line = ProcessTracker.readLine(this._psReader);
            }
            this.updateProcesses(newPIDs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void finish() {
        this._updateFlag = false;
        if (this._isEnabled) {
            this.endTrackerProcess();
        }
        super.finish();
    }

    private void updateProcesses(ArrayList newPIDs) {
        ProcessDescriptor p;
        boolean firstRun = this._currentProcesses.size() == 0;
        int c = this._currentProcesses.size() - 1;
        while (c >= 0) {
            p = (ProcessDescriptor)this._currentProcesses.get(c);
            if (newPIDs.contains(p)) {
                newPIDs.remove(p);
            } else {
                this._currentProcesses.remove(p);
            }
            --c;
        }
        int i = 0;
        while (i < newPIDs.size()) {
            p = (ProcessDescriptor)newPIDs.get(i);
            this._currentProcesses.add(p);
            if (!firstRun) {
                this._newestProcess = p;
            }
            ++i;
        }
    }

    public void endTrackerProcess() {
        if (this._isEnabled) {
            try {
                this._psWriter.write("exit");
                this._psWriter.write("\n");
                this._psWriter.flush();
                this._psReader.close();
                this._psWriter.close();
                this._psShell.waitFor();
            }
            catch (Exception exception) {}
        }
    }

    public ProcessDescriptor getNewestProcess() {
        return this._newestProcess;
    }

    private ProcessDescriptor findLast(String cmd) {
        if (this._newestProcess != null && this._newestProcess.hasCMD(cmd)) {
            return this._newestProcess;
        }
        int i = this._currentProcesses.size() - 1;
        while (i > 0) {
            ProcessDescriptor descriptor = (ProcessDescriptor)this._currentProcesses.get(i);
            if (descriptor.hasCMD(cmd)) {
                return descriptor;
            }
            --i;
        }
        return null;
    }

    public void killCommand(String cmd) {
        ProcessDescriptor descriptor = this.findLast(cmd);
        if (descriptor != null) {
            this.kill(descriptor);
        }
    }

    public void killLastest() {
        if (this._newestProcess != null) {
            this.kill(this._newestProcess);
        }
    }

    private void kill(ProcessDescriptor descriptor) {
        if (this._isEnabled) {
            try {
                this._psWriter.write("kill " + descriptor.getPID());
                this._psWriter.write("\n");
                this._psWriter.flush();
                this._psReader.reset();
            }
            catch (Exception exception) {}
            this.doUpdate();
        }
    }

    public void handle() {
        if (!this._isEnabled) {
            this.finish();
        }
        if (this._updateFlag) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
            this.getCurrentProcesses();
            this._updateFlag = false;
        }
    }

    public void doUpdate() {
        this._updateFlag = this._isEnabled;
    }

    public synchronized void waitForInput() {
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {}
    }

    private class ProcessDescriptor {
        private String _pid;
        private String _cmd;

        public ProcessDescriptor(String pid, String cmd) {
            this._pid = pid;
            this._cmd = cmd;
        }

        public String getPID() {
            return this._pid;
        }

        public String getCMD() {
            return this._cmd;
        }

        public String toString() {
            String result = String.valueOf(this.getPID()) + " " + this.getCMD();
            if (this == ProcessTracker.this._newestProcess) {
                result = String.valueOf(result) + " *";
            }
            return result;
        }

        public boolean hasCMD(String cmdname) {
            StringTokenizer tokenizer = new StringTokenizer(this._cmd, "/");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (tokenizer.hasMoreElements() || !token.equals(cmdname)) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object obj) {
            ProcessDescriptor des;
            return obj instanceof ProcessDescriptor && (des = (ProcessDescriptor)obj).getPID().equals(this._pid);
        }
    }
}

