/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.dstore.universal.miners;

import java.io.File;
import org.eclipse.dstore.core.model.DataStore;

public class UniversalServerUtilities {
    public static String getUserPreferencesDirectory(DataStore dataStore) {
        File dirFile;
        String userPreferencesDirectory = dataStore.getClient().getProperty("user.home");
        String clientUserID = System.getProperty("client.username");
        clientUserID = clientUserID == null || clientUserID.equals("") ? "" : String.valueOf(clientUserID) + File.separator;
        if (userPreferencesDirectory.length() == 0 || userPreferencesDirectory.charAt(userPreferencesDirectory.length() - 1) != File.separatorChar) {
            userPreferencesDirectory = String.valueOf(userPreferencesDirectory) + File.separator;
        }
        if (!(dirFile = new File(userPreferencesDirectory = String.valueOf(userPreferencesDirectory) + ".eclipse" + File.separator + "RSE" + File.separator + clientUserID)).exists()) {
            dirFile.mkdirs();
        }
        return userPreferencesDirectory;
    }

    public static void logInfo(String minerName, String message, DataStore dataStore) {
        dataStore.getClient().getLogger().logInfo(minerName, message);
    }

    public static void logWarning(String minerName, String message, DataStore dataStore) {
        dataStore.getClient().getLogger().logWarning(minerName, message);
    }

    public static void logError(String minerName, String message, Throwable exception, DataStore dataStore) {
        dataStore.getClient().getLogger().logError(minerName, message, exception);
    }

    public static void logDebugMessage(String minerName, String message, DataStore dataStore) {
        dataStore.getClient().getLogger().logDebugMessage(minerName, message);
    }
}

