/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.core.connection;

import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.tests.core.RSECoreTestCase;
import org.eclipse.rse.tests.core.connection.IRSEConnectionManager;
import org.eclipse.rse.tests.core.connection.IRSEConnectionProperties;
import org.eclipse.rse.tests.internal.RSEConnectionManager;
import org.eclipse.rse.ui.RSEUIPlugin;

public class RSEBaseConnectionTestCase
extends RSECoreTestCase {
    private final IRSEConnectionManager connectionManager = new RSEConnectionManager();
    private final IRSEConnectionProperties localSystemConnectionProperties;

    public RSEBaseConnectionTestCase() {
        this(null);
    }

    public RSEBaseConnectionTestCase(String name) {
        super(name);
        Properties properties = new Properties();
        properties.setProperty("system_type_id", "org.eclipse.rse.systemtype.local");
        properties.setProperty("address", "localhost");
        properties.setProperty("name", "Local");
        this.localSystemConnectionProperties = this.getConnectionManager().loadConnectionProperties(properties, false);
    }

    protected IRSEConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    protected IHost getLocalSystemConnection() {
        RSEBaseConnectionTestCase.assertNotNull((String)"Local system connection properties are not available!", (Object)this.localSystemConnectionProperties);
        Exception exception = null;
        String cause = null;
        IHost connection = null;
        try {
            connection = this.getConnectionManager().findOrCreateConnection(this.localSystemConnectionProperties);
        }
        catch (Exception e) {
            exception = e;
            cause = exception.getLocalizedMessage();
        }
        RSEBaseConnectionTestCase.assertNull((String)("Failed to find and create local system connection! Possible cause: " + cause), (Object)exception);
        RSEBaseConnectionTestCase.assertNotNull((String)"Failed to find and create local system connection! Cause unknown!", (Object)connection);
        return connection;
    }

    protected IHost getSSHHost() {
        return this.getHost("sshConnection.properties");
    }

    protected IHost getFTPHost() {
        return this.getHost("ftpConnection.properties");
    }

    protected IHost getLinuxHost() {
        return this.getHost("linuxConnection.properties");
    }

    protected IHost getWindowsHost() {
        return this.getHost("windowsConnection.properties");
    }

    protected IHost getHost(String propertiesFileName) {
        IPath location = this.getTestDataLocation("", false);
        RSEBaseConnectionTestCase.assertNotNull((String)"Cannot locate test data! Missing test data location?", (Object)location);
        location = location.append(propertiesFileName);
        RSEBaseConnectionTestCase.assertNotNull((String)"Failed to construct location to 'connection.properties' test data file!", (Object)location);
        RSEBaseConnectionTestCase.assertTrue((String)"Required test data file seems to be not a file!", (boolean)location.toFile().isFile());
        RSEBaseConnectionTestCase.assertTrue((String)"Required test data file is not readable!", (boolean)location.toFile().canRead());
        IRSEConnectionProperties properties = this.getConnectionManager().loadConnectionProperties(location, false);
        RSEBaseConnectionTestCase.assertNotNull((String)("Failed to load test connection properties from location " + location.toOSString()), (Object)properties);
        IHost host = this.getConnectionManager().findOrCreateConnection(properties);
        RSEBaseConnectionTestCase.assertNotNull((String)("Failed to create connection " + properties.getProperty("name")), (Object)host);
        ISubSystem[] ss = host.getSubSystems();
        int i = 0;
        while (i < ss.length) {
            String id = ss[i].getSubSystemConfiguration().getId();
            if (id.indexOf("dstore.") >= 0) {
                IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
                store.setValue("org.eclipse.rse.preferences.alert.ssl", false);
                store.setValue("org.eclipse.rse.preferences.alert.nonssl", false);
                break;
            }
            ++i;
        }
        return host;
    }

    protected IHost getRemoteSystemConnection(String systemTypeID, String systemAddress, String systemName, String userID, String password) {
        Exception exception = null;
        String cause = null;
        Properties properties = new Properties();
        properties.setProperty("system_type_id", systemTypeID);
        properties.setProperty("address", systemAddress);
        properties.setProperty("name", systemName);
        properties.setProperty("userid", userID);
        if (password != null) {
            properties.setProperty("password", password);
        }
        IRSEConnectionProperties remoteSystemConnectionProperties = this.getConnectionManager().loadConnectionProperties(properties, false);
        IHost connection = null;
        try {
            connection = this.getConnectionManager().findOrCreateConnection(remoteSystemConnectionProperties);
        }
        catch (Exception e) {
            exception = e;
            cause = exception.getLocalizedMessage();
        }
        RSEBaseConnectionTestCase.assertNull((String)("Failed to find and create remote system connection! Possible cause: " + cause), (Object)exception);
        RSEBaseConnectionTestCase.assertNotNull((String)"Failed to find and create remote system connection! Cause unknown!", (Object)connection);
        return connection;
    }

    protected IProgressMonitor getDefaultProgressMonitor() {
        return new NullProgressMonitor();
    }
}

