/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rse.tests.RSETestsPlugin;
import org.eclipse.rse.tests.core.RSEWaitAndDispatchUtil;
import org.eclipse.rse.tests.core.connection.IRSEConnectionProperties;
import org.eclipse.rse.tests.core.connection.RSEBaseConnectionTestCase;
import org.eclipse.ui.PlatformUI;

public class RSEInternalFrameworkTestCase
extends RSEBaseConnectionTestCase {
    static /* synthetic */ Class class$0;

    public void testCoreTestPropertiesHandling() {
        if (!RSETestsPlugin.isTestCaseEnabled("RSEInternalFrameworkTestCase.testCoreTestPropertiesHandling")) {
            return;
        }
        RSEInternalFrameworkTestCase.assertTrue((String)"Unexpected default for property PROP_MAXIMIZE_REMOTE_SYSTEMS_VIEW!", (boolean)this.isProperty("org.eclipse.rse.tests.core.maximizeRemoteSystemsView", false));
        RSEInternalFrameworkTestCase.assertEquals((String)"Unexpected default for property PROP_SWITCH_TO_PERSPECTIVE!", (String)"org.eclipse.rse.ui.view.SystemPerspective", (String)this.getProperty("org.eclipse.rse.tests.core.switchToPerspective"));
        RSEInternalFrameworkTestCase.assertTrue((String)"Unexpected default for property PROP_FORCE_BACKGROUND_EXECUTION!", (boolean)this.isProperty("org.eclipse.rse.tests.core.forceBackgroundExecution", false));
        RSEInternalFrameworkTestCase.assertTrue((String)"Unexpected default for property PROP_PERFORMANCE_TIMING_INCLUDE_SETUP_TEARDOWN!", (boolean)this.isProperty("org.eclipse.rse.tests.core.timingsIncludeSetupAndTearDown", false));
        this.setProperty("testBooleanProperty", true);
        RSEInternalFrameworkTestCase.assertTrue((String)"Unexpected stored value for testBooleanProperty!", (boolean)this.isProperty("testBooleanProperty", true));
        this.setProperty("testBooleanProperty", false);
        RSEInternalFrameworkTestCase.assertTrue((String)"Unexpected stored value for testBooleanProperty!", (boolean)this.isProperty("testBooleanProperty", false));
        this.setProperty("testBooleanProperty", null);
        RSEInternalFrameworkTestCase.assertNull((String)"testBooleanProperty not removed!", (Object)this.getProperty("testBooleanProperty"));
        this.setProperty("testStringProperty", "stringPropertyValue");
        RSEInternalFrameworkTestCase.assertTrue((String)"Unexpected stored value for testStringProperty!", (boolean)this.isProperty("testStringProperty", "stringPropertyValue"));
        this.setProperty("testStringProperty", "0123456789");
        RSEInternalFrameworkTestCase.assertTrue((String)"Unexpected stored value for testStringProperty!", (boolean)this.isProperty("testStringProperty", "0123456789"));
        this.setProperty("testStringProperty", null);
        RSEInternalFrameworkTestCase.assertNull((String)"testStringProperty not removed!", (Object)this.getProperty("testStringProperty"));
    }

    public void testWaitAndDispatch() {
        if (!RSETestsPlugin.isTestCaseEnabled("RSEInternalFrameworkTestCase.testWaitAndDispatch")) {
            return;
        }
        long start = System.currentTimeMillis();
        RSEWaitAndDispatchUtil.waitAndDispatch(2500L);
        long end = System.currentTimeMillis();
        RSEInternalFrameworkTestCase.assertTrue((String)"Failed to wait a given timeout!", (end - start >= 2500L ? 1 : 0) != 0);
        ArrayList params = new ArrayList();
        TestJob job = new TestJob(params);
        job.setUser(false);
        job.setSystem(true);
        job.setPriority(20);
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule(3000L);
        boolean timeout = RSEWaitAndDispatchUtil.waitAndDispatch(10000L, new TestWaiter(params));
        RSEInternalFrameworkTestCase.assertFalse((String)"Interrupt condition failed to stop wait method!", (boolean)timeout);
        RSEInternalFrameworkTestCase.assertEquals((String)"Interrupt condition failed to dispose!", (int)0, (int)params.size());
    }

    public void testTestDataLocationManagement() {
        if (!RSETestsPlugin.isTestCaseEnabled("RSEInternalFrameworkTestCase.testTestDataLocationManagement")) {
            return;
        }
        IPath root = this.getTestDataLocation("", false);
        RSEInternalFrameworkTestCase.assertNotNull((String)"Failed to query test data location root!", (Object)root);
        RSEInternalFrameworkTestCase.assertTrue((String)("Test data root location " + root.toOSString() + " is not a directory!"), (boolean)root.toFile().isDirectory());
        RSEInternalFrameworkTestCase.assertTrue((String)("Test data root location " + root.toOSString() + " cannot be read!"), (boolean)root.toFile().canRead());
        String relative = "unittest_" + System.currentTimeMillis();
        IPath path = this.getTestDataLocation(relative, false);
        RSEInternalFrameworkTestCase.assertNull((String)"Test data location exist but should not!", (Object)path);
        String os = Platform.getOS();
        RSEInternalFrameworkTestCase.assertNotNull((String)"Failed to query current execution host operating system string!", (Object)os);
        path = root.append(String.valueOf(relative) + "/" + os);
        RSEInternalFrameworkTestCase.assertTrue((String)"Failed to create test data location directories. Permission problem?", (boolean)path.toFile().mkdirs());
        IPath path2 = this.getTestDataLocation(relative, false);
        RSEInternalFrameworkTestCase.assertNotNull((String)("Test data location " + root.append(relative).toOSString() + " seems not to exist!"), (Object)path2);
        path2 = this.getTestDataLocation(relative, true);
        RSEInternalFrameworkTestCase.assertNotNull((String)("Test data location " + path.toOSString() + " seems not to exist!"), (Object)path2);
        RSEInternalFrameworkTestCase.assertTrue((String)("Failed to delete test data location " + path.toOSString() + "!"), (boolean)path.toFile().delete());
        RSEInternalFrameworkTestCase.assertTrue((String)("Failed to delete test data location " + root.append(relative).toOSString() + "!"), (boolean)root.append(relative).toFile().delete());
    }

    public void testConnectionManager() {
        if (!RSETestsPlugin.isTestCaseEnabled("RSEInternalFrameworkTestCase.testConnectionManager")) {
            return;
        }
        IPath location = this.getTestDataLocation("testConnectionManager", false);
        RSEInternalFrameworkTestCase.assertNotNull((String)"Cannot locate test data! Missing test data location?", (Object)location);
        location = location.append("connection.properties");
        RSEInternalFrameworkTestCase.assertNotNull((String)"Failed to construct location to 'connection.properties' test data file!", (Object)location);
        RSEInternalFrameworkTestCase.assertTrue((String)"Required test data file seems to be not a file!", (boolean)location.toFile().isFile());
        RSEInternalFrameworkTestCase.assertTrue((String)"Required test data file is not readable!", (boolean)location.toFile().canRead());
        IRSEConnectionProperties properties = this.getConnectionManager().loadConnectionProperties(location, true);
        RSEInternalFrameworkTestCase.assertNotNull((String)("Failed to load test connection properties from location " + location.toOSString()), (Object)properties);
        RSEInternalFrameworkTestCase.assertEquals((String)"Property name does not match!", (String)"test_windows", (String)properties.getProperty("name"));
        RSEInternalFrameworkTestCase.assertEquals((String)"Property profile name does not match!", (String)"junit_test_profile", (String)properties.getProperty("profile_name"));
        RSEInternalFrameworkTestCase.assertEquals((String)"Property system type does not match!", (String)"org.eclipse.rse.systemtype.windows", (String)properties.getProperty("system_type_id"));
        RSEInternalFrameworkTestCase.assertEquals((String)"Property remote system address does not match!", (String)"128.0.0.1", (String)properties.getProperty("address"));
        RSEInternalFrameworkTestCase.assertEquals((String)"Property user id does not match!", (String)"test_user", (String)properties.getProperty("userid"));
        RSEInternalFrameworkTestCase.assertEquals((String)"Property password does not match!", (String)"test_passwd", (String)properties.getProperty("password"));
        Properties props = new Properties();
        props.setProperty("system_type_id", "org.eclipse.rse.systemtype.ssh");
        props.setProperty("userid", "local_user");
        props.setProperty("password", "local_passwd");
        properties = this.getConnectionManager().loadConnectionProperties(props, true);
        RSEInternalFrameworkTestCase.assertNotNull((String)("Failed to load test connection properties from location " + location.toOSString()), (Object)properties);
        RSEInternalFrameworkTestCase.assertEquals((String)"Property name does not match!", (String)"Local", (String)properties.getProperty("name"));
        RSEInternalFrameworkTestCase.assertNull((String)"Property profile name does not match!", (Object)properties.getProperty("profile_name"));
        RSEInternalFrameworkTestCase.assertEquals((String)"Property system type does not match!", (String)"org.eclipse.rse.systemtype.ssh", (String)properties.getProperty("system_type_id"));
        RSEInternalFrameworkTestCase.assertEquals((String)"Property remote system address does not match!", (String)"localhost", (String)properties.getProperty("address"));
        RSEInternalFrameworkTestCase.assertEquals((String)"Property user id does not match!", (String)"local_user", (String)properties.getProperty("userid"));
        RSEInternalFrameworkTestCase.assertEquals((String)"Property password does not match!", (String)"local_passwd", (String)properties.getProperty("password"));
        properties = this.getConnectionManager().loadConnectionProperties(props, false);
        RSEInternalFrameworkTestCase.assertNotNull((String)("Failed to load test connection properties from location " + location.toOSString()), (Object)properties);
        RSEInternalFrameworkTestCase.assertNull((String)"Property name does not match!", (Object)properties.getProperty("name"));
        RSEInternalFrameworkTestCase.assertNull((String)"Property profile name does not match!", (Object)properties.getProperty("profile_name"));
        RSEInternalFrameworkTestCase.assertEquals((String)"Property system type does not match!", (String)"org.eclipse.rse.systemtype.ssh", (String)properties.getProperty("system_type_id"));
        RSEInternalFrameworkTestCase.assertNull((String)"Property remote system address does not match!", (Object)properties.getProperty("address"));
        RSEInternalFrameworkTestCase.assertEquals((String)"Property user id does not match!", (String)"local_user", (String)properties.getProperty("userid"));
        RSEInternalFrameworkTestCase.assertEquals((String)"Property password does not match!", (String)"local_passwd", (String)properties.getProperty("password"));
    }

    private static class TestJob
    extends Job {
        final List params;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.tests.internal.RSEInternalFrameworkTestCase");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public TestJob(List params) {
            super("Test Job");
            if (!$assertionsDisabled && params == null) {
                throw new AssertionError();
            }
            this.params = params;
        }

        protected IStatus run(IProgressMonitor monitor) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(this){
                final /* synthetic */ TestJob this$1;
                {
                    this.this$1 = testJob;
                }

                public void run() {
                    this.this$1.params.add(Boolean.TRUE);
                }
            });
            return Status.OK_STATUS;
        }
    }

    private static class TestWaiter
    implements RSEWaitAndDispatchUtil.IInterruptCondition {
        private final List params;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.tests.internal.RSEInternalFrameworkTestCase");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public TestWaiter(List params) {
            if (!$assertionsDisabled && params == null) {
                throw new AssertionError();
            }
            this.params = params;
        }

        public boolean isTrue() {
            return this.params.size() > 0;
        }

        public void dispose() {
            this.params.clear();
        }
    }
}

