/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.subsystems.files;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.ISystemResourceSet;
import org.eclipse.rse.core.model.SystemRemoteResourceSet;
import org.eclipse.rse.core.model.SystemStartHere;
import org.eclipse.rse.core.model.SystemWorkspaceResourceSet;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISystemDragDropAdapter;
import org.eclipse.rse.files.ui.resources.UniversalFileTransferUtility;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.IFileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.tests.RSETestsPlugin;
import org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTest;
import org.eclipse.rse.tests.subsystems.files.FileServiceHelper;
import org.eclipse.rse.ui.RSEUIPlugin;

public class FileServiceArchiveTestDStore
extends FileServiceArchiveTest {
    private boolean fPreference_ALERT_SSL;
    private boolean fPreference_ALERT_NONSSL;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public FileServiceArchiveTestDStore(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("FileServiceArchiveTestDStore");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz, (String)"testCopyBatchToArchiveFile"));
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz2, (String)"testCopyBatchToVirtualFileLevelOne"));
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz3, (String)"testCopyBatchToVirtualFileLevelTwo"));
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz4, (String)"testCopyBatchVirtualFile"));
        Class<?> clazz5 = class$0;
        if (clazz5 == null) {
            try {
                clazz5 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz5, (String)"testCopyBatchVirtualFileLevelTwo"));
        Class<?> clazz6 = class$0;
        if (clazz6 == null) {
            try {
                clazz6 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz6, (String)"testCopyToArchiveFile"));
        Class<?> clazz7 = class$0;
        if (clazz7 == null) {
            try {
                clazz7 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz7, (String)"testCopyToVirtualFileLevelOne"));
        Class<?> clazz8 = class$0;
        if (clazz8 == null) {
            try {
                clazz8 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz8, (String)"testCopyToVirtualFileLevelTwo"));
        Class<?> clazz9 = class$0;
        if (clazz9 == null) {
            try {
                clazz9 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz9, (String)"testCopyVirtualBatchToArchiveFile"));
        Class<?> clazz10 = class$0;
        if (clazz10 == null) {
            try {
                clazz10 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz10, (String)"testCopyVirtualBatchToVirtualFileLevelOne"));
        Class<?> clazz11 = class$0;
        if (clazz11 == null) {
            try {
                clazz11 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz11, (String)"testCopyVirtualBatchToVirtualFileLevelTwo"));
        Class<?> clazz12 = class$0;
        if (clazz12 == null) {
            try {
                clazz12 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz12, (String)"testCopyVirtualFile"));
        Class<?> clazz13 = class$0;
        if (clazz13 == null) {
            try {
                clazz13 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz13, (String)"testCopyVirtualFileLevelTwo"));
        Class<?> clazz14 = class$0;
        if (clazz14 == null) {
            try {
                clazz14 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz14, (String)"testCreateZipFile"));
        Class<?> clazz15 = class$0;
        if (clazz15 == null) {
            try {
                clazz15 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz15, (String)"testMoveToArchiveFile"));
        Class<?> clazz16 = class$0;
        if (clazz16 == null) {
            try {
                clazz16 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz16, (String)"testMoveToVirtualFileLevelOne"));
        Class<?> clazz17 = class$0;
        if (clazz17 == null) {
            try {
                clazz17 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz17, (String)"testMoveToVirtualFileLevelTwo"));
        Class<?> clazz18 = class$0;
        if (clazz18 == null) {
            try {
                clazz18 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz18, (String)"testMoveVirtualFile"));
        Class<?> clazz19 = class$0;
        if (clazz19 == null) {
            try {
                clazz19 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz19, (String)"testMoveVirtualFileLevelTwo"));
        Class<?> clazz20 = class$0;
        if (clazz20 == null) {
            try {
                clazz20 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz20, (String)"testRenameVirtualFile"));
        Class<?> clazz21 = class$0;
        if (clazz21 == null) {
            try {
                clazz21 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz21, (String)"testCreateTarFile"));
        Class<?> clazz22 = class$0;
        if (clazz22 == null) {
            try {
                clazz22 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz22, (String)"testCopyTarVirtualFile"));
        Class<?> clazz23 = class$0;
        if (clazz23 == null) {
            try {
                clazz23 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz23, (String)"testCopyTarVirtualFileLevelFour"));
        Class<?> clazz24 = class$0;
        if (clazz24 == null) {
            try {
                clazz24 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz24, (String)"testCopyToTarArchiveFile"));
        Class<?> clazz25 = class$0;
        if (clazz25 == null) {
            try {
                clazz25 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz25, (String)"testCopyToTarVirtualFileLevelOne"));
        Class<?> clazz26 = class$0;
        if (clazz26 == null) {
            try {
                clazz26 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz26, (String)"testCopyToTarVirtualFileLevelFour"));
        Class<?> clazz27 = class$0;
        if (clazz27 == null) {
            try {
                clazz27 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz27, (String)"testDeleteTarVirtualFile"));
        Class<?> clazz28 = class$0;
        if (clazz28 == null) {
            try {
                clazz28 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz28, (String)"testMoveTarVirtualFile"));
        Class<?> clazz29 = class$0;
        if (clazz29 == null) {
            try {
                clazz29 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz29, (String)"testMoveTarVirtualFileLevelFour"));
        Class<?> clazz30 = class$0;
        if (clazz30 == null) {
            try {
                clazz30 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz30, (String)"testMoveToTarArchiveFile"));
        Class<?> clazz31 = class$0;
        if (clazz31 == null) {
            try {
                clazz31 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz31, (String)"testMoveToTarVirtualFileLevelOne"));
        Class<?> clazz32 = class$0;
        if (clazz32 == null) {
            try {
                clazz32 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz32, (String)"testMoveToVirtualFileLevelFour"));
        Class<?> clazz33 = class$0;
        if (clazz33 == null) {
            try {
                clazz33 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz33, (String)"testRenameTarVirtualFile"));
        Class<?> clazz34 = class$0;
        if (clazz34 == null) {
            try {
                clazz34 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz34, (String)"testCopyBatchTarVirtualFileLevelFive"));
        Class<?> clazz35 = class$0;
        if (clazz35 == null) {
            try {
                clazz35 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz35, (String)"testCopyBatchToTarArchiveFile"));
        Class<?> clazz36 = class$0;
        if (clazz36 == null) {
            try {
                clazz36 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz36, (String)"testCopyBatchToTarVirtualFileLevelFour"));
        Class<?> clazz37 = class$0;
        if (clazz37 == null) {
            try {
                clazz37 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz37, (String)"testSuperTransferLocalToRemote"));
        Class<?> clazz38 = class$0;
        if (clazz38 == null) {
            try {
                clazz38 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz38, (String)"testSuperTransferDStoreWindowsAndDStore"));
        Class<?> clazz39 = class$0;
        if (clazz39 == null) {
            try {
                clazz39 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz39, (String)"testSuperTransferDStoreToLocal"));
        Class<?> clazz40 = class$0;
        if (clazz40 == null) {
            try {
                clazz40 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz40, (String)"testOpenFileFromTarArchive"));
        Class<?> clazz41 = class$0;
        if (clazz41 == null) {
            try {
                clazz41 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz41, (String)"testCopyVirtualFileFromDStoreToLocal"));
        Class<?> clazz42 = class$0;
        if (clazz42 == null) {
            try {
                clazz42 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz42, (String)"testCopyVirtualFileLevelTwoFromDStoreToLocal"));
        Class<?> clazz43 = class$0;
        if (clazz43 == null) {
            try {
                clazz43 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz43, (String)"testCopyVirtualFileFromLocalToDStore"));
        Class<?> clazz44 = class$0;
        if (clazz44 == null) {
            try {
                clazz44 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz44, (String)"testCopyVirtualFileLevelTwoFromLocalToDStore"));
        Class<?> clazz45 = class$0;
        if (clazz45 == null) {
            try {
                clazz45 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz45, (String)"testCopyVFLevelTwoToArchiveFromDStoreToLocal"));
        Class<?> clazz46 = class$0;
        if (clazz46 == null) {
            try {
                clazz46 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz46, (String)"testCopyVFLevelTwoToArchiveFromLocalToDStore"));
        Class<?> clazz47 = class$0;
        if (clazz47 == null) {
            try {
                clazz47 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz47, (String)"testCopyVFToArchiveFromDStoreToLocal"));
        Class<?> clazz48 = class$0;
        if (clazz48 == null) {
            try {
                clazz48 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz48, (String)"testCopyVFToArchiveFromLocalToDStore"));
        Class<?> clazz49 = class$0;
        if (clazz49 == null) {
            try {
                clazz49 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz49, (String)"testCopyVFToVFFromDStoreToLocal"));
        Class<?> clazz50 = class$0;
        if (clazz50 == null) {
            try {
                clazz50 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz50, (String)"testCopyVFToVFLevelTwoFromDStoreToLocal"));
        Class<?> clazz51 = class$0;
        if (clazz51 == null) {
            try {
                clazz51 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz51, (String)"testCopyVFToVFFromLocalToDStore"));
        Class<?> clazz52 = class$0;
        if (clazz52 == null) {
            try {
                clazz52 = class$0 = Class.forName("org.eclipse.rse.tests.subsystems.files.FileServiceArchiveTestDStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        suite.addTest(TestSuite.createTest((Class)clazz52, (String)"testCopyVFToVFLevelTwoFromLocalToDStore"));
        return suite;
    }

    protected void setupFileSubSystem() {
        IHost dstoreHost = this.getLinuxHost();
        FileServiceArchiveTestDStore.assertNotNull((Object)dstoreHost);
        ISystemRegistry sr = SystemStartHere.getSystemRegistry();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.rse.services.files.IFileService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISubSystem[] ss = sr.getServiceSubSystems(dstoreHost, (Class)clazz);
        int i = 0;
        while (i < ss.length) {
            if (ss[i] instanceof IFileServiceSubSystem) {
                this.fss = (IFileServiceSubSystem)ss[i];
                this.fs = this.fss.getFileService();
            }
            ++i;
        }
        IHost localHost = this.getLocalSystemConnection();
        sr = SystemStartHere.getSystemRegistry();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.rse.services.files.IFileService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ss = sr.getServiceSubSystems(localHost, (Class)clazz2);
        int i2 = 0;
        while (i2 < ss.length) {
            if (ss[i2] instanceof IFileServiceSubSystem) {
                this.localFss = (IFileServiceSubSystem)ss[i2];
            }
            ++i2;
        }
        try {
            IConnectorService connectionService = this.fss.getConnectorService();
            connectionService.acquireCredentials(false);
            connectionService.connect(this.mon);
        }
        catch (Exception e) {
            FileServiceArchiveTestDStore.assertTrue((String)("Exception creating temp dir " + e.getStackTrace().toString()), (boolean)false);
        }
    }

    public void tearDown() throws Exception {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        store.setValue("org.eclipse.rse.preferences.alert.ssl", this.fPreference_ALERT_SSL);
        store.setValue("org.eclipse.rse.preferences.alert.nonssl", this.fPreference_ALERT_NONSSL);
        super.tearDown();
    }

    public void testSuperTransferLocalToRemote() throws Exception {
        String tempPath = FileServiceArchiveTestDStore.getWorkspace().getRoot().getLocation().append("temp").toString();
        IFileStore temp = this.createDir(tempPath, true);
        this.createSuperTransferFolder(temp);
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        boolean preference_DOSUPERTRANSFER = store.getBoolean("org.eclipse.rse.subsystems.files.core.preferences.dosupertransfer");
        store.setValue("org.eclipse.rse.subsystems.files.core.preferences.dosupertransfer", true);
        IRemoteFile sourceFolderToCopy1 = this.localFss.getRemoteFileObject(String.valueOf(tempPath) + '\\' + this.folderToCopyName3, this.mon);
        IAdaptable iAdaptable = (IAdaptable)sourceFolderToCopy1;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISystemDragDropAdapter srcAdapter1 = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz);
        SystemRemoteResourceSet fromSet3 = new SystemRemoteResourceSet((ISubSystem)this.localFss, srcAdapter1);
        fromSet3.addResource((Object)sourceFolderToCopy1);
        ISystemResourceSet tempObjects3 = srcAdapter1.doDrag(fromSet3, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects3), (IRemoteFile)this.tempDir, (IProgressMonitor)this.mon, (boolean)true);
        Object[] children = this.fss.resolveFilterString((Object)this.tempDir, null, this.mon);
        FileServiceArchiveTestDStore.assertTrue((children.length == 1 ? 1 : 0) != 0);
        Object theCopiedFolder = this.getChildFromFolder(this.tempDir, this.folderToCopyName3);
        FileServiceArchiveTestDStore.assertNotNull((Object)theCopiedFolder);
        String[] childrenToCheck = new String[]{"aaaaaaaa", "aaaab", "epdcdump01.hex12a", "RSE-SDK-2.0RC1.zip"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents((IRemoteFile)theCopiedFolder, childrenToCheck, typesToCheck);
        store.setValue("org.eclipse.rse.subsystems.files.core.preferences.dosupertransfer", preference_DOSUPERTRANSFER);
        temp.delete(0, this.mon);
    }

    public void testSuperTransferDStoreWindowsAndDStore() throws Exception {
        String tempPath = FileServiceArchiveTestDStore.getWorkspace().getRoot().getLocation().append("temp").toString();
        IFileStore temp = this.createDir(tempPath, true);
        this.createSuperTransferFolder(temp);
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        boolean preference_DOSUPERTRANSFER = store.getBoolean("org.eclipse.rse.subsystems.files.core.preferences.dosupertransfer");
        store.setValue("org.eclipse.rse.subsystems.files.core.preferences.dosupertransfer", true);
        IRemoteFile sourceFolderToCopy1 = this.localFss.getRemoteFileObject(String.valueOf(tempPath) + '\\' + this.folderToCopyName3, this.mon);
        IAdaptable iAdaptable = (IAdaptable)sourceFolderToCopy1;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISystemDragDropAdapter srcAdapter1 = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz);
        SystemRemoteResourceSet fromSet1 = new SystemRemoteResourceSet((ISubSystem)this.localFss, srcAdapter1);
        fromSet1.addResource((Object)sourceFolderToCopy1);
        ISystemResourceSet tempObjects1 = srcAdapter1.doDrag(fromSet1, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects1), (IRemoteFile)this.tempDir, (IProgressMonitor)this.mon, (boolean)true);
        this.fss.resolveFilterString((Object)this.tempDir, null, this.mon);
        IHost dstoreHost = this.getWindowsHost();
        FileServiceArchiveTestDStore.assertNotNull((Object)dstoreHost);
        ISystemRegistry sr = SystemStartHere.getSystemRegistry();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.rse.services.files.IFileService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISubSystem[] ss = sr.getServiceSubSystems(dstoreHost, (Class)clazz2);
        IFileServiceSubSystem dstoreWindowsFss = null;
        int i = 0;
        while (i < ss.length) {
            if (ss[i] instanceof IFileServiceSubSystem) {
                dstoreWindowsFss = (IFileServiceSubSystem)ss[i];
            }
            ++i;
        }
        FileServiceArchiveTestDStore.assertNotNull(dstoreWindowsFss);
        IConnectorService dstoreWindowsConnectionService = dstoreWindowsFss.getConnectorService();
        dstoreWindowsConnectionService.acquireCredentials(false);
        dstoreWindowsConnectionService.connect(this.mon);
        IRemoteFile dstoreWindowsTempDir = null;
        try {
            IRemoteFile homeDirectory = dstoreWindowsFss.getRemoteFileObject(".", this.mon);
            String baseFolderName = "rsetest";
            String homeFolderName = homeDirectory.getAbsolutePath();
            String testFolderName = FileServiceHelper.getRandomLocation(dstoreWindowsFss, homeFolderName, baseFolderName, this.mon);
            dstoreWindowsTempDir = this.createFileOrFolder(dstoreWindowsFss, homeFolderName, testFolderName, true);
        }
        catch (Exception e) {
            FileServiceArchiveTestDStore.fail((String)("Problem encountered: " + e.getStackTrace().toString()));
        }
        IRemoteFile sourceFolderToCopy2 = (IRemoteFile)this.getChildFromFolder(this.tempDir, this.folderToCopyName3);
        IAdaptable iAdaptable2 = (IAdaptable)sourceFolderToCopy2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISystemDragDropAdapter srcAdapter2 = (ISystemDragDropAdapter)iAdaptable2.getAdapter((Class)clazz3);
        SystemRemoteResourceSet fromSet2 = new SystemRemoteResourceSet((ISubSystem)this.fss, srcAdapter2);
        fromSet2.addResource((Object)sourceFolderToCopy2);
        ISystemResourceSet tempObjects2 = srcAdapter2.doDrag(fromSet2, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects2), (IRemoteFile)dstoreWindowsTempDir, (IProgressMonitor)this.mon, (boolean)true);
        Object[] children = dstoreWindowsFss.resolveFilterString((Object)dstoreWindowsTempDir, null, this.mon);
        FileServiceArchiveTestDStore.assertTrue((children.length == 1 ? 1 : 0) != 0);
        Object theCopiedFolder = this.getChildFromFolder(dstoreWindowsFss, dstoreWindowsTempDir, this.folderToCopyName3);
        FileServiceArchiveTestDStore.assertNotNull((Object)theCopiedFolder);
        String[] childrenToCheck = new String[]{"aaaaaaaa", "aaaab", "epdcdump01.hex12a", "RSE-SDK-2.0RC1.zip"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents(dstoreWindowsFss, (IRemoteFile)theCopiedFolder, childrenToCheck, typesToCheck);
        store.setValue("org.eclipse.rse.subsystems.files.core.preferences.dosupertransfer", preference_DOSUPERTRANSFER);
        try {
            dstoreWindowsFss.delete(dstoreWindowsTempDir, this.mon);
        }
        catch (SystemMessageException msg) {
            System.err.println("Exception on deleting local temp dir: " + msg.getLocalizedMessage());
        }
        temp.delete(0, this.mon);
    }

    public void testSuperTransferDStoreToLocal() throws Exception {
        String tempPath = FileServiceArchiveTestDStore.getWorkspace().getRoot().getLocation().append("temp").toString();
        IFileStore temp = this.createDir(tempPath, true);
        this.createSuperTransferFolder(temp);
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        boolean preference_DOSUPERTRANSFER = store.getBoolean("org.eclipse.rse.subsystems.files.core.preferences.dosupertransfer");
        store.setValue("org.eclipse.rse.subsystems.files.core.preferences.dosupertransfer", true);
        IRemoteFile sourceFolderToCopy1 = this.localFss.getRemoteFileObject(String.valueOf(tempPath) + '\\' + this.folderToCopyName3, this.mon);
        IAdaptable iAdaptable = (IAdaptable)sourceFolderToCopy1;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISystemDragDropAdapter srcAdapter1 = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz);
        SystemRemoteResourceSet fromSet1 = new SystemRemoteResourceSet((ISubSystem)this.localFss, srcAdapter1);
        fromSet1.addResource((Object)sourceFolderToCopy1);
        ISystemResourceSet tempObjects1 = srcAdapter1.doDrag(fromSet1, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects1), (IRemoteFile)this.tempDir, (IProgressMonitor)this.mon, (boolean)true);
        this.fss.resolveFilterString((Object)this.tempDir, null, this.mon);
        IRemoteFile localTempDir = null;
        try {
            IRemoteFile homeDirectory = this.localFss.getRemoteFileObject(".", this.mon);
            String baseFolderName = "rsetest";
            String homeFolderName = homeDirectory.getAbsolutePath();
            String testFolderName = FileServiceHelper.getRandomLocation(this.localFss, homeFolderName, baseFolderName, this.mon);
            localTempDir = this.createFileOrFolder(this.localFss, homeFolderName, testFolderName, true);
        }
        catch (Exception e) {
            FileServiceArchiveTestDStore.fail((String)("Problem encountered: " + e.getStackTrace().toString()));
        }
        IRemoteFile sourceFolderToCopy2 = (IRemoteFile)this.getChildFromFolder(this.tempDir, this.folderToCopyName3);
        IAdaptable iAdaptable2 = (IAdaptable)sourceFolderToCopy2;
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISystemDragDropAdapter srcAdapter2 = (ISystemDragDropAdapter)iAdaptable2.getAdapter((Class)clazz2);
        SystemRemoteResourceSet fromSet2 = new SystemRemoteResourceSet((ISubSystem)this.fss, srcAdapter2);
        fromSet2.addResource((Object)sourceFolderToCopy2);
        ISystemResourceSet tempObjects2 = srcAdapter2.doDrag(fromSet2, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects2), (IRemoteFile)localTempDir, (IProgressMonitor)this.mon, (boolean)true);
        Object[] localChildren = this.localFss.resolveFilterString((Object)localTempDir, null, this.mon);
        FileServiceArchiveTestDStore.assertTrue((localChildren.length == 1 ? 1 : 0) != 0);
        Object theCopiedFolderLocal = this.getChildFromFolder(this.localFss, localTempDir, this.folderToCopyName3);
        FileServiceArchiveTestDStore.assertNotNull((Object)theCopiedFolderLocal);
        String[] childrenToCheck = new String[]{"aaaaaaaa", "aaaab", "epdcdump01.hex12a", "RSE-SDK-2.0RC1.zip"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents(this.localFss, (IRemoteFile)theCopiedFolderLocal, childrenToCheck, typesToCheck);
        store.setValue("org.eclipse.rse.subsystems.files.core.preferences.dosupertransfer", preference_DOSUPERTRANSFER);
        try {
            this.localFss.delete(localTempDir, this.mon);
        }
        catch (SystemMessageException msg) {
            System.err.println("Exception on deleting local temp dir: " + msg.getLocalizedMessage());
        }
        temp.delete(0, this.mon);
    }

    public void testCopyVirtualFileFromDStoreToLocal() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceZipFiles();
        String sourceZipFileName = this.zipSourceFileName1;
        IRemoteFile sourceZipFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceZipFileName);
        FileServiceArchiveTestDStore.assertNotNull((Object)sourceZipFile);
        IRemoteFile localTempDir = null;
        try {
            IRemoteFile homeDirectory = this.localFss.getRemoteFileObject(".", this.mon);
            String baseFolderName = "rsetest";
            String homeFolderName = homeDirectory.getAbsolutePath();
            String testFolderName = FileServiceHelper.getRandomLocation(this.localFss, homeFolderName, baseFolderName, this.mon);
            localTempDir = this.createFileOrFolder(this.localFss, homeFolderName, testFolderName, true);
        }
        catch (Exception e) {
            FileServiceArchiveTestDStore.fail((String)("Problem encountered: " + e.getStackTrace().toString()));
        }
        String folderName = "folder1";
        IRemoteFile folder1 = this.createFileOrFolder(this.localFss, localTempDir.getAbsolutePath(), folderName, true);
        FileServiceArchiveTestDStore.assertNotNull((Object)folder1);
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(sourceZipFile, this.folderToCopyName1);
        IAdaptable iAdaptable = (IAdaptable)firstLevelChild;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISystemDragDropAdapter srcAdapter1 = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz);
        SystemRemoteResourceSet fromSet3 = new SystemRemoteResourceSet((ISubSystem)this.fss, srcAdapter1);
        fromSet3.addResource((Object)firstLevelChild);
        ISystemResourceSet tempObjects3 = srcAdapter1.doDrag(fromSet3, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects3), (IRemoteFile)folder1, (IProgressMonitor)this.mon, (boolean)true);
        Thread.sleep(50L);
        Object copiedVirtualFolder = this.getChildFromFolder(this.localFss, folder1, this.folderToCopyName1);
        FileServiceArchiveTestDStore.assertNotNull((Object)copiedVirtualFolder);
        String[] contents = new String[]{"Team", "TypeFilters", "xuanchentp", ".compatibility", ".project"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents(this.localFss, (IRemoteFile)copiedVirtualFolder, contents, typesToCheck);
        try {
            this.localFss.delete(localTempDir, this.mon);
        }
        catch (SystemMessageException msg) {
            System.err.println("Exception on deleting local temp dir: " + msg.getLocalizedMessage());
        }
    }

    public void testCopyVirtualFileLevelTwoFromDStoreToLocal() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceZipFiles();
        String sourceZipFileName = this.zipSourceFileName1;
        IRemoteFile sourceZipFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceZipFileName);
        FileServiceArchiveTestDStore.assertNotNull((Object)sourceZipFile);
        IRemoteFile localTempDir = null;
        try {
            IRemoteFile homeDirectory = this.localFss.getRemoteFileObject(".", this.mon);
            String baseFolderName = "rsetest";
            String homeFolderName = homeDirectory.getAbsolutePath();
            String testFolderName = FileServiceHelper.getRandomLocation(this.localFss, homeFolderName, baseFolderName, this.mon);
            localTempDir = this.createFileOrFolder(this.localFss, homeFolderName, testFolderName, true);
        }
        catch (Exception e) {
            FileServiceArchiveTestDStore.fail((String)("Problem encountered: " + e.getStackTrace().toString()));
        }
        String folderName = "folder1";
        String secondLeveChildName = "Team";
        IRemoteFile folder1 = this.createFileOrFolder(this.localFss, localTempDir.getAbsolutePath(), folderName, true);
        FileServiceArchiveTestDStore.assertNotNull((Object)folder1);
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(sourceZipFile, this.folderToCopyName1);
        IRemoteFile secondLevelChild = (IRemoteFile)this.getChildFromFolder(firstLevelChild, "Team");
        IAdaptable iAdaptable = (IAdaptable)secondLevelChild;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISystemDragDropAdapter srcAdapter1 = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz);
        SystemRemoteResourceSet fromSet3 = new SystemRemoteResourceSet((ISubSystem)this.fss, srcAdapter1);
        fromSet3.addResource((Object)secondLevelChild);
        ISystemResourceSet tempObjects3 = srcAdapter1.doDrag(fromSet3, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects3), (IRemoteFile)folder1, (IProgressMonitor)this.mon, (boolean)true);
        Thread.sleep(50L);
        Object copiedVirtualFolder = this.getChildFromFolder(this.localFss, folder1, secondLeveChildName);
        FileServiceArchiveTestDStore.assertNotNull((Object)copiedVirtualFolder);
        String[] contents = new String[]{"Connections", "Filters", "profile.xmi"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE};
        this.checkFolderContents(this.localFss, (IRemoteFile)copiedVirtualFolder, contents, typesToCheck);
        try {
            this.localFss.delete(localTempDir, this.mon);
        }
        catch (SystemMessageException msg) {
            System.err.println("Exception on deleting local temp dir: " + msg.getLocalizedMessage());
        }
    }

    public void testCopyVirtualFileFromLocalToDStore() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        IRemoteFile sourceZipLocation = this.createSourceZipFiles(this.localFss);
        String sourceZipFileName = this.zipSourceFileName1;
        IRemoteFile sourceZipFile = (IRemoteFile)this.getChildFromFolder(this.localFss, sourceZipLocation, sourceZipFileName);
        FileServiceArchiveTestDStore.assertNotNull((Object)sourceZipFile);
        String folderName = "folder1";
        IRemoteFile folder1 = this.createFileOrFolder(this.fss, this.tempDir.getAbsolutePath(), folderName, true);
        FileServiceArchiveTestDStore.assertNotNull((Object)folder1);
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(this.localFss, sourceZipFile, this.folderToCopyName1);
        IAdaptable iAdaptable = (IAdaptable)firstLevelChild;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISystemDragDropAdapter srcAdapter1 = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz);
        SystemRemoteResourceSet fromSet3 = new SystemRemoteResourceSet((ISubSystem)this.localFss, srcAdapter1);
        fromSet3.addResource((Object)firstLevelChild);
        ISystemResourceSet tempObjects3 = srcAdapter1.doDrag(fromSet3, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects3), (IRemoteFile)folder1, (IProgressMonitor)this.mon, (boolean)true);
        Object copiedVirtualFolder = this.getChildFromFolder(this.fss, folder1, this.folderToCopyName1);
        FileServiceArchiveTestDStore.assertNotNull((Object)copiedVirtualFolder);
        String[] contents = new String[]{"Team", "TypeFilters", "xuanchentp", ".compatibility", ".project"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents(this.fss, (IRemoteFile)copiedVirtualFolder, contents, typesToCheck);
        try {
            this.localFss.delete(sourceZipLocation, this.mon);
        }
        catch (SystemMessageException msg) {
            System.err.println("Exception on deleting local temp dir: " + msg.getLocalizedMessage());
        }
    }

    public void testCopyVirtualFileLevelTwoFromLocalToDStore() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        IRemoteFile sourceZipLocation = this.createSourceZipFiles(this.localFss);
        String sourceZipFileName = this.zipSourceFileName1;
        IRemoteFile sourceZipFile = (IRemoteFile)this.getChildFromFolder(this.localFss, sourceZipLocation, sourceZipFileName);
        FileServiceArchiveTestDStore.assertNotNull((Object)sourceZipFile);
        String folderName = "folder1";
        IRemoteFile folder1 = this.createFileOrFolder(this.fss, this.tempDir.getAbsolutePath(), folderName, true);
        FileServiceArchiveTestDStore.assertNotNull((Object)folder1);
        String secondLeveChildName = "Team";
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(this.localFss, sourceZipFile, this.folderToCopyName1);
        IRemoteFile secondLevelChild = (IRemoteFile)this.getChildFromFolder(this.localFss, firstLevelChild, secondLeveChildName);
        IAdaptable iAdaptable = (IAdaptable)secondLevelChild;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISystemDragDropAdapter srcAdapter1 = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz);
        SystemRemoteResourceSet fromSet3 = new SystemRemoteResourceSet((ISubSystem)this.localFss, srcAdapter1);
        fromSet3.addResource((Object)secondLevelChild);
        ISystemResourceSet tempObjects3 = srcAdapter1.doDrag(fromSet3, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects3), (IRemoteFile)folder1, (IProgressMonitor)this.mon, (boolean)true);
        Object copiedVirtualFolder = this.getChildFromFolder(this.fss, folder1, secondLeveChildName);
        FileServiceArchiveTestDStore.assertNotNull((Object)copiedVirtualFolder);
        String[] contents = new String[]{"Connections", "Filters", "profile.xmi"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE};
        this.checkFolderContents(this.fss, (IRemoteFile)copiedVirtualFolder, contents, typesToCheck);
        try {
            this.localFss.delete(sourceZipLocation, this.mon);
        }
        catch (SystemMessageException msg) {
            System.err.println("Exception on deleting local temp dir: " + msg.getLocalizedMessage());
        }
    }

    public void testCopyVFToArchiveFromDStoreToLocal() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceZipFiles();
        IRemoteFile localTempDir = this.createSourceZipFiles(this.localFss);
        String sourceZipFileName = this.zipSourceFileName1;
        IRemoteFile sourceZipFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceZipFileName);
        FileServiceArchiveTestDStore.assertNotNull((Object)sourceZipFile);
        IRemoteFile destinationArchiveFile = (IRemoteFile)this.getChildFromFolder(this.localFss, localTempDir, this.zipSourceFileName2);
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(sourceZipFile, this.folderToCopyName1);
        IAdaptable iAdaptable = (IAdaptable)firstLevelChild;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISystemDragDropAdapter srcAdapter1 = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz);
        SystemRemoteResourceSet fromSet3 = new SystemRemoteResourceSet((ISubSystem)this.fss, srcAdapter1);
        fromSet3.addResource((Object)firstLevelChild);
        ISystemResourceSet tempObjects3 = srcAdapter1.doDrag(fromSet3, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects3), (IRemoteFile)destinationArchiveFile, (IProgressMonitor)this.mon, (boolean)true);
        Thread.sleep(50L);
        Object copiedVirtualFolder = this.getChildFromFolder(this.localFss, destinationArchiveFile, this.folderToCopyName1);
        FileServiceArchiveTestDStore.assertNotNull((Object)copiedVirtualFolder);
        String[] contents = new String[]{"Team", "TypeFilters", "xuanchentp", ".compatibility", ".project"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents(this.localFss, (IRemoteFile)copiedVirtualFolder, contents, typesToCheck);
        try {
            this.localFss.delete(localTempDir, this.mon);
        }
        catch (SystemMessageException msg) {
            System.err.println("Exception on deleting local temp dir: " + msg.getLocalizedMessage());
        }
    }

    public void testCopyVFLevelTwoToArchiveFromDStoreToLocal() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceZipFiles();
        IRemoteFile localTempDir = this.createSourceZipFiles(this.localFss);
        String sourceZipFileName = this.zipSourceFileName1;
        IRemoteFile sourceZipFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceZipFileName);
        FileServiceArchiveTestDStore.assertNotNull((Object)sourceZipFile);
        IRemoteFile destinationArchiveFile = (IRemoteFile)this.getChildFromFolder(this.localFss, localTempDir, this.zipSourceFileName2);
        String secondLeveChildName = "Team";
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(this.fss, sourceZipFile, this.folderToCopyName1);
        IRemoteFile secondLevelChild = (IRemoteFile)this.getChildFromFolder(this.fss, firstLevelChild, secondLeveChildName);
        IAdaptable iAdaptable = (IAdaptable)secondLevelChild;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISystemDragDropAdapter srcAdapter1 = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz);
        SystemRemoteResourceSet fromSet3 = new SystemRemoteResourceSet((ISubSystem)this.fss, srcAdapter1);
        fromSet3.addResource((Object)secondLevelChild);
        ISystemResourceSet tempObjects3 = srcAdapter1.doDrag(fromSet3, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects3), (IRemoteFile)destinationArchiveFile, (IProgressMonitor)this.mon, (boolean)true);
        Thread.sleep(50L);
        Object copiedVirtualFolder = this.getChildFromFolder(this.localFss, destinationArchiveFile, secondLeveChildName);
        FileServiceArchiveTestDStore.assertNotNull((Object)copiedVirtualFolder);
        String[] contents = new String[]{"Connections", "Filters", "profile.xmi"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE};
        this.checkFolderContents(this.localFss, (IRemoteFile)copiedVirtualFolder, contents, typesToCheck);
        try {
            this.localFss.delete(localTempDir, this.mon);
        }
        catch (SystemMessageException msg) {
            System.err.println("Exception on deleting local temp dir: " + msg.getLocalizedMessage());
        }
    }

    public void testCopyVFToArchiveFromLocalToDStore() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceZipFiles();
        IRemoteFile localTempDir = this.createSourceZipFiles(this.localFss);
        String sourceZipFileName = this.zipSourceFileName1;
        IRemoteFile sourceZipFile = (IRemoteFile)this.getChildFromFolder(this.localFss, localTempDir, sourceZipFileName);
        FileServiceArchiveTestDStore.assertNotNull((Object)sourceZipFile);
        IRemoteFile destinationArchiveFile = (IRemoteFile)this.getChildFromFolder(this.fss, this.tempDir, this.zipSourceFileName2);
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(this.localFss, sourceZipFile, this.folderToCopyName1);
        IAdaptable iAdaptable = (IAdaptable)firstLevelChild;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISystemDragDropAdapter srcAdapter1 = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz);
        SystemRemoteResourceSet fromSet3 = new SystemRemoteResourceSet((ISubSystem)this.localFss, srcAdapter1);
        fromSet3.addResource((Object)firstLevelChild);
        ISystemResourceSet tempObjects3 = srcAdapter1.doDrag(fromSet3, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects3), (IRemoteFile)destinationArchiveFile, (IProgressMonitor)this.mon, (boolean)true);
        Thread.sleep(50L);
        Object copiedVirtualFolder = this.getChildFromFolder(this.fss, destinationArchiveFile, this.folderToCopyName1);
        FileServiceArchiveTestDStore.assertNotNull((Object)copiedVirtualFolder);
        String[] contents = new String[]{"Team", "TypeFilters", "xuanchentp", ".compatibility", ".project"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents(this.fss, (IRemoteFile)copiedVirtualFolder, contents, typesToCheck);
        try {
            this.localFss.delete(localTempDir, this.mon);
        }
        catch (SystemMessageException msg) {
            System.err.println("Exception on deleting local temp dir: " + msg.getLocalizedMessage());
        }
    }

    public void testCopyVFLevelTwoToArchiveFromLocalToDStore() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceZipFiles();
        IRemoteFile localTempDir = this.createSourceZipFiles(this.localFss);
        String sourceZipFileName = this.zipSourceFileName1;
        IRemoteFile sourceZipFile = (IRemoteFile)this.getChildFromFolder(this.localFss, localTempDir, sourceZipFileName);
        FileServiceArchiveTestDStore.assertNotNull((Object)sourceZipFile);
        IRemoteFile destinationArchiveFile = (IRemoteFile)this.getChildFromFolder(this.fss, this.tempDir, this.zipSourceFileName2);
        String secondLeveChildName = "Team";
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(this.localFss, sourceZipFile, this.folderToCopyName1);
        IRemoteFile secondLevelChild = (IRemoteFile)this.getChildFromFolder(this.localFss, firstLevelChild, secondLeveChildName);
        IAdaptable iAdaptable = (IAdaptable)secondLevelChild;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISystemDragDropAdapter srcAdapter1 = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz);
        SystemRemoteResourceSet fromSet3 = new SystemRemoteResourceSet((ISubSystem)this.localFss, srcAdapter1);
        fromSet3.addResource((Object)secondLevelChild);
        ISystemResourceSet tempObjects3 = srcAdapter1.doDrag(fromSet3, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects3), (IRemoteFile)destinationArchiveFile, (IProgressMonitor)this.mon, (boolean)true);
        Thread.sleep(50L);
        Object copiedVirtualFolder = this.getChildFromFolder(this.fss, destinationArchiveFile, secondLeveChildName);
        FileServiceArchiveTestDStore.assertNotNull((Object)copiedVirtualFolder);
        String[] contents = new String[]{"Connections", "Filters", "profile.xmi"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE};
        this.checkFolderContents(this.fss, (IRemoteFile)copiedVirtualFolder, contents, typesToCheck);
        try {
            this.localFss.delete(localTempDir, this.mon);
        }
        catch (SystemMessageException msg) {
            System.err.println("Exception on deleting local temp dir: " + msg.getLocalizedMessage());
        }
    }

    public void testCopyVFToVFFromDStoreToLocal() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceZipFiles();
        IRemoteFile localTempDir = this.createSourceZipFiles(this.localFss);
        String sourceZipFileName = this.zipSourceFileName1;
        IRemoteFile sourceZipFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceZipFileName);
        FileServiceArchiveTestDStore.assertNotNull((Object)sourceZipFile);
        IRemoteFile destinationArchiveFile = (IRemoteFile)this.getChildFromFolder(this.localFss, localTempDir, this.zipSourceFileName2);
        IRemoteFile destinationVirtualFolder = (IRemoteFile)this.getChildFromFolder(this.localFss, destinationArchiveFile, this.folderToCopyName2);
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(sourceZipFile, this.folderToCopyName1);
        IAdaptable iAdaptable = (IAdaptable)firstLevelChild;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISystemDragDropAdapter srcAdapter1 = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz);
        SystemRemoteResourceSet fromSet3 = new SystemRemoteResourceSet((ISubSystem)this.fss, srcAdapter1);
        fromSet3.addResource((Object)firstLevelChild);
        ISystemResourceSet tempObjects3 = srcAdapter1.doDrag(fromSet3, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects3), (IRemoteFile)destinationVirtualFolder, (IProgressMonitor)this.mon, (boolean)true);
        Thread.sleep(50L);
        Object copiedVirtualFolder = this.getChildFromFolder(this.localFss, destinationVirtualFolder, this.folderToCopyName1);
        FileServiceArchiveTestDStore.assertNotNull((Object)copiedVirtualFolder);
        String[] contents = new String[]{"Team", "TypeFilters", "xuanchentp", ".compatibility", ".project"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents(this.localFss, (IRemoteFile)copiedVirtualFolder, contents, typesToCheck);
        try {
            this.localFss.delete(localTempDir, this.mon);
        }
        catch (SystemMessageException msg) {
            System.err.println("Exception on deleting local temp dir: " + msg.getLocalizedMessage());
        }
    }

    public void testCopyVFToVFLevelTwoFromDStoreToLocal() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceZipFiles();
        IRemoteFile localTempDir = this.createSourceZipFiles(this.localFss);
        String sourceZipFileName = this.zipSourceFileName1;
        IRemoteFile sourceZipFile = (IRemoteFile)this.getChildFromFolder(this.tempDir, sourceZipFileName);
        FileServiceArchiveTestDStore.assertNotNull((Object)sourceZipFile);
        IRemoteFile destinationArchiveFile = (IRemoteFile)this.getChildFromFolder(this.localFss, localTempDir, this.zipSourceFileName2);
        IRemoteFile firstChild = (IRemoteFile)this.getChildFromFolder(this.localFss, destinationArchiveFile, this.folderToCopyName2);
        IRemoteFile destinationVirtualFolder = (IRemoteFile)this.getChildFromFolder(this.localFss, firstChild, "20070319");
        String secondLeveChildName = "Team";
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(this.fss, sourceZipFile, this.folderToCopyName1);
        IRemoteFile secondLevelChild = (IRemoteFile)this.getChildFromFolder(this.fss, firstLevelChild, secondLeveChildName);
        IAdaptable iAdaptable = (IAdaptable)secondLevelChild;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISystemDragDropAdapter srcAdapter1 = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz);
        SystemRemoteResourceSet fromSet3 = new SystemRemoteResourceSet((ISubSystem)this.fss, srcAdapter1);
        fromSet3.addResource((Object)secondLevelChild);
        ISystemResourceSet tempObjects3 = srcAdapter1.doDrag(fromSet3, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects3), (IRemoteFile)destinationVirtualFolder, (IProgressMonitor)this.mon, (boolean)true);
        Thread.sleep(50L);
        Object copiedVirtualFolder = this.getChildFromFolder(this.localFss, destinationVirtualFolder, secondLeveChildName);
        FileServiceArchiveTestDStore.assertNotNull((Object)copiedVirtualFolder);
        String[] contents = new String[]{"Connections", "Filters", "profile.xmi"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE};
        this.checkFolderContents(this.localFss, (IRemoteFile)copiedVirtualFolder, contents, typesToCheck);
        try {
            this.localFss.delete(localTempDir, this.mon);
        }
        catch (SystemMessageException msg) {
            System.err.println("Exception on deleting local temp dir: " + msg.getLocalizedMessage());
        }
    }

    public void testCopyVFToVFFromLocalToDStore() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceZipFiles();
        IRemoteFile localTempDir = this.createSourceZipFiles(this.localFss);
        String sourceZipFileName = this.zipSourceFileName1;
        IRemoteFile sourceZipFile = (IRemoteFile)this.getChildFromFolder(this.localFss, localTempDir, sourceZipFileName);
        FileServiceArchiveTestDStore.assertNotNull((Object)sourceZipFile);
        IRemoteFile destinationArchiveFile = (IRemoteFile)this.getChildFromFolder(this.fss, this.tempDir, this.zipSourceFileName2);
        IRemoteFile destinationVirtualFolder = (IRemoteFile)this.getChildFromFolder(this.fss, destinationArchiveFile, this.folderToCopyName2);
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(this.localFss, sourceZipFile, this.folderToCopyName1);
        IAdaptable iAdaptable = (IAdaptable)firstLevelChild;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISystemDragDropAdapter srcAdapter1 = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz);
        SystemRemoteResourceSet fromSet3 = new SystemRemoteResourceSet((ISubSystem)this.localFss, srcAdapter1);
        fromSet3.addResource((Object)firstLevelChild);
        ISystemResourceSet tempObjects3 = srcAdapter1.doDrag(fromSet3, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects3), (IRemoteFile)destinationVirtualFolder, (IProgressMonitor)this.mon, (boolean)true);
        Thread.sleep(50L);
        Object copiedVirtualFolder = this.getChildFromFolder(this.fss, destinationVirtualFolder, this.folderToCopyName1);
        FileServiceArchiveTestDStore.assertNotNull((Object)copiedVirtualFolder);
        String[] contents = new String[]{"Team", "TypeFilters", "xuanchentp", ".compatibility", ".project"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE, TYPE_FILE};
        this.checkFolderContents(this.fss, (IRemoteFile)copiedVirtualFolder, contents, typesToCheck);
        try {
            this.localFss.delete(localTempDir, this.mon);
        }
        catch (SystemMessageException msg) {
            System.err.println("Exception on deleting local temp dir: " + msg.getLocalizedMessage());
        }
    }

    public void testCopyVFToVFLevelTwoFromLocalToDStore() throws Exception {
        if (!RSETestsPlugin.isTestCaseEnabled("FileServiceTest.testCreateFile")) {
            return;
        }
        this.createSourceZipFiles();
        IRemoteFile localTempDir = this.createSourceZipFiles(this.localFss);
        String sourceZipFileName = this.zipSourceFileName1;
        IRemoteFile sourceZipFile = (IRemoteFile)this.getChildFromFolder(this.localFss, localTempDir, sourceZipFileName);
        FileServiceArchiveTestDStore.assertNotNull((Object)sourceZipFile);
        IRemoteFile destinationArchiveFile = (IRemoteFile)this.getChildFromFolder(this.fss, this.tempDir, this.zipSourceFileName2);
        IRemoteFile firstChild = (IRemoteFile)this.getChildFromFolder(this.fss, destinationArchiveFile, this.folderToCopyName2);
        IRemoteFile destinationVirtualFolder = (IRemoteFile)this.getChildFromFolder(this.fss, firstChild, "20070319");
        String secondLeveChildName = "Team";
        IRemoteFile firstLevelChild = (IRemoteFile)this.getChildFromFolder(this.localFss, sourceZipFile, this.folderToCopyName1);
        IRemoteFile secondLevelChild = (IRemoteFile)this.getChildFromFolder(this.localFss, firstLevelChild, secondLeveChildName);
        IAdaptable iAdaptable = (IAdaptable)secondLevelChild;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISystemDragDropAdapter srcAdapter1 = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz);
        SystemRemoteResourceSet fromSet3 = new SystemRemoteResourceSet((ISubSystem)this.localFss, srcAdapter1);
        fromSet3.addResource((Object)secondLevelChild);
        ISystemResourceSet tempObjects3 = srcAdapter1.doDrag(fromSet3, this.mon);
        UniversalFileTransferUtility.uploadResourcesFromWorkspace((SystemWorkspaceResourceSet)((SystemWorkspaceResourceSet)tempObjects3), (IRemoteFile)destinationVirtualFolder, (IProgressMonitor)this.mon, (boolean)true);
        Thread.sleep(50L);
        Object copiedVirtualFolder = this.getChildFromFolder(this.fss, destinationVirtualFolder, secondLeveChildName);
        FileServiceArchiveTestDStore.assertNotNull((Object)copiedVirtualFolder);
        String[] contents = new String[]{"Connections", "Filters", "profile.xmi"};
        int[] typesToCheck = new int[]{TYPE_FOLDER, TYPE_FOLDER, TYPE_FILE};
        this.checkFolderContents(this.fss, (IRemoteFile)copiedVirtualFolder, contents, typesToCheck);
        try {
            this.localFss.delete(localTempDir, this.mon);
        }
        catch (SystemMessageException msg) {
            System.err.println("Exception on deleting local temp dir: " + msg.getLocalizedMessage());
        }
    }
}

