/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.subsystems.files;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.IFileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IVirtualRemoteFile;
import org.eclipse.rse.tests.core.connection.RSEBaseConnectionTestCase;
import org.eclipse.rse.tests.subsystems.files.FileServiceHelper;

public class FileServiceBaseTest
extends RSEBaseConnectionTestCase {
    protected IFileServiceSubSystem fss;
    protected IFileServiceSubSystem localFss;
    protected IFileService fs;
    protected IRemoteFile tempDir;
    protected String tempDirPath;
    protected IProgressMonitor mon = new NullProgressMonitor();
    public static int TYPE_FILE = 0;
    public static int TYPE_FOLDER = 1;
    static /* synthetic */ Class class$0;

    public FileServiceBaseTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.setupFileSubSystem();
        try {
            IRemoteFile homeDirectory = this.fss.getRemoteFileObject(".", this.mon);
            String baseFolderName = "rsetest";
            String homeFolderName = homeDirectory.getAbsolutePath();
            String testFolderName = FileServiceHelper.getRandomLocation(this.fss, homeFolderName, baseFolderName, this.mon);
            this.tempDir = this.createFileOrFolder(homeFolderName, testFolderName, true);
            this.tempDirPath = this.tempDir.getAbsolutePath();
        }
        catch (Exception e) {
            FileServiceBaseTest.fail((String)("Problem encountered: " + e.getStackTrace().toString()));
        }
    }

    public void tearDown() throws Exception {
        try {
            this.fss.delete(this.tempDir, this.mon);
        }
        catch (SystemMessageException msg) {
            System.err.println("Exception on tearDown: " + msg.getLocalizedMessage());
        }
        super.tearDown();
    }

    public boolean isWindows() {
        return this.fss.getHost().getSystemType().isWindows();
    }

    public String getTestFileName() {
        if (!this.isWindows()) {
            return "a !@#${a}\"' fi\tle\b\\%^&*()?_ =[]~+-'`;:,.|<>";
        }
        return "a !@#${a}'` file%^&()_ =[]~+-;,.";
    }

    public IRemoteFile copySourceFileOrFolder(String sourceFullName, String sourceName, String targetFolderFullName) throws Exception {
        IRemoteFile result = null;
        IRemoteFile originalTargetArchiveFile = this.fss.getRemoteFileObject(sourceFullName, this.mon);
        IRemoteFile targetFolder = this.fss.getRemoteFileObject(targetFolderFullName, this.mon);
        this.fss.copy(originalTargetArchiveFile, targetFolder, sourceName, this.mon);
        result = this.fss.getRemoteFileObject(FileServiceBaseTest.getNewAbsoluteName(targetFolder, sourceName), this.mon);
        this.fss.resolveFilterString((Object)targetFolder, null, this.mon);
        return result;
    }

    public IRemoteFile createFileOrFolder(String targetFolderName, String fileOrFolderName, boolean isFolder) throws Exception {
        return this.createFileOrFolder(this.fss, targetFolderName, fileOrFolderName, isFolder);
    }

    public IRemoteFile createFileOrFolder(IFileServiceSubSystem inputFss, String targetFolderName, String fileOrFolderName, boolean isFolder) throws Exception {
        IRemoteFile result = null;
        IRemoteFile targetFolder = inputFss.getRemoteFileObject(targetFolderName, this.mon);
        String fileOrFolderAbsName = FileServiceBaseTest.getNewAbsoluteName(targetFolder, fileOrFolderName);
        IRemoteFile newFileOrFolderPath = inputFss.getRemoteFileObject(fileOrFolderAbsName, this.mon);
        result = isFolder ? inputFss.createFolder(newFileOrFolderPath, this.mon) : inputFss.createFile(newFileOrFolderPath, this.mon);
        inputFss.resolveFilterString((Object)targetFolder, null, this.mon);
        return result;
    }

    public Object getChildFromFolder(IRemoteFile folderToCheck, String childName) throws Exception {
        return this.getChildFromFolder(this.fss, folderToCheck, childName);
    }

    public Object getChildFromFolder(IFileServiceSubSystem inputFss, IRemoteFile folderToCheck, String childName) throws Exception {
        Object[] children = null;
        Object foundChild = null;
        children = inputFss.resolveFilterString((Object)folderToCheck, null, this.mon);
        int i = 0;
        while (i < children.length) {
            String thisName = ((IRemoteFile)children[i]).getName();
            if (thisName.equals(childName)) {
                foundChild = children[i];
                break;
            }
            ++i;
        }
        return foundChild;
    }

    public void checkFolderContents(IRemoteFile folderToCheck, String[] names, int[] types) throws Exception {
        this.checkFolderContents(this.fss, folderToCheck, names, types);
    }

    public void checkFolderContents(IFileServiceSubSystem inputFss, IRemoteFile folderToCheck, String[] names, int[] types) throws Exception {
        folderToCheck = inputFss.getRemoteFileObject(folderToCheck.getAbsolutePath(), this.mon);
        System.out.println("verifying the contents for folder: " + folderToCheck.getAbsolutePath());
        Object[] children = inputFss.resolveFilterString((Object)folderToCheck, null, this.mon);
        HashMap<String, Object> childrenMap = new HashMap<String, Object>();
        int i = 0;
        while (i < children.length) {
            String thisName = ((IRemoteFile)children[i]).getName();
            childrenMap.put(thisName, children[i]);
            ++i;
        }
        i = 0;
        while (i < names.length) {
            IRemoteFile found = (IRemoteFile)childrenMap.get(names[i]);
            FileServiceBaseTest.assertTrue((String)("Could not find " + names[i]), (found != null ? 1 : 0) != 0);
            FileServiceBaseTest.assertTrue((boolean)found.exists());
            if (types != null && types.length != 0) {
                if (types[i] == TYPE_FILE) {
                    FileServiceBaseTest.assertTrue((boolean)found.isFile());
                } else if (types[i] == TYPE_FOLDER) {
                    FileServiceBaseTest.assertTrue((boolean)found.isDirectory());
                }
            }
            ++i;
        }
    }

    protected static String getNewAbsoluteName(IRemoteFile parentFolder, String newName) {
        String newAbsName = null;
        char sep = parentFolder.getSeparatorChar();
        String parentFolderPath = parentFolder.getAbsolutePath();
        if (parentFolder instanceof IVirtualRemoteFile) {
            sep = '/';
        } else if (parentFolder.isArchive()) {
            sep = '/';
            parentFolderPath = String.valueOf(parentFolderPath) + "#virtual#/";
        }
        newAbsName = parentFolderPath.length() == 1 && parentFolderPath.charAt(0) == '/' && parentFolderPath.charAt(0) == sep ? String.valueOf(sep) + newName : String.valueOf(parentFolderPath) + sep + newName;
        return newAbsName;
    }

    protected IFileStore createDir(IFileStore store, boolean clear) throws CoreException {
        if (clear && store.fetchInfo().exists()) {
            store.delete(0, (IProgressMonitor)new NullProgressMonitor());
        }
        store.mkdir(0, (IProgressMonitor)new NullProgressMonitor());
        IFileInfo info = store.fetchInfo();
        FileServiceBaseTest.assertTrue((String)"createDir.1", (boolean)info.exists());
        FileServiceBaseTest.assertTrue((String)"createDir.1", (boolean)info.isDirectory());
        return store;
    }

    protected IFileStore createDir(String string, boolean clear) throws CoreException {
        return this.createDir(EFS.getFileSystem((String)"file").getStore((IPath)new Path(string)), clear);
    }

    protected void createFile(IFileStore target, String content) throws CoreException {
        target.delete(0, null);
        ByteArrayInputStream input = new ByteArrayInputStream(content.getBytes());
        this.transferData(input, target.openOutputStream(0, null));
        IFileInfo info = target.fetchInfo();
        FileServiceBaseTest.assertTrue((info.exists() && !info.isDirectory() ? 1 : 0) != 0);
    }

    protected void assertClose(InputStream stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {
            FileServiceBaseTest.fail((String)"Failed close in assertClose");
        }
    }

    public InputStream getContents(String text) {
        return new ByteArrayInputStream(text.getBytes());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean compareContent(InputStream a, InputStream b) {
        if (a == null && b == null) {
            return true;
        }
        try {
            int d;
            int c;
            if (a == null || b == null) {
                return false;
            }
            while ((c = a.read()) == (d = b.read()) && c != -1 && d != -1) {
            }
            boolean bl = c == -1 && d == -1;
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
        finally {
            this.assertClose(a);
            this.assertClose(b);
        }
    }

    protected void transferData(InputStream input, OutputStream output) {
        try {
            try {
                int c = 0;
                while ((c = input.read()) != -1) {
                    output.write(c);
                }
            }
            finally {
                input.close();
                output.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            FileServiceBaseTest.assertTrue((String)e.toString(), (boolean)false);
        }
    }

    protected String getRandomString() {
        switch ((int)Math.round(Math.random() * 10.0)) {
            case 0: {
                return "este e' o meu conteudo (portuguese)";
            }
            case 1: {
                return "ho ho ho";
            }
            case 2: {
                return "I'll be back";
            }
            case 3: {
                return "don't worry, be happy";
            }
            case 4: {
                return "there is no imagination for more sentences";
            }
            case 5: {
                return "customize yours";
            }
            case 6: {
                return "foo";
            }
            case 7: {
                return "bar";
            }
            case 8: {
                return "foobar";
            }
            case 9: {
                return "case 9";
            }
        }
        return "these are my contents";
    }

    protected void setupFileSubSystem() {
        IHost localHost = this.getLocalSystemConnection();
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.services.files.IFileService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISubSystem[] ss = sr.getServiceSubSystems(localHost, (Class)clazz);
        int i = 0;
        while (i < ss.length) {
            if (ss[i] instanceof IFileServiceSubSystem) {
                this.fss = (IFileServiceSubSystem)ss[i];
                this.fs = this.fss.getFileService();
            }
            ++i;
        }
        this.localFss = this.fss;
        FileServiceBaseTest.assertNotNull((Object)this.localFss);
    }
}

