/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.subsystems.files;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.SystemStartHere;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.tests.RSETestsPlugin;
import org.eclipse.rse.tests.core.connection.RSEBaseConnectionTestCase;

public class FileSubsystemConsistencyTestCase
extends RSEBaseConnectionTestCase {
    private List _subSystems;
    private List _connections;
    private List _samplePaths;
    private String LOCALTEMPDIR = "C:\\temp";
    static /* synthetic */ Class class$0;

    protected void tearDown() throws Exception {
        if (this._subSystems != null) {
            int i = 0;
            while (i < this._subSystems.size()) {
                IRemoteFileSubSystem ss = (IRemoteFileSubSystem)this._subSystems.get(i);
                if (ss != null && ss.isConnected()) {
                    ss.disconnect(true);
                }
                ++i;
            }
        }
        if (this._connections != null) {
            int j = 0;
            while (j < this._connections.size()) {
                IHost host = (IHost)this._connections.get(j);
                if (host != null) {
                    this.getConnectionManager().removeConnection(host.getSystemProfileName(), host.getName());
                }
                ++j;
            }
        }
        this._subSystems.clear();
        this._connections.clear();
        this._subSystems = null;
        this._connections = null;
        super.tearDown();
    }

    protected void setupConnections() {
        if (this._connections == null) {
            this._connections = new ArrayList();
            this._subSystems = new ArrayList();
            this.addSystem(this.getLinuxHost());
            this.addSystem(this.getSSHHost());
            this.addSystem(this.getFTPHost());
            this._samplePaths = new ArrayList();
            this._samplePaths.add("/usr");
            this._samplePaths.add("/usr/lib");
            this._samplePaths.add("/usr/bin");
            this._samplePaths.add("/bin");
            this._samplePaths.add("/etc");
            this._samplePaths.add("/home");
            this._samplePaths.add("/sbin");
        }
    }

    private void addSystem(IHost host) {
        IRemoteFileSubSystem fss = null;
        ISystemRegistry sr = SystemStartHere.getSystemRegistry();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.services.files.IFileService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISubSystem[] ss = sr.getServiceSubSystems(host, (Class)clazz);
        int i = 0;
        while (i < ss.length) {
            if (ss[i] instanceof IRemoteFileSubSystem) {
                fss = (IRemoteFileSubSystem)ss[i];
            }
            ++i;
        }
        this._subSystems.add(fss);
        this._connections.add(host);
    }

    public void testImplicitConnectViaFileSubSystem() {
        if (!RSETestsPlugin.isTestCaseEnabled("FileSubsystemConsistencyTestCase.testImplicitConnectViaFileSubSystem")) {
            return;
        }
        this.setupConnections();
        String testPath = "/usr/lib";
        int i = 0;
        while (i < this._subSystems.size()) {
            IRemoteFileSubSystem ss = (IRemoteFileSubSystem)this._subSystems.get(i);
            if (ss.isConnected()) {
                try {
                    ss.disconnect(true);
                }
                catch (Exception exception) {}
            }
            String systemType = ss.getConfigurationId();
            Exception exception = null;
            String cause = null;
            IRemoteFile remoteFile = null;
            try {
                remoteFile = ss.getRemoteFileObject(testPath, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                exception = e;
                cause = e.getLocalizedMessage();
            }
            FileSubsystemConsistencyTestCase.assertNull((String)(String.valueOf(systemType) + ":Exception getting remote file! Possible cause: " + cause), (Object)exception);
            FileSubsystemConsistencyTestCase.assertTrue((boolean)ss.isConnected());
            FileSubsystemConsistencyTestCase.assertNotNull((String)(String.valueOf(systemType) + ":Unexpected return value for getRemoteFile().  Remote file is null!"), (Object)remoteFile);
            ++i;
        }
    }

    public void testSingleFileQuery() {
        if (!RSETestsPlugin.isTestCaseEnabled("FileSubsystemConsistencyTestCase.testSingleFileQuery")) {
            return;
        }
        this.setupConnections();
        String[] testPaths = this._samplePaths.toArray(new String[this._samplePaths.size()]);
        int i = 0;
        while (i < this._subSystems.size()) {
            IRemoteFileSubSystem ss = (IRemoteFileSubSystem)this._subSystems.get(i);
            if (!ss.isConnected()) {
                try {
                    ss.connect((IProgressMonitor)new NullProgressMonitor(), false);
                }
                catch (Exception exception) {}
            }
            String systemType = ss.getConfigurationId();
            Exception exception = null;
            String cause = null;
            IRemoteFile[] remoteFiles = new IRemoteFile[testPaths.length];
            long t1 = System.currentTimeMillis();
            int f = 0;
            while (f < testPaths.length) {
                try {
                    remoteFiles[f] = ss.getRemoteFileObject(testPaths[f], (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception e) {
                    exception = e;
                    cause = e.getLocalizedMessage();
                }
                ++f;
            }
            long t2 = System.currentTimeMillis();
            System.out.println(String.valueOf(systemType) + ": get files time = " + (t2 - t1) + " milliseconds");
            IRemoteFile[] results = null;
            ArrayList<IRemoteFile> consolidatedResults = new ArrayList<IRemoteFile>();
            long t3 = System.currentTimeMillis();
            int q = 0;
            while (q < remoteFiles.length) {
                try {
                    IRemoteFile[] children = ss.list(remoteFiles[q], 0, (IProgressMonitor)new NullProgressMonitor());
                    int c = 0;
                    while (c < children.length) {
                        consolidatedResults.add(children[c]);
                        ++c;
                    }
                }
                catch (Exception e) {
                    exception = e;
                    cause = e.getLocalizedMessage();
                }
                ++q;
            }
            results = consolidatedResults.toArray(new IRemoteFile[consolidatedResults.size()]);
            long t4 = System.currentTimeMillis();
            System.out.println(String.valueOf(systemType) + ": query time = " + (t4 - t3) + " milliseconds");
            FileSubsystemConsistencyTestCase.assertNull((String)(String.valueOf(systemType) + ":Exception getting remote files! Possible cause: " + cause), (Object)exception);
            FileSubsystemConsistencyTestCase.assertTrue((boolean)ss.isConnected());
            System.out.println(String.valueOf(systemType) + ": results size=" + results.length);
            ++i;
        }
    }

    public void testMultiFileQuery() {
        if (!RSETestsPlugin.isTestCaseEnabled("FileSubsystemConsistencyTestCase.testMultiFileQuery")) {
            return;
        }
        this.setupConnections();
        String[] testPaths = this._samplePaths.toArray(new String[this._samplePaths.size()]);
        int i = 0;
        while (i < this._subSystems.size()) {
            IRemoteFileSubSystem ss = (IRemoteFileSubSystem)this._subSystems.get(i);
            if (!ss.isConnected()) {
                try {
                    ss.connect((IProgressMonitor)new NullProgressMonitor(), false);
                }
                catch (Exception exception) {}
            }
            String systemType = ss.getConfigurationId();
            Exception exception = null;
            String cause = null;
            IRemoteFile[] remoteFiles = null;
            long t1 = System.currentTimeMillis();
            try {
                remoteFiles = ss.getRemoteFileObjects(testPaths, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                exception = e;
                e.printStackTrace();
                cause = e.getLocalizedMessage();
            }
            long t2 = System.currentTimeMillis();
            System.out.println(String.valueOf(systemType) + ": get files time = " + (t2 - t1) + " milliseconds");
            IRemoteFile[] results = null;
            long t3 = System.currentTimeMillis();
            try {
                results = ss.listMultiple(remoteFiles, 0, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                exception = e;
                e.printStackTrace();
                cause = e.getLocalizedMessage();
            }
            long t4 = System.currentTimeMillis();
            System.out.println(String.valueOf(systemType) + ": query time = " + (t4 - t3) + " milliseconds");
            FileSubsystemConsistencyTestCase.assertNull((String)(String.valueOf(systemType) + ":Exception getting remote files! Possible cause: " + cause), (Object)exception);
            FileSubsystemConsistencyTestCase.assertTrue((boolean)ss.isConnected());
            System.out.println(String.valueOf(systemType) + ":results size=" + results.length);
            ++i;
        }
    }

    public void testSingleFileDownload() {
        if (!RSETestsPlugin.isTestCaseEnabled("FileSubsystemConsistencyTestCase.testSingleFileDownload")) {
            return;
        }
        this.setupConnections();
        this.internalFileDownload(false);
    }

    public void testMultiFileDownload() {
        if (!RSETestsPlugin.isTestCaseEnabled("FileSubsystemConsistencyTestCase.testMultiFileDownload")) {
            return;
        }
        this.setupConnections();
        this.internalFileDownload(true);
    }

    protected void internalFileDownload(boolean multi) {
        String remoteParentDir = "/usr/include";
        File tempDir = new File(this.LOCALTEMPDIR);
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
        int i = 0;
        while (i < this._subSystems.size()) {
            String systemType;
            File subTempDir;
            IRemoteFileSubSystem ss = (IRemoteFileSubSystem)this._subSystems.get(i);
            if (!ss.isConnected()) {
                try {
                    ss.connect((IProgressMonitor)new NullProgressMonitor(), false);
                }
                catch (Exception exception) {}
            }
            if ((subTempDir = new File(tempDir, String.valueOf(systemType = ss.getConfigurationId()) + (multi ? "_multi" : "_single"))).exists()) {
                try {
                    String[] children = subTempDir.list();
                    int c = 0;
                    while (c < children.length) {
                        new File(children[c]).delete();
                        ++c;
                    }
                }
                catch (Exception exception) {}
            } else {
                subTempDir.mkdirs();
            }
            Object exception = null;
            String cause = null;
            try {
                NullProgressMonitor monitor = new NullProgressMonitor();
                IRemoteFile includeDir = ss.getRemoteFileObject(remoteParentDir, (IProgressMonitor)monitor);
                IRemoteFile[] files = ss.list(includeDir, 1, (IProgressMonitor)monitor);
                System.out.println(String.valueOf(systemType) + ": downloading " + files.length + " files");
                String[] destinations = new String[files.length];
                String[] encodings = new String[files.length];
                long[] fileSizes = new long[files.length];
                int d = 0;
                while (d < files.length) {
                    IRemoteFile file = files[d];
                    destinations[d] = String.valueOf(subTempDir.getAbsolutePath()) + File.separatorChar + file.getName();
                    encodings[d] = file.getEncoding();
                    fileSizes[d] = file.getLength();
                    ++d;
                }
                long t1 = System.currentTimeMillis();
                if (multi) {
                    System.out.println(String.valueOf(systemType) + ":Starting multi-file Download");
                    ss.downloadMultiple(files, destinations, encodings, (IProgressMonitor)monitor);
                } else {
                    System.out.println(String.valueOf(systemType) + ":Starting single file Download");
                    int s = 0;
                    while (s < files.length) {
                        ss.download(files[s], destinations[s], encodings[s], (IProgressMonitor)monitor);
                        ++s;
                    }
                }
                long t2 = System.currentTimeMillis();
                System.out.println(String.valueOf(systemType) + ": download time = " + (t2 - t1) + " milliseconds");
                FileSubsystemConsistencyTestCase.assertNull((String)(String.valueOf(systemType) + ":Exception getting remote files! Possible cause: " + cause), exception);
                FileSubsystemConsistencyTestCase.assertTrue((boolean)ss.isConnected());
                int r = 0;
                while (r < destinations.length) {
                    boolean goodDownload;
                    long expectedSize = fileSizes[r];
                    File destination = new File(destinations[r]);
                    long actualSize = destination.length();
                    boolean bl = goodDownload = expectedSize == actualSize;
                    if (!goodDownload) {
                        System.out.println("bad download of " + destination.getAbsolutePath());
                        System.out.println("expected size:" + expectedSize);
                        System.out.println("actual size:" + actualSize);
                    }
                    FileSubsystemConsistencyTestCase.assertTrue((boolean)goodDownload);
                    ++r;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }
}

