/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.rse.internal.useractions.ui.SystemCommandViewerConfiguration;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDAResources;
import org.eclipse.rse.shells.ui.view.SystemCommandEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SystemEditCommandDialog
extends Dialog {
    protected Label newNamePrompt;
    protected String cmd;
    protected String newCmdString;
    protected boolean ignoreChanges;
    protected SystemCommandViewerConfiguration sourceViewerConfiguration;
    protected SystemCommandEditor textCommand;
    protected Button insertVariableButton;
    protected int style;
    protected int INSERT_ID = 10;

    public SystemEditCommandDialog(Shell shell, String command, SystemCommandViewerConfiguration sourceViewerConfiguration, int style) {
        this(shell, command, SystemUDAResources.RESID_UDA_PROMPTCMD_TITLE, sourceViewerConfiguration, style);
    }

    public SystemEditCommandDialog(Shell shell, String command, String title, SystemCommandViewerConfiguration sourceViewerConfiguration, int style) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.style = style;
        this.cmd = command;
        this.sourceViewerConfiguration = sourceViewerConfiguration;
    }

    protected Control createDialogArea(Composite gparent) {
        Composite parent = new Composite(gparent, 0);
        GridData data = new GridData();
        data.heightHint = 100;
        data.widthHint = 400;
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)data);
        this.createEditor(parent, 5, this.sourceViewerConfiguration, this.cmd);
        String title = SystemUDAResources.RESID_UDA_COMMAND_LABEL;
        this.getShell().setText(title);
        return parent;
    }

    private SourceViewer createEditor(Composite parent, int columnSpan, SystemCommandViewerConfiguration sourceViewerConfiguration, String cmd) {
        this.textCommand = new SystemCommandEditor(null, parent, this.style, columnSpan, (SourceViewerConfiguration)sourceViewerConfiguration, cmd, SystemUDAResources.RESID_UDA_INSERTVAR_BUTTON_LABEL);
        return this.textCommand;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        String label = SystemUDAResources.RESID_UDA_INSERTVAR_BUTTON_LABEL;
        this.createButton(parent, this.INSERT_ID, label, false);
        super.createButtonsForButtonBar(parent);
    }

    protected Control getInitialFocusControl() {
        return this.textCommand.getControl();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.processOK();
            this.textCommand.getTextWidget().dispose();
        }
        if (buttonId == this.INSERT_ID) {
            this.textCommand.getTextWidget().setFocus();
            this.textCommand.doOperation(13);
        }
        super.buttonPressed(buttonId);
    }

    protected boolean processOK() {
        this.newCmdString = this.textCommand.getDocument().get().trim();
        return true;
    }

    public String getCommand() {
        return this.newCmdString;
    }
}

