/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui.uda.actions;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.internal.useractions.Activator;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDAResources;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDActionSubsystem;
import org.eclipse.rse.internal.useractions.ui.uda.SystemWorkWithUDAsDialog;
import org.eclipse.rse.ui.actions.SystemBaseDialogAction;
import org.eclipse.swt.widgets.Shell;

public class SystemWorkWithUDAsAction
extends SystemBaseDialogAction {
    private ISubSystem subsystem = null;
    private ISubSystemConfiguration subsystemFactory = null;
    private ISystemProfile profile;
    private SystemUDActionSubsystem udaActionSubsystem = null;

    public SystemWorkWithUDAsAction(Shell parent, ISubSystem subSystem, SystemUDActionSubsystem udaActionSubsystem) {
        this(parent);
        this.setSubSystem(subSystem);
        this.setActionSubsystem(udaActionSubsystem);
        this.setAvailableOffline(true);
    }

    public SystemWorkWithUDAsAction(Shell parent, ISubSystemConfiguration subSystemFactory, ISystemProfile profile, SystemUDActionSubsystem udaActionSubsystem) {
        this(parent);
        this.setSubSystemFactory(this.subsystemFactory, profile);
        this.setActionSubsystem(udaActionSubsystem);
    }

    public SystemWorkWithUDAsAction(Shell parent) {
        super(SystemUDAResources.ACTION_WORKWITH_UDAS_LABEL, SystemUDAResources.ACTION_WORKWITH_UDAS_TOOLTIP, Activator.getDefault().getImageDescriptor("WORK_WITH_USER_ACTIONS_1"), parent);
        this.allowOnMultipleSelection(false);
        this.setContextMenuGroup("group.workwith");
        this.setHelp("org.eclipse.rse.ui.actn0045");
    }

    public SystemWorkWithUDAsAction(Shell parent, boolean fromCascadingCompileAction) {
        super(fromCascadingCompileAction ? SystemUDAResources.ACTION_WORKWITH_WWUDAS_LABEL : SystemUDAResources.ACTION_WORKWITH_UDAS_LABEL, fromCascadingCompileAction ? SystemUDAResources.ACTION_WORKWITH_WWUDAS_TOOLTIP : SystemUDAResources.ACTION_WORKWITH_UDAS_TOOLTIP, Activator.getDefault().getImageDescriptor("WORK_WITH_USER_ACTIONS_1"), parent);
        this.allowOnMultipleSelection(false);
        if (!fromCascadingCompileAction) {
            this.setContextMenuGroup("group.workwith");
        } else {
            this.setContextMenuGroup("group.reorganize");
        }
        this.setHelp("org.eclipse.rse.ui.actn0045");
    }

    public void reset() {
        this.subsystem = null;
        this.subsystemFactory = null;
        this.profile = null;
    }

    public void setSubSystem(ISubSystem subsystem) {
        this.subsystem = subsystem;
        if (subsystem != null) {
            this.subsystemFactory = subsystem.getSubSystemConfiguration();
            this.profile = subsystem.getSystemProfile();
        }
    }

    public void setSubSystemFactory(ISubSystemConfiguration subsystemFactory, ISystemProfile profile) {
        this.subsystemFactory = subsystemFactory;
        this.profile = profile;
    }

    public void setActionSubsystem(SystemUDActionSubsystem udaActionSubsystem) {
        this.udaActionSubsystem = udaActionSubsystem;
    }

    public boolean updateSelection(IStructuredSelection selection) {
        return true;
    }

    protected Dialog createDialog(Shell parent) {
        Object element = this.getFirstSelection();
        if (this.subsystem == null && element instanceof ISubSystem) {
            this.subsystem = (ISubSystem)element;
        }
        SystemWorkWithUDAsDialog dlg = null;
        dlg = this.subsystem != null ? new SystemWorkWithUDAsDialog(parent, this.subsystem, this.udaActionSubsystem) : new SystemWorkWithUDAsDialog(parent, this.subsystemFactory, this.profile, this.udaActionSubsystem);
        return dlg;
    }

    protected Object getDialogValue(Dialog dlg) {
        return null;
    }
}

