/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.clientserver.archiveutils;

import java.io.File;
import java.io.IOException;
import org.eclipse.rse.services.clientserver.ISystemOperationMonitor;
import org.eclipse.rse.services.clientserver.SystemEncodingUtil;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.archiveutils.ISystemArchiveHandler;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.clientserver.messages.SystemOperationFailedException;
import org.eclipse.rse.services.clientserver.messages.SystemUnexpectedErrorException;

public final class VirtualChild {
    public String fullName = "";
    public String name = "";
    public String path = "";
    public boolean isDirectory = false;
    protected ISystemArchiveHandler _handler;
    protected File _extractedFile;
    protected File _containingArchive;
    private String comment;
    private long compressedSize;
    private String compressionMethod;
    private long size;
    private long timeStamp;

    public VirtualChild(ISystemArchiveHandler handler) {
        this._handler = handler;
        this._extractedFile = null;
        this._containingArchive = null;
        this.comment = "";
        this.compressedSize = -1L;
        this.compressionMethod = "";
        this.size = -1L;
        this.timeStamp = -1L;
    }

    public VirtualChild(ISystemArchiveHandler handler, String fullVirtualName) {
        this(handler);
        this.renameTo(fullVirtualName);
    }

    public VirtualChild(String fullVirtualName, File containingArchive) {
        this(null);
        this.renameTo(fullVirtualName);
        this._containingArchive = containingArchive;
    }

    public ISystemArchiveHandler getHandler() {
        return this._handler;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long value) {
        this.timeStamp = value;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long value) {
        this.size = value;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String value) {
        this.comment = value != null ? value : "";
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public void setCompressedSize(long value) {
        this.compressedSize = value;
    }

    public String getCompressionMethod() {
        return this.compressionMethod;
    }

    public void setCompressionMethod(String value) {
        this.compressionMethod = value != null ? value : "";
    }

    public double getCompressionRatio() {
        if (this.size <= 0L) {
            return 1.0;
        }
        if (this.compressedSize <= 0L) {
            return 1.0;
        }
        return ((double)this.size - (double)this.compressedSize) / (double)this.size;
    }

    public File getExtractedFile() throws SystemMessageException {
        return this.getExtractedFile(SystemEncodingUtil.ENCODING_UTF_8, false, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File getExtractedFile(String sourceEncoding, boolean isText, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        File returnedFile = null;
        if (this._extractedFile == null || this._extractedFile.lastModified() != this.getTimeStamp()) {
            try {
                int i = this.name.lastIndexOf(".");
                String ext = "";
                if (i != -1) {
                    ext = this.name.substring(i + 1);
                }
                this._extractedFile = i < 3 ? File.createTempFile(String.valueOf(this.name) + "123", "virtual." + ext) : File.createTempFile(this.name, "virtual." + ext);
                this._extractedFile.deleteOnExit();
                if (this._handler == null) {
                    return this._extractedFile;
                }
                if (this.isDirectory) {
                    if (!(this._extractedFile.isDirectory() || this._extractedFile.delete() && this._extractedFile.mkdirs())) {
                        System.out.println("VirtualChild.getExtractedFile(): Could not create temp dir.");
                        if (archiveOperationMonitor != null && !archiveOperationMonitor.isCancelled()) {
                            archiveOperationMonitor.setDone(true);
                        }
                        return null;
                    }
                    this._handler.extractVirtualDirectory(this.fullName, this._extractedFile, sourceEncoding, isText, archiveOperationMonitor);
                } else {
                    this._handler.extractVirtualFile(this.fullName, this._extractedFile, sourceEncoding, isText, archiveOperationMonitor);
                }
            }
            catch (IOException e) {
                throw new SystemOperationFailedException("org.eclipse.rse.services", "VirtualChild.getExtractedFile()", e);
            }
        }
        returnedFile = this.isDirectory ? new File(this._extractedFile, this.name) : this._extractedFile;
        if (archiveOperationMonitor != null && !archiveOperationMonitor.isCancelled()) {
            archiveOperationMonitor.setDone(true);
        }
        return returnedFile;
    }

    public void getExtractedFile(File destination, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        this.getExtractedFile(destination, SystemEncodingUtil.ENCODING_UTF_8, false, archiveOperationMonitor);
    }

    public void getExtractedFile(File destination, String sourceEncoding, boolean isText, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        if (this._handler == null) {
            throw new SystemUnexpectedErrorException("org.eclipse.rse.services");
        }
        if (this._extractedFile == null || this._extractedFile.lastModified() != this.getTimeStamp() || !destination.getAbsolutePath().equals(this._extractedFile.getAbsolutePath())) {
            if (this.isDirectory) {
                this._handler.extractVirtualDirectory(this.fullName, destination.getParentFile(), destination, sourceEncoding, isText, archiveOperationMonitor);
            } else {
                this._handler.extractVirtualFile(this.fullName, destination, sourceEncoding, isText, archiveOperationMonitor);
            }
            this._extractedFile = destination;
        }
        if (archiveOperationMonitor != null && !archiveOperationMonitor.isCancelled()) {
            archiveOperationMonitor.setDone(true);
        }
    }

    public boolean exists() throws SystemMessageException {
        if (this._handler == null) {
            return false;
        }
        return this._handler.exists(this.fullName, null);
    }

    public void renameTo(String newName) {
        this.fullName = newName = ArchiveHandlerManager.cleanUpVirtualPath(newName);
        int i = newName.lastIndexOf("/");
        if (i == -1) {
            this.name = newName;
            this.path = "";
        } else {
            this.name = newName.substring(i + 1);
            this.path = newName.substring(0, i);
        }
        this._extractedFile = null;
    }

    public String getArchiveStandardName() {
        if (this._handler == null) {
            return this.fullName;
        }
        return this._handler.getStandardName(this);
    }

    public File getContainingArchive() {
        if (this._handler == null) {
            return this._containingArchive;
        }
        return this._handler.getArchive();
    }
}

