/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view;

import com.ibm.icu.text.MessageFormat;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemRemoteChangeEvent;
import org.eclipse.rse.core.events.ISystemRemoteChangeListener;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.ISystemResourceChangeListener;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IRSECallback;
import org.eclipse.rse.core.model.ISystemContainer;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISystemDragDropAdapter;
import org.eclipse.rse.internal.core.model.SystemRegistry;
import org.eclipse.rse.internal.ui.SystemPropertyResources;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.actions.SystemCommonDeleteAction;
import org.eclipse.rse.internal.ui.actions.SystemCommonRenameAction;
import org.eclipse.rse.internal.ui.view.SystemViewPart;
import org.eclipse.rse.internal.ui.view.SystemViewPromptableAdapter;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemActionViewerFilter;
import org.eclipse.rse.ui.SystemPreferencesManager;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.actions.SystemCopyToClipboardAction;
import org.eclipse.rse.ui.actions.SystemPasteFromClipboardAction;
import org.eclipse.rse.ui.actions.SystemRefreshAction;
import org.eclipse.rse.ui.actions.SystemTablePrintAction;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.dialogs.SystemSelectAnythingDialog;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.model.ISystemShellProvider;
import org.eclipse.rse.ui.view.IRSEViewPart;
import org.eclipse.rse.ui.view.ISystemTableViewColumnManager;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.SystemTableView;
import org.eclipse.rse.ui.view.SystemTableViewProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.CellEditorActionHandler;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.osgi.framework.Bundle;

public class SystemTableViewPart
extends ViewPart
implements ISelectionListener,
ISelectionChangedListener,
ISystemMessageLine,
ISystemShellProvider,
ISystemResourceChangeListener,
ISystemRemoteChangeListener,
IRSEViewPart {
    private HistoryItem _currentItem;
    private SystemTableView _viewer;
    protected ArrayList _browseHistory;
    protected int _browsePosition;
    private ForwardAction _forwardAction = null;
    private BackwardAction _backwardAction = null;
    private UpAction _upAction = null;
    private LockAction _lockAction = null;
    private RefreshAction _refreshAction = null;
    private SystemRefreshAction _refreshSelectionAction = null;
    private SelectInputAction _selectInputAction = null;
    private PositionToAction _positionToAction = null;
    private SubSetAction _subsetAction = null;
    private SystemTablePrintAction _printTableAction = null;
    private SelectColumnsAction _selectColumnsAction = null;
    private SystemCopyToClipboardAction _copyAction;
    private SystemPasteFromClipboardAction _pasteAction;
    private SystemCommonDeleteAction _deleteAction;
    private SystemCommonRenameAction _renameAction;
    private IMemento _memento = null;
    private IAdaptable _mementoInput = null;
    private Object _lastSelection = null;
    private boolean _isLocked = false;
    private String _message;
    private String _errorMessage;
    private SystemMessage sysErrorMessage;
    private IStatusLineManager _statusLine = null;
    public static final String ID = "org.eclipse.rse.ui.view.systemTableView";
    public static final String TAG_TABLE_VIEW_PROFILE_ID = "tableViewProfileID";
    public static final String TAG_TABLE_VIEW_CONNECTION_ID = "tableViewConnectionID";
    public static final String TAG_TABLE_VIEW_SUBSYSTEM_ID = "tableViewSubsystemID";
    public static final String TAG_TABLE_VIEW_OBJECT_ID = "tableViewObjectID";
    public static final String TAG_TABLE_VIEW_FILTER_ID = "tableViewFilterID";
    public static final String TAG_TABLE_VIEW_SUBSET = "subset";
    public static final String TAG_TABLE_VIEW_COLUMN_WIDTHS_ID = "columnWidths";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void setFocus() {
        if (this._viewer.getInput() == null) {
            if (this._memento != null) {
                this.restoreState(this._memento);
            } else {
                this.setInput((IAdaptable)RSECorePlugin.getTheSystemRegistry());
            }
        }
        this._viewer.getControl().setFocus();
    }

    public SystemTableView getViewer() {
        return this._viewer;
    }

    public Viewer getRSEViewer() {
        return this._viewer;
    }

    public void createPartControl(Composite parent) {
        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
        registry.addSystemResourceChangeListener((ISystemResourceChangeListener)this);
        registry.addSystemRemoteChangeListener((ISystemRemoteChangeListener)this);
        Table table = new Table(parent, 99074);
        this._viewer = new SystemTableView(table, this);
        table.setLinesVisible(true);
        ISelectionService selectionService = this.getSite().getWorkbenchWindow().getSelectionService();
        selectionService.addSelectionListener((ISelectionListener)this);
        this._viewer.addSelectionChangedListener(this);
        this.getSite().setSelectionProvider((ISelectionProvider)this._viewer);
        this._viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SystemTableViewPart.this.handleDoubleClick(event);
            }
        });
        this._isLocked = true;
        this.fillLocalToolBar();
        this._browseHistory = new ArrayList();
        this._browsePosition = 0;
        Clipboard clipboard = RSEUIPlugin.getTheSystemRegistryUI().getSystemClipboard();
        CellEditorActionHandler editorActionHandler = new CellEditorActionHandler(this.getViewSite().getActionBars());
        this._copyAction = new SystemCopyToClipboardAction(this._viewer.getShell(), clipboard);
        this._pasteAction = new SystemPasteFromClipboardAction(this._viewer.getShell(), clipboard);
        this._deleteAction = new SystemCommonDeleteAction(this._viewer.getShell(), this._viewer);
        this._renameAction = new SystemCommonRenameAction(this._viewer.getShell(), this._viewer);
        editorActionHandler.setCopyAction((IAction)this._copyAction);
        editorActionHandler.setPasteAction((IAction)this._pasteAction);
        editorActionHandler.setDeleteAction((IAction)this._deleteAction);
        editorActionHandler.setSelectAllAction((IAction)new SelectAllAction());
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this._renameAction);
        SystemWidgetHelpers.setHelp(this._viewer.getControl(), "org.eclipse.rse.ui.sysd0000");
        this.getSite().registerContextMenu(this._viewer.getContextMenuManager(), (ISelectionProvider)this._viewer);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection sel) {
        if (part != this && part instanceof SystemViewPart) {
            Object first;
            if (!this._isLocked && sel instanceof IStructuredSelection && this._lastSelection != (first = ((IStructuredSelection)sel).getFirstElement())) {
                this._lastSelection = first;
                if (first instanceof IAdaptable) {
                    ISystemViewElementAdapter va;
                    IAdaptable adapt = (IAdaptable)first;
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((va = (ISystemViewElementAdapter)adapt.getAdapter((Class)clazz)) != null && !(va instanceof SystemViewPromptableAdapter) && va.hasChildren(adapt) && adapt != this._viewer.getInput()) {
                        this.setInput(adapt);
                    }
                }
            }
        } else if (part == this) {
            this.updateActionStates();
        }
    }

    public void dispose() {
        ISelectionService selectionService = this.getSite().getWorkbenchWindow().getSelectionService();
        selectionService.removeSelectionListener((ISelectionListener)this);
        this._viewer.removeSelectionChangedListener(this);
        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
        registry.removeSystemRemoteChangeListener((ISystemRemoteChangeListener)this);
        registry.removeSystemResourceChangeListener((ISystemResourceChangeListener)this);
        if (this._viewer != null) {
            this._viewer.dispose();
        }
        super.dispose();
    }

    private void handleDoubleClick(DoubleClickEvent event) {
        IStructuredSelection s = (IStructuredSelection)event.getSelection();
        Object element = s.getFirstElement();
        if (element == null) {
            return;
        }
        IAdaptable iAdaptable = (IAdaptable)element;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISystemViewElementAdapter adapter = (ISystemViewElementAdapter)iAdaptable.getAdapter((Class)clazz);
        boolean alreadyHandled = false;
        if (adapter != null && !(alreadyHandled = adapter.handleDoubleClick(element))) {
            if (adapter.isPromptable(element)) {
                adapter.getChildren((IAdaptable)element, (IProgressMonitor)new NullProgressMonitor());
            } else if (adapter.hasChildren((IAdaptable)element)) {
                this.setInput((IAdaptable)element);
            }
        }
    }

    public void updateActionStates() {
        if (this._refreshAction == null) {
            this.fillLocalToolBar();
        }
        this._backwardAction.checkEnabledState();
        this._forwardAction.checkEnabledState();
        this._upAction.checkEnabledState();
        this._lockAction.checkEnabledState();
        this._refreshAction.checkEnabledState();
        this._selectInputAction.checkEnabledState();
        this._positionToAction.checkEnabledState();
        this._subsetAction.checkEnabledState();
        this._printTableAction.checkEnabledState();
        this._selectColumnsAction.checkEnabledState();
    }

    private ImageDescriptor getEclipseImageDescriptor(String relativePath) {
        String iconPath = "icons/full/";
        try {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
            URL installURL = bundle.getEntry("/");
            URL url = new URL(installURL, String.valueOf(iconPath) + relativePath);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public void fillLocalToolBar() {
        if (this._refreshAction == null) {
            this._refreshAction = new RefreshAction();
            this._backwardAction = new BackwardAction();
            this._forwardAction = new ForwardAction();
            this._upAction = new UpAction();
            this._lockAction = new LockAction();
            this._selectInputAction = new SelectInputAction();
            this._positionToAction = new PositionToAction();
            this._subsetAction = new SubSetAction();
            this._printTableAction = new SystemTablePrintAction(this.getTitle(), this._viewer);
            this._selectColumnsAction = new SelectColumnsAction();
        }
        this.updateActionStates();
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        IMenuManager menuMgr = actionBars.getMenuManager();
        this._refreshSelectionAction = new SystemRefreshAction(this.getShell());
        actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this._refreshSelectionAction);
        this._refreshSelectionAction.setSelectionProvider(this._viewer);
        this._statusLine = actionBars.getStatusLineManager();
        this.addToolBarItems(toolBarManager);
        this.addToolBarMenuItems(menuMgr);
    }

    private void addToolBarMenuItems(IMenuManager menuManager) {
        menuManager.removeAll();
        menuManager.add((IAction)this._selectColumnsAction);
        menuManager.add((IContributionItem)new Separator("View"));
        menuManager.add((IAction)this._selectInputAction);
        menuManager.add((IContributionItem)new Separator("Filter"));
        menuManager.add((IAction)this._positionToAction);
        menuManager.add((IAction)this._subsetAction);
    }

    private void addToolBarItems(IToolBarManager toolBarManager) {
        toolBarManager.removeAll();
        this._lockAction.setChecked(this._isLocked);
        toolBarManager.add((IAction)this._lockAction);
        toolBarManager.add((IAction)this._refreshAction);
        toolBarManager.add((IContributionItem)new Separator("Navigate"));
        if (this._isLocked) {
            toolBarManager.add((IAction)this._backwardAction);
            toolBarManager.add((IAction)this._forwardAction);
        }
        toolBarManager.add((IAction)this._upAction);
        toolBarManager.add((IContributionItem)new Separator("View"));
        toolBarManager.add((IAction)this._selectColumnsAction);
    }

    public void showLock() {
        if (this._upAction != null) {
            IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
            toolBarManager.removeAll();
            this.updateActionStates();
            this.addToolBarItems(toolBarManager);
        }
    }

    public void selectionChanged(SelectionChangedEvent e) {
        this.updateActionStates();
        IStructuredSelection sel = (IStructuredSelection)e.getSelection();
        this._copyAction.setEnabled(this._copyAction.updateSelection(sel));
        this._pasteAction.setEnabled(this._pasteAction.updateSelection(sel));
        this._deleteAction.setEnabled(this._deleteAction.updateSelection(sel));
    }

    public void setInput(IAdaptable object) {
        String[] filters = null;
        if (this._currentItem != null) {
            ISystemViewElementAdapter adapter2;
            IAdaptable item = this._currentItem.getObject();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ISystemViewElementAdapter adapter1 = (ISystemViewElementAdapter)object.getAdapter((Class)clazz);
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter1 == (adapter2 = (ISystemViewElementAdapter)item.getAdapter((Class)clazz2))) {
                filters = this._currentItem.getFilters();
            } else {
                this._viewer.setViewFilters(null);
            }
        }
        this.setInput(object, filters, this._isLocked);
        if (!this._isLocked) {
            this._currentItem = new HistoryItem(object, null);
        }
    }

    public void setInput(HistoryItem historyItem) {
        this.setInput(historyItem.getObject(), historyItem.getFilters(), false);
        this._currentItem = historyItem;
    }

    public void setInput(IAdaptable object, String[] filters, boolean updateHistory) {
        if (this._viewer != null) {
            this.setTitle(object);
            this._viewer.setInput(object);
            if (this._refreshSelectionAction != null) {
                this._refreshSelectionAction.updateSelection((IStructuredSelection)new StructuredSelection((Object)object));
            }
            if (filters != null) {
                this._viewer.setViewFilters(filters);
            }
            if (updateHistory) {
                while (this._browsePosition < this._browseHistory.size() - 1) {
                    this._browseHistory.remove(this._browseHistory.get(this._browseHistory.size() - 1));
                }
                this._currentItem = new HistoryItem(object, filters);
                this._browseHistory.add(this._currentItem);
                this._browsePosition = this._browseHistory.lastIndexOf(this._currentItem);
            }
            this.updateActionStates();
        }
    }

    public void setTitle(IAdaptable object) {
        if (object == null) {
            this.setContentDescription("");
        } else {
            ISystemViewElementAdapter va;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((va = (ISystemViewElementAdapter)object.getAdapter((Class)clazz)) != null) {
                String type = va.getType(object);
                String name = va.getName(object);
                String title = MessageFormat.format((String)SystemResources.SystemTableViewPart_title, (Object[])new String[]{type, name});
                this.setContentDescription(title);
            }
        }
    }

    public void systemResourceChanged(ISystemResourceChangeEvent event) {
        Object child = event.getSource();
        Object input = this._viewer.getInput();
        switch (event.getType()) {
            case 65: {
                if (child != input) break;
                this.setTitle((IAdaptable)child);
                break;
            }
            case 55: {
                this.removeFromHistory(event.getSource());
                break;
            }
            case 60: {
                Object[] multi = event.getMultiSource();
                int i = 0;
                while (i < multi.length) {
                    this.removeFromHistory(multi[i]);
                    ++i;
                }
                break;
            }
        }
    }

    protected void removeFromHistory(Object c) {
        IAdaptable currentObject;
        int i = 0;
        while (i < this._browseHistory.size()) {
            HistoryItem hist = (HistoryItem)this._browseHistory.get(i);
            IAdaptable historyObj = hist.getObject();
            if (historyObj == c || historyObj.equals(c) || this.isParentOf(c, historyObj)) {
                this._browseHistory.remove(hist);
                if (this._browsePosition >= i) {
                    --this._browsePosition;
                    if (this._browsePosition < 0) {
                        this._browsePosition = 0;
                    }
                }
                --i;
            }
            ++i;
        }
        if (this._currentItem != null && (c == (currentObject = this._currentItem.getObject()) || c.equals(currentObject) || this.isParentOf(c, currentObject))) {
            if (this._browseHistory.size() > 0) {
                this._currentItem = (HistoryItem)this._browseHistory.get(this._browsePosition);
                this.setInput(this._currentItem.getObject(), null, false);
            } else {
                this._currentItem = null;
                this.setInput((IAdaptable)RSECorePlugin.getTheSystemRegistry(), null, true);
            }
        }
    }

    protected boolean isParentOf(Object parent, Object child) {
        if (parent instanceof IAdaptable && child instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)parent;
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ISystemDragDropAdapter adapterParent = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz);
            IAdaptable iAdaptable2 = (IAdaptable)child;
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ISystemDragDropAdapter adapterChild = (ISystemDragDropAdapter)iAdaptable2.getAdapter((Class)clazz2);
            if (adapterParent != null && adapterChild != null && adapterParent.getSubSystem(parent) == adapterChild.getSubSystem(child)) {
                String parentAbsoluteName = adapterParent.getAbsoluteName(parent);
                String childAbsoluteName = adapterChild.getAbsoluteName(child);
                if (childAbsoluteName != null && childAbsoluteName.startsWith(parentAbsoluteName)) {
                    return true;
                }
            }
        }
        return false;
    }

    public void systemRemoteResourceChanged(ISystemRemoteChangeEvent event) {
        int eventType = event.getEventType();
        Object remoteResource = event.getResource();
        List remoteResourceNames = null;
        if (remoteResource instanceof List) {
            remoteResourceNames = (List)remoteResource;
            remoteResource = remoteResourceNames.get(0);
        }
        Object child = event.getResource();
        Object input = this._viewer.getInput();
        String[] oldNames = event.getOldNames();
        String oldName = oldNames == null ? null : oldNames[0];
        boolean referToSameObject = false;
        if (input != null && oldName != null) {
            referToSameObject = SystemRegistry.isSameObjectByAbsoluteName((Object)input, null, (Object)child, (String)oldName);
        }
        if (input == child || child instanceof List || referToSameObject) {
            switch (eventType) {
                case 4: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    if (child instanceof List) {
                        List list = (List)child;
                        int v = 0;
                        while (v < list.size()) {
                            Object c = list.get(v);
                            this.removeFromHistory(c);
                            ++v;
                        }
                        break;
                    }
                    this.removeFromHistory(child);
                    return;
                }
                case 8: {
                    this.setInput((IAdaptable)child);
                }
            }
        }
    }

    public Shell getShell() {
        return this._viewer.getShell();
    }

    private void restoreState(IMemento memento) {
        RestoreStateRunnable rsr = new RestoreStateRunnable(memento);
        rsr.setRule((ISchedulingRule)RSECorePlugin.getTheSystemRegistry());
        rsr.setSystem(true);
        rsr.schedule();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento != null && SystemPreferencesManager.getRememberState()) {
            this._memento = memento;
        }
    }

    public void saveState(IMemento memento) {
        Object input;
        super.saveState(memento);
        if (!SystemPreferencesManager.getRememberState()) {
            return;
        }
        if (this._viewer != null && (input = this._viewer.getInput()) != null) {
            Table table;
            if (!(input instanceof ISystemRegistry)) {
                if (input instanceof IHost) {
                    IHost connection = (IHost)input;
                    String connectionID = connection.getAliasName();
                    String profileID = connection.getSystemProfileName();
                    memento.putString(TAG_TABLE_VIEW_CONNECTION_ID, connectionID);
                    memento.putString(TAG_TABLE_VIEW_PROFILE_ID, profileID);
                } else {
                    ISystemViewElementAdapter va;
                    ISubSystem subsystem;
                    IAdaptable iAdaptable = (IAdaptable)input;
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((subsystem = (va = (ISystemViewElementAdapter)iAdaptable.getAdapter((Class)clazz)).getSubSystem(input)) != null) {
                        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
                        String subsystemID = registry.getAbsoluteNameForSubSystem(subsystem);
                        String profileID = subsystem.getHost().getSystemProfileName();
                        String connectionID = subsystem.getHost().getAliasName();
                        String objectID = va.getAbsoluteName(input);
                        memento.putString(TAG_TABLE_VIEW_PROFILE_ID, profileID);
                        memento.putString(TAG_TABLE_VIEW_CONNECTION_ID, connectionID);
                        memento.putString(TAG_TABLE_VIEW_SUBSYSTEM_ID, subsystemID);
                        if (input instanceof ISystemFilterReference) {
                            memento.putString(TAG_TABLE_VIEW_FILTER_ID, objectID);
                            memento.putString(TAG_TABLE_VIEW_OBJECT_ID, null);
                        } else if (input instanceof ISubSystem) {
                            memento.putString(TAG_TABLE_VIEW_OBJECT_ID, null);
                            memento.putString(TAG_TABLE_VIEW_FILTER_ID, null);
                        } else {
                            memento.putString(TAG_TABLE_VIEW_OBJECT_ID, objectID);
                            memento.putString(TAG_TABLE_VIEW_FILTER_ID, null);
                        }
                    }
                }
            }
            if ((table = this._viewer.getTable()) != null && !table.isDisposed()) {
                String columnWidths = new String();
                TableColumn[] columns = table.getColumns();
                int i = 0;
                while (i < columns.length) {
                    TableColumn column = columns[i];
                    int width = column.getWidth();
                    columnWidths = i == columns.length - 1 ? String.valueOf(columnWidths) + width : String.valueOf(columnWidths) + width + ",";
                    ++i;
                }
                memento.putString(TAG_TABLE_VIEW_COLUMN_WIDTHS_ID, columnWidths);
            }
        }
    }

    public void clearErrorMessage() {
        this._errorMessage = null;
        this.sysErrorMessage = null;
        if (this._statusLine != null) {
            this._statusLine.setErrorMessage(this._errorMessage);
        }
    }

    public void clearMessage() {
        this._message = null;
        if (this._statusLine != null) {
            this._statusLine.setMessage(this._message);
        }
    }

    public String getErrorMessage() {
        return this._errorMessage;
    }

    public String getMessage() {
        return this._message;
    }

    public void setErrorMessage(String message) {
        this._errorMessage = message;
        if (this._statusLine != null) {
            this._statusLine.setErrorMessage(message);
        }
    }

    public SystemMessage getSystemErrorMessage() {
        return this.sysErrorMessage;
    }

    public void setErrorMessage(SystemMessage message) {
        this.sysErrorMessage = message;
        this.setErrorMessage(message.getLevelOneText());
    }

    public void setErrorMessage(Throwable exc) {
        this.setErrorMessage(exc.getMessage());
    }

    public void setMessage(String message) {
        this._message = message;
        if (this._statusLine != null) {
            this._statusLine.setMessage(message);
        }
    }

    public void setMessage(SystemMessage message) {
        this.setMessage(message.getLevelOneText());
    }

    class BackwardAction
    extends BrowseAction {
        public BackwardAction() {
            super(SystemResources.ACTION_HISTORY_MOVEBACKWARD_LABEL, SystemTableViewPart.this.getEclipseImageDescriptor("elcl16/backward_nav.gif"));
            SystemTableViewPart.this.setTitleToolTip(SystemResources.ACTION_HISTORY_MOVEBACKWARD_TOOLTIP);
            this.setDisabledImageDescriptor(SystemTableViewPart.this.getEclipseImageDescriptor("dlcl16/backward_nav.gif"));
        }

        public void checkEnabledState() {
            if (SystemTableViewPart.this._isLocked && SystemTableViewPart.this._browseHistory != null && SystemTableViewPart.this._browseHistory.size() > 0 && SystemTableViewPart.this._browsePosition > 0) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }

        public void run() {
            --SystemTableViewPart.this._browsePosition;
            HistoryItem historyItem = (HistoryItem)SystemTableViewPart.this._browseHistory.get(SystemTableViewPart.this._browsePosition);
            SystemTableViewPart.this.setInput(historyItem);
        }
    }

    class BrowseAction
    extends Action {
        public BrowseAction() {
        }

        public BrowseAction(String label, ImageDescriptor des) {
            super(label, des);
            this.setToolTipText(label);
        }

        public void checkEnabledState() {
            if (SystemTableViewPart.this._viewer != null && SystemTableViewPart.this._viewer.getInput() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void run() {
        }
    }

    class ForwardAction
    extends BrowseAction {
        public ForwardAction() {
            super(SystemResources.ACTION_HISTORY_MOVEFORWARD_LABEL, SystemTableViewPart.this.getEclipseImageDescriptor("elcl16/forward_nav.gif"));
            SystemTableViewPart.this.setTitleToolTip(SystemResources.ACTION_HISTORY_MOVEFORWARD_TOOLTIP);
            this.setDisabledImageDescriptor(SystemTableViewPart.this.getEclipseImageDescriptor("dlcl16/forward_nav.gif"));
        }

        public void checkEnabledState() {
            if (SystemTableViewPart.this._isLocked && SystemTableViewPart.this._browseHistory != null && SystemTableViewPart.this._browseHistory.size() > 0 && SystemTableViewPart.this._browsePosition < SystemTableViewPart.this._browseHistory.size() - 1) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }

        public void run() {
            ++SystemTableViewPart.this._browsePosition;
            HistoryItem historyItem = (HistoryItem)SystemTableViewPart.this._browseHistory.get(SystemTableViewPart.this._browsePosition);
            SystemTableViewPart.this.setInput(historyItem);
        }
    }

    class HistoryItem {
        private String[] _filters;
        private IAdaptable _object;

        public HistoryItem(IAdaptable object, String[] filters) {
            this._object = object;
            this._filters = filters;
        }

        public IAdaptable getObject() {
            return this._object;
        }

        public String[] getFilters() {
            return this._filters;
        }

        public void setFilters(String[] filters) {
            this._filters = filters;
        }
    }

    class LockAction
    extends BrowseAction {
        public LockAction() {
            this.setImageDescriptor(RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.lockIcon"));
            String label = this.determineLabel();
            this.setText(label);
            this.setToolTipText(label);
        }

        public void checkEnabledState() {
            this.setChecked(SystemTableViewPart.this._isLocked);
            String label = this.determineLabel();
            this.setText(label);
            this.setToolTipText(label);
        }

        public void run() {
            SystemTableViewPart.this._isLocked = !SystemTableViewPart.this._isLocked;
            SystemTableViewPart.this.showLock();
        }

        public String determineLabel() {
            if (!SystemTableViewPart.this._isLocked) {
                return SystemResources.ACTION_LOCK_LABEL;
            }
            return SystemResources.ACTION_UNLOCK_LABEL;
        }

        public String determineTooltip() {
            if (!SystemTableViewPart.this._isLocked) {
                return SystemResources.ACTION_LOCK_TOOLTIP;
            }
            return SystemResources.ACTION_UNLOCK_TOOLTIP;
        }
    }

    class PositionToAction
    extends BrowseAction {
        public PositionToAction() {
            super(SystemResources.ACTION_POSITIONTO_LABEL, null);
            this.setToolTipText(SystemResources.ACTION_POSITIONTO_TOOLTIP);
        }

        public void run() {
            PositionToDialog posDialog = new PositionToDialog(SystemTableViewPart.this.getViewer().getShell(), SystemTableViewPart.this.getTitle(), SystemTableViewPart.this._currentItem);
            if (posDialog.open() == 0) {
                String name = posDialog.getPositionName();
                SystemTableViewPart.this._viewer.positionTo(name);
            }
        }

        class PositionToDialog
        extends SystemPromptDialog {
            private String _name;
            private Combo _cbName;

            public PositionToDialog(Shell shell, String title, HistoryItem historyItem) {
                super(shell, title);
            }

            public String getPositionName() {
                return this._name;
            }

            protected void buttonPressed(int buttonId) {
                this.setReturnCode(buttonId);
                this._name = this._cbName.getText();
                this.close();
            }

            protected Control getInitialFocusControl() {
                return this._cbName;
            }

            public Control createInner(Composite parent) {
                Composite c = SystemWidgetHelpers.createComposite(parent, 2);
                Label aLabel = new Label(c, 0);
                aLabel.setText(SystemPropertyResources.RESID_PROPERTY_NAME_LABEL);
                this._cbName = SystemWidgetHelpers.createCombo(c, null);
                GridData textData = new GridData(768);
                this._cbName.setLayoutData((Object)textData);
                this._cbName.setText("*");
                this._cbName.setToolTipText(SystemResources.RESID_TABLE_POSITIONTO_ENTRY_TOOLTIP);
                this.getShell().setText(SystemResources.RESID_TABLE_POSITIONTO_LABEL);
                this.setHelp();
                return c;
            }

            private void setHelp() {
                this.setHelp("org.eclipse.rse.ui.gnpt0000");
            }
        }
    }

    class RefreshAction
    extends BrowseAction {
        public RefreshAction() {
            super(SystemResources.ACTION_REFRESH_TABLE_LABLE, RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.refresh_navIcon"));
            this.setToolTipText(SystemResources.ACTION_REFRESH_TABLE_TOOLTIP);
        }

        public void run() {
            Object inputObject = SystemTableViewPart.this._viewer.getInput();
            if (inputObject instanceof ISystemContainer) {
                ((ISystemContainer)inputObject).markStale(true);
            }
            ((SystemTableViewProvider)SystemTableViewPart.this._viewer.getContentProvider()).flushCache();
            ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
            registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent(inputObject, 82, inputObject));
        }
    }

    class RestoreStateRunnable
    extends Job {
        private IMemento _rmemento;

        public RestoreStateRunnable(IMemento memento) {
            super("Restore RSE Table");
            this._rmemento = memento;
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                IStatus wstatus = RSECorePlugin.waitForInitCompletion();
                if (!wstatus.isOK() && wstatus.getSeverity() == 4) {
                    return wstatus;
                }
            }
            catch (InterruptedException interruptedException) {
                return Status.CANCEL_STATUS;
            }
            IMemento memento = this._rmemento;
            String profileId = memento.getString(SystemTableViewPart.TAG_TABLE_VIEW_PROFILE_ID);
            String connectionId = memento.getString(SystemTableViewPart.TAG_TABLE_VIEW_CONNECTION_ID);
            String subsystemId = memento.getString(SystemTableViewPart.TAG_TABLE_VIEW_SUBSYSTEM_ID);
            String filterID = memento.getString(SystemTableViewPart.TAG_TABLE_VIEW_FILTER_ID);
            String objectID = memento.getString(SystemTableViewPart.TAG_TABLE_VIEW_OBJECT_ID);
            ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
            ISystemRegistry input = null;
            if (subsystemId == null) {
                if (connectionId != null) {
                    ISystemProfile profile = registry.getSystemProfile(profileId);
                    input = registry.getHost(profile, connectionId);
                } else {
                    input = registry;
                }
            } else {
                ISubSystem subsystem = registry.getSubSystem(subsystemId);
                if (subsystem != null) {
                    if (filterID == null && objectID == null) {
                        input = subsystem;
                    } else {
                        if (!subsystem.isConnected()) {
                            try {
                                ISystemRegistry finInput = input;
                                subsystem.connect(false, new IRSECallback(this, memento, finInput, subsystem, filterID, objectID){
                                    final /* synthetic */ RestoreStateRunnable this$1;
                                    private final /* synthetic */ IMemento val$memento;
                                    private final /* synthetic */ Object val$finInput;
                                    private final /* synthetic */ ISubSystem val$subsystem;
                                    private final /* synthetic */ String val$filterID;
                                    private final /* synthetic */ String val$objectID;
                                    {
                                        this.this$1 = restoreStateRunnable;
                                        this.val$memento = iMemento;
                                        this.val$finInput = object;
                                        this.val$subsystem = iSubSystem;
                                        this.val$filterID = string;
                                        this.val$objectID = string2;
                                    }

                                    public void done(IStatus status, Object result) {
                                        Display.getDefault().asyncExec((Runnable)this.this$1.new RunOnceConnectedOnMainThread(this.val$memento, this.val$finInput, this.val$subsystem, this.val$filterID, this.val$objectID));
                                    }
                                });
                                return Status.OK_STATUS;
                            }
                            catch (Exception exception) {
                                return Status.CANCEL_STATUS;
                            }
                        }
                        return this.runOnceConnected(monitor, memento, input, subsystem, filterID, objectID);
                    }
                }
            }
            return this.runWithInput(monitor, input, memento);
        }

        public IStatus runOnceConnected(IProgressMonitor monitor, IMemento memento, Object input, ISubSystem subsystem, String filterID, String objectID) {
            if (subsystem.isConnected()) {
                if (filterID != null) {
                    try {
                        input = subsystem.getObjectWithAbsoluteName(filterID, monitor);
                    }
                    catch (Exception exception) {}
                } else if (objectID != null) {
                    try {
                        input = subsystem.getObjectWithAbsoluteName(objectID, monitor);
                    }
                    catch (Exception exception) {
                        return Status.CANCEL_STATUS;
                    }
                }
            }
            return this.runWithInput(monitor, input, memento);
        }

        public IStatus runWithInput(IProgressMonitor monitor, Object input, IMemento memento) {
            if (input != null && input instanceof IAdaptable) {
                SystemTableViewPart.this._mementoInput = (IAdaptable)input;
                if (SystemTableViewPart.this._mementoInput != null && SystemTableViewPart.this._viewer != null) {
                    String columnWidths = memento.getString(SystemTableViewPart.TAG_TABLE_VIEW_COLUMN_WIDTHS_ID);
                    if (columnWidths != null) {
                        StringTokenizer tok = new StringTokenizer(columnWidths, ",");
                        int[] colWidths = new int[tok.countTokens()];
                        int t = 0;
                        while (tok.hasMoreTokens()) {
                            String columnStr = tok.nextToken();
                            colWidths[t] = Integer.parseInt(columnStr);
                            ++t;
                        }
                        SystemTableViewPart.this._viewer.setLastColumnWidths(colWidths);
                    }
                    Display.getDefault().asyncExec(new Runnable(this){
                        final /* synthetic */ RestoreStateRunnable this$1;
                        {
                            this.this$1 = restoreStateRunnable;
                        }

                        public void run() {
                            RestoreStateRunnable.access$0(this.this$1).setInput(SystemTableViewPart.access$7(RestoreStateRunnable.access$0(this.this$1)));
                        }
                    });
                }
            }
            return Status.OK_STATUS;
        }

        static /* synthetic */ SystemTableViewPart access$0(RestoreStateRunnable restoreStateRunnable) {
            return restoreStateRunnable.SystemTableViewPart.this;
        }

        private class RunOnceConnectedOnMainThread
        implements Runnable {
            private IMemento _inmemento;
            private Object _input;
            private ISubSystem _subSystem;
            private String _filterID;
            private String _objectID;

            public RunOnceConnectedOnMainThread(IMemento memento, Object input, ISubSystem subSystem, String filterID, String objectID) {
                this._inmemento = memento;
                this._input = input;
                this._subSystem = subSystem;
                this._filterID = filterID;
                this._objectID = objectID;
            }

            public void run() {
                RestoreStateRunnable.this.runOnceConnected((IProgressMonitor)new NullProgressMonitor(), this._inmemento, this._input, this._subSystem, this._filterID, this._objectID);
            }
        }
    }

    class SelectAllAction
    extends BrowseAction {
        public SelectAllAction() {
            super(SystemResources.ACTION_SELECT_ALL_LABEL, null);
            this.setToolTipText(SystemResources.ACTION_SELECT_ALL_TOOLTIP);
        }

        public void checkEnabledState() {
            if (SystemTableViewPart.this._viewer != null && SystemTableViewPart.this._viewer.getInput() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void run() {
            SystemTableViewPart.this._viewer.getTable().selectAll();
            SystemTableViewPart.this._viewer.setSelection(SystemTableViewPart.this._viewer.getSelection());
        }
    }

    private class SelectColumnsAction
    extends BrowseAction {
        public SelectColumnsAction() {
            super(SystemResources.ACTION_SELECTCOLUMNS_LABEL, null);
            this.setToolTipText(SystemResources.ACTION_SELECTCOLUMNS_TOOLTIP);
            this.setImageDescriptor(RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemfilterIcon"));
        }

        public void checkEnabledState() {
            if (SystemTableViewPart.this._viewer != null && SystemTableViewPart.this._viewer.getInput() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void run() {
            ISystemTableViewColumnManager mgr = SystemTableViewPart.this._viewer.getColumnManager();
            ISystemViewElementAdapter adapter = SystemTableViewPart.this._viewer.getAdapterForContents();
            SelectColumnsDialog dlg = new SelectColumnsDialog(SystemTableViewPart.this.getShell(), adapter, mgr);
            if (dlg.open() == 0) {
                mgr.setCustomDescriptors(adapter, dlg.getDisplayedColumns());
                SystemTableViewPart.this._viewer.computeLayout(true);
                SystemTableViewPart.this._viewer.refresh();
            }
        }

        class SelectColumnsDialog
        extends SystemPromptDialog {
            private ISystemViewElementAdapter _adapter;
            private ISystemTableViewColumnManager _columnManager;
            private IPropertyDescriptor[] _uniqueDescriptors;
            private ArrayList _currentDisplayedDescriptors;
            private ArrayList _availableDescriptors;
            private org.eclipse.swt.widgets.List _availableList;
            private org.eclipse.swt.widgets.List _displayedList;
            private Button _addButton;
            private Button _removeButton;
            private Button _upButton;
            private Button _downButton;

            public SelectColumnsDialog(Shell shell, ISystemViewElementAdapter viewAdapter, ISystemTableViewColumnManager columnManager) {
                super(shell, SystemResources.RESID_TABLE_SELECT_COLUMNS_LABEL);
                SelectColumnsAction.this.setToolTipText(SystemResources.RESID_TABLE_SELECT_COLUMNS_TOOLTIP);
                this._adapter = viewAdapter;
                this._columnManager = columnManager;
                this._uniqueDescriptors = viewAdapter.getUniquePropertyDescriptors();
                IPropertyDescriptor[] initialDisplayedDescriptors = this._columnManager.getVisibleDescriptors(this._adapter);
                this._currentDisplayedDescriptors = new ArrayList(initialDisplayedDescriptors.length);
                int i = 0;
                while (i < initialDisplayedDescriptors.length) {
                    if (!this._currentDisplayedDescriptors.contains(initialDisplayedDescriptors[i])) {
                        this._currentDisplayedDescriptors.add(initialDisplayedDescriptors[i]);
                    }
                    ++i;
                }
                this._availableDescriptors = new ArrayList(this._uniqueDescriptors.length);
                i = 0;
                while (i < this._uniqueDescriptors.length) {
                    if (!this._currentDisplayedDescriptors.contains(this._uniqueDescriptors[i])) {
                        this._availableDescriptors.add(this._uniqueDescriptors[i]);
                    }
                    ++i;
                }
            }

            public void handleEvent(Event e) {
                Widget source = e.widget;
                if (source == this._addButton) {
                    int[] toAdd = this._availableList.getSelectionIndices();
                    this.addToDisplay(toAdd);
                } else if (source == this._removeButton) {
                    int[] toAdd = this._displayedList.getSelectionIndices();
                    this.removeFromDisplay(toAdd);
                } else if (source == this._upButton) {
                    int index = this._displayedList.getSelectionIndex();
                    this.moveUp(index);
                    this._displayedList.select(index - 1);
                } else if (source == this._downButton) {
                    int index = this._displayedList.getSelectionIndex();
                    this.moveDown(index);
                    this._displayedList.select(index + 1);
                }
                this.updateEnableStates();
            }

            public IPropertyDescriptor[] getDisplayedColumns() {
                IPropertyDescriptor[] displayedColumns = new IPropertyDescriptor[this._currentDisplayedDescriptors.size()];
                int i = 0;
                while (i < this._currentDisplayedDescriptors.size()) {
                    displayedColumns[i] = (IPropertyDescriptor)this._currentDisplayedDescriptors.get(i);
                    ++i;
                }
                return displayedColumns;
            }

            private void updateEnableStates() {
                boolean enableAdd = false;
                boolean enableRemove = false;
                boolean enableUp = false;
                boolean enableDown = false;
                int[] availableSelected = this._availableList.getSelectionIndices();
                int i = 0;
                while (i < availableSelected.length) {
                    int index = availableSelected[i];
                    IPropertyDescriptor descriptor = (IPropertyDescriptor)this._availableDescriptors.get(index);
                    if (!this._currentDisplayedDescriptors.contains(descriptor)) {
                        enableAdd = true;
                    }
                    ++i;
                }
                if (this._displayedList.getSelectionCount() > 0) {
                    enableRemove = true;
                    int index = this._displayedList.getSelectionIndex();
                    if (index > 0) {
                        enableUp = true;
                    }
                    if (index < this._displayedList.getItemCount() - 1) {
                        enableDown = true;
                    }
                }
                this._addButton.setEnabled(enableAdd);
                this._removeButton.setEnabled(enableRemove);
                this._upButton.setEnabled(enableUp);
                this._downButton.setEnabled(enableDown);
            }

            private void moveUp(int index) {
                Object obj = this._currentDisplayedDescriptors.remove(index);
                this._currentDisplayedDescriptors.add(index - 1, obj);
                this.refreshDisplayedList();
            }

            private void moveDown(int index) {
                Object obj = this._currentDisplayedDescriptors.remove(index);
                this._currentDisplayedDescriptors.add(index + 1, obj);
                this.refreshDisplayedList();
            }

            private void addToDisplay(int[] toAdd) {
                ArrayList<IPropertyDescriptor> added = new ArrayList<IPropertyDescriptor>();
                int i = 0;
                while (i < toAdd.length) {
                    int index = toAdd[i];
                    IPropertyDescriptor descriptor = (IPropertyDescriptor)this._availableDescriptors.get(index);
                    if (!this._currentDisplayedDescriptors.contains(descriptor)) {
                        this._currentDisplayedDescriptors.add(descriptor);
                        added.add(descriptor);
                    }
                    ++i;
                }
                i = 0;
                while (i < added.size()) {
                    this._availableDescriptors.remove(added.get(i));
                    ++i;
                }
                this.refreshAvailableList();
                this.refreshDisplayedList();
            }

            private void removeFromDisplay(int[] toRemove) {
                int i = 0;
                while (i < toRemove.length) {
                    int index = toRemove[i];
                    IPropertyDescriptor descriptor = (IPropertyDescriptor)this._currentDisplayedDescriptors.get(index);
                    this._currentDisplayedDescriptors.remove(index);
                    this._availableDescriptors.add(descriptor);
                    ++i;
                }
                this.refreshDisplayedList();
                this.refreshAvailableList();
            }

            protected void buttonPressed(int buttonId) {
                this.setReturnCode(buttonId);
                this.close();
            }

            protected Control getInitialFocusControl() {
                return this._availableList;
            }

            public Control createInner(Composite parent) {
                Composite main = SystemWidgetHelpers.createComposite(parent, 1);
                Composite c = SystemWidgetHelpers.createComposite(main, 4);
                c.setLayoutData((Object)new GridData(1808));
                this._availableList = SystemWidgetHelpers.createListBox(c, SystemResources.RESID_TABLE_SELECT_COLUMNS_AVAILABLE_LABEL, this, true);
                Composite addRemoveComposite = SystemWidgetHelpers.createComposite(c, 1);
                addRemoveComposite.setLayoutData((Object)new GridData(4));
                this._addButton = SystemWidgetHelpers.createPushButton(addRemoveComposite, SystemResources.RESID_TABLE_SELECT_COLUMNS_ADD_LABEL, this);
                this._addButton.setToolTipText(SystemResources.RESID_TABLE_SELECT_COLUMNS_ADD_TOOLTIP);
                this._removeButton = SystemWidgetHelpers.createPushButton(addRemoveComposite, SystemResources.RESID_TABLE_SELECT_COLUMNS_REMOVE_LABEL, this);
                this._removeButton.setToolTipText(SystemResources.RESID_TABLE_SELECT_COLUMNS_REMOVE_TOOLTIP);
                this._displayedList = SystemWidgetHelpers.createListBox(c, SystemResources.RESID_TABLE_SELECT_COLUMNS_DISPLAYED_LABEL, this, false);
                Composite upDownComposite = SystemWidgetHelpers.createComposite(c, 1);
                upDownComposite.setLayoutData((Object)new GridData(4));
                this._upButton = SystemWidgetHelpers.createPushButton(upDownComposite, SystemResources.RESID_TABLE_SELECT_COLUMNS_UP_LABEL, this);
                this._upButton.setToolTipText(SystemResources.RESID_TABLE_SELECT_COLUMNS_UP_TOOLTIP);
                this._downButton = SystemWidgetHelpers.createPushButton(upDownComposite, SystemResources.RESID_TABLE_SELECT_COLUMNS_DOWN_LABEL, this);
                this._downButton.setToolTipText(SystemResources.RESID_TABLE_SELECT_COLUMNS_DOWN_TOOLTIP);
                this.initLists();
                this.setHelp();
                return c;
            }

            private void initLists() {
                this.refreshAvailableList();
                this.refreshDisplayedList();
                this.updateEnableStates();
            }

            private void refreshAvailableList() {
                this._availableList.removeAll();
                int i = 0;
                while (i < this._availableDescriptors.size()) {
                    IPropertyDescriptor descriptor = (IPropertyDescriptor)this._availableDescriptors.get(i);
                    this._availableList.add(descriptor.getDisplayName());
                    ++i;
                }
            }

            private void refreshDisplayedList() {
                this._displayedList.removeAll();
                int i = 0;
                while (i < this._currentDisplayedDescriptors.size()) {
                    Object obj = this._currentDisplayedDescriptors.get(i);
                    if (obj != null && obj instanceof IPropertyDescriptor) {
                        this._displayedList.add(((IPropertyDescriptor)obj).getDisplayName());
                    }
                    ++i;
                }
            }

            private void setHelp() {
                this.setHelp("org.eclipse.rse.ui.gntc0000");
            }
        }
    }

    class SelectInputAction
    extends BrowseAction {
        public SelectInputAction() {
            super(SystemResources.ACTION_SELECT_INPUT_LABEL, null);
            this.setToolTipText(SystemResources.ACTION_SELECT_INPUT_TOOLTIP);
        }

        public void checkEnabledState() {
            this.setEnabled(true);
        }

        public void run() {
            Object selected;
            SystemSelectAnythingDialog dlg = new SystemSelectAnythingDialog(SystemTableViewPart.this._viewer.getShell(), SystemResources.ACTION_SELECT_INPUT_DLG);
            SystemActionViewerFilter filter = new SystemActionViewerFilter();
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class[] types = classArray;
            filter.addFilterCriterion(types, "hasChildren", "true");
            dlg.setViewerFilter(filter);
            Object inputObject = SystemTableViewPart.this._viewer.getInput();
            if (inputObject == null) {
                inputObject = RSECorePlugin.getTheSystemRegistry();
            }
            dlg.setInputObject(inputObject);
            if (dlg.open() == 0 && (selected = dlg.getSelectedObject()) != null && selected instanceof IAdaptable) {
                IAdaptable adaptable = (IAdaptable)selected;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ((ISystemViewElementAdapter)adaptable.getAdapter((Class)clazz2)).setViewer((Viewer)SystemTableViewPart.this._viewer);
                SystemTableViewPart.this.setInput(adaptable);
            }
        }
    }

    class SubSetAction
    extends BrowseAction {
        public SubSetAction() {
            super(SystemResources.ACTION_SUBSET_LABEL, null);
            this.setToolTipText(SystemResources.ACTION_SUBSET_TOOLTIP);
        }

        public void run() {
            SubSetDialog subsetDialog = new SubSetDialog(SystemTableViewPart.this.getViewer().getShell(), SystemTableViewPart.this._viewer.getVisibleDescriptors(SystemTableViewPart.this._viewer.getInput()), SystemTableViewPart.this._currentItem);
            if (subsetDialog.open() == 0) {
                String[] filters = subsetDialog.getFilters();
                SystemTableViewPart.this._currentItem.setFilters(filters);
                SystemTableViewPart.this._viewer.setViewFilters(filters);
            }
        }

        class SubSetDialog
        extends SystemPromptDialog {
            private String[] _filters;
            private Text[] _controls;
            private IPropertyDescriptor[] _uniqueDescriptors;
            private HistoryItem _historyItem;

            public SubSetDialog(Shell shell, IPropertyDescriptor[] uniqueDescriptors, HistoryItem historyItem) {
                super(shell, SystemResources.RESID_TABLE_SUBSET_LABEL);
                this._uniqueDescriptors = uniqueDescriptors;
                this._historyItem = historyItem;
            }

            public String[] getFilters() {
                return this._filters;
            }

            protected void buttonPressed(int buttonId) {
                this.setReturnCode(buttonId);
                int i = 0;
                while (i < this._controls.length) {
                    this._filters[i] = this._controls[i].getText();
                    ++i;
                }
                this.close();
            }

            protected Control getInitialFocusControl() {
                return this._controls[0];
            }

            public Control createInner(Composite parent) {
                Composite c = SystemWidgetHelpers.createComposite(parent, 2);
                int numberOfFields = this._uniqueDescriptors.length;
                this._controls = new Text[numberOfFields + 1];
                this._filters = new String[numberOfFields + 1];
                Label nLabel = new Label(c, 0);
                nLabel.setText(SystemPropertyResources.RESID_PROPERTY_NAME_LABEL);
                String[] histFilters = null;
                if (this._historyItem != null) {
                    histFilters = this._historyItem.getFilters();
                }
                this._controls[0] = SystemWidgetHelpers.createTextField(c, null);
                GridData textData = new GridData(768);
                this._controls[0].setLayoutData((Object)textData);
                this._controls[0].setText("*");
                this._controls[0].setToolTipText(SystemResources.RESID_TABLE_SUBSET_ENTRY_TOOLTIP);
                if (histFilters != null) {
                    this._controls[0].setText(histFilters[0]);
                }
                int i = 0;
                while (i < numberOfFields) {
                    IPropertyDescriptor des = this._uniqueDescriptors[i];
                    Label aLabel = new Label(c, 0);
                    aLabel.setText(des.getDisplayName());
                    this._controls[i + 1] = SystemWidgetHelpers.createTextField(c, null);
                    GridData textData3 = new GridData(768);
                    textData3.widthHint = 150;
                    this._controls[i + 1].setLayoutData((Object)textData3);
                    this._controls[i + 1].setText("*");
                    if (histFilters != null) {
                        this._controls[i + 1].setText(histFilters[i + 1]);
                        this._controls[i + 1].setToolTipText(SystemResources.RESID_TABLE_SUBSET_ENTRY_TOOLTIP);
                    }
                    ++i;
                }
                this.setHelp();
                return c;
            }

            private void setHelp() {
                this.setHelp("org.eclipse.rse.ui.gnss0000");
            }
        }
    }

    class UpAction
    extends BrowseAction {
        private IAdaptable _parent;

        public UpAction() {
            super(SystemResources.ACTION_GOUPLEVEL_TOOLTIP, SystemTableViewPart.this.getEclipseImageDescriptor("elcl16/up_nav.gif"));
            this.setDisabledImageDescriptor(SystemTableViewPart.this.getEclipseImageDescriptor("dlcl16/up_nav.gif"));
        }

        public void checkEnabledState() {
            if (SystemTableViewPart.this._viewer.getInput() != null) {
                SystemTableViewProvider provider = (SystemTableViewProvider)SystemTableViewPart.this._viewer.getContentProvider();
                if (provider != null) {
                    Object parent = provider.getParent(SystemTableViewPart.this._viewer.getInput());
                    if (parent instanceof IAdaptable) {
                        this._parent = (IAdaptable)parent;
                        this.setEnabled(true);
                    } else {
                        this._parent = null;
                        this.setEnabled(false);
                    }
                } else {
                    this._parent = null;
                    this.setEnabled(false);
                }
            } else {
                this._parent = null;
                this.setEnabled(false);
            }
        }

        public void run() {
            if (this._parent != null) {
                SystemTableViewPart.this.setInput(this._parent);
            }
        }
    }
}

