/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.model;

import org.eclipse.tm.internal.terminal.model.ISnapshotChanges;
import org.eclipse.tm.terminal.model.ITerminalTextData;

public class SnapshotChanges
implements ISnapshotChanges {
    private int fFirstChangedLine;
    private int fLastChangedLine;
    private int fScrollWindowStartLine;
    private int fScrollWindowSize;
    private int fScrollWindowShift;
    private boolean fScrollDontTrack;
    private boolean[] fChangedLines;
    private int fInterestWindowSize;
    private int fInterestWindowStartLine;
    private boolean fDimensionsChanged;
    private boolean fTerminalHasChanged;
    private boolean fCursorHasChanged;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.tm.internal.terminal.model.SnapshotChanges");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public SnapshotChanges(int nLines) {
        this.setChangedLinesLength(nLines);
        this.fFirstChangedLine = Integer.MAX_VALUE;
        this.fLastChangedLine = -1;
    }

    public SnapshotChanges(int windowStart, int windowSize) {
        this.setChangedLinesLength(windowStart + windowSize);
        this.fFirstChangedLine = Integer.MAX_VALUE;
        this.fLastChangedLine = -1;
        this.fInterestWindowStartLine = windowStart;
        this.fInterestWindowSize = windowSize;
    }

    private boolean throwRuntimeException() {
        throw new RuntimeException();
    }

    boolean isInInterestWindow(int line, int size) {
        if (this.fInterestWindowSize <= 0) {
            return true;
        }
        return line + size > this.fInterestWindowStartLine && line < this.fInterestWindowStartLine + this.fInterestWindowSize;
    }

    boolean isInInterestWindow(int line) {
        if (this.fInterestWindowSize <= 0) {
            return true;
        }
        return line >= this.fInterestWindowStartLine && line < this.fInterestWindowStartLine + this.fInterestWindowSize;
    }

    int fitLineToWindow(int line) {
        if (this.fInterestWindowSize <= 0) {
            return line;
        }
        if (line < this.fInterestWindowStartLine) {
            return this.fInterestWindowStartLine;
        }
        return line;
    }

    int fitSizeToWindow(int line, int size) {
        if (this.fInterestWindowSize <= 0) {
            return size;
        }
        if (line < this.fInterestWindowStartLine) {
            size -= this.fInterestWindowStartLine - line;
            line = this.fInterestWindowStartLine;
        }
        if (line + size > this.fInterestWindowStartLine + this.fInterestWindowSize) {
            size = this.fInterestWindowStartLine + this.fInterestWindowSize - line;
        }
        return size;
    }

    public void markLineChanged(int line) {
        if (!this.isInInterestWindow(line)) {
            return;
        }
        if ((line = this.fitLineToWindow(line)) < this.fFirstChangedLine) {
            this.fFirstChangedLine = line;
        }
        if (line > this.fLastChangedLine) {
            this.fLastChangedLine = line;
        }
        if (line < this.getChangedLineLength()) {
            this.setChangedLine(line, true);
        }
    }

    public void markLinesChanged(int line, int n) {
        if (n <= 0 || !this.isInInterestWindow(line, n)) {
            return;
        }
        n = this.fitSizeToWindow(line, n);
        line = this.fitLineToWindow(line);
        int m = Math.min(line + n, this.getChangedLineLength());
        int i = line;
        while (i < m) {
            this.setChangedLine(i, true);
            ++i;
        }
        this.markLineChanged(line);
        this.markLineChanged(line + n - 1);
    }

    public void markCursorChanged() {
        this.fCursorHasChanged = true;
    }

    public void convertScrollingIntoChanges() {
        this.markLinesChanged(this.fScrollWindowStartLine, this.fScrollWindowSize);
        this.fScrollWindowStartLine = 0;
        this.fScrollWindowSize = 0;
        this.fScrollWindowShift = 0;
    }

    public boolean hasChanged() {
        return this.fFirstChangedLine != Integer.MAX_VALUE || this.fLastChangedLine > 0 || this.fScrollWindowShift != 0 || this.fDimensionsChanged || this.fCursorHasChanged;
    }

    public void markDimensionsChanged() {
        this.fDimensionsChanged = true;
    }

    public boolean hasDimensionsChanged() {
        return this.fDimensionsChanged;
    }

    public boolean hasTerminalChanged() {
        return this.fTerminalHasChanged;
    }

    public void setTerminalChanged() {
        this.fTerminalHasChanged = true;
    }

    public void scroll(int startLine, int size, int shift) {
        size = this.fitSizeToWindow(startLine, size);
        startLine = this.fitLineToWindow(startLine);
        if (this.fScrollDontTrack) {
            this.markLinesChanged(startLine, size);
        } else if (shift >= 0) {
            this.doNotTrackScrollingAnymore();
            this.markLinesChanged(startLine, size);
        } else if (this.fScrollWindowShift < 0) {
            if (this.fScrollWindowStartLine == startLine && this.fScrollWindowSize == size) {
                this.fScrollWindowShift += shift;
                this.scrollChangesLinesWithNegativeShift(startLine, size, shift);
            } else {
                this.doNotTrackScrollingAnymore();
                this.markLinesChanged(startLine, size);
            }
        } else {
            this.fScrollWindowStartLine = startLine;
            this.fScrollWindowSize = size;
            this.fScrollWindowShift = shift;
            this.scrollChangesLinesWithNegativeShift(startLine, size, shift);
        }
    }

    private void doNotTrackScrollingAnymore() {
        if (this.fScrollWindowSize > 0) {
            this.markLinesChanged(this.fScrollWindowStartLine, this.fScrollWindowSize);
            this.fScrollWindowStartLine = 0;
            this.fScrollWindowSize = 0;
            this.fScrollWindowShift = 0;
        }
        this.fScrollDontTrack = true;
    }

    private void scrollChangesLinesWithNegativeShift(int line, int n, int shift) {
        if (!$assertionsDisabled && shift >= 0 && !this.throwRuntimeException()) {
            throw new AssertionError();
        }
        int m = Math.min(line + n + shift, this.getChangedLineLength() + shift);
        int i = line;
        while (i < m) {
            this.setChangedLine(i, this.hasLineChanged(i - shift));
            if (i < this.fFirstChangedLine && this.hasLineChanged(i)) {
                this.fFirstChangedLine = i;
            }
            ++i;
        }
        i = Math.max(0, line + n + shift);
        while (i < line + n) {
            this.markLineChanged(i);
            ++i;
        }
    }

    public void setAllChanged(int height) {
        this.fScrollWindowStartLine = 0;
        this.fScrollWindowSize = 0;
        this.fScrollWindowShift = 0;
        this.fFirstChangedLine = this.fitLineToWindow(0);
        this.fLastChangedLine = this.fFirstChangedLine + this.fitSizeToWindow(0, height) - 1;
        this.setChangedLinesLength(0);
    }

    public int getFirstChangedLine() {
        return this.fFirstChangedLine;
    }

    public int getLastChangedLine() {
        return this.fLastChangedLine;
    }

    public int getScrollWindowStartLine() {
        return this.fScrollWindowStartLine;
    }

    public int getScrollWindowSize() {
        return this.fScrollWindowSize;
    }

    public int getScrollWindowShift() {
        return this.fScrollWindowShift;
    }

    public void copyChangedLines(ITerminalTextData dest, ITerminalTextData source) {
        int n = Math.min(this.fLastChangedLine + 1, source.getHeight());
        int i = this.fFirstChangedLine;
        while (i < n) {
            if (this.hasLineChanged(i)) {
                dest.copyLine(source, i, i);
            }
            ++i;
        }
    }

    public int getInterestWindowSize() {
        return this.fInterestWindowSize;
    }

    public int getInterestWindowStartLine() {
        return this.fInterestWindowStartLine;
    }

    public void setInterestWindow(int startLine, int size) {
        int oldStartLine = this.fInterestWindowStartLine;
        int oldSize = this.fInterestWindowSize;
        this.fInterestWindowStartLine = startLine;
        this.fInterestWindowSize = size;
        if (oldSize > 0) {
            int shift = oldStartLine - startLine;
            if (shift == 0) {
                if (size > oldSize) {
                    this.markLinesChanged(oldStartLine + oldSize, size - oldSize);
                }
            } else if (Math.abs(shift) < size) {
                if (shift < 0) {
                    this.scroll(startLine, oldSize, shift);
                    int i = oldStartLine + oldSize;
                    while (i < startLine + size) {
                        this.markLineChanged(i);
                        ++i;
                    }
                } else {
                    this.markLinesChanged(startLine, size);
                }
            } else {
                this.markLinesChanged(startLine, size);
            }
        }
    }

    public boolean hasLineChanged(int line) {
        if (line < this.fChangedLines.length) {
            return this.fChangedLines[line];
        }
        return this.isInInterestWindow(line);
    }

    int getChangedLineLength() {
        return this.fChangedLines.length;
    }

    void setChangedLine(int line, boolean changed) {
        this.fChangedLines[line] = changed;
    }

    void setChangedLinesLength(int length) {
        this.fChangedLines = new boolean[length];
    }
}

