/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.clientserver;

import java.util.regex.Pattern;
import org.eclipse.rse.services.clientserver.archiveutils.AbsoluteVirtualPath;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;

public class PathUtility {
    private static Pattern badSlashPatternWin = Pattern.compile("/|\\\\\\\\");
    private static Pattern badSlashPatternUnix = Pattern.compile("\\\\|//");
    private static Pattern fValidShellPattern = Pattern.compile("[a-zA-Z0-9._/]*");

    public static String normalizeWindows(String path) {
        boolean endsWithSlash;
        if (path == null || path.length() < 2) {
            return path;
        }
        boolean bl = endsWithSlash = path.endsWith("\\") || path.endsWith("/");
        if (badSlashPatternWin.matcher(path).find()) {
            StringBuffer buf = new StringBuffer(path.length());
            boolean foundBackslash = false;
            int i = 0;
            while (i < path.length()) {
                char c = path.charAt(i);
                if (c == '/') {
                    c = '\\';
                }
                if (c == '\\') {
                    if (!foundBackslash) {
                        foundBackslash = true;
                        buf.append(c);
                    }
                } else {
                    foundBackslash = false;
                    buf.append(c);
                }
                ++i;
            }
            if (endsWithSlash && buf.length() != 3) {
                buf.deleteCharAt(buf.length() - 1);
            }
            path = buf.toString();
        } else if (endsWithSlash && path.length() != 3) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String normalizeUnix(String path) {
        boolean endsWithSlash;
        if (path == null || path.length() < 2) {
            return path;
        }
        boolean bl = endsWithSlash = path.endsWith("\\") || path.endsWith("/");
        if (badSlashPatternUnix.matcher(path).find()) {
            StringBuffer buf = new StringBuffer(path.length());
            boolean foundSlash = false;
            int i = 0;
            while (i < path.length()) {
                char c = path.charAt(i);
                if (c == '\\') {
                    c = '/';
                }
                if (c == '/') {
                    if (!foundSlash) {
                        foundSlash = true;
                        buf.append(c);
                    }
                } else {
                    foundSlash = false;
                    buf.append(c);
                }
                ++i;
            }
            if (endsWithSlash && buf.length() != 1) {
                buf.deleteCharAt(buf.length() - 1);
            }
            path = buf.toString();
        } else if (endsWithSlash && path.length() != 1) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String normalizeVirtualWindows(String path) {
        if (path == null || path.length() < 2) {
            return path;
        }
        AbsoluteVirtualPath avp = new AbsoluteVirtualPath(path);
        String realPart = avp.getContainingArchiveString();
        realPart = ArchiveHandlerManager.isVirtual(realPart) ? PathUtility.normalizeVirtualWindows(realPart) : PathUtility.normalizeWindows(realPart);
        return String.valueOf(realPart) + "#virtual#/" + avp.getVirtualPart();
    }

    public static String normalizeVirtualUnix(String path) {
        if (path == null || path.length() < 2) {
            return path;
        }
        AbsoluteVirtualPath avp = new AbsoluteVirtualPath(path);
        String realPart = avp.getContainingArchiveString();
        realPart = ArchiveHandlerManager.isVirtual(realPart) ? PathUtility.normalizeVirtualUnix(realPart) : PathUtility.normalizeUnix(realPart);
        return String.valueOf(realPart) + "#virtual#/" + avp.getVirtualPart();
    }

    public static String normalizeUnknown(String path) {
        if (path == null || path.length() < 2) {
            return path;
        }
        if (path.charAt(1) == ':') {
            if (path.indexOf("#virtual#") == -1) {
                return PathUtility.normalizeWindows(path);
            }
            return PathUtility.normalizeVirtualWindows(path);
        }
        if (path.charAt(0) == '/') {
            if (path.indexOf("#virtual#") == -1) {
                return PathUtility.normalizeUnix(path);
            }
            return PathUtility.normalizeVirtualUnix(path);
        }
        return path;
    }

    public static String getSeparator(String path) {
        if (path != null && path.length() > 0) {
            switch (path.charAt(0)) {
                case '/': {
                    return "/";
                }
                case '\\': {
                    return "\\";
                }
            }
            if (path.length() > 2 && path.charAt(1) == ':') {
                switch (path.charAt(2)) {
                    case '\\': {
                        return "\\";
                    }
                    case '/': {
                        return "/";
                    }
                }
            }
            if (path.indexOf(47) > 0) {
                return "/";
            }
            if (path.indexOf(92) > 0) {
                return "\\";
            }
            if (path.length() == 2 && path.charAt(1) == ':') {
                return "\\";
            }
        }
        return "/";
    }

    public static String enQuoteUnix(String s) {
        if (fValidShellPattern.matcher(s).matches()) {
            return s;
        }
        StringBuffer buf = new StringBuffer(s.length() + 16);
        buf.append('\"');
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '$': 
                case '\'': 
                case '\\': 
                case '`': {
                    buf.append('\"');
                    buf.append('\\');
                    buf.append(c);
                    buf.append('\"');
                    break;
                }
                case '\n': 
                case '\"': {
                    buf.append('\\');
                    buf.append(c);
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        buf.append('\"');
        return buf.toString();
    }
}

