/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.connectorservice.ssh;

import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.internal.connectorservice.ssh.SshConnectorResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class KeyboardInteractiveDialog
extends TrayDialog {
    private Text[] texts;
    protected String domain;
    protected String destination;
    protected String name;
    protected String instruction;
    protected String lang;
    protected String[] prompt;
    protected boolean[] echo;
    private String message;
    private String[] result;

    public KeyboardInteractiveDialog(Shell parentShell, String connectionId, String destination, String name, String instruction, String[] prompt, boolean[] echo) {
        super(parentShell);
        this.domain = connectionId;
        this.destination = destination;
        this.name = name;
        this.instruction = instruction;
        this.prompt = prompt;
        this.echo = echo;
        this.message = NLS.bind((String)SshConnectorResources.KeyboardInteractiveDialog_message, (Object[])new String[]{String.valueOf(destination) + (name != null && name.length() > 0 ? ": " + name : "")});
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.message);
    }

    public void create() {
        super.create();
        if (this.texts.length > 0) {
            this.texts[0].setFocus();
        }
    }

    protected Control createDialogArea(Composite parent) {
        GridData data;
        Label messageLabel;
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(1808));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)main, "org.eclipse.team.cvs.ui.keyboard_interactive_dialog_context");
        if (this.message != null) {
            messageLabel = new Label(main, 64);
            messageLabel.setText(this.message);
            data = new GridData(768);
            data.horizontalSpan = 3;
            messageLabel.setLayoutData((Object)data);
        }
        if (this.domain != null) {
            Label label = new Label(main, 64);
            label.setText(NLS.bind((String)SshConnectorResources.KeyboardInteractiveDialog_labelConnection, (Object[])new String[]{this.domain}));
            data = new GridData(768);
            data.horizontalSpan = 3;
            label.setLayoutData((Object)data);
        }
        if (this.instruction != null && this.instruction.length() > 0) {
            messageLabel = new Label(main, 64);
            messageLabel.setText(this.instruction);
            data = new GridData(768);
            data.horizontalSpan = 3;
            messageLabel.setLayoutData((Object)data);
        }
        this.createPasswordFields(main);
        return main;
    }

    protected void createPasswordFields(Composite parent) {
        this.texts = new Text[this.prompt.length];
        int i = 0;
        while (i < this.prompt.length) {
            new Label(parent, 0).setText(this.prompt[i]);
            this.texts[i] = new Text(parent, 2048);
            GridData data = new GridData(768);
            data.widthHint = this.convertHorizontalDLUsToPixels(200);
            this.texts[i].setLayoutData((Object)data);
            if (!this.echo[i]) {
                this.texts[i].setEchoChar('*');
            }
            new Label(parent, 0);
            ++i;
        }
    }

    public String[] getResult() {
        return this.result;
    }

    protected void okPressed() {
        this.result = new String[this.prompt.length];
        int i = 0;
        while (i < this.texts.length) {
            this.result[i] = this.texts[i].getText();
            ++i;
        }
        super.okPressed();
    }

    protected void cancelPressed() {
        this.result = null;
        super.cancelPressed();
    }
}

