/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.shells.local.model;

import java.io.File;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.services.local.shells.ParsedOutput;
import org.eclipse.rse.internal.services.local.shells.Patterns;
import org.eclipse.rse.internal.subsystems.shells.servicesubsystem.OutputRefreshJob;
import org.eclipse.rse.internal.subsystems.shells.subsystems.RemoteError;
import org.eclipse.rse.internal.subsystems.shells.subsystems.RemoteOutput;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IHostShellChangeEvent;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCommandShell;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteOutput;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.ServiceCommandShell;

public class LocalServiceCommandShell
extends ServiceCommandShell {
    private Patterns _patterns = new Patterns();
    private String _workingDir;
    private IRemoteFileSubSystem _fs;

    public LocalServiceCommandShell(IRemoteCmdSubSystem cmdSS, IHostShell hostShell) {
        super(cmdSS, hostShell);
        this._patterns.update("cmd");
        ISubSystem[] sses = cmdSS.getHost().getSubSystems();
        int i = 0;
        while (i < sses.length) {
            if (sses[i] instanceof IRemoteFileSubSystem) {
                this._fs = (IRemoteFileSubSystem)sses[i];
            }
            ++i;
        }
    }

    public Object getContext() {
        String workingDir = this._workingDir;
        if (workingDir != null && workingDir.length() > 0) {
            try {
                return this._fs.getRemoteFileObject(workingDir);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public void shellOutputChanged(IHostShellChangeEvent event) {
        Object[] lines = event.getLines();
        IRemoteOutput[] outputs = new IRemoteOutput[lines.length];
        int i = 0;
        while (i < lines.length) {
            String line = (String)lines[i];
            ParsedOutput parsedMsg = null;
            try {
                parsedMsg = this._patterns.matchLine(line);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            Object output = null;
            String type = "stdout";
            if (parsedMsg != null) {
                type = parsedMsg.type;
            }
            output = event.isError() ? new RemoteError((Object)this, type) : new RemoteOutput((Object)this, type);
            output.setText(line);
            if (parsedMsg != null) {
                String file = parsedMsg.file;
                if (type.equals("prompt")) {
                    this._workingDir = file;
                    output.setAbsolutePath(this._workingDir);
                } else {
                    output.setAbsolutePath(String.valueOf(this._workingDir) + File.separatorChar + file);
                }
            }
            this.addOutput(output);
            outputs[i] = output;
            ++i;
        }
        if (this._lastRefreshJob == null || this._lastRefreshJob.isComplete()) {
            this._lastRefreshJob = new OutputRefreshJob((IRemoteCommandShell)this, outputs, false);
            this._lastRefreshJob.schedule();
        }
    }

    public void writeToShell(String cmd) {
        super.writeToShell(cmd);
        this._patterns.update(cmd);
    }
}

