/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.shells.ui.view;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.model.IHost;
import org.eclipse.rse.model.ISystemRegistry;
import org.eclipse.rse.model.ISystemResourceChangeEvent;
import org.eclipse.rse.model.ISystemResourceChangeListener;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.shells.ui.RemoteCommandHelpers;
import org.eclipse.rse.shells.ui.ShellResources;
import org.eclipse.rse.shells.ui.actions.SystemBaseShellAction;
import org.eclipse.rse.shells.ui.view.CommandsViewPage;
import org.eclipse.rse.shells.ui.view.CommandsViewWorkbook;
import org.eclipse.rse.shells.ui.view.SystemCommandsUI;
import org.eclipse.rse.shells.ui.view.SystemViewRemoteOutputAdapter;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCmdSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.IRemoteCommandShell;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.actions.SystemBaseDummyAction;
import org.eclipse.rse.ui.actions.SystemTablePrintAction;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.view.IRSEViewPart;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.SystemTableView;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.CellEditorActionHandler;
import org.eclipse.ui.part.ViewPart;

public class SystemCommandsViewPart
extends ViewPart
implements ISelectionListener,
SelectionListener,
ISelectionChangedListener,
ISystemResourceChangeListener,
IRSEViewPart,
IMenuListener,
ISystemMessageLine {
    private ClearAction _clearAction = null;
    private List _shellActions = null;
    private SystemTablePrintAction _printTableAction = null;
    private CommandsViewWorkbook _folder = null;
    private IRemoteCommandShell _lastSelected = null;
    private CellEditorActionHandler _editorActionHandler = null;
    private String _message;
    private String _errorMessage;
    private SystemMessage sysErrorMessage;
    private IStatusLineManager _statusLine = null;
    public static final String ID = "org.eclipse.rse.shells.ui.view.commandsView";
    static /* synthetic */ Class class$0;

    public void setFocus() {
        this._folder.showCurrentPage();
    }

    public Shell getShell() {
        return this._folder.getShell();
    }

    public Viewer getRSEViewer() {
        return this._folder.getViewer();
    }

    public CellEditorActionHandler getEditorActionHandler() {
        if (this._editorActionHandler == null) {
            this._editorActionHandler = new CellEditorActionHandler(this.getViewSite().getActionBars());
        }
        return this._editorActionHandler;
    }

    public void createPartControl(Composite parent) {
        this._folder = new CommandsViewWorkbook(parent, this);
        this._folder.getFolder().addSelectionListener((SelectionListener)this);
        ISelectionService selectionService = this.getSite().getWorkbenchWindow().getSelectionService();
        selectionService.addSelectionListener((ISelectionListener)this);
        SystemWidgetHelpers.setHelp((Control)this._folder, (String)"org.eclipse.rse.ui.ucmd0000");
        ISystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
        registry.addSystemResourceChangeListener((ISystemResourceChangeListener)this);
        RestoreStateRunnable restore = new RestoreStateRunnable();
        Display.getCurrent().asyncExec((Runnable)restore);
        this.fillLocalToolBar();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection sel) {
    }

    public void dispose() {
        ISelectionService selectionService = this.getSite().getWorkbenchWindow().getSelectionService();
        selectionService.removeSelectionListener((ISelectionListener)this);
        this._folder.dispose();
        ISystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
        registry.removeSystemResourceChangeListener((ISystemResourceChangeListener)this);
        super.dispose();
    }

    public void updateActionStates() {
        IRemoteCommandShell currentSelected;
        if (this._shellActions == null) {
            this.fillLocalToolBar();
        }
        if (this._folder != null && this._folder.getInput() != null && (currentSelected = (IRemoteCommandShell)this._folder.getInput()) != null) {
            if (currentSelected != this._lastSelected) {
                IActionBars actionBars = this.getViewSite().getActionBars();
                IToolBarManager toolBarManager = actionBars.getToolBarManager();
                this.updateShellActions();
                this.addToolBarItems(toolBarManager);
            }
            this._lastSelected = currentSelected;
            this._folder.updateActionStates();
            CommandsViewPage page = this._folder.getCurrentTabItem();
            if (page != null) {
                this._printTableAction.setTableView(page.getTitle(), (SystemTableView)page.getViewer());
            } else {
                this._printTableAction.setTableView("", null);
            }
            this._clearAction.checkEnabledState();
            StructuredSelection cmdSelection = new StructuredSelection(this._folder.getInput());
            int i = 0;
            while (i < this._shellActions.size()) {
                Object action = this._shellActions.get(i);
                if (action instanceof SystemBaseShellAction) {
                    SystemBaseShellAction shellAction = (SystemBaseShellAction)((Object)action);
                    shellAction.setEnabled(shellAction.updateSelection((IStructuredSelection)cmdSelection));
                }
                ++i;
            }
            this._printTableAction.checkEnabledState();
        }
    }

    protected void updateShellActions() {
        if (this._folder != null && this._folder.getInput() != null) {
            IRemoteCommandShell cmdShell = (IRemoteCommandShell)this._folder.getInput();
            IAdaptable iAdaptable = (IAdaptable)cmdShell;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            SystemViewRemoteOutputAdapter adapter = (SystemViewRemoteOutputAdapter)((Object)iAdaptable.getAdapter((Class)clazz));
            this._shellActions = adapter.getShellActions(cmdShell.getCommandSubSystem().getParentRemoteCmdSubSystemFactory());
        } else if (this._shellActions != null) {
            this._shellActions.clear();
        } else {
            this._shellActions = new ArrayList();
        }
    }

    public void fillLocalToolBar() {
        boolean firstCall = false;
        if (this._folder != null) {
            boolean bl = firstCall = this._shellActions == null;
            if (firstCall) {
                this.updateShellActions();
            }
            this.updateActionStates();
            IActionBars actionBars = this.getViewSite().getActionBars();
            if (firstCall) {
                this._clearAction = new ClearAction();
                this._printTableAction = new SystemTablePrintAction(this.getTitle(), null);
                IMenuManager menuManager = actionBars.getMenuManager();
                this.addMenuItems(menuManager);
                this._statusLine = actionBars.getStatusLineManager();
            }
            IToolBarManager toolBarManager = actionBars.getToolBarManager();
            this.addToolBarItems(toolBarManager);
        }
    }

    private void addToolBarItems(IToolBarManager toolBarManager) {
        toolBarManager.removeAll();
        if (this._clearAction != null) {
            toolBarManager.add((IAction)this._clearAction);
        }
        if (this._shellActions != null) {
            int i = 0;
            while (i < this._shellActions.size()) {
                Object shellAction = this._shellActions.get(i);
                if (shellAction instanceof IContributionItem) {
                    toolBarManager.add((IContributionItem)shellAction);
                } else if (shellAction instanceof IAction) {
                    toolBarManager.add((IAction)shellAction);
                }
                ++i;
            }
        }
        toolBarManager.update(true);
    }

    private void addMenuItems(IMenuManager menuManager) {
        CommandMenuManager launchMenu = new CommandMenuManager();
        launchMenu.add((IAction)new SystemBaseDummyAction());
        launchMenu.addMenuListener(this);
        launchMenu.setRemoveAllWhenShown(true);
        menuManager.add((IContributionItem)launchMenu);
        menuManager.addMenuListener((IMenuListener)this);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this._printTableAction);
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        if (menuManager instanceof CommandSubmenuManager) {
            IRemoteCmdSubSystem[] cmdSubSystems = ((CommandSubmenuManager)menuManager).getSubSystems();
            int c = 0;
            while (c < cmdSubSystems.length) {
                IRemoteCmdSubSystem cmdSubSystem = cmdSubSystems[c];
                if (cmdSubSystem != null && cmdSubSystem.canRunShell()) {
                    String name = cmdSubSystem.getName();
                    IAdaptable iAdaptable = (IAdaptable)cmdSubSystem;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    ISystemViewElementAdapter ssva = (ISystemViewElementAdapter)iAdaptable.getAdapter((Class)clazz);
                    ImageDescriptor icon = ssva.getImageDescriptor((Object)cmdSubSystem);
                    ShellAction action = new ShellAction(name, icon, cmdSubSystem);
                    menuManager.add((IAction)action);
                }
                ++c;
            }
        } else {
            boolean hasItem = false;
            ISystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
            IHost[] connections = registry.getHosts();
            int i = 0;
            while (i < connections.length) {
                IHost connection = connections[i];
                if (registry.isAnySubSystemConnected(connection) || connection.getSystemType().equals("Local")) {
                    IRemoteCmdSubSystem[] cmdSubSystems = RemoteCommandHelpers.getCmdSubSystems(connection);
                    if (cmdSubSystems.length == 1) {
                        IRemoteCmdSubSystem cmdSubSystem = cmdSubSystems[0];
                        if (cmdSubSystem != null && cmdSubSystem.canRunShell()) {
                            hasItem = true;
                            if (menuManager instanceof CommandMenuManager) {
                                IAdaptable iAdaptable = (IAdaptable)connection;
                                Class<?> clazz = class$0;
                                if (clazz == null) {
                                    try {
                                        clazz = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                ISystemViewElementAdapter va = (ISystemViewElementAdapter)iAdaptable.getAdapter((Class)clazz);
                                String name = connection.getAliasName();
                                ImageDescriptor icon = va.getImageDescriptor((Object)connection);
                                ShellAction action = new ShellAction(name, icon, cmdSubSystem);
                                menuManager.add((IAction)action);
                            }
                        }
                    } else if (cmdSubSystems.length > 1 && menuManager instanceof CommandMenuManager) {
                        IAdaptable iAdaptable = (IAdaptable)connection;
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        ISystemViewElementAdapter cfr_ignored_0 = (ISystemViewElementAdapter)iAdaptable.getAdapter((Class)clazz);
                        CommandSubmenuManager sublaunchMenu = new CommandSubmenuManager(connection, cmdSubSystems);
                        sublaunchMenu.add((IAction)new SystemBaseDummyAction());
                        sublaunchMenu.addMenuListener(this);
                        sublaunchMenu.setRemoveAllWhenShown(true);
                        menuManager.add((IContributionItem)sublaunchMenu);
                        menuManager.addMenuListener((IMenuListener)this);
                    }
                }
                ++i;
            }
            if (!(menuManager instanceof CommandMenuManager)) {
                MenuManager lmgr;
                if (!hasItem) {
                    MenuManager lmgr2;
                    if (menuManager.getItems().length > 0 && (lmgr2 = (MenuManager)menuManager.getItems()[0]).getMenu() != null) {
                        lmgr2.getMenu().getParentItem().setEnabled(false);
                    }
                } else if (menuManager.getItems().length > 0 && (lmgr = (MenuManager)menuManager.getItems()[0]).getMenu() != null) {
                    lmgr.getMenu().getParentItem().setEnabled(true);
                }
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent e) {
    }

    public void updateOutput(IRemoteCommandShell root) {
        this.updateOutput(root, true);
    }

    private void updateOutput(IRemoteCommandShell root, boolean createTab) {
        if (root != null) {
            this._folder.updateOutput(root, createTab);
            if (createTab) {
                this.updateActionStates();
            }
        }
    }

    public void setInput(IAdaptable object) {
        this.setInput(object, true);
    }

    public void setInput(IAdaptable object, boolean updateHistory) {
        this._folder.setInput(object);
    }

    protected void initDefaultCommandShells() {
        ISystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
        IHost[] connections = registry.getHosts();
        CommandsViewPage curpage = this._folder.getCurrentTabItem();
        int i = 0;
        while (i < connections.length) {
            IRemoteCmdSubSystem[] cmdSubSystems;
            IHost connection = connections[i];
            if ((registry.isAnySubSystemConnected(connection) || connection.getSystemType().equals("Local")) && (cmdSubSystems = RemoteCommandHelpers.getCmdSubSystems(connection)).length > 0) {
                int c = 0;
                while (c < cmdSubSystems.length) {
                    IRemoteCmdSubSystem cmdSubSystem = cmdSubSystems[c];
                    if (cmdSubSystem != null && cmdSubSystem.canRunShell()) {
                        this.restoreCommandShells(cmdSubSystem);
                    }
                    ++c;
                }
            }
            ++i;
        }
        if (curpage != null) {
            this.updateOutput((IRemoteCommandShell)curpage.getInput());
        }
    }

    protected void restoreCommandShells(IRemoteCmdSubSystem cmdSS) {
        try {
            IRemoteCommandShell[] cmds = cmdSS.getShells();
            if (cmds == null || cmds.length == 0) {
                cmds = cmdSS.restoreShellState(this.getShell());
                int i = 0;
                while (i < cmds.length) {
                    this.updateOutput(cmds[i]);
                    ++i;
                }
            }
        }
        catch (Exception exception) {}
    }

    public void systemResourceChanged(ISystemResourceChangeEvent event) {
        Shell shell;
        Object source;
        if (event.getType() == 140) {
            source = event.getSource();
            if (source instanceof IRemoteCmdSubSystem) {
                shell = RSEUIPlugin.getTheSystemRegistry().getShell();
                shell.getDisplay().asyncExec((Runnable)new CommandSubSystemDisconnectedRunnable((IRemoteCmdSubSystem)source));
            } else if (source instanceof IRemoteCommandShell) {
                this.updateOutput((IRemoteCommandShell)source, false);
                this.updateActionStates();
            }
        }
        if (event.getType() == 141) {
            source = event.getSource();
            if (source instanceof IRemoteCommandShell) {
                this.updateOutput((IRemoteCommandShell)source, false);
                this._folder.remove((IRemoteCommandShell)source);
                this.updateActionStates();
            }
        } else if (event.getType() == 82) {
            Object parent = event.getParent();
            if (parent instanceof IRemoteCommandShell) {
                this.updateOutput((IRemoteCommandShell)parent, false);
            }
        } else if (event.getType() == 86) {
            IRemoteCmdSubSystem cmdSS = null;
            Object parent = event.getSource();
            if (parent instanceof IRemoteFileSubSystem) {
                IRemoteFileSubSystem ss = (IRemoteFileSubSystem)parent;
                cmdSS = RemoteCommandHelpers.getCmdSubSystem(ss.getHost());
            } else if (parent instanceof IRemoteCmdSubSystem) {
                cmdSS = (IRemoteCmdSubSystem)parent;
            } else if (parent instanceof ISubSystem) {
                cmdSS = RemoteCommandHelpers.getCmdSubSystem(((ISubSystem)parent).getHost());
            }
            if (cmdSS != null && cmdSS.isConnected()) {
                this.restoreCommandShells(cmdSS);
            }
        } else if (event.getType() == 90 && (source = event.getSource()) instanceof IRemoteCmdSubSystem) {
            shell = RSEUIPlugin.getTheSystemRegistry().getShell();
            shell.getDisplay().asyncExec((Runnable)new CommandSubSystemDisconnectedRunnable((IRemoteCmdSubSystem)source));
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        Widget source = e.widget;
        if (source == this._folder.getFolder()) {
            this.updateActionStates();
        }
    }

    public void clearErrorMessage() {
        this._errorMessage = null;
        this.sysErrorMessage = null;
        if (this._statusLine != null) {
            this._statusLine.setErrorMessage(this._errorMessage);
        }
    }

    public void clearMessage() {
        this._message = null;
        if (this._statusLine != null) {
            this._statusLine.setMessage(this._message);
        }
    }

    public String getErrorMessage() {
        return this._errorMessage;
    }

    public String getMessage() {
        return this._message;
    }

    public void setErrorMessage(String message) {
        this._errorMessage = message;
        if (this._statusLine != null) {
            this._statusLine.setErrorMessage(message);
        }
    }

    public SystemMessage getSystemErrorMessage() {
        return this.sysErrorMessage;
    }

    public void setErrorMessage(SystemMessage message) {
        this.sysErrorMessage = message;
        this.setErrorMessage(message.getLevelOneText());
    }

    public void setErrorMessage(Throwable exc) {
        this.setErrorMessage(exc.getMessage());
    }

    public void setMessage(String message) {
        this._message = message;
        if (this._statusLine != null) {
            this._statusLine.setMessage(message);
        }
    }

    public void setMessage(SystemMessage message) {
        this.setMessage(message.getLevelOneText());
    }

    class RestoreStateRunnable
    implements Runnable {
        RestoreStateRunnable() {
        }

        public void run() {
            SystemCommandsViewPart.this.initDefaultCommandShells();
        }
    }

    class BrowseAction
    extends Action {
        public BrowseAction(String label, ImageDescriptor des) {
            super(label, des);
            this.setToolTipText(label);
        }

        public void checkEnabledState() {
            if (SystemCommandsViewPart.this._folder != null && SystemCommandsViewPart.this._folder.getInput() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void run() {
        }
    }

    public class ShellAction
    extends BrowseAction {
        private IRemoteCmdSubSystem _cmdSubSystem;

        public ShellAction(String title, ImageDescriptor image, IRemoteCmdSubSystem cmdSubSystem) {
            super(title, image);
            this.setToolTipText(ShellResources.ACTION_RUN_SHELL_TOOLTIP);
            this._cmdSubSystem = cmdSubSystem;
        }

        public void checkEnabledState() {
            this.setEnabled(this._cmdSubSystem.canRunShell());
        }

        public void run() {
            try {
                IRemoteCommandShell cmd = this._cmdSubSystem.runShell(SystemCommandsViewPart.this.getShell(), null);
                if (cmd != null) {
                    this.showInView(cmd);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void showInView(IRemoteCommandShell cmd) {
            SystemCommandsUI commandsUI = SystemCommandsUI.getInstance();
            SystemCommandsViewPart cmdsPart = commandsUI.activateCommandsView();
            cmdsPart.updateOutput(cmd);
        }
    }

    public class ClearAction
    extends BrowseAction {
        public ClearAction() {
            super(SystemResources.ACTION_CLEAR_LABEL, RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.clearIcon"));
            ImageDescriptor des = RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.clearIcon");
            this.setImageDescriptor(des);
            this.setEnabled(false);
        }

        public void checkEnabledState() {
            Object input = SystemCommandsViewPart.this._folder.getInput();
            if (input != null && input instanceof IRemoteCommandShell) {
                this.setEnabled(((IRemoteCommandShell)input).isActive());
                return;
            }
            this.setEnabled(false);
        }

        public void run() {
            if (SystemCommandsViewPart.this._folder.getInput() != null) {
                this.clear();
            }
        }

        private void clear() {
            SystemCommandsViewPart.this._folder.getViewer().clearAllItems();
        }
    }

    public class CommandSubSystemDisconnectedRunnable
    implements Runnable {
        private IRemoteCmdSubSystem _subsystem;

        public CommandSubSystemDisconnectedRunnable(IRemoteCmdSubSystem subsystem) {
            this._subsystem = subsystem;
        }

        public void run() {
            IRemoteCommandShell[] cmds = this._subsystem.getShells();
            if (cmds != null) {
                int i = 0;
                while (i < cmds.length) {
                    SystemCommandsViewPart.this._folder.remove(cmds[i]);
                    ++i;
                }
            }
        }
    }

    public class CommandMenuManager
    extends MenuManager {
        public CommandMenuManager() {
            super(ShellResources.ACTION_LAUNCH_LABEL);
        }
    }

    public class CommandSubmenuManager
    extends MenuManager {
        private IRemoteCmdSubSystem[] _subsystems;

        public CommandSubmenuManager(IHost connection, IRemoteCmdSubSystem[] subsystems) {
            super(connection.getAliasName());
            this._subsystems = subsystems;
        }

        public IRemoteCmdSubSystem[] getSubSystems() {
            return this._subsystems;
        }
    }
}

