/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.dstore.security.wizards;

import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import org.eclipse.dstore.core.util.ssl.DStoreKeyStore;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.comm.ISystemKeystoreProvider;
import org.eclipse.rse.dstore.security.ImageRegistry;
import org.eclipse.rse.dstore.security.UniversalSecurityProperties;
import org.eclipse.rse.dstore.security.wizards.SystemImportCertWizardAliasPage;
import org.eclipse.rse.dstore.security.wizards.SystemImportCertWizardMainPage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.ISystemMessages;
import org.eclipse.rse.ui.wizards.AbstractSystemWizard;

public class SystemImportCertWizard
extends AbstractSystemWizard
implements ISystemMessages {
    private SystemImportCertWizardMainPage _mainPage;
    private SystemImportCertWizardAliasPage _aliasPage;
    private ISystemKeystoreProvider _provider;
    private String _systemName;

    public SystemImportCertWizard(ISystemKeystoreProvider provider, String systemName) {
        super(UniversalSecurityProperties.RESID_SECURITY_TRUST_IMPORT_CERTIFICATE_WIZARD, ImageRegistry.getImageDescriptor("import_cert_wiz.gif"));
        this._provider = provider;
        this._systemName = systemName;
    }

    public void addPages() {
        try {
            this._mainPage = this.createMainPage();
            this.addPage((IWizardPage)this._mainPage);
            this._aliasPage = this.createAliasPage();
            this.addPage((IWizardPage)this._aliasPage);
        }
        catch (Exception exc) {
            SystemBasePlugin.logError((String)"New File: Error in createPages: ", (Throwable)exc);
        }
    }

    protected SystemImportCertWizardMainPage createMainPage() {
        SystemMessage errMsg = null;
        this._mainPage = new SystemImportCertWizardMainPage((Wizard)this, this.getCertificates());
        if (errMsg != null) {
            this._mainPage.setErrorMessage(errMsg);
        }
        return this._mainPage;
    }

    protected SystemImportCertWizardAliasPage createAliasPage() {
        SystemMessage errMsg = null;
        this._aliasPage = new SystemImportCertWizardAliasPage((Wizard)this, this.getCertificates(), this._systemName);
        if (errMsg != null) {
            this._aliasPage.setErrorMessage(errMsg);
        }
        return this._aliasPage;
    }

    public boolean performFinish() {
        boolean ok = false;
        if (this._aliasPage.performFinish()) {
            List certs = this.getCertificates();
            int i = 0;
            while (i < certs.size()) {
                X509Certificate cert = (X509Certificate)certs.get(i);
                if (cert != null) {
                    String alias = this._aliasPage.getAlias();
                    try {
                        KeyStore ks = DStoreKeyStore.getKeyStore((String)this._provider.getKeyStorePath(), (String)this._provider.getKeyStorePassword());
                        DStoreKeyStore.addCertificateToKeyStore((KeyStore)ks, (Certificate)cert, (String)alias);
                        DStoreKeyStore.persistKeyStore((KeyStore)ks, (String)this._provider.getKeyStorePath(), (String)this._provider.getKeyStorePassword());
                        ok = true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ok = false;
                    }
                }
                ++i;
            }
        }
        return ok;
    }

    public List getCertificates() {
        return (List)this.getInputObject();
    }
}

