/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.local.shells;

import java.io.BufferedReader;
import java.io.IOException;
import org.eclipse.rse.services.shells.AbstractHostShellOutputReader;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IHostShellOutputReader;

public class LocalShellOutputReader
extends AbstractHostShellOutputReader
implements IHostShellOutputReader {
    protected BufferedReader _reader;

    public LocalShellOutputReader(IHostShell hostShell, BufferedReader reader, boolean isErrorReader) {
        super(hostShell, isErrorReader);
        this._reader = reader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object internalReadLine() {
        StringBuffer theLine = new StringBuffer();
        int lastch = 0;
        boolean done = false;
        while (!done && !this.isFinished()) {
            try {
                int ch = this._reader.read();
                switch (ch) {
                    case -1: {
                        if (theLine.length() == 0) {
                            return null;
                        }
                        done = true;
                        break;
                    }
                    case 65535: {
                        if (theLine.length() == 0) {
                            return null;
                        }
                        done = true;
                        break;
                    }
                    case 10: {
                        done = true;
                        break;
                    }
                    case 9: {
                        theLine.append("     ");
                        break;
                    }
                    case 13: {
                        break;
                    }
                    default: {
                        char tch = (char)ch;
                        if (!Character.isISOControl(tch)) {
                            theLine.append(tch);
                            break;
                        }
                        this._reader.read();
                    }
                }
                boolean ready = this._reader.ready();
                if (ch == 10 && lastch == 13) {
                    return theLine.toString();
                }
                lastch = ch;
                if (ready) continue;
                try {
                    Thread.sleep(this._waitIncrement);
                }
                catch (InterruptedException interruptedException) {}
                if (this._reader.ready()) continue;
                if (done) {
                    return theLine.toString().trim();
                }
                done = true;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return theLine.toString();
    }
}

