/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.local.processes;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.SortedSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.clientserver.processes.IHostProcess;
import org.eclipse.rse.services.clientserver.processes.IHostProcessFilter;
import org.eclipse.rse.services.clientserver.processes.handlers.ProcessHandler;
import org.eclipse.rse.services.clientserver.processes.handlers.ProcessHandlerManager;
import org.eclipse.rse.services.local.ILocalService;
import org.eclipse.rse.services.local.files.LocalServiceResources;
import org.eclipse.rse.services.processes.AbstractProcessService;
import org.eclipse.rse.services.processes.IProcessService;

public class LocalProcessService
extends AbstractProcessService
implements ILocalService,
IProcessService {
    protected String[] _statusTypes;
    protected ProcessHandler handler = ProcessHandlerManager.getInstance().getNewProcessHandler();

    public String getName() {
        return LocalServiceResources.Local_Process_Service_Name;
    }

    public String getDescription() {
        return LocalServiceResources.Local_Process_Service_Description;
    }

    public IHostProcess[] listAllProcesses(IProgressMonitor monitor, IHostProcessFilter filter) throws SystemMessageException {
        IHostProcess[] processes = null;
        if (this.handler == null) {
            return null;
        }
        try {
            SortedSet results = this.handler.lookupProcesses(filter);
            processes = results.toArray(new IHostProcess[results.size()]);
        }
        catch (Exception exception) {
            throw new SystemMessageException(this.getMessage("RSEPG1301"));
        }
        return processes;
    }

    public boolean kill(IProgressMonitor monitor, long PID, String signal) throws SystemMessageException {
        IHostProcess process = null;
        try {
            process = this.getProcess(monitor, PID);
            this.handler.kill(process, signal);
            return true;
        }
        catch (InterruptedException interruptedException) {
            throw new SystemMessageException(this.getMessage("RSEG1067"));
        }
        catch (Exception e) {
            String name = "";
            if (process != null) {
                name = String.valueOf(name) + process.getName();
            }
            String pid = "";
            if (process != null) {
                pid = String.valueOf(pid) + process.getPid();
            }
            SystemMessage msg = this.getMessage("RSEPG1300");
            msg.makeSubstitution((Object)(String.valueOf(name) + " (" + pid + ")"), (Object)e.getMessage());
            throw new SystemMessageException(msg);
        }
    }

    public String[] getSignalTypes() {
        if (this._statusTypes != null) {
            return this._statusTypes;
        }
        this._statusTypes = this.internalGetSignalTypes();
        return this._statusTypes;
    }

    protected String[] internalGetSignalTypes() {
        BufferedReader reader;
        InputStreamReader isr;
        block8: {
            block7: {
                Process kill = Runtime.getRuntime().exec("kill -l");
                isr = new InputStreamReader(kill.getInputStream());
                if (isr != null) break block7;
                return null;
            }
            reader = new BufferedReader(isr);
            if (reader != null) break block8;
            return null;
        }
        try {
            String nextLine = reader.readLine();
            String output = "";
            while (nextLine != null) {
                output = String.valueOf(output) + nextLine + "\n";
                nextLine = reader.readLine();
            }
            reader.close();
            isr.close();
            if (output.equals("")) {
                throw new Exception();
            }
            String[] lines = output.trim().split("\\s+");
            if (lines == null) {
                throw new Exception();
            }
            return lines;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void initService(IProgressMonitor monitor) {
    }

    public void uninitService(IProgressMonitor monitor) {
    }
}

