/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.local.search;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.internal.services.local.search.LocalSearchResult;
import org.eclipse.rse.services.clientserver.StringCompare;
import org.eclipse.rse.services.clientserver.SystemFileClassifier;
import org.eclipse.rse.services.clientserver.SystemSearchString;
import org.eclipse.rse.services.clientserver.archiveutils.AbsoluteVirtualPath;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.archiveutils.VirtualChild;
import org.eclipse.rse.services.clientserver.search.SystemSearchFileNameMatcher;
import org.eclipse.rse.services.clientserver.search.SystemSearchLineMatch;
import org.eclipse.rse.services.clientserver.search.SystemSearchMatch;
import org.eclipse.rse.services.clientserver.search.SystemSearchStringMatchLocator;
import org.eclipse.rse.services.clientserver.search.SystemSearchStringMatcher;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.services.local.files.LocalHostFile;
import org.eclipse.rse.services.local.files.LocalVirtualHostFile;
import org.eclipse.rse.services.search.IHostSearchResult;
import org.eclipse.rse.services.search.IHostSearchResultConfiguration;
import org.eclipse.rse.services.search.ISearchHandler;

public class LocalSearchHandler
implements ISearchHandler {
    protected HashSet _alreadySearched;
    protected IHostSearchResultConfiguration _searchConfig;
    protected File _theFile;
    protected int _depth = -1;
    protected IFileService _fs;
    protected boolean _isDone;
    protected boolean _isCancelled;
    protected LocalHostFile _theRmtFile;
    protected SystemSearchString _searchString;
    protected SystemSearchStringMatcher _stringMatcher;
    protected boolean _isFileSearch;
    protected SystemSearchFileNameMatcher _fileNameMatcher;
    protected String _classificationString;

    public LocalSearchHandler(IHostSearchResultConfiguration searchConfig, IFileService fileService) {
        this._searchConfig = searchConfig;
        this._theRmtFile = (LocalHostFile)searchConfig.getSearchTarget();
        if (!(this._theRmtFile instanceof LocalVirtualHostFile)) {
            this._theFile = this._theRmtFile.getFile();
        } else {
            String absPath = this._theRmtFile.getAbsolutePath();
            AbsoluteVirtualPath avp = new AbsoluteVirtualPath(absPath);
            this._theFile = new File(avp.toString());
        }
        this._fs = fileService;
        this._searchString = searchConfig.getSearchString();
        boolean includeSubfolders = this._searchString.isIncludeSubfolders();
        this._depth = includeSubfolders ? -1 : 1;
        this._isCancelled = false;
        this._isDone = false;
        this._alreadySearched = new HashSet();
        this._stringMatcher = new SystemSearchStringMatcher(this._searchString.getTextString(), this._searchString.isCaseSensitive(), this._searchString.isTextStringRegex());
        this._isFileSearch = this._stringMatcher.isSearchStringEmpty() || this._stringMatcher.isSearchStringAsterisk();
        boolean fsCaseSensitive = this._fs.isCaseSensitive();
        this._fileNameMatcher = new SystemSearchFileNameMatcher(this._searchString.getFileNamesString(), fsCaseSensitive, this._searchString.isFileNamesRegex());
        this._classificationString = this._searchString.getClassificationString();
    }

    public void search(IProgressMonitor monitor) {
        this.internalSearch(this._theFile, this._depth, this._theRmtFile);
        this._isDone = true;
        if (!this._isCancelled) {
            this._searchConfig.setStatus(1);
        } else {
            this._searchConfig.setStatus(2);
        }
    }

    public boolean isDone() {
        return this._isDone;
    }

    public void cancel(IProgressMonitor monitor) {
        this._isCancelled = true;
    }

    private boolean hasSearchedDirectory(File file) {
        return this._alreadySearched.contains(file);
    }

    private boolean internalSearch(File theFile, int depth, IHostFile context) {
        boolean foundFile = false;
        boolean isDirectory = theFile.isDirectory();
        boolean isArchive = ArchiveHandlerManager.getInstance().isArchive(theFile);
        String absPath = theFile.getAbsolutePath();
        String compareStr = theFile.getName();
        boolean isVirtual = ArchiveHandlerManager.isVirtual((String)absPath);
        boolean isVirtualDirectory = false;
        VirtualChild vc = null;
        if (isVirtual) {
            vc = ArchiveHandlerManager.getInstance().getVirtualObject(absPath);
            boolean bl = isVirtualDirectory = isVirtual && vc.isDirectory;
        }
        if (!isDirectory && !isArchive && !isVirtualDirectory && this.doesFilePatternMatch(compareStr) && this.doesClassificationMatch(absPath)) {
            LocalHostFile file;
            if (isVirtual) {
                file = new LocalVirtualHostFile(vc);
                SystemSearchLineMatch[] matches = null;
                if (!this._isFileSearch) {
                    matches = vc.getHandler().search(vc.fullName, this._stringMatcher);
                    IHostSearchResult[] results = this.convert(file, matches);
                    this._searchConfig.addResults((Object)file, results);
                } else {
                    this._searchConfig.addResult((Object)file);
                }
            } else {
                file = new LocalHostFile(theFile, false);
                if (this._isFileSearch || this.internalSearchWithinFile(file, theFile)) {
                    this._searchConfig.addResult((Object)file);
                } else {
                    this._searchConfig.addResult((Object)file);
                }
            }
            foundFile = true;
            if (foundFile) {
                foundFile = false;
            }
        }
        if (depth != 0 && (isDirectory || isArchive || isVirtualDirectory) && !this.hasSearchedDirectory(theFile)) {
            this._alreadySearched.add(theFile);
            File[] children = null;
            if (isArchive || isVirtualDirectory) {
                AbsoluteVirtualPath avp = new AbsoluteVirtualPath(absPath);
                File archive = new File(avp.getContainingArchiveString());
                String virtualPath = avp.getVirtualPart();
                VirtualChild[] virtualchildren = null;
                try {
                    virtualchildren = ArchiveHandlerManager.getInstance().getContents(archive, virtualPath);
                }
                catch (IOException iOException) {}
                if (virtualchildren != null) {
                    children = new File[virtualchildren.length];
                    int i = 0;
                    while (i < virtualchildren.length) {
                        AbsoluteVirtualPath newAvp = new AbsoluteVirtualPath(absPath);
                        newAvp.setVirtualPart(virtualchildren[i].fullName);
                        children[i] = new File(newAvp.toString());
                        ++i;
                    }
                    if (virtualchildren.length == 0) {
                        children = null;
                    }
                }
            } else {
                children = theFile.listFiles();
            }
            if (children != null) {
                LocalHostFile fileImpl = null;
                if (!isVirtualDirectory) {
                    boolean isRoot = false;
                    fileImpl = new LocalHostFile(theFile, isRoot);
                } else {
                    fileImpl = new LocalVirtualHostFile(vc);
                }
                int i = 0;
                while (i < children.length && !this._isCancelled) {
                    File child = children[i];
                    if (this.internalSearch(child, depth - 1, fileImpl)) {
                        foundFile = true;
                    }
                    ++i;
                }
            }
        }
        return foundFile;
    }

    private boolean internalSearchWithinFile(IHostFile remoteFile, File theFile) {
        SystemSearchLineMatch[] matches;
        block4: {
            if (this._isFileSearch) {
                return true;
            }
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(theFile);
                InputStreamReader reader = new InputStreamReader(inputStream);
                BufferedReader bufReader = new BufferedReader(reader);
                SystemSearchStringMatchLocator locator = new SystemSearchStringMatchLocator((Reader)bufReader, this._stringMatcher);
                matches = locator.locateMatches();
                if (matches != null && matches.length != 0) break block4;
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        IHostSearchResult[] results = this.convert(remoteFile, matches);
        this._searchConfig.addResults((Object)remoteFile, results);
        return true;
    }

    protected boolean doesFilePatternMatch(String compareStr) {
        return this._fileNameMatcher.matches(compareStr);
    }

    protected boolean doesClassificationMatch(String absolutePath) {
        if (this._classificationString == null || this._classificationString.equals("")) {
            return true;
        }
        String classification = SystemFileClassifier.getInstance().classifyFile(absolutePath);
        return StringCompare.compare((String)this._classificationString, (String)classification, (boolean)true);
    }

    private IHostSearchResult[] convert(IHostFile remoteFile, SystemSearchLineMatch[] lineMatches) {
        LocalSearchResult[] results = new LocalSearchResult[lineMatches.length];
        int i = 0;
        while (i < lineMatches.length) {
            results[i] = new LocalSearchResult(this._searchConfig, remoteFile, this._searchString);
            results[i].setText(lineMatches[i].getLine());
            results[i].setLine(lineMatches[i].getLineNumber());
            results[i].setIndex(i);
            Iterator iter = lineMatches[i].getMatches();
            while (iter.hasNext()) {
                SystemSearchMatch match = (SystemSearchMatch)iter.next();
                int startOffset = match.getStartOffset();
                int endOffset = match.getEndOffset();
                results[i].addMatch(startOffset, endOffset);
            }
            ++i;
        }
        return results;
    }
}

