/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core.internal;

import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.core.IRSESystemType;
import org.osgi.framework.Bundle;

public class RSESystemType
implements IRSESystemType {
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_VALUE = "value";
    String id = null;
    String name = null;
    String description = null;
    HashMap properties;
    Bundle definingBundle = null;

    public RSESystemType(IConfigurationElement element) {
        this.id = element.getAttribute(ATTR_ID);
        this.name = element.getAttribute(ATTR_NAME);
        this.description = element.getAttribute(ATTR_DESCRIPTION);
        this.loadProperties(element);
        this.definingBundle = Platform.getBundle((String)element.getContributor().getName());
    }

    private void loadProperties(IConfigurationElement element) {
        IConfigurationElement[] children = element.getChildren();
        this.properties = new HashMap(children.length);
        int i = 0;
        while (i < children.length) {
            IConfigurationElement child = children[i];
            String key = child.getAttribute(ATTR_NAME);
            String value = child.getAttribute(ATTR_VALUE);
            if (key != null && value != null) {
                this.properties.put(key, value);
            }
            ++i;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getProperty(String key) {
        return (String)this.properties.get(key);
    }

    public Bundle getDefiningBundle() {
        return this.definingBundle;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

