/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.files.ui.FileResources;
import org.eclipse.rse.files.ui.actions.SystemExtractAction;
import org.eclipse.rse.files.ui.actions.SystemExtractToAction;
import org.eclipse.rse.files.ui.resources.CombineDialog;
import org.eclipse.rse.model.ISystemRegistry;
import org.eclipse.rse.model.ISystemResourceChangeEvent;
import org.eclipse.rse.model.SystemResourceChangeEvent;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.swt.widgets.Shell;

public class SystemCombineAction
extends SystemExtractToAction {
    public SystemCombineAction(Shell parent) {
        super(parent, FileResources.ACTION_COMBINE_LABEL, FileResources.ACTION_COMBINE_TOOLTIP);
        this.setHelp("org.eclipse.rse.ui.actn0120");
        this.setImageDescriptor(RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.combine_tskIcon"));
    }

    public void run() {
        boolean repeat = true;
        while (repeat) {
            SystemMessageDialog dlg;
            SystemMessage msg;
            IRemoteFile firstSelection = (IRemoteFile)this._selected.get(0);
            String title = FileResources.RESID_COMBINE_TITLE;
            CombineDialog dialog = new CombineDialog(this.getShell(), title);
            if (dialog == null) {
                return;
            }
            dialog.setNeedsProgressMonitor(false);
            dialog.setMessage(FileResources.RESID_COMBINE_PROMPT);
            dialog.setShowNewConnectionPrompt(true);
            dialog.setShowPropertySheet(true, false);
            dialog.setSystemTypes(systemTypes);
            dialog.setPreSelection(firstSelection);
            dialog.setBlockOnOpen(true);
            dialog.open();
            boolean cancelled = false;
            if (dialog.wasCancelled()) {
                cancelled = true;
            }
            IRemoteFile destination = null;
            IRemoteFileSubSystem destSS = null;
            if (cancelled) {
                return;
            }
            destination = (IRemoteFile)dialog.getOutputObject();
            destSS = destination.getParentRemoteFileSubSystem();
            if (destination == null) {
                System.out.println("blah");
            }
            if (ArchiveHandlerManager.isVirtual((String)destination.getAbsolutePath())) {
                msg = RSEUIPlugin.getPluginMessage((String)"RSEG1121");
                dlg = new SystemMessageDialog(this.getShell(), msg);
                dlg.open();
                continue;
            }
            if (this.destinationInSource(destination)) {
                msg = RSEUIPlugin.getPluginMessage((String)"RSEG1129");
                dlg = new SystemMessageDialog(this.getShell(), msg);
                dlg.open();
                continue;
            }
            try {
                if (!destination.exists()) {
                    destSS.createFile(destination);
                }
            }
            catch (SystemMessageException e) {
                System.out.println(e.getMessage());
            }
            int i = 0;
            while (i < this._selected.size()) {
                IRemoteFile selection = (IRemoteFile)this._selected.get(i);
                selection.getParentRemoteFileSubSystem();
                IRunnableContext runnableContext = this.getRunnableContext(this._parent);
                String nextName = selection.getName();
                int j = nextName.lastIndexOf(".");
                if (j != -1) {
                    nextName = nextName.substring(0, j);
                }
                String nextDest = String.valueOf(destination.getAbsolutePath()) + "#virtual#/" + nextName;
                IRemoteFile nextDestination = null;
                try {
                    while (destSS.getRemoteFileObject(nextDest).exists()) {
                        nextDest = String.valueOf(nextDest) + "1";
                    }
                    nextDestination = destSS.getRemoteFileObject(nextDest);
                    destSS.createFolder(nextDestination);
                }
                catch (SystemMessageException e) {
                    SystemMessageDialog dlg2 = new SystemMessageDialog(this.getShell(), e.getSystemMessage());
                    dlg2.open();
                    return;
                }
                SystemExtractAction.ExtractRunnable runnable = new SystemExtractAction.ExtractRunnable(this, selection, nextDestination);
                try {
                    runnableContext.run(false, true, (IRunnableWithProgress)runnable);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {}
                ++i;
            }
            ISystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
            registry.fireRemoteResourceChangeEvent(1, (Object)destination, (Object)destination.getParentPath(), (ISubSystem)destSS, null, null);
            registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)destination, 82, (Object)destination.getParentPath()));
            repeat = false;
        }
    }
}

