/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.files.ui.FileResources;
import org.eclipse.rse.files.ui.actions.SystemExtractAction;
import org.eclipse.rse.files.ui.actions.SystemExtractToAction;
import org.eclipse.rse.files.ui.resources.CombineDialog;
import org.eclipse.rse.model.ISystemRegistry;
import org.eclipse.rse.model.ISystemResourceChangeEvent;
import org.eclipse.rse.model.SystemResourceChangeEvent;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.swt.widgets.Shell;

public class SystemConvertAction
extends SystemExtractToAction {
    public SystemConvertAction(Shell parent) {
        super(parent, FileResources.ACTION_CONVERT_LABEL, FileResources.ACTION_CONVERT_TOOLTIP);
        this.setHelp("org.eclipse.rse.ui.actn0121");
        this.setImageDescriptor(RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.convertarchive_tskIcon"));
    }

    public void run() {
        int i = 0;
        while (i < this._selected.size()) {
            block19: {
                SystemMessageDialog dlg;
                SystemMessage msg;
                IRemoteFile selection = (IRemoteFile)this._selected.get(i);
                String title = FileResources.RESID_CONVERT_TITLE;
                CombineDialog dialog = new CombineDialog(this.getShell(), title, true);
                if (dialog == null) {
                    return;
                }
                dialog.setNeedsProgressMonitor(false);
                String message = SystemMessage.sub((String)FileResources.RESID_CONVERT_PROMPT, (String)"&1", (String)selection.getAbsolutePath());
                dialog.setMessage(message);
                dialog.setShowNewConnectionPrompt(true);
                dialog.setShowPropertySheet(true, false);
                dialog.setSystemTypes(systemTypes);
                dialog.setPreSelection(selection);
                dialog.setBlockOnOpen(true);
                dialog.setHelp("org.eclipse.rse.ui.cnvd0000");
                dialog.setShowLocationPrompt(true);
                dialog.setLocationPrompt(FileResources.RESID_CONVERT_LOCATION);
                dialog.setNameAndTypePrompt(FileResources.RESID_CONVERT_NAMEANDTYPE);
                dialog.setSelectionValidator(this);
                dialog.open();
                boolean cancelled = false;
                if (dialog.wasCancelled()) {
                    cancelled = true;
                }
                IRemoteFile destination = null;
                IRemoteFileSubSystem destSS = null;
                if (cancelled) {
                    return;
                }
                destination = (IRemoteFile)dialog.getOutputObject();
                destSS = destination.getParentRemoteFileSubSystem();
                if (destination == null) {
                    System.out.println("blah");
                }
                if (ArchiveHandlerManager.isVirtual((String)destination.getAbsolutePath())) {
                    msg = RSEUIPlugin.getPluginMessage((String)"RSEG1127");
                    dlg = new SystemMessageDialog(this.getShell(), msg);
                    dlg.open();
                    --i;
                } else if (!destination.canWrite()) {
                    msg = RSEUIPlugin.getPluginMessage((String)"RSEF1313");
                    dlg = new SystemMessageDialog(this.getShell(), msg);
                    dlg.open();
                    --i;
                } else if (selection.isAncestorOf(destination)) {
                    msg = RSEUIPlugin.getPluginMessage((String)"RSEG1129");
                    dlg = new SystemMessageDialog(this.getShell(), msg);
                    dlg.open();
                    --i;
                } else {
                    try {
                        if (destination.exists()) {
                            msg = RSEUIPlugin.getPluginMessage((String)"RSEF5012");
                            msg.makeSubstitution((Object)destination.getName());
                            dlg = new SystemMessageDialog(this.getShell(), msg);
                            boolean ok = dlg.openQuestionNoException();
                            if (ok) {
                                if (destination.getAbsolutePath().equals(selection.getAbsolutePath())) break block19;
                                destSS.delete(destination, null);
                            } else {
                                --i;
                                break block19;
                            }
                        }
                        destSS.createFile(destination);
                    }
                    catch (SystemMessageException e) {
                        dlg = new SystemMessageDialog(this.getShell(), e.getSystemMessage());
                        dlg.open();
                        break block19;
                    }
                    selection.getParentRemoteFileSubSystem();
                    IRunnableContext runnableContext = this.getRunnableContext(this._parent);
                    SystemExtractAction.ExtractRunnable runnable = new SystemExtractAction.ExtractRunnable(this, selection, destination);
                    try {
                        runnableContext.run(false, true, (IRunnableWithProgress)runnable);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                    }
                    catch (InterruptedException interruptedException) {}
                    ISystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
                    registry.fireRemoteResourceChangeEvent(1, (Object)destination, (Object)destination.getParentPath(), (ISubSystem)destSS, null, null);
                    registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)destination, 82, (Object)destination.getParentPath()));
                }
            }
            ++i;
        }
    }
}

