/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.files.ui.FileResources;
import org.eclipse.rse.files.ui.resources.ISaveAsDialog;
import org.eclipse.rse.files.ui.resources.SaveAsDialog;
import org.eclipse.rse.files.ui.resources.SystemEditableRemoteFile;
import org.eclipse.rse.files.ui.resources.SystemIFileProperties;
import org.eclipse.rse.model.ISystemResourceChangeEvent;
import org.eclipse.rse.model.SystemResourceChangeEvent;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileIOException;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileSecurityException;
import org.eclipse.rse.ui.ISystemMessages;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.FileEditorInput;

public class SystemUploadConflictAction
extends SystemBaseAction
implements Runnable {
    private IFile _tempFile;
    private IRemoteFile _remoteFile;

    public SystemUploadConflictAction(Shell shell, IFile tempFile, IRemoteFile remoteFile, boolean remoteNewer) {
        super(FileResources.RESID_CONFLICT_SAVE_TITLE, shell);
        this._tempFile = tempFile;
        this._remoteFile = remoteFile;
    }

    public void run() {
        SystemIFileProperties properties = new SystemIFileProperties((IResource)this._tempFile);
        UploadConflictDialog cnfDialog = new UploadConflictDialog(SystemBasePlugin.getActiveWorkbenchShell());
        if (cnfDialog.open() == 0) {
            IRemoteFile remoteFile;
            IRemoteFileSubSystem fs = this._remoteFile.getParentRemoteFileSubSystem();
            if (cnfDialog.getOverwriteRemote()) {
                try {
                    fs.uploadUTF8(this._tempFile, this._remoteFile, null);
                    this._remoteFile.markStale(true);
                    this._remoteFile = fs.getRemoteFileObject(this._remoteFile.getAbsolutePath());
                    properties.setRemoteFileTimeStamp(this._remoteFile.getLastModified());
                    properties.setDirty(false);
                }
                catch (RemoteFileSecurityException remoteFileSecurityException) {
                }
                catch (RemoteFileIOException remoteFileIOException) {
                }
                catch (Exception exception) {}
            } else if (cnfDialog.getOverwriteLocal()) {
                try {
                    fs.downloadUTF8(this._remoteFile, this._tempFile, null);
                    properties.setRemoteFileTimeStamp(this._remoteFile.getLastModified());
                    properties.setDirty(false);
                    properties.setUsedBinaryTransfer(this._remoteFile.isBinary());
                }
                catch (RemoteFileSecurityException e) {
                    e.printStackTrace();
                }
                catch (RemoteFileIOException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (cnfDialog.getSaveas() && (remoteFile = cnfDialog.getSaveasLocation()) != null) {
                try {
                    fs = remoteFile.getParentRemoteFileSubSystem();
                    if (!remoteFile.exists()) {
                        fs.createFile(remoteFile);
                    }
                }
                catch (SystemMessageException e) {
                    SystemBasePlugin.logError((String)"Error in performSaveAs", (Throwable)e);
                    SystemMessage message = RSEUIPlugin.getPluginMessage((String)"RSEF8002");
                    SystemMessageDialog dialog = new SystemMessageDialog(SystemBasePlugin.getActiveWorkbenchShell(), message);
                    dialog.open();
                    return;
                }
                try {
                    fs.uploadUTF8(this._tempFile, remoteFile, null);
                    properties.setRemoteFileTimeStamp(0L);
                    properties.setDirty(false);
                }
                catch (SystemMessageException systemMessageException) {}
                ReopenAction reopen = new ReopenAction(this._tempFile, remoteFile);
                Display.getDefault().asyncExec((Runnable)reopen);
            }
        } else {
            properties.setDirty(true);
        }
    }

    private class UploadConflictDialog
    extends SystemPromptDialog
    implements ISystemMessages,
    SelectionListener {
        private Button _overwriteLocalButton;
        private Button _overwriteRemoteButton;
        private Button _saveasButton;
        private Button _browseButton;
        private Text _saveasFileEntry;
        private boolean _overwriteLocal;
        private boolean _overwriteRemote;
        private boolean _saveas;
        private SystemMessage _errorMessage;
        private IRemoteFile _saveasLocation;

        public UploadConflictDialog(Shell shell) {
            super(shell, FileResources.RESID_CONFLICT_SAVE_TITLE);
        }

        protected void buttonPressed(int buttonId) {
            this.setReturnCode(buttonId);
            this._overwriteLocal = this._overwriteLocalButton.getSelection();
            this._overwriteRemote = this._overwriteRemoteButton.getSelection();
            this._saveas = this._saveasButton.getSelection();
            this.close();
        }

        public boolean getOverwriteLocal() {
            return this._overwriteLocal;
        }

        public boolean getOverwriteRemote() {
            return this._overwriteRemote;
        }

        public boolean getSaveas() {
            return this._saveas;
        }

        public IRemoteFile getSaveasLocation() {
            return this._saveasLocation;
        }

        public Control createInner(Composite parent) {
            Image image = this.getShell().getDisplay().getSystemImage(4);
            Composite c = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            c.setLayout((Layout)layout);
            c.setLayoutData((Object)new GridData(1808));
            Composite m = new Composite(c, 0);
            GridLayout mlayout = new GridLayout();
            mlayout.numColumns = 2;
            m.setLayout((Layout)mlayout);
            m.setLayoutData((Object)new GridData(1808));
            Label label = new Label(m, 0);
            image.setBackground(label.getBackground());
            label.setImage(image);
            label.setLayoutData((Object)new GridData(66));
            Text text = new Text(m, 66);
            text.setEditable(false);
            text.setText(FileResources.RESID_CONFLICT_SAVE_MESSAGE);
            GridData textData = new GridData(1808);
            textData.widthHint = 100;
            textData.horizontalSpan = 2;
            textData.verticalSpan = 5;
            Composite options = new Composite(c, 0);
            GridLayout olayout = new GridLayout();
            olayout.numColumns = 1;
            options.setLayout((Layout)olayout);
            options.setLayoutData((Object)new GridData(1808));
            this._overwriteLocalButton = new Button(options, 16);
            this._overwriteLocalButton.setText(FileResources.RESID_CONFLICT_SAVE_REPLACELOCAL);
            this._overwriteLocalButton.addSelectionListener((SelectionListener)this);
            this._overwriteLocalButton.setSelection(true);
            this._overwriteRemoteButton = new Button(options, 16);
            this._overwriteRemoteButton.setText(FileResources.RESID_CONFLICT_SAVE_OVERWRITEREMOTE);
            this._overwriteRemoteButton.addSelectionListener((SelectionListener)this);
            this._saveasButton = new Button(options, 16);
            this._saveasButton.setText(FileResources.RESID_CONFLICT_SAVE_SAVETODIFFERENT);
            this._saveasButton.addSelectionListener((SelectionListener)this);
            Composite s = new Composite(options, 0);
            GridLayout slayout = new GridLayout();
            slayout.numColumns = 2;
            s.setLayout((Layout)slayout);
            s.setLayoutData((Object)new GridData(1808));
            this._saveasFileEntry = new Text(s, 2048);
            this._saveasFileEntry.setEnabled(false);
            GridData fileEntryData = new GridData(1808);
            fileEntryData.widthHint = 100;
            this._saveasFileEntry.setLayoutData((Object)fileEntryData);
            this._saveasFileEntry.setEditable(false);
            this._browseButton = new Button(s, 8);
            this._browseButton.setText(SystemResources.BUTTON_BROWSE);
            this._browseButton.addSelectionListener((SelectionListener)this);
            this._browseButton.setEnabled(false);
            this.setHelp();
            return c;
        }

        public void widgetSelected(SelectionEvent e) {
            if (this._saveasButton.getSelection()) {
                this._browseButton.setEnabled(true);
                this._saveasFileEntry.setEnabled(true);
                if (this._saveasLocation != null) {
                    this._errorMessage = null;
                    this.setErrorMessage(this._errorMessage);
                    this.enableOkButton(true);
                } else {
                    this.enableOkButton(false);
                    this._errorMessage = RSEUIPlugin.getPluginMessage((String)"RSEG1032");
                    this.setErrorMessage(this._errorMessage);
                }
            } else {
                this._browseButton.setEnabled(false);
                this._saveasFileEntry.setEnabled(false);
                this.enableOkButton(true);
                this._errorMessage = null;
                this.setErrorMessage(this._errorMessage);
            }
            if (e.getSource() == this._browseButton) {
                ISaveAsDialog dlg = SaveAsDialog.getSaveAsDialog(this.getShell());
                dlg.setMultipleSelectionMode(false);
                if (SystemUploadConflictAction.this._remoteFile != null) {
                    Object output;
                    dlg.setPreSelection(SystemUploadConflictAction.this._remoteFile);
                    if (dlg.open() == 0 && (output = dlg.getOutputObject()) instanceof IRemoteFile) {
                        IRemoteFile toCreate = (IRemoteFile)output;
                        try {
                            this._errorMessage = null;
                            this._saveasLocation = toCreate;
                            this._saveasFileEntry.setText(toCreate.getAbsolutePath());
                            this.enableOkButton(this._errorMessage == null);
                            this.setErrorMessage(this._errorMessage);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        protected Control getInitialFocusControl() {
            this.enableOkButton(true);
            return this._overwriteLocalButton;
        }

        private void setHelp() {
            this.setHelp("org.eclipse.rse.ui.scdl0000");
        }
    }

    public class CloseEditorAction
    implements Runnable {
        public IEditorPart _editor;

        public CloseEditorAction(IEditorPart editor) {
            this._editor = editor;
        }

        public void run() {
            SystemBasePlugin.getActiveWorkbenchWindow().getActivePage().closeEditor(this._editor, false);
        }
    }

    public class ReopenAction
    implements Runnable {
        private IFile _tempFile;
        private IRemoteFile _saveasFile;

        public ReopenAction(IFile tempFile, IRemoteFile saveasFile) {
            this._tempFile = tempFile;
            this._saveasFile = saveasFile;
        }

        private IEditorPart getEditorFor(IFile tempFile) {
            FileEditorInput finput;
            IEditorPart editor;
            IEditorInput input;
            IWorkbenchPage page;
            IWorkbenchWindow window = SystemBasePlugin.getActiveWorkbenchWindow();
            if (window != null && (page = window.getActivePage()) != null && (input = (editor = page.getActiveEditor()).getEditorInput()) instanceof FileEditorInput && (finput = (FileEditorInput)input).getFile().getFullPath().equals((Object)tempFile.getFullPath())) {
                return editor;
            }
            return null;
        }

        public void run() {
            try {
                this._saveasFile = this._saveasFile.getParentRemoteFileSubSystem().getRemoteFileObject(this._saveasFile.getAbsolutePath());
                RSEUIPlugin.getTheSystemRegistry().fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)this._saveasFile.getParentRemoteFile(), 82, null));
            }
            catch (SystemMessageException e) {
                e.printStackTrace();
            }
            IEditorPart editor = this.getEditorFor(this._tempFile);
            if (editor != null) {
                String id = editor.getEditorSite().getId();
                SystemEditableRemoteFile edit = new SystemEditableRemoteFile(this._saveasFile, id);
                try {
                    edit.download(SystemUploadConflictAction.this.getShell());
                    edit.addAsListener();
                    edit.setLocalResourceProperties();
                    edit.openEditor();
                    CloseEditorAction closeAction = new CloseEditorAction(editor);
                    Display.getDefault().asyncExec((Runnable)closeAction);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

