/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.view;

import java.io.File;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.RemoteChildrenContentsType;
import org.eclipse.rse.core.subsystems.SubSystem;
import org.eclipse.rse.files.ui.FileResources;
import org.eclipse.rse.files.ui.actions.SystemAddToArchiveAction;
import org.eclipse.rse.files.ui.actions.SystemCompareFilesAction;
import org.eclipse.rse.files.ui.actions.SystemCompareWithEditionAction;
import org.eclipse.rse.files.ui.actions.SystemConvertAction;
import org.eclipse.rse.files.ui.actions.SystemEditFilesAction;
import org.eclipse.rse.files.ui.actions.SystemExtractAction;
import org.eclipse.rse.files.ui.actions.SystemExtractToAction;
import org.eclipse.rse.files.ui.actions.SystemMoveRemoteFileAction;
import org.eclipse.rse.files.ui.actions.SystemNewFileAction;
import org.eclipse.rse.files.ui.actions.SystemNewFileFilterFromFolderAction;
import org.eclipse.rse.files.ui.actions.SystemNewFolderAction;
import org.eclipse.rse.files.ui.actions.SystemRemoteFileOpenWithMenu;
import org.eclipse.rse.files.ui.actions.SystemReplaceWithEditionAction;
import org.eclipse.rse.files.ui.actions.SystemSearchAction;
import org.eclipse.rse.files.ui.resources.SystemEditableRemoteFile;
import org.eclipse.rse.files.ui.resources.SystemIFileProperties;
import org.eclipse.rse.files.ui.resources.SystemRemoteEditManager;
import org.eclipse.rse.files.ui.resources.UniversalFileTransferUtility;
import org.eclipse.rse.filters.ISystemFilterReference;
import org.eclipse.rse.filters.SystemFilterReference;
import org.eclipse.rse.model.IHost;
import org.eclipse.rse.model.ISystemContentsType;
import org.eclipse.rse.model.ISystemRegistry;
import org.eclipse.rse.model.ISystemResourceChangeEvent;
import org.eclipse.rse.model.ISystemResourceSet;
import org.eclipse.rse.model.SystemMessageObject;
import org.eclipse.rse.model.SystemRemoteResourceSet;
import org.eclipse.rse.model.SystemResourceChangeEvent;
import org.eclipse.rse.model.SystemWorkspaceResourceSet;
import org.eclipse.rse.services.clientserver.StringCompare;
import org.eclipse.rse.services.clientserver.SystemSearchString;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.search.HostSearchResultSet;
import org.eclipse.rse.services.search.IHostSearchResultConfiguration;
import org.eclipse.rse.services.search.IHostSearchResultSet;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileFilterString;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystemConfiguration;
import org.eclipse.rse.subsystems.files.core.subsystems.IVirtualRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileEmpty;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileIOException;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileRoot;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteFileSecurityException;
import org.eclipse.rse.subsystems.files.core.subsystems.RemoteSearchResultsContentsType;
import org.eclipse.rse.ui.ISystemMessages;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemMenuManager;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.actions.SystemCopyToClipboardAction;
import org.eclipse.rse.ui.actions.SystemPasteFromClipboardAction;
import org.eclipse.rse.ui.actions.SystemShowInMonitorAction;
import org.eclipse.rse.ui.actions.SystemShowInTableAction;
import org.eclipse.rse.ui.dialogs.SystemRenameSingleDialog;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.operations.SystemFetchOperation;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.view.AbstractSystemViewAdapter;
import org.eclipse.rse.ui.view.ISystemDragDropAdapter;
import org.eclipse.rse.ui.view.ISystemEditableRemoteObject;
import org.eclipse.rse.ui.view.ISystemPropertyConstants;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.ISystemViewDropDestination;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.rse.ui.view.SystemViewResources;
import org.eclipse.rse.ui.view.search.SystemSearchTableView;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class SystemViewRemoteFileAdapter
extends AbstractSystemViewAdapter
implements ISystemViewElementAdapter,
ISystemRemoteElementAdapter,
ISystemMessages,
ISystemPropertyConstants {
    private String xlatedSize = SystemViewResources.RESID_PROPERTY_FILE_SIZE_VALUE;
    private String xlatedCompressedSize = SystemViewResources.RESID_PROPERTY_VIRTUALFILE_COMPRESSEDSIZE_VALUE;
    private String xlatedExpandedSize = SystemViewResources.RESID_PROPERTY_ARCHIVE_EXPANDEDSIZE_VALUE;
    private static final Object[] EMPTY_LIST = new Object[0];
    private boolean filesOnly;
    private boolean foldersOnly;
    private SystemNewFileAction addNewFile;
    private SystemNewFolderAction addNewFolder;
    private SystemNewFileFilterFromFolderAction addNewFilter;
    private SystemMoveRemoteFileAction moveAction;
    private SystemCopyToClipboardAction copyClipboardAction;
    private SystemPasteFromClipboardAction pasteClipboardAction;
    private SystemCompareFilesAction compareFilesAction;
    private SystemCompareWithEditionAction compareEditionAction;
    private SystemReplaceWithEditionAction replaceEditionAction;
    private SystemSearchAction searchAction;
    private SystemShowInTableAction showInTableAction;
    private SystemShowInMonitorAction showInMonitorAction;
    private SystemExtractAction extractAction;
    private SystemExtractToAction extractToAction;
    private SystemConvertAction convertAction;
    private SystemAddToArchiveAction addToArchiveAction;
    private IEditorRegistry registry;
    private SystemRemoteFileOpenWithMenu openWithMenu;
    private boolean debug = false;
    private static PropertyDescriptor[] propertyDescriptorArray = null;
    private static PropertyDescriptor[] briefPropertyDescriptorArray = null;
    private static PropertyDescriptor[] uniquePropertyDescriptorArray = null;
    private static PropertyDescriptor[] uniqueArchiveDescriptorArray = null;
    private static PropertyDescriptor[] uniqueVirtualDescriptorArray = null;
    private static PropertyDescriptor[] archiveDescriptorArray = null;
    private static PropertyDescriptor[] virtualDescriptorArray = null;
    static final SystemMessage _uploadMessage = RSEUIPlugin.getPluginMessage((String)"RSEG1296");
    static final SystemMessage _downloadMessage = RSEUIPlugin.getPluginMessage((String)"RSEG1295");
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public SystemViewRemoteFileAdapter() {
    }

    private IEditorRegistry getEditorRegistry() {
        IWorkbench workbench;
        if (this.registry == null && (workbench = PlatformUI.getWorkbench()) != null) {
            this.registry = workbench.getEditorRegistry();
        }
        return this.registry;
    }

    public SystemViewRemoteFileAdapter(boolean foldersOnly, boolean filesOnly) {
        this();
        this.foldersOnly = foldersOnly;
        this.filesOnly = filesOnly;
    }

    public void setFilterString(String filterString) {
        if (this.filesOnly && filterString != null && filterString.indexOf("/ns") == -1) {
            filterString = String.valueOf(filterString) + " /ns";
        } else if (this.foldersOnly && filterString != null && filterString.indexOf("/nf") == -1) {
            filterString = String.valueOf(filterString) + " /nf";
        }
        this.filterString = filterString;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public void addActions(SystemMenuManager menu, IStructuredSelection selection, Shell shell, String menuGroup) {
        boolean elementType = false;
        boolean isArchive = false;
        boolean allHaveContents = false;
        boolean canEdit = true;
        boolean supportsSearch = true;
        boolean supportsArchiveManagement = false;
        boolean isVirtual = false;
        Object firstSelection = selection.getFirstElement();
        IRemoteFile firstFile = null;
        if (firstSelection == null || !(firstSelection instanceof IRemoteFile)) {
            return;
        }
        firstFile = (IRemoteFile)firstSelection;
        elementType = firstFile.isDirectory() || firstFile.isRoot();
        isArchive = firstFile.isArchive();
        isVirtual = firstFile instanceof IVirtualRemoteFile;
        canEdit = firstFile.canRead();
        supportsSearch = firstFile.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemFactory().supportsSearch();
        supportsArchiveManagement = firstFile.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemFactory().supportsArchiveManagement();
        allHaveContents = isArchive;
        if (isArchive) {
            Iterator elements = selection.iterator();
            Object element = null;
            while (elements.hasNext()) {
                element = elements.next();
                IRemoteFile remoteObj = element;
                if (remoteObj.isArchive()) continue;
                allHaveContents = false;
                break;
            }
        }
        if (elementType || isArchive && supportsArchiveManagement) {
            if (!this.foldersOnly && canEdit) {
                if (this.addNewFile == null) {
                    this.addNewFile = new SystemNewFileAction(shell);
                }
                menu.add("group.new", (IAction)this.addNewFile);
            }
            if (!this.filesOnly) {
                if (canEdit) {
                    if (this.addNewFolder == null) {
                        this.addNewFolder = new SystemNewFolderAction(shell);
                    }
                    menu.add("group.new", (IAction)this.addNewFolder);
                }
                if (this.addNewFilter == null) {
                    this.addNewFilter = new SystemNewFileFilterFromFolderAction(shell);
                }
                menu.appendToGroup("group.new", (IContributionItem)new Separator());
                menu.add("group.new", (IAction)this.addNewFilter);
            }
        } else if (canEdit) {
            String label = SystemResources.ACTION_CASCADING_OPEN_LABEL;
            String tooltip = SystemResources.ACTION_CASCADING_OPEN_TOOLTIP;
            SystemEditFilesAction action = new SystemEditFilesAction(label, tooltip, shell);
            menu.add("group.open", (IAction)action);
            MenuManager submenu = new MenuManager(FileResources.ResourceNavigator_openWith, "group.openwith");
            if (this.openWithMenu == null) {
                this.openWithMenu = new SystemRemoteFileOpenWithMenu();
            }
            this.openWithMenu.updateSelection(selection);
            submenu.add((IContributionItem)this.openWithMenu);
            menu.getMenuManager().appendToGroup("group.openwith", (IContributionItem)submenu);
        }
        if (this.extractAction == null) {
            this.extractAction = new SystemExtractAction(shell);
        }
        if (this.extractToAction == null) {
            this.extractToAction = new SystemExtractToAction(shell);
        }
        if (this.convertAction == null) {
            this.convertAction = new SystemConvertAction(shell);
        }
        if (this.addToArchiveAction == null) {
            this.addToArchiveAction = new SystemAddToArchiveAction(shell);
        }
        if (!allHaveContents || canEdit) {
            // empty if block
        }
        if (this.moveAction == null) {
            this.moveAction = new SystemMoveRemoteFileAction(shell);
        }
        firstFile.getParentRemoteFileSubSystem();
        ISystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
        Clipboard clipboard = registry.getSystemClipboard();
        if (this.pasteClipboardAction == null) {
            this.pasteClipboardAction = new SystemPasteFromClipboardAction(shell, clipboard);
        }
        if (this.copyClipboardAction == null) {
            this.copyClipboardAction = new SystemCopyToClipboardAction(shell, clipboard);
        }
        if (this.searchAction == null) {
            this.searchAction = new SystemSearchAction(shell);
        }
        if (this.compareFilesAction == null) {
            this.compareFilesAction = new SystemCompareFilesAction(shell);
        }
        if (this.compareEditionAction == null) {
            this.compareEditionAction = new SystemCompareWithEditionAction(shell);
        }
        if (this.replaceEditionAction == null) {
            this.replaceEditionAction = new SystemReplaceWithEditionAction(shell);
        }
        if (this.showInTableAction == null) {
            this.showInTableAction = new SystemShowInTableAction(shell);
        }
        if (this.showInMonitorAction == null) {
            this.showInMonitorAction = new SystemShowInMonitorAction(shell);
        }
        if (canEdit && supportsSearch) {
            menu.add("group.search", (IAction)this.searchAction);
        }
        if (!firstFile.isRoot() && canEdit) {
            menu.add(menuGroup, (IAction)this.copyClipboardAction);
            if (!elementType) {
                menu.add("group.comparewith", (IAction)this.compareFilesAction);
                menu.add("group.comparewith", (IAction)this.compareEditionAction);
                menu.add("group.replacewith", (IAction)this.replaceEditionAction);
            }
        }
        if (elementType || isArchive && supportsArchiveManagement) {
            if (canEdit) {
                menu.add(menuGroup, (IAction)this.pasteClipboardAction);
            }
            menu.add("group.open", (IAction)this.showInTableAction);
            menu.add("group.open", (IAction)this.showInMonitorAction);
        }
        if (!firstFile.isRoot() && canEdit) {
            menu.add(menuGroup, (IAction)this.moveAction);
        }
    }

    public ImageDescriptor getImageDescriptor(Object element) {
        IRemoteFile file = (IRemoteFile)element;
        if (file.isFile() || file.isArchive()) {
            return this.getEditorRegistry().getImageDescriptor(file.getName());
        }
        boolean isOpen = false;
        if (this.getViewer() instanceof AbstractTreeViewer) {
            AbstractTreeViewer atv = (AbstractTreeViewer)this.getViewer();
            isOpen = atv.getExpandedState(element);
        }
        if (file.isRoot()) {
            return RSEUIPlugin.getDefault().getImageDescriptor(isOpen ? "org.eclipse.rse.ui.systemrootdriveopenIcon" : "org.eclipse.rse.ui.systemrootdriveIcon");
        }
        if (isOpen) {
            return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER");
        }
        return RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.systemfolderIcon");
    }

    public String getText(Object element) {
        return this.getName(element);
    }

    public String getAlternateText(Object element) {
        return ((IRemoteFile)element).getLabel();
    }

    public String getName(Object element) {
        return ((IRemoteFile)element).getName();
    }

    public String getType(Object element) {
        IRemoteFile file = (IRemoteFile)element;
        if (file.isRoot()) {
            return SystemViewResources.RESID_PROPERTY_FILE_TYPE_ROOT_VALUE;
        }
        if (file.isDirectory()) {
            return SystemViewResources.RESID_PROPERTY_FILE_TYPE_FOLDER_VALUE;
        }
        return SystemViewResources.RESID_PROPERTY_FILE_TYPE_FILE_VALUE;
    }

    public String getStatusLineText(Object element) {
        return String.valueOf(this.getType(element)) + ": " + this.getAbsoluteName(element);
    }

    public Object getParent(Object element) {
        IRemoteFile file = (IRemoteFile)element;
        IRemoteFile parent = file.getParentRemoteFile();
        if (parent != null && parent.getAbsolutePath().equals(file.getAbsolutePath())) {
            parent = null;
        }
        return parent;
    }

    public Object[] getChildren(IProgressMonitor monitor, Object element) {
        return this.internalGetChildren(monitor, element);
    }

    public Object[] getChildren(Object element) {
        this._lastResults = this.internalGetChildren(null, element);
        return this._lastResults;
    }

    private synchronized Object[] internalGetChildren(IProgressMonitor monitor, Object element) {
        boolean hasChildren;
        IRemoteFile file = (IRemoteFile)element;
        if (file instanceof RemoteFileEmpty) {
            return EMPTY_LIST;
        }
        if (file instanceof RemoteFileRoot) {
            return ((RemoteFileRoot)file).getRootFiles();
        }
        IRemoteFileSubSystem ss = file.getParentRemoteFileSubSystem();
        RemoteFileFilterString orgRffs = file.getFilterString();
        String filter = null;
        if (orgRffs != null) {
            RemoteFileFilterString rffs;
            if (this.foldersOnly) {
                rffs = (RemoteFileFilterString)orgRffs.clone();
                rffs.setPath(null);
                rffs.setShowFiles(false);
                rffs.setShowSubDirs(true);
                filter = rffs.toString();
            } else if (this.filesOnly) {
                rffs = (RemoteFileFilterString)orgRffs.clone();
                rffs.setPath(null);
                rffs.setShowSubDirs(false);
                rffs.setShowFiles(true);
                filter = rffs.toString();
            } else {
                filter = null;
            }
        } else {
            filter = this.foldersOnly ? (this.filterString == null ? "* /nf" : this.filterString) : (this.filesOnly ? (this.filterString == null ? "* /ns" : this.filterString) : (this.filterString == null ? "*" : this.filterString));
        }
        Object[] children = null;
        Viewer v = this.getViewer();
        if (v != null && v instanceof SystemSearchTableView) {
            SystemSearchTableView view = (SystemSearchTableView)v;
            Iterator iter = view.getResultSet().getSearchConfigurations();
            boolean hasSearchResults = false;
            while (iter.hasNext() && !hasSearchResults) {
                IHostSearchResultConfiguration config = (IHostSearchResultConfiguration)iter.next();
                String searchString = config.getSearchString().getTextString();
                hasSearchResults = file.hasContents((ISystemContentsType)RemoteSearchResultsContentsType.getInstance(), searchString);
                if (!hasSearchResults) continue;
                children = file.getContents((ISystemContentsType)RemoteSearchResultsContentsType.getInstance(), searchString);
                return children;
            }
        }
        if ((hasChildren = file.hasContents((ISystemContentsType)RemoteChildrenContentsType.getInstance(), filter)) && !file.isStale()) {
            children = file.getContents((ISystemContentsType)RemoteChildrenContentsType.getInstance(), filter);
        } else {
            try {
                children = monitor != null ? ss.resolveFilterString(monitor, (Object)file, filter) : ss.resolveFilterString((Object)file, filter, this.getShell());
                if (children == null || children.length == 0) {
                    children = EMPTY_LIST;
                }
            }
            catch (InterruptedException interruptedException) {
                children = new SystemMessageObject[]{new SystemMessageObject(RSEUIPlugin.getPluginMessage((String)"RSEG1067"), 1, element)};
            }
            catch (Exception exc) {
                children = new SystemMessageObject[]{new SystemMessageObject(RSEUIPlugin.getPluginMessage((String)"RSEG1098"), 0, element)};
                SystemBasePlugin.logError((String)"Exception resolving file filter strings", (Throwable)exc);
            }
        }
        return children;
    }

    public boolean hasChildren(Object element) {
        IRemoteFile file = (IRemoteFile)element;
        boolean supportsArchiveManagement = file.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemFactory().supportsArchiveManagement();
        boolean hasChildren = false;
        if (file instanceof IVirtualRemoteFile) {
            hasChildren = ((IVirtualRemoteFile)file).isVirtualFolder();
        } else {
            boolean bl = hasChildren = !file.isFile() || file.isArchive() && supportsArchiveManagement;
        }
        if (!hasChildren) {
            Viewer v = this.getViewer();
            if (v != null && v instanceof SystemSearchTableView) {
                SystemSearchTableView view = (SystemSearchTableView)v;
                Iterator iter = view.getResultSet().getSearchConfigurations();
                while (iter.hasNext() && !hasChildren) {
                    IHostSearchResultConfiguration config = (IHostSearchResultConfiguration)iter.next();
                    String searchString = config.getSearchString().getTextString();
                    hasChildren = file.hasContents((ISystemContentsType)RemoteSearchResultsContentsType.getInstance(), searchString);
                }
            } else {
                hasChildren = file.hasContents((ISystemContentsType)RemoteChildrenContentsType.getInstance());
            }
        }
        return hasChildren;
    }

    public IPropertyDescriptor[] getUniquePropertyDescriptors() {
        IRemoteFile file = null;
        if (this.propertySourceInput instanceof IRemoteFile) {
            boolean isRegular;
            file = (IRemoteFile)this.propertySourceInput;
            boolean supportsArchiveManagement = file.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemFactory().supportsArchiveManagement();
            boolean isArchive = file != null && file.isArchive() && supportsArchiveManagement;
            boolean isVirtual = file != null && file instanceof IVirtualRemoteFile && supportsArchiveManagement;
            boolean bl = isRegular = !isArchive && !isVirtual;
            if (isRegular && uniquePropertyDescriptorArray == null || isArchive && uniqueArchiveDescriptorArray == null || isVirtual && uniqueVirtualDescriptorArray == null) {
                int nbrOfArchiveProperties = 2;
                int nbrOfVirtualProperties = 4;
                int nbrOfProperties = 4;
                if (isVirtual) {
                    nbrOfProperties += nbrOfVirtualProperties;
                } else if (isArchive) {
                    nbrOfProperties += nbrOfArchiveProperties;
                }
                if (isRegular) {
                    uniquePropertyDescriptorArray = new PropertyDescriptor[nbrOfProperties];
                } else if (isVirtual) {
                    uniqueVirtualDescriptorArray = new PropertyDescriptor[nbrOfProperties];
                } else if (isArchive) {
                    uniqueArchiveDescriptorArray = new PropertyDescriptor[nbrOfProperties];
                }
                int i = -1;
                RSEUIPlugin.getDefault();
                if (isRegular) {
                    SystemViewRemoteFileAdapter.uniquePropertyDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.classification", (String)SystemViewResources.RESID_PROPERTY_FILE_CLASSIFICATION_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_CLASSIFICATION_TOOLTIP);
                } else if (isVirtual) {
                    SystemViewRemoteFileAdapter.uniqueVirtualDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.classification", (String)SystemViewResources.RESID_PROPERTY_FILE_CLASSIFICATION_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_CLASSIFICATION_TOOLTIP);
                } else if (isArchive) {
                    SystemViewRemoteFileAdapter.uniqueArchiveDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.classification", (String)SystemViewResources.RESID_PROPERTY_FILE_CLASSIFICATION_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_CLASSIFICATION_TOOLTIP);
                }
                if (isRegular) {
                    SystemViewRemoteFileAdapter.uniquePropertyDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.lastmodified", (String)SystemViewResources.RESID_PROPERTY_FILE_LASTMODIFIED_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_LASTMODIFIED_TOOLTIP);
                } else if (isVirtual) {
                    SystemViewRemoteFileAdapter.uniqueVirtualDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.lastmodified", (String)SystemViewResources.RESID_PROPERTY_FILE_LASTMODIFIED_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_LASTMODIFIED_TOOLTIP);
                } else if (isArchive) {
                    SystemViewRemoteFileAdapter.uniqueArchiveDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.lastmodified", (String)SystemViewResources.RESID_PROPERTY_FILE_LASTMODIFIED_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_LASTMODIFIED_TOOLTIP);
                }
                if (isRegular) {
                    SystemViewRemoteFileAdapter.uniquePropertyDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.size", (String)SystemViewResources.RESID_PROPERTY_FILE_SIZE_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_SIZE_TOOLTIP);
                } else if (isVirtual) {
                    SystemViewRemoteFileAdapter.uniqueVirtualDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.size", (String)SystemViewResources.RESID_PROPERTY_FILE_SIZE_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_SIZE_TOOLTIP);
                } else if (isArchive) {
                    SystemViewRemoteFileAdapter.uniqueArchiveDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.size", (String)SystemViewResources.RESID_PROPERTY_FILE_SIZE_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_SIZE_TOOLTIP);
                }
                if (isRegular) {
                    SystemViewRemoteFileAdapter.uniquePropertyDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.canonicalpath", (String)SystemViewResources.RESID_PROPERTY_FILE_CANONICAL_PATH_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_CANONICAL_PATH_TOOLTIP);
                } else if (isVirtual) {
                    SystemViewRemoteFileAdapter.uniqueVirtualDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.canonicalpath", (String)SystemViewResources.RESID_PROPERTY_FILE_CANONICAL_PATH_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_CANONICAL_PATH_TOOLTIP);
                } else if (isArchive) {
                    SystemViewRemoteFileAdapter.uniqueArchiveDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.canonicalpath", (String)SystemViewResources.RESID_PROPERTY_FILE_CANONICAL_PATH_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_CANONICAL_PATH_TOOLTIP);
                }
                if (isVirtual) {
                    SystemViewRemoteFileAdapter.uniqueVirtualDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.virtual.compressedsize", (String)SystemViewResources.RESID_PROPERTY_VIRTUALFILE_COMPRESSEDSIZE_LABEL, (String)SystemViewResources.RESID_PROPERTY_VIRTUALFILE_COMPRESSEDSIZE_DESCRIPTION);
                    SystemViewRemoteFileAdapter.uniqueVirtualDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.virtual.compressionratio", (String)SystemViewResources.RESID_PROPERTY_VIRTUALFILE_COMPRESSIONRATIO_LABEL, (String)SystemViewResources.RESID_PROPERTY_VIRTUALFILE_COMPRESSIONRATIO_DESCRIPTION);
                    SystemViewRemoteFileAdapter.uniqueVirtualDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.virtual.compressionmethod", (String)SystemViewResources.RESID_PROPERTY_VIRTUALFILE_COMPRESSIONMETHOD_LABEL, (String)SystemViewResources.RESID_PROPERTY_VIRTUALFILE_COMPRESSIONMETHOD_DESCRIPTION);
                    SystemViewRemoteFileAdapter.uniqueVirtualDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.virtual.comment", (String)SystemViewResources.RESID_PROPERTY_VIRTUALFILE_COMMENT_LABEL, (String)SystemViewResources.RESID_PROPERTY_VIRTUALFILE_COMMENT_DESCRIPTION);
                } else if (isArchive) {
                    SystemViewRemoteFileAdapter.uniqueArchiveDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.archive.expandedsize", (String)SystemViewResources.RESID_PROPERTY_ARCHIVE_EXPANDEDSIZE_LABEL, (String)SystemViewResources.RESID_PROPERTY_ARCHIVE_EXPANDEDSIZE_DESCRIPTION);
                    SystemViewRemoteFileAdapter.uniqueArchiveDescriptorArray[++i] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.archive.comment", (String)SystemViewResources.RESID_PROPERTY_ARCHIVE_COMMENT_LABEL, (String)SystemViewResources.RESID_PROPERTY_ARCHIVE_COMMENT_DESCRIPTION);
                }
            }
            if (isRegular) {
                return uniquePropertyDescriptorArray;
            }
            if (isVirtual) {
                return uniqueVirtualDescriptorArray;
            }
            if (isArchive) {
                return uniqueArchiveDescriptorArray;
            }
            return uniquePropertyDescriptorArray;
        }
        return uniquePropertyDescriptorArray;
    }

    protected IPropertyDescriptor[] internalGetPropertyDescriptors() {
        boolean isRegular;
        IRemoteFile file = null;
        if (this.propertySourceInput instanceof IRemoteFile) {
            file = (IRemoteFile)this.propertySourceInput;
        }
        boolean isArchive = false;
        boolean isVirtual = file != null && file instanceof IVirtualRemoteFile;
        boolean bl = isRegular = !isArchive && !isVirtual;
        if (isRegular && propertyDescriptorArray == null || isArchive && archiveDescriptorArray == null || isVirtual && virtualDescriptorArray == null) {
            int nbrOfArchiveProperties = 2;
            int nbrOfVirtualProperties = 4;
            int nbrOfProperties = 8;
            int nbrOfBriefProperties = 2;
            if (this.debug) {
                nbrOfProperties += 7;
            }
            if (isVirtual) {
                nbrOfProperties += nbrOfVirtualProperties;
            } else if (isArchive) {
                nbrOfProperties += nbrOfArchiveProperties;
            }
            if (isRegular) {
                propertyDescriptorArray = new PropertyDescriptor[nbrOfProperties];
            } else if (isVirtual) {
                virtualDescriptorArray = new PropertyDescriptor[nbrOfProperties];
            } else if (isArchive) {
                archiveDescriptorArray = new PropertyDescriptor[nbrOfProperties];
            }
            briefPropertyDescriptorArray = new PropertyDescriptor[nbrOfBriefProperties];
            int idx = -1;
            int briefIdx = idx++;
            if (isRegular) {
                SystemViewRemoteFileAdapter.propertyDescriptorArray[idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.path", (String)SystemViewResources.RESID_PROPERTY_FILE_PATH_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_PATH_TOOLTIP);
            } else if (isVirtual) {
                SystemViewRemoteFileAdapter.virtualDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.path", (String)SystemViewResources.RESID_PROPERTY_FILE_PATH_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_PATH_TOOLTIP);
            } else if (isArchive) {
                SystemViewRemoteFileAdapter.archiveDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.path", (String)SystemViewResources.RESID_PROPERTY_FILE_PATH_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_PATH_TOOLTIP);
            }
            SystemViewRemoteFileAdapter.briefPropertyDescriptorArray[++briefIdx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.path", (String)SystemViewResources.RESID_PROPERTY_FILE_PATH_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_PATH_TOOLTIP);
            if (isRegular) {
                SystemViewRemoteFileAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.filterString", (String)SystemViewResources.RESID_PROPERTY_FILTERSTRING_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILTERSTRING_TOOLTIP);
            } else if (isVirtual) {
                SystemViewRemoteFileAdapter.virtualDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.filterString", (String)SystemViewResources.RESID_PROPERTY_FILTERSTRING_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILTERSTRING_TOOLTIP);
            } else if (isArchive) {
                SystemViewRemoteFileAdapter.archiveDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.filterString", (String)SystemViewResources.RESID_PROPERTY_FILTERSTRING_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILTERSTRING_TOOLTIP);
            }
            SystemViewRemoteFileAdapter.briefPropertyDescriptorArray[++briefIdx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.filterString", (String)SystemViewResources.RESID_PROPERTY_FILTERSTRING_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILTERSTRING_TOOLTIP);
            if (isRegular) {
                SystemViewRemoteFileAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.canonicalpath", (String)SystemViewResources.RESID_PROPERTY_FILE_CANONICAL_PATH_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_CANONICAL_PATH_TOOLTIP);
            } else if (isVirtual) {
                SystemViewRemoteFileAdapter.virtualDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.canonicalpath", (String)SystemViewResources.RESID_PROPERTY_FILE_CANONICAL_PATH_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_CANONICAL_PATH_TOOLTIP);
            } else if (isArchive) {
                SystemViewRemoteFileAdapter.archiveDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.canonicalpath", (String)SystemViewResources.RESID_PROPERTY_FILE_CANONICAL_PATH_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_CANONICAL_PATH_TOOLTIP);
            }
            if (isRegular) {
                SystemViewRemoteFileAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.lastmodified", (String)SystemViewResources.RESID_PROPERTY_FILE_LASTMODIFIED_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_LASTMODIFIED_TOOLTIP);
            } else if (isVirtual) {
                SystemViewRemoteFileAdapter.virtualDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.lastmodified", (String)SystemViewResources.RESID_PROPERTY_FILE_LASTMODIFIED_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_LASTMODIFIED_TOOLTIP);
            } else if (isArchive) {
                SystemViewRemoteFileAdapter.archiveDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.lastmodified", (String)SystemViewResources.RESID_PROPERTY_FILE_LASTMODIFIED_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_LASTMODIFIED_TOOLTIP);
            }
            if (isRegular) {
                SystemViewRemoteFileAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.size", (String)SystemViewResources.RESID_PROPERTY_FILE_SIZE_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_SIZE_TOOLTIP);
            } else if (isVirtual) {
                SystemViewRemoteFileAdapter.virtualDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.size", (String)SystemViewResources.RESID_PROPERTY_FILE_SIZE_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_SIZE_TOOLTIP);
            } else if (isArchive) {
                SystemViewRemoteFileAdapter.archiveDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.size", (String)SystemViewResources.RESID_PROPERTY_FILE_SIZE_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_SIZE_TOOLTIP);
            }
            if (isRegular) {
                SystemViewRemoteFileAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.classification", (String)SystemViewResources.RESID_PROPERTY_FILE_CLASSIFICATION_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_CLASSIFICATION_TOOLTIP);
            } else if (isVirtual) {
                SystemViewRemoteFileAdapter.virtualDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.classification", (String)SystemViewResources.RESID_PROPERTY_FILE_CLASSIFICATION_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_CLASSIFICATION_TOOLTIP);
            } else if (isArchive) {
                SystemViewRemoteFileAdapter.archiveDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.classification", (String)SystemViewResources.RESID_PROPERTY_FILE_CLASSIFICATION_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_CLASSIFICATION_TOOLTIP);
            }
            if (isRegular) {
                SystemViewRemoteFileAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.readonly", (String)SystemViewResources.RESID_PROPERTY_FILE_READONLY_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_READONLY_TOOLTIP);
            } else if (isVirtual) {
                SystemViewRemoteFileAdapter.virtualDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.readonly", (String)SystemViewResources.RESID_PROPERTY_FILE_READONLY_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_READONLY_TOOLTIP);
            } else if (isArchive) {
                SystemViewRemoteFileAdapter.archiveDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.readonly", (String)SystemViewResources.RESID_PROPERTY_FILE_READONLY_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_READONLY_TOOLTIP);
            }
            if (isRegular) {
                SystemViewRemoteFileAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.hidden", (String)SystemViewResources.RESID_PROPERTY_FILE_HIDDEN_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_HIDDEN_TOOLTIP);
            } else if (isVirtual) {
                SystemViewRemoteFileAdapter.virtualDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.hidden", (String)SystemViewResources.RESID_PROPERTY_FILE_HIDDEN_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_HIDDEN_TOOLTIP);
            } else if (isArchive) {
                SystemViewRemoteFileAdapter.archiveDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.file.hidden", (String)SystemViewResources.RESID_PROPERTY_FILE_HIDDEN_LABEL, (String)SystemViewResources.RESID_PROPERTY_FILE_HIDDEN_TOOLTIP);
            }
            if (this.debug) {
                SystemViewRemoteFileAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor("DEBUG_PARENTREMOTEFILE");
                SystemViewRemoteFileAdapter.briefPropertyDescriptorArray[++briefIdx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor("DEBUG_PARENTREMOTEFILE");
                SystemViewRemoteFileAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor("DEBUG_PARENT");
                SystemViewRemoteFileAdapter.briefPropertyDescriptorArray[++briefIdx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor("DEBUG_PARENT");
                SystemViewRemoteFileAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor("DEBUG_PARENTNOROOT");
                SystemViewRemoteFileAdapter.briefPropertyDescriptorArray[++briefIdx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor("DEBUG_PARENTNOROOT");
                SystemViewRemoteFileAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor("DEBUG_PARENTNAME");
                SystemViewRemoteFileAdapter.briefPropertyDescriptorArray[++briefIdx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor("DEBUG_PARENTNAME");
                SystemViewRemoteFileAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor("DEBUG_ROOT");
                SystemViewRemoteFileAdapter.briefPropertyDescriptorArray[++briefIdx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor("DEBUG_ROOT");
                SystemViewRemoteFileAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor("DEBUG_ISROOT");
                SystemViewRemoteFileAdapter.briefPropertyDescriptorArray[++briefIdx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor("DEBUG_ISROOT");
                SystemViewRemoteFileAdapter.propertyDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor("DEBUG_EXISTS");
                SystemViewRemoteFileAdapter.briefPropertyDescriptorArray[++briefIdx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor("DEBUG_EXISTS");
            }
            if (isVirtual) {
                SystemViewRemoteFileAdapter.virtualDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.virtual.compressedsize", (String)SystemViewResources.RESID_PROPERTY_VIRTUALFILE_COMPRESSEDSIZE_LABEL, (String)SystemViewResources.RESID_PROPERTY_VIRTUALFILE_COMPRESSEDSIZE_DESCRIPTION);
                SystemViewRemoteFileAdapter.virtualDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.virtual.compressionratio", (String)SystemViewResources.RESID_PROPERTY_VIRTUALFILE_COMPRESSIONRATIO_LABEL, (String)SystemViewResources.RESID_PROPERTY_VIRTUALFILE_COMPRESSIONRATIO_DESCRIPTION);
                SystemViewRemoteFileAdapter.virtualDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.virtual.compressionmethod", (String)SystemViewResources.RESID_PROPERTY_VIRTUALFILE_COMPRESSIONMETHOD_LABEL, (String)SystemViewResources.RESID_PROPERTY_VIRTUALFILE_COMPRESSIONMETHOD_DESCRIPTION);
                SystemViewRemoteFileAdapter.virtualDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.virtual.comment", (String)SystemViewResources.RESID_PROPERTY_VIRTUALFILE_COMMENT_LABEL, (String)SystemViewResources.RESID_PROPERTY_VIRTUALFILE_COMMENT_DESCRIPTION);
            } else if (isArchive) {
                SystemViewRemoteFileAdapter.archiveDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.archive.expandedsize", (String)SystemViewResources.RESID_PROPERTY_ARCHIVE_EXPANDEDSIZE_LABEL, (String)SystemViewResources.RESID_PROPERTY_ARCHIVE_EXPANDEDSIZE_DESCRIPTION);
                SystemViewRemoteFileAdapter.archiveDescriptorArray[++idx] = SystemViewRemoteFileAdapter.createSimplePropertyDescriptor((String)"org.eclipse.rse.ui.archive.comment", (String)SystemViewResources.RESID_PROPERTY_ARCHIVE_COMMENT_LABEL, (String)SystemViewResources.RESID_PROPERTY_ARCHIVE_COMMENT_DESCRIPTION);
            }
        }
        if (this.propertySourceInput instanceof IRemoteFile && ((IRemoteFile)this.propertySourceInput).showBriefPropertySet()) {
            return propertyDescriptorArray;
        }
        if (isRegular) {
            return propertyDescriptorArray;
        }
        if (isVirtual) {
            return virtualDescriptorArray;
        }
        if (isArchive) {
            return archiveDescriptorArray;
        }
        return propertyDescriptorArray;
    }

    protected static PropertyDescriptor createSimplePropertyDescriptor(String keyAndLabel) {
        PropertyDescriptor pd = new PropertyDescriptor((Object)keyAndLabel, keyAndLabel);
        return pd;
    }

    protected Object internalGetPropertyValue(Object key) {
        return this.getPropertyValue(key, true);
    }

    public Object getPropertyValue(Object property, boolean formatted) {
        String name = (String)property;
        IRemoteFile file = (IRemoteFile)this.propertySourceInput;
        IVirtualRemoteFile virtualFile = null;
        boolean isVirtual = file instanceof IVirtualRemoteFile;
        if (isVirtual) {
            virtualFile = (IVirtualRemoteFile)file;
        }
        if (this.debug) {
            if (name.equals("DEBUG_PARENTREMOTEFILE")) {
                IRemoteFile parent = file.getParentRemoteFile();
                if (parent == null) {
                    return "null";
                }
                return "absPath='" + parent.getAbsolutePath() + "'";
            }
            if (name.equals("DEBUG_PARENT")) {
                return file.getParentPath();
            }
            if (name.equals("DEBUG_PARENTNOROOT")) {
                return file.getParentNoRoot();
            }
            if (name.equals("DEBUG_PARENTNAME")) {
                return file.getParentName();
            }
            if (name.equals("DEBUG_ROOT")) {
                return file.getRoot();
            }
            if (name.equals("DEBUG_ISROOT")) {
                return file.isRoot() ? "true" : "false";
            }
            if (name.equals("DEBUG_EXISTS")) {
                return file.exists() ? "true" : "false";
            }
        }
        if (name.equals("org.eclipse.rse.ui.file.lastmodified")) {
            Date date = file.getLastModifiedDate();
            if (date != null) {
                if (formatted) {
                    SimpleDateFormat datefmt = (SimpleDateFormat)DateFormat.getDateTimeInstance(1, 2);
                    return datefmt.format(date);
                }
                return date;
            }
            return date;
        }
        if (name.equals("org.eclipse.rse.ui.file.size")) {
            if (formatted) {
                return SystemViewRemoteFileAdapter.sub((String)this.xlatedSize, (String)"&1", (String)Long.toString(file.getLength()));
            }
            return new Long(file.getLength());
        }
        if (name.equals("org.eclipse.rse.ui.archive.expandedsize")) {
            if (!isVirtual) {
                return new Long(0L);
            }
            if (formatted) {
                return SystemViewRemoteFileAdapter.sub((String)this.xlatedExpandedSize, (String)"&1", (String)Long.toString(virtualFile.getExpandedSize()));
            }
            return new Long(virtualFile.getExpandedSize());
        }
        if (name.equals("org.eclipse.rse.ui.virtual.compressedsize")) {
            if (!isVirtual) {
                return new Long(0L);
            }
            if (formatted) {
                return SystemViewRemoteFileAdapter.sub((String)this.xlatedCompressedSize, (String)"&1", (String)Long.toString(virtualFile.getCompressedSize()));
            }
            return new Long(virtualFile.getCompressedSize());
        }
        if (name.equals("org.eclipse.rse.ui.file.path")) {
            return file.getParentPath();
        }
        if (name.equals("org.eclipse.rse.ui.file.canonicalpath")) {
            return file.getCanonicalPath();
        }
        if (name.equals("org.eclipse.rse.ui.file.classification")) {
            return file.getClassification();
        }
        if (name.equals("org.eclipse.rse.ui.file.readonly")) {
            return file.canWrite() ? this.getTranslatedNo() : this.getTranslatedYes();
        }
        if (name.equals("org.eclipse.rse.ui.file.readable")) {
            return file.canRead() ? this.getTranslatedYes() : this.getTranslatedNo();
        }
        if (name.equals("org.eclipse.rse.ui.file.writable")) {
            return file.canWrite() ? this.getTranslatedYes() : this.getTranslatedNo();
        }
        if (name.equals("org.eclipse.rse.ui.file.hidden")) {
            return file.isHidden() ? this.getTranslatedYes() : this.getTranslatedNo();
        }
        if (name.equals("org.eclipse.rse.ui.filterString")) {
            return file.getFilterString();
        }
        if (name.equals("org.eclipse.rse.ui.archive.comment") || name.equals("org.eclipse.rse.ui.virtual.comment")) {
            return file.getComment();
        }
        if (name.equals("org.eclipse.rse.ui.virtual.compressionmethod")) {
            if (!isVirtual) {
                return "";
            }
            return virtualFile.getCompressionMethod();
        }
        if (name.equals("org.eclipse.rse.ui.virtual.compressionratio")) {
            Double ratio = new Double(virtualFile.getCompressionRatio());
            if (formatted) {
                NumberFormat numfmt = NumberFormat.getPercentInstance();
                return numfmt.format(ratio);
            }
            return ratio;
        }
        return null;
    }

    public boolean canDrag(Object element) {
        if (element instanceof IRemoteFile) {
            return ((IRemoteFile)element).canRead();
        }
        return true;
    }

    public boolean canDrop(Object element) {
        if (element instanceof IRemoteFile) {
            IRemoteFile file = (IRemoteFile)element;
            boolean supportsArchiveManagement = file.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemFactory().supportsArchiveManagement();
            return file.canRead() && file.canWrite() && (file.isDirectory() || file.isRoot() || file.isArchive() && supportsArchiveManagement);
        }
        return false;
    }

    public boolean validateDrop(ISystemResourceSet srcSet, Object target, boolean sameSystem) {
        if (target instanceof IRemoteFile) {
            ISystemViewDropDestination adapter;
            Object first;
            IRemoteFile targetFile = (IRemoteFile)target;
            boolean supportsArchiveManagement = targetFile.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemFactory().supportsArchiveManagement();
            if (!targetFile.isFile() || targetFile.isArchive() && supportsArchiveManagement) {
                targetFile.canWrite();
            }
            if ((first = srcSet.get(0)) instanceof IRemoteFile) {
                return true;
            }
            if (first instanceof IResource) {
                return true;
            }
            if (first instanceof ISystemFilterReference) {
                return true;
            }
            IAdapterManager iAdapterManager = Platform.getAdapterManager();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewDropDestination");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (ISystemViewDropDestination)iAdapterManager.getAdapter(first, (Class)clazz)) != null) {
                return adapter.supportDropDestination(target);
            }
        }
        return false;
    }

    public boolean validateDrop(Object src, Object target, boolean sameSystem) {
        if (target instanceof IRemoteFile) {
            IRemoteFile targetFile = (IRemoteFile)target;
            boolean supportsArchiveManagement = targetFile.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemFactory().supportsArchiveManagement();
            if (!targetFile.isFile() || targetFile.isArchive() && supportsArchiveManagement) {
                ISystemViewDropDestination adapter;
                targetFile.canWrite();
                if (src instanceof IRemoteFile) {
                    return true;
                }
                if (src instanceof IResource) {
                    return true;
                }
                if (src instanceof String) {
                    File localFile = new File((String)src);
                    return localFile.exists();
                }
                if (src instanceof ISystemFilterReference) {
                    return true;
                }
                IAdapterManager iAdapterManager = Platform.getAdapterManager();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewDropDestination");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((adapter = (ISystemViewDropDestination)iAdapterManager.getAdapter(src, (Class)clazz)) != null) {
                    return adapter.supportDropDestination(target);
                }
            }
        }
        return false;
    }

    public Object doDrag(Object element, boolean sameSystem, IProgressMonitor monitor) {
        if (element instanceof IRemoteFile) {
            IRemoteFile srcFileOrFolder = (IRemoteFile)element;
            return UniversalFileTransferUtility.copyRemoteResourceToWorkspace(srcFileOrFolder, monitor);
        }
        if (element instanceof IResource) {
            return element;
        }
        return null;
    }

    public ISystemResourceSet doDrag(SystemRemoteResourceSet set, IProgressMonitor monitor) {
        boolean supportsSearch = ((IRemoteFileSubSystemConfiguration)set.getSubSystem().getSubSystemConfiguration()).supportsSearch();
        boolean doSuperTransferProperty = RSEUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.rse.preferences.dosupertransfer");
        if (!doSuperTransferProperty && supportsSearch) {
            SystemRemoteResourceSet flatSet = new SystemRemoteResourceSet(set.getSubSystem(), set.getAdapter());
            long totalByteSize = this.getFlatRemoteResourceSet(set.getResourceSet(), flatSet, monitor);
            flatSet.setByteSize(totalByteSize);
            if (monitor != null) {
                monitor.beginTask(_downloadMessage.getLevelOneText(), (int)totalByteSize);
            }
            try {
                SystemWorkspaceResourceSet flatResult = UniversalFileTransferUtility.copyRemoteResourcesToWorkspace(flatSet, monitor);
                if (flatResult.hasMessage()) {
                    return flatResult;
                }
                SystemWorkspaceResourceSet hierarchicalResult = new SystemWorkspaceResourceSet();
                int i = 0;
                while (i < set.size()) {
                    IRemoteFile remoteFile = (IRemoteFile)set.get(i);
                    hierarchicalResult.addResource((Object)UniversalFileTransferUtility.getTempFileFor(remoteFile));
                    ++i;
                }
                return hierarchicalResult;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return UniversalFileTransferUtility.copyRemoteResourcesToWorkspace(set, monitor);
    }

    private IRemoteFileSubSystem getLocalFileSubSystem() {
        ISystemRegistry registry = RSEUIPlugin.getTheSystemRegistry();
        IHost[] connections = registry.getHosts();
        int i = 0;
        while (i < connections.length) {
            IHost connection = connections[i];
            IRemoteFileSubSystem anFS = RemoteFileUtility.getFileSubSystem((IHost)connection);
            if (anFS.getHost().getSystemType().equals("Local")) {
                return anFS;
            }
            ++i;
        }
        return null;
    }

    protected long getFlatRemoteResourceSet(List initialResources, SystemRemoteResourceSet flatSet, IProgressMonitor monitor) {
        long totalByteSize = 0L;
        ArrayList<IHostSearchResultConfiguration> configList = new ArrayList<IHostSearchResultConfiguration>();
        HostSearchResultSet searchSet = new HostSearchResultSet();
        IRemoteFileSubSystem subsys = (IRemoteFileSubSystem)flatSet.getSubSystem();
        if (subsys instanceof FileServiceSubSystem) {
            FileServiceSubSystem ss = (FileServiceSubSystem)subsys;
            SystemSearchString searchString = new SystemSearchString("*", false, false, "*", false, false, true);
            int i = 0;
            while (i < initialResources.size()) {
                IRemoteFile remoteFile = (IRemoteFile)initialResources.get(i);
                if (remoteFile.isDirectory()) {
                    IHostSearchResultConfiguration config = ss.createSearchConfiguration((IHostSearchResultSet)searchSet, (Object)remoteFile, searchString);
                    subsys.search(config);
                    configList.add(config);
                } else {
                    flatSet.addResource((Object)remoteFile);
                }
                ++i;
            }
        }
        SubProgressMonitor submonitor = null;
        if (monitor != null) {
            submonitor = new SubProgressMonitor(monitor, configList.size());
            submonitor.setTaskName(FileResources.RESID_SEARCH_MESSAGE_SEARCHING);
        }
        int n = 0;
        while (n < configList.size()) {
            IHostSearchResultConfiguration config = (IHostSearchResultConfiguration)configList.get(n);
            while (config.getStatus() != 1) {
                if (monitor != null) {
                    if (monitor.isCanceled()) {
                        return totalByteSize;
                    }
                    Display display = Display.getCurrent();
                    while (display.readAndDispatch()) {
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
            if (config.getStatus() == 1) {
                submonitor.worked(1);
                Object[] results = config.getResults();
                int m = 0;
                while (m < results.length) {
                    Object result = results[m];
                    if (result instanceof IRemoteFile) {
                        IRemoteFile file = (IRemoteFile)result;
                        flatSet.addResource((Object)file);
                        totalByteSize += file.getLength();
                    }
                    ++m;
                }
            }
            ++n;
        }
        return totalByteSize;
    }

    protected long getFlatWorkspaceResourceSet(List resources, SystemWorkspaceResourceSet flatSet, IProgressMonitor monitor) {
        long totalBytes = 0L;
        int i = 0;
        while (i < resources.size()) {
            IResource resource = (IResource)resources.get(i);
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                flatSet.addResource((Object)file);
                File osFile = file.getLocation().toFile();
                totalBytes += osFile.length();
            } else if (resource instanceof IContainer) {
                IContainer container = (IContainer)resource;
                try {
                    IResource[] members = container.members();
                    totalBytes += this.getFlatWorkspaceResourceSet(members, flatSet, monitor);
                }
                catch (Exception exception) {}
            }
            ++i;
        }
        return totalBytes;
    }

    protected long getFlatWorkspaceResourceSet(IResource[] resources, SystemWorkspaceResourceSet flatSet, IProgressMonitor monitor) {
        long totalBytes = 0L;
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                flatSet.addResource((Object)file);
                File osFile = file.getLocation().toFile();
                totalBytes += osFile.length();
            } else if (resource instanceof IContainer) {
                IContainer container = (IContainer)resource;
                try {
                    IResource[] members = container.members();
                    totalBytes += this.getFlatWorkspaceResourceSet(members, flatSet, monitor);
                }
                catch (Exception exception) {}
            }
            ++i;
        }
        return totalBytes;
    }

    public ISystemResourceSet doDrop(ISystemResourceSet fromSet, Object target, boolean sameSystemType, boolean sameSystem, int srcType, IProgressMonitor monitor) {
        SystemRemoteResourceSet resultSet = new SystemRemoteResourceSet(this.getSubSystem(target), (ISystemDragDropAdapter)this);
        if (!sameSystem && sameSystemType) {
            fromSet = this.doDrag((SystemRemoteResourceSet)fromSet, monitor);
        }
        if (target instanceof IRemoteFile) {
            IRemoteFile targetFolder = (IRemoteFile)target;
            IRemoteFileSubSystem targetFS = targetFolder.getParentRemoteFileSubSystem();
            try {
                targetFolder = targetFS.getRemoteFileObject(targetFolder.getAbsolutePath());
            }
            catch (Exception exception) {}
            if (!targetFolder.canWrite()) {
                SystemMessage errorMsg = RSEUIPlugin.getPluginMessage((String)"RSEF1001");
                errorMsg.makeSubstitution((Object)targetFS.getHostAliasName());
                resultSet.setMessage(errorMsg);
                return resultSet;
            }
            if (!targetFS.isConnected()) {
                return null;
            }
            List set = fromSet.getResourceSet();
            if (set.size() > 0) {
                if (fromSet instanceof SystemWorkspaceResourceSet) {
                    boolean doSuperTransferProperty = RSEUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.rse.preferences.dosupertransfer");
                    if (!doSuperTransferProperty) {
                        SystemWorkspaceResourceSet flatFromSet = new SystemWorkspaceResourceSet();
                        long totalByteSize = this.getFlatWorkspaceResourceSet(fromSet.getResourceSet(), flatFromSet, monitor);
                        if (monitor != null) {
                            int size = (int)totalByteSize;
                            monitor.beginTask(_uploadMessage.getLevelOneText(), size);
                        }
                        return UniversalFileTransferUtility.copyWorkspaceResourcesToRemote((SystemWorkspaceResourceSet)fromSet, targetFolder, monitor, this.getShell(), true);
                    }
                    return UniversalFileTransferUtility.copyWorkspaceResourcesToRemote((SystemWorkspaceResourceSet)fromSet, targetFolder, monitor, this.getShell(), true);
                }
                if (fromSet instanceof SystemRemoteResourceSet) {
                    SystemRemoteResourceSet rmtSet = (SystemRemoteResourceSet)fromSet;
                    rmtSet.getAdapter();
                    ISubSystem srcSubSystem = rmtSet.getSubSystem();
                    Object first = set.get(0);
                    if (first instanceof ISystemFilterReference) {
                        SystemWorkspaceResourceSet downloadedFilterResults = new SystemWorkspaceResourceSet();
                        int i = 0;
                        while (i < set.size()) {
                            ISystemFilterReference ref = (ISystemFilterReference)set.get(i);
                            SystemFilterReference filterReference = (SystemFilterReference)ref;
                            Object[] children = null;
                            try {
                                children = ((SubSystem)srcSubSystem).internalResolveFilterStrings(monitor, filterReference.getReferencedFilter().getFilterStrings());
                            }
                            catch (Exception exception) {}
                            int c = 0;
                            while (c < children.length) {
                                Object child = children[c];
                                if (child instanceof IAdaptable) {
                                    Object newSrc = child;
                                    if (srcSubSystem != targetFS) {
                                        ISystemDragDropAdapter cAdapter;
                                        IAdaptable iAdaptable = (IAdaptable)child;
                                        Class<?> clazz = class$1;
                                        if (clazz == null) {
                                            try {
                                                clazz = Class.forName("org.eclipse.rse.ui.view.ISystemDragDropAdapter");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        if ((newSrc = (cAdapter = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz)).doDrag(child, sameSystemType, monitor)) instanceof SystemMessage) {
                                            resultSet.setMessage((SystemMessage)newSrc);
                                            return resultSet;
                                        }
                                        downloadedFilterResults.addResource(newSrc);
                                    }
                                }
                                ++c;
                            }
                            ++i;
                        }
                        return this.doDrop((ISystemResourceSet)downloadedFilterResults, target, sameSystemType, srcSubSystem == targetFS, 0, monitor);
                    }
                    if (first instanceof IRemoteFile) {
                        String name;
                        IRemoteFile srcFileOrFolder;
                        ArrayList<IRemoteFile> toCopy = new ArrayList<IRemoteFile>();
                        ArrayList<String> toCopyNames = new ArrayList<String>();
                        ArrayList<IRemoteFile> toCopyBatch = new ArrayList<IRemoteFile>();
                        int i = 0;
                        while (i < set.size()) {
                            block44: {
                                SystemMessage errorMessage;
                                srcFileOrFolder = (IRemoteFile)set.get(i);
                                if (!srcFileOrFolder.exists()) {
                                    errorMessage = RSEUIPlugin.getPluginMessage((String)"RSEG1106");
                                    errorMessage.makeSubstitution((Object)srcFileOrFolder.getAbsolutePath(), (Object)srcFileOrFolder.getSystemConnection().getAliasName());
                                    resultSet.setMessage(errorMessage);
                                    return resultSet;
                                }
                                if (!srcFileOrFolder.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemFactory().supportsArchiveManagement()) {
                                    errorMessage = RSEUIPlugin.getPluginMessage((String)"RSEG1304");
                                    resultSet.setMessage(errorMessage);
                                    return resultSet;
                                }
                                name = srcFileOrFolder.getName();
                                if (sameSystem) {
                                    try {
                                        if (targetFolder.getAbsolutePath().equals(srcFileOrFolder.getAbsolutePath())) break block44;
                                        IRemoteFile existingFileOrFolder = ((IRemoteFileSubSystem)srcSubSystem).getRemoteFileObject(targetFolder, name);
                                        if (existingFileOrFolder.exists()) {
                                            ISystemValidator validator = null;
                                            SystemRenameSingleDialog dlg = new SystemRenameSingleDialog(this.getShell(), true, (Object)existingFileOrFolder, validator);
                                            dlg.open();
                                            name = !dlg.wasCancelled() ? dlg.getNewName() : null;
                                            if (name != null) {
                                                toCopy.add(srcFileOrFolder);
                                                toCopyNames.add(name);
                                            }
                                        } else if (name != null) {
                                            toCopyBatch.add(srcFileOrFolder);
                                        }
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                } else {
                                    System.out.println("HOW DID I GET HERE?!!");
                                }
                            }
                            ++i;
                        }
                        int x = 0;
                        while (x < toCopy.size()) {
                            srcFileOrFolder = (IRemoteFile)toCopy.get(x);
                            name = (String)toCopyNames.get(x);
                            try {
                                if (targetFS.copy(srcFileOrFolder, targetFolder, name, monitor)) {
                                    IRemoteFile copiedFile = targetFS.getRemoteFileObject(targetFolder, name);
                                    resultSet.addResource((Object)copiedFile);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            ++x;
                        }
                        IRemoteFile[] srcFileOrFolders = new IRemoteFile[toCopyBatch.size()];
                        int x2 = 0;
                        while (x2 < toCopyBatch.size()) {
                            srcFileOrFolders[x2] = (IRemoteFile)toCopyBatch.get(x2);
                            ++x2;
                        }
                        if (toCopyBatch.size() > 0) {
                            try {
                                if (targetFS.copyBatch(srcFileOrFolders, targetFolder, monitor)) {
                                    x2 = 0;
                                    while (x2 < toCopyBatch.size()) {
                                        IRemoteFile copiedFile = targetFS.getRemoteFileObject(targetFolder, srcFileOrFolders[x2].getName());
                                        resultSet.addResource((Object)copiedFile);
                                        ++x2;
                                    }
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
        }
        return resultSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object doDrop(Object src, Object target, boolean sameSystemType, boolean sameSystem, int sourceType, IProgressMonitor monitor) {
        IRemoteFile result = null;
        if (sameSystemType && !sameSystem) {
            src = this.doDrag(src, sameSystem, monitor);
        }
        if (!(target instanceof IRemoteFile)) {
            return null;
        }
        IRemoteFile targetFolder = (IRemoteFile)target;
        IRemoteFileSubSystem targetFS = targetFolder.getParentRemoteFileSubSystem();
        try {
            targetFolder = targetFS.getRemoteFileObject(targetFolder.getAbsolutePath());
        }
        catch (Exception exception) {}
        if (!targetFolder.canWrite()) {
            SystemMessage errorMsg = RSEUIPlugin.getPluginMessage((String)"RSEF1001");
            errorMsg.makeSubstitution((Object)targetFS.getHostAliasName());
            return errorMsg;
        }
        if (!targetFS.isConnected()) {
            return null;
        }
        if (sourceType == 2 && src instanceof String) {
            IRemoteFileSubSystem localFS = this.getLocalFileSubSystem();
            IRemoteFile srcFileOrFolder = null;
            try {
                srcFileOrFolder = localFS.getRemoteFileObject((String)src);
                return this.doDrop(srcFileOrFolder, target, sameSystemType, sameSystem, 0, monitor);
            }
            catch (SystemMessageException e) {
                return e.getSystemMessage();
            }
        }
        if (sourceType == 3) {
            boolean cfr_ignored_0 = src instanceof String;
        }
        if ((sourceType == 1 || sourceType == 0) && src instanceof IResource) {
            IResource srcFileOrFolder = (IResource)src;
            return UniversalFileTransferUtility.copyWorkspaceResourceToRemote(srcFileOrFolder, targetFolder, monitor, true);
        }
        if (sourceType != 0) return result;
        if (src instanceof ISystemFilterReference) {
            Object adapter;
            ISystemViewElementAdapter filterAdapter;
            SystemFilterReference filterReference = (SystemFilterReference)src;
            Class<?> clazz = class$2;
            if (clazz == null) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$2 = clazz2;
            }
            if ((filterAdapter = (ISystemViewElementAdapter)(adapter = filterReference.getAdapter((Class)clazz))) == null) return result;
            SubSystem filterSubSystem = (SubSystem)filterAdapter.getSubSystem((Object)filterReference);
            Object[] children = null;
            try {
                children = filterSubSystem.internalResolveFilterStrings(monitor, filterReference.getReferencedFilter().getFilterStrings());
            }
            catch (Exception exception) {}
            int c = 0;
            while (true) {
                if (c >= children.length) {
                    return target;
                }
                Object child = children[c];
                if (child instanceof IAdaptable) {
                    Object newSrc = child;
                    if (filterSubSystem != targetFS) {
                        ISystemDragDropAdapter cAdapter;
                        IAdaptable iAdaptable = (IAdaptable)child;
                        Class<?> clazz3 = class$1;
                        if (clazz3 == null) {
                            try {
                                clazz3 = Class.forName("org.eclipse.rse.ui.view.ISystemDragDropAdapter");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if ((newSrc = (cAdapter = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz3)).doDrag(child, sameSystemType, monitor)) instanceof SystemMessage) {
                            return newSrc;
                        }
                    }
                    this.doDrop(newSrc, target, sameSystemType, filterSubSystem == targetFS, 0, monitor);
                }
                ++c;
            }
        }
        if (!(src instanceof IRemoteFile)) return result;
        try {
            IRemoteFile srcFileOrFolder = (IRemoteFile)src;
            if (!srcFileOrFolder.exists()) {
                SystemMessage errorMessage = RSEUIPlugin.getPluginMessage((String)"RSEG1106");
                errorMessage.makeSubstitution((Object)srcFileOrFolder.getAbsolutePath(), (Object)srcFileOrFolder.getSystemConnection().getAliasName());
                return errorMessage;
            }
            SystemMessage copyMessage = RSEUIPlugin.getPluginMessage((String)"RSEG1072");
            copyMessage.makeSubstitution((Object)srcFileOrFolder.getName(), (Object)targetFolder.getAbsolutePath());
            IRemoteFileSubSystem localFS = srcFileOrFolder.getParentRemoteFileSubSystem();
            String name = srcFileOrFolder.getName();
            if (localFS == targetFS) {
                if (targetFolder.getAbsolutePath().equals(srcFileOrFolder.getAbsolutePath())) return result;
                IRemoteFile existingFileOrFolder = localFS.getRemoteFileObject(targetFolder, name);
                if (existingFileOrFolder.exists()) {
                    ISystemValidator validator = null;
                    SystemRenameSingleDialog dlg = new SystemRenameSingleDialog(this.getShell(), true, (Object)existingFileOrFolder, validator);
                    dlg.open();
                    name = !dlg.wasCancelled() ? dlg.getNewName() : null;
                }
                if (name == null) return result;
                monitor.subTask(copyMessage.getLevelOneText());
                if (!targetFS.copy(srcFileOrFolder, targetFolder, name, monitor)) return result;
                return targetFS.getRemoteFileObject(targetFolder, name);
            }
            System.out.println("how do we get here!??");
            if (srcFileOrFolder.isFile()) {
                try {
                    name = this.checkForCollision(this.getShell(), targetFolder, name);
                    if (name == null) {
                        return null;
                    }
                    boolean isTargetArchive = targetFolder.isArchive();
                    StringBuffer newPathBuf = new StringBuffer(targetFolder.getAbsolutePath());
                    if (isTargetArchive) {
                        newPathBuf.append("#virtual#/");
                    } else {
                        newPathBuf.append(targetFolder.getSeparatorChar());
                    }
                    newPathBuf.append(name);
                    String newPath = newPathBuf.toString();
                    monitor.subTask(copyMessage.getLevelOneText());
                    targetFS.upload(srcFileOrFolder.getAbsolutePath(), newPath, monitor);
                    return targetFS.getRemoteFileObject(targetFolder, name);
                }
                catch (RemoteFileIOException e) {
                    return e.getSystemMessage();
                }
                catch (RemoteFileSecurityException e) {
                    return e.getSystemMessage();
                }
                catch (Exception exception) {
                    return null;
                }
            }
            boolean isTargetArchive = targetFolder.isArchive();
            StringBuffer newPathBuf = new StringBuffer(targetFolder.getAbsolutePath());
            if (isTargetArchive) {
                newPathBuf.append("#virtual#/");
            } else {
                newPathBuf.append(targetFolder.getSeparatorChar());
            }
            newPathBuf.append(name);
            String newPath = newPathBuf.toString();
            IRemoteFile newTargetFolder = targetFS.getRemoteFileObject(newPath);
            targetFS.createFolder(newTargetFolder);
            IRemoteFile[] children = localFS.listFoldersAndFiles(srcFileOrFolder);
            if (children == null) return newTargetFolder;
            int i = 0;
            while (true) {
                if (i >= children.length) {
                    return newTargetFolder;
                }
                if (monitor.isCanceled()) {
                    return null;
                }
                IRemoteFile child = children[i];
                if (this.doDrop(child, (Object)newTargetFolder, sameSystemType, sameSystem, sourceType, monitor) == null) {
                    return null;
                }
                ++i;
            }
        }
        catch (SystemMessageException e) {
            return e.getSystemMessage();
        }
    }

    protected String checkForCollision(Shell shell, IRemoteFile targetFolder, String oldName) {
        String newName = oldName;
        try {
            IRemoteFileSubSystem ss = targetFolder.getParentRemoteFileSubSystem();
            IRemoteFile targetFileOrFolder = ss.getRemoteFileObject(targetFolder, oldName);
            if (targetFileOrFolder.exists()) {
                ISystemValidator validator = null;
                SystemRenameSingleDialog dlg = new SystemRenameSingleDialog(shell, true, (Object)targetFileOrFolder, validator);
                dlg.open();
                newName = !dlg.wasCancelled() ? dlg.getNewName() : null;
            }
        }
        catch (SystemMessageException e) {
            SystemBasePlugin.logError((String)"SystemCopyRemoteFileAction.checkForCollision()", (Throwable)e);
        }
        return newName;
    }

    public boolean canDelete(Object element) {
        IRemoteFile file = (IRemoteFile)element;
        return !file.isRoot() && file.canRead();
    }

    public boolean doDelete(Shell shell, Object element) throws Exception {
        return this.doDelete(shell, element, null);
    }

    public boolean doDelete(Shell shell, Object element, IProgressMonitor monitor) throws Exception {
        boolean ok;
        IRemoteFile file = (IRemoteFile)element;
        IRemoteFile parentFile = file.getParentRemoteFile();
        IRemoteFileSubSystem ss = file.getParentRemoteFileSubSystem();
        try {
            IResource tmp = UniversalFileTransferUtility.getTempFileFor(file);
            if (tmp.exists()) {
                try {
                    tmp.delete(false, null);
                }
                catch (Exception exception) {}
            }
            ok = ss.delete(file, monitor);
            file.markStale(true);
            parentFile.markStale(true);
        }
        catch (Exception exception) {
            ok = false;
            SystemMessageDialog.displayErrorMessage((Shell)shell, (SystemMessage)RSEUIPlugin.getPluginMessage((String)"RSEF1300").makeSubstitution((Object)file.toString()));
        }
        return ok;
    }

    public boolean doDeleteBatch(Shell shell, List resourceSet, IProgressMonitor monitor) throws Exception {
        boolean ok;
        IRemoteFileSubSystem ss = null;
        IRemoteFile[] files = new IRemoteFile[resourceSet.size()];
        int i = 0;
        while (i < resourceSet.size()) {
            IRemoteFile file;
            files[i] = file = (IRemoteFile)resourceSet.get(i);
            IRemoteFile parentFile = file.getParentRemoteFile();
            if (ss == null) {
                ss = file.getParentRemoteFileSubSystem();
            }
            try {
                IResource tmp = UniversalFileTransferUtility.getTempFileFor(file);
                if (tmp.exists()) {
                    try {
                        tmp.delete(false, null);
                    }
                    catch (Exception exception) {}
                }
                file.markStale(true);
                parentFile.markStale(true);
            }
            catch (Exception exception) {
                ok = false;
                SystemMessageDialog.displayErrorMessage((Shell)shell, (SystemMessage)RSEUIPlugin.getPluginMessage((String)"RSEF1300").makeSubstitution((Object)file.toString()));
            }
            ++i;
        }
        ok = ss.deleteBatch(files, monitor);
        return ok;
    }

    public boolean canRename(Object element) {
        IRemoteFile file = (IRemoteFile)element;
        return !file.isRoot() && file.canRead();
    }

    private void moveTempResource(IResource localResource, IPath newLocalPath, IRemoteFileSubSystem ss, String newRemotePath) {
        if (localResource != null) {
            try {
                this.moveTempFileProperties(localResource, ss, newRemotePath);
                localResource.move(newLocalPath, true, null);
            }
            catch (Exception exception) {}
        }
    }

    private void moveTempFileProperties(IResource localResource, IRemoteFileSubSystem ss, String remotePath) {
        if (localResource instanceof IContainer) {
            IContainer localContainer = (IContainer)localResource;
            try {
                IResource[] members = localContainer.members();
                int i = 0;
                while (i < members.length) {
                    IResource member = members[i];
                    this.moveTempFileProperties(member, ss, String.valueOf(remotePath) + "/" + member.getName());
                    ++i;
                }
            }
            catch (Exception exception) {}
        } else if (localResource instanceof IFile) {
            IFile localFile = (IFile)localResource;
            try {
                SystemIFileProperties properties = new SystemIFileProperties((IResource)localFile);
                properties.setRemoteFilePath(remotePath);
                Object editableObj = properties.getRemoteFileObject();
                if (editableObj != null) {
                    SystemEditableRemoteFile editable = (SystemEditableRemoteFile)editableObj;
                    IRemoteFile newRemoteFile = ss.getRemoteFileObject(remotePath);
                    editable.setRemoteFile(newRemoteFile);
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean doRename(Shell shell, Object element, String newName) throws Exception {
        boolean ok = true;
        IRemoteFile file = (IRemoteFile)element;
        IRemoteFileSubSystem ss = file.getParentRemoteFileSubSystem();
        ISystemRegistry sr = RSEUIPlugin.getTheSystemRegistry();
        try {
            String newRemotePath = String.valueOf(file.getParentPath()) + "/" + newName;
            IResource localResource = null;
            if (SystemRemoteEditManager.getDefault().doesRemoteEditProjectExist()) {
                localResource = UniversalFileTransferUtility.getTempFileFor(file);
            }
            ss.rename(file, newName);
            if (localResource != null && localResource.exists()) {
                IPath newLocalPath = localResource.getParent().getFullPath().append(newName);
                this.moveTempResource(localResource, newLocalPath, ss, newRemotePath);
            }
            if (file.isDirectory()) {
                SystemResourceChangeEvent event = new SystemResourceChangeEvent((Object)file.getParentRemoteFile(), 85, null);
                sr.fireEvent((ISystemResourceChangeEvent)event);
            }
            file.markStale(true);
        }
        catch (Exception exception) {
            ok = false;
            SystemMessageDialog.displayErrorMessage((Shell)shell, (SystemMessage)RSEUIPlugin.getPluginMessage((String)"RSEF1301").makeSubstitution((Object)file.toString()));
        }
        return ok;
    }

    public ISystemValidator getNameValidator(Object element) {
        if (element instanceof IRemoteFile) {
            IRemoteFile file = (IRemoteFile)element;
            if (file.isDirectory()) {
                return file.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemFactory().getFolderNameValidator();
            }
            return file.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemFactory().getFileNameValidator();
        }
        return null;
    }

    public String getCanonicalNewName(Object element, String newName) {
        if (element instanceof IRemoteFile) {
            IRemoteFile file = (IRemoteFile)element;
            if (file.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemFactory().isUnixStyle()) {
                return newName;
            }
            return newName.toUpperCase();
        }
        return newName;
    }

    public boolean namesAreEqual(Object element, String newName) {
        if (element instanceof IRemoteFile) {
            IRemoteFile file = (IRemoteFile)element;
            if (file.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemFactory().isUnixStyle()) {
                return this.getName(element).equals(newName);
            }
            return this.getName(element).equalsIgnoreCase(newName);
        }
        return super.namesAreEqual(element, newName);
    }

    public String getMementoHandleKey(Object element) {
        return "Remote";
    }

    public String getAbsoluteName(Object element) {
        IRemoteFile file = (IRemoteFile)element;
        return file.getAbsolutePath();
    }

    public String getAbsoluteParentName(Object element) {
        IRemoteFile file = (IRemoteFile)element;
        return file.getParentPath();
    }

    public ISubSystem getSubSystem(Object element) {
        if (element instanceof IRemoteFile) {
            IRemoteFile file = (IRemoteFile)element;
            return file.getParentRemoteFileSubSystem();
        }
        return null;
    }

    public String getSubSystemFactoryId(Object element) {
        IRemoteFile file = (IRemoteFile)element;
        return file.getParentRemoteFileSubSystem().getSubSystemConfiguration().getId();
    }

    public String getRemoteTypeCategory(Object element) {
        return "files";
    }

    public String getRemoteType(Object element) {
        IRemoteFile file = (IRemoteFile)element;
        if (!file.isRoot() && !file.isDirectory()) {
            return "file";
        }
        return "folder";
    }

    public String getRemoteSubType(Object element) {
        IRemoteFile file = (IRemoteFile)element;
        if (file.isFile()) {
            return file.getExtension();
        }
        if (file.isRoot()) {
            return "root";
        }
        return "subfolder";
    }

    public String getRemoteSubSubType(Object element) {
        return null;
    }

    public String getRemoteSourceType(Object element) {
        IRemoteFile file = (IRemoteFile)element;
        String srcType = null;
        if (file.isFile()) {
            srcType = file.getExtension();
            if (srcType == null) {
                srcType = "blank";
            } else if (srcType.length() == 0) {
                srcType = "null";
            }
        }
        return srcType;
    }

    public boolean refreshRemoteObject(Object oldElement, Object newElement) {
        return oldElement instanceof RemoteFile;
    }

    public Object getRemoteParent(Shell shell, Object element) throws Exception {
        return ((IRemoteFile)element).getParentRemoteFile();
    }

    public String[] getRemoteParentNamesInUse(Shell shell, Object element) throws Exception {
        String[] names = EMPTY_STRING_LIST;
        IRemoteFile file = (IRemoteFile)element;
        String parentName = file.getParentPath();
        if (parentName == null) {
            return names;
        }
        Object[] children = this.getChildren(file.getParentRemoteFile());
        if (children == null || children.length == 0) {
            return names;
        }
        names = new String[children.length];
        int idx = 0;
        while (idx < names.length) {
            names[idx] = ((IRemoteFile)children[idx]).getName();
            ++idx;
        }
        return names;
    }

    public boolean handleDoubleClick(Object element) {
        IRemoteFile remoteFile = (IRemoteFile)element;
        if (!remoteFile.canRead()) {
            return false;
        }
        if (!remoteFile.isArchive() || !remoteFile.getParentRemoteFileSubSystem().getParentRemoteFileSubSystemFactory().supportsArchiveManagement()) {
            block8: {
                ISystemEditableRemoteObject editable = this.getEditableRemoteObject(remoteFile);
                if (editable != null) {
                    try {
                        if (editable.checkOpenInEditor() != 0) {
                            editable.open(this.getShell());
                            break block8;
                        }
                        editable.setLocalResourceProperties();
                        editable.openEditor();
                    }
                    catch (Exception exception) {}
                } else if (remoteFile.isDirectory()) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean canEdit(Object element) {
        IRemoteFile remoteFile = (IRemoteFile)element;
        if (remoteFile.isFile()) {
            return remoteFile.canRead();
        }
        return false;
    }

    public ISystemEditableRemoteObject getEditableRemoteObject(Object element) {
        RemoteFile remoteFile = (RemoteFile)element;
        if (remoteFile.isFile()) {
            try {
                SystemIFileProperties properties;
                Object obj;
                IFile file = this.getCachedCopy((IRemoteFile)remoteFile);
                if (file != null && (obj = (properties = new SystemIFileProperties((IResource)file)).getRemoteFileObject()) != null && obj instanceof ISystemEditableRemoteObject) {
                    ISystemEditableRemoteObject rmtObj = (ISystemEditableRemoteObject)obj;
                    IAdaptable rmtFile = rmtObj.getRemoteObject();
                    boolean cfr_ignored_0 = rmtFile instanceof IRemoteFile;
                    return rmtObj;
                }
                return new SystemEditableRemoteFile((IRemoteFile)remoteFile);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public IFile getCachedCopy(IRemoteFile remoteFile) throws SystemMessageException {
        IResource replica;
        if (SystemRemoteEditManager.getDefault().doesRemoteEditProjectExist() && (replica = UniversalFileTransferUtility.getTempFileFor(remoteFile)) != null && replica.exists()) {
            return (IFile)replica;
        }
        return null;
    }

    public String getFilterStringFor(Object object) {
        if (object instanceof IRemoteFile) {
            IRemoteFile remoteFile = (IRemoteFile)object;
            if (remoteFile.isDirectory()) {
                return String.valueOf(remoteFile.getAbsolutePath()) + remoteFile.getSeparator() + "*";
            }
            return remoteFile.getAbsolutePath();
        }
        return null;
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (target instanceof IRemoteFile) {
            IRemoteFile tgt = (IRemoteFile)target;
            String inName = name.toLowerCase();
            if (inName.equals("classification")) {
                String classification = tgt.getClassification();
                if (classification != null) {
                    return StringCompare.compare((String)value, (String)classification, (boolean)true);
                }
            } else {
                if (inName.equals("name")) {
                    boolean caseSensitive = tgt.getParentRemoteFileSubSystem().isCaseSensitive();
                    String tgtName = this.getName(target);
                    String val = value;
                    if (!caseSensitive) {
                        tgtName = tgtName.toLowerCase();
                        val = val.toLowerCase();
                    }
                    if (val.endsWith("*")) {
                        return tgtName.startsWith(val.substring(0, val.length() - 1));
                    }
                    return val.equals(tgtName);
                }
                if (inName.equals("absolutePath".toLowerCase())) {
                    boolean caseSensitive = tgt.getParentRemoteFileSubSystem().isCaseSensitive();
                    String tgtPath = this.getAbsoluteName(target);
                    String val = value;
                    if (!caseSensitive) {
                        tgtPath = tgtPath.toLowerCase();
                        val = val.toLowerCase();
                    }
                    if (val.endsWith("*")) {
                        return tgtPath.startsWith(val.substring(0, val.length() - 1));
                    }
                    return val.equals(tgtPath);
                }
                if (inName.equals("extension")) {
                    boolean caseSensitive = tgt.getParentRemoteFileSubSystem().isCaseSensitive();
                    String tgtExtension = tgt.getExtension();
                    if (tgtExtension == null) {
                        return false;
                    }
                    StringTokenizer st = new StringTokenizer(value, " \t\n\r\f,");
                    String val = null;
                    while (st.hasMoreTokens()) {
                        val = st.nextToken();
                        if (!caseSensitive) {
                            tgtExtension = tgtExtension.toLowerCase();
                            val = val.toLowerCase();
                        }
                        boolean match = false;
                        match = val.endsWith("*") ? tgtExtension.startsWith(val.substring(0, val.length() - 1)) : val.equals(tgtExtension);
                        if (!match) continue;
                        return true;
                    }
                    return false;
                }
                if (inName.equals("isroot")) {
                    return tgt.isRoot() && value.equals("true") || !tgt.isRoot() && value.equals("false");
                }
                if (inName.equals("isfile")) {
                    return tgt.isFile() && value.equals("true") || !tgt.isFile() && value.equals("false");
                }
                if (inName.equals("isdirectory")) {
                    return tgt.isDirectory() && value.equals("true") || !tgt.isDirectory() && value.equals("false");
                }
                if (inName.equals("ishidden")) {
                    return tgt.isHidden() && value.equals("true") || !tgt.isHidden() && value.equals("false");
                }
                if (inName.equals("canread")) {
                    return tgt.canRead() && value.equals("true") || !tgt.canRead() && value.equals("false");
                }
                if (inName.equals("canwrite")) {
                    return tgt.canWrite() && value.equals("true") || !tgt.canWrite() && value.equals("false");
                }
                if (inName.equals("isbinary")) {
                    return tgt.isBinary() && value.equals("true") || !tgt.isBinary() && value.equals("false");
                }
                if (inName.equals("istext")) {
                    return tgt.isText() && value.equals("true") || !tgt.isText() && value.equals("false");
                }
                if (inName.equals("isarchive")) {
                    return tgt.isArchive() && value.equals("true") || !tgt.isArchive() && value.equals("false");
                }
                if (inName.equals("isvirtual")) {
                    return tgt instanceof IVirtualRemoteFile && value.equals("true") || !(tgt instanceof IVirtualRemoteFile) && value.equals("false");
                }
                if (inName.equals("isexecutable")) {
                    return tgt.isExecutable() && value.equals("true") || !tgt.isExecutable() && value.equals("false");
                }
                if (inName.equals("islink")) {
                    return tgt.isLink() && value.equals("true") || !tgt.isLink() && value.equals("false");
                }
            }
        }
        return super.testAttribute(target, name, value);
    }

    public boolean supportsDeferredQueries() {
        return true;
    }

    protected SystemFetchOperation getSystemFetchOperation(Object o, IElementCollector collector) {
        return new SystemFetchOperation(null, (IAdaptable)o, (ISystemViewElementAdapter)this, collector, true);
    }

    public boolean supportsUserDefinedActions(Object object) {
        if (object instanceof IRemoteFile) {
            IRemoteFile file = (IRemoteFile)object;
            if (file instanceof IVirtualRemoteFile) {
                return false;
            }
            return this.getSubSystem(object).getSubSystemConfiguration().supportsUserDefinedActions();
        }
        return this.getSubSystem(object).getSubSystemConfiguration().supportsUserDefinedActions();
    }
}

