/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.wizards;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.rse.files.ui.FileResources;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.ISystemMessages;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.rse.ui.validators.ValidatorFileName;
import org.eclipse.rse.ui.wizards.AbstractSystemWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class SystemNewFileWizardMainPage
extends AbstractSystemWizardPage
implements ISystemMessages {
    protected String fileNameStr;
    protected Text folderName;
    protected Text connectionName;
    protected Text fileName;
    protected Combo folderNames;
    protected SystemMessage errorMessage;
    protected ISystemValidator nameValidator;
    protected IRemoteFile[] parentFolders;
    protected ISystemMessageLine msgLine;
    public String[] allnames;

    public SystemNewFileWizardMainPage(Wizard wizard, IRemoteFile[] parentFolders) {
        super((IWizard)wizard, "NewFile", FileResources.RESID_NEWFILE_PAGE1_TITLE, FileResources.RESID_NEWFILE_PAGE1_DESCRIPTION);
        this.parentFolders = parentFolders;
    }

    public Control createContents(Composite parent) {
        int nbrColumns = 2;
        Composite composite_prompts = SystemWidgetHelpers.createComposite((Composite)parent, (int)nbrColumns);
        this.connectionName = SystemWidgetHelpers.createLabeledTextField((Composite)composite_prompts, null, (String)FileResources.RESID_NEWFILE_CONNECTIONNAME_LABEL, (String)FileResources.RESID_NEWFILE_CONNECTIONNAME_TIP);
        if (this.parentFolders == null || this.parentFolders.length == 1) {
            this.folderName = SystemWidgetHelpers.createLabeledTextField((Composite)composite_prompts, null, (String)FileResources.RESID_NEWFILE_FOLDER_LABEL, (String)FileResources.RESID_NEWFILE_FOLDER_TIP);
        } else {
            this.folderNames = SystemWidgetHelpers.createLabeledReadonlyCombo((Composite)composite_prompts, null, (String)FileResources.RESID_NEWFILE_FOLDER_LABEL, (String)FileResources.RESID_NEWFILE_FOLDER_TIP);
        }
        this.fileName = SystemWidgetHelpers.createLabeledTextField((Composite)composite_prompts, null, (String)FileResources.RESID_NEWFILE_NAME_LABEL, (String)FileResources.RESID_NEWFILE_NAME_TOOLTIP);
        this.initializeInput();
        this.fileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemNewFileWizardMainPage.this.validateNameInput();
            }
        });
        SystemWidgetHelpers.setCompositeHelp((Composite)composite_prompts, (String)"org.eclipse.rse.ui.ufwf0000");
        return composite_prompts;
    }

    protected Control getInitialFocusControl() {
        return this.fileName;
    }

    protected void initializeInput() {
        this.connectionName.setEditable(false);
        this.nameValidator = new ValidatorFileName();
        if (this.parentFolders == null || this.parentFolders.length == 0) {
            this.folderName.setEditable(false);
            this.fileName.setEditable(false);
            this.setPageComplete(false);
            return;
        }
        IRemoteFileSubSystem rfss = this.parentFolders[0].getParentRemoteFileSubSystem();
        this.connectionName.setText(rfss.getHostAliasName());
        this.connectionName.setToolTipText(rfss.getHost().getHostName());
        if (this.folderName != null) {
            this.folderName.setText(this.parentFolders[0].getAbsolutePath());
            this.folderName.setEditable(false);
        } else {
            String[] names = new String[this.parentFolders.length];
            int idx = 0;
            while (idx < names.length) {
                names[idx] = this.parentFolders[idx].getAbsolutePath();
                ++idx;
            }
            this.folderNames.setItems(names);
            this.folderNames.select(0);
        }
    }

    protected SystemMessage validateNameInput() {
        this.errorMessage = null;
        this.clearErrorMessage();
        if (this.nameValidator != null) {
            this.errorMessage = this.nameValidator.validate(this.fileName.getText());
        }
        if (this.errorMessage != null) {
            this.setErrorMessage(this.errorMessage);
        }
        this.setPageComplete(this.errorMessage == null);
        return this.errorMessage;
    }

    public boolean performFinish() {
        return true;
    }

    public String getfileName() {
        return this.fileName.getText();
    }

    public IRemoteFile getParentFolder() {
        if (this.folderName != null) {
            return this.parentFolders[0];
        }
        int selIdx = this.folderNames.getSelectionIndex();
        if (selIdx == -1) {
            selIdx = 0;
        }
        return this.parentFolders[selIdx];
    }

    public boolean isPageComplete() {
        return this.errorMessage == null && this.fileName.getText().trim().length() > 0;
    }
}

