/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.rse.model.IHost;
import org.eclipse.rse.model.ISystemRegistry;
import org.eclipse.rse.ui.ISystemPreferencesConstants;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.propertypages.RemoteSystemsPreferencePage;

public class SystemPreferencesManager
implements ISystemPreferencesConstants {
    private static SystemPreferencesManager inst;
    private Hashtable userIdsPerKey = null;

    protected SystemPreferencesManager() {
    }

    public static SystemPreferencesManager getPreferencesManager() {
        if (inst == null) {
            inst = new SystemPreferencesManager();
        }
        return inst;
    }

    public String[] getActiveProfileNames() {
        return RemoteSystemsPreferencePage.getActiveProfiles();
    }

    public void renameActiveProfile(String oldName, String newName) {
        String[] names = this.getActiveProfileNames();
        int matchPos = -1;
        int idx = 0;
        while (matchPos == -1 && idx < names.length) {
            if (names[idx].equalsIgnoreCase(oldName)) {
                matchPos = idx;
                names[idx] = newName;
            }
            ++idx;
        }
        if (matchPos >= 0) {
            RemoteSystemsPreferencePage.setActiveProfiles(names);
        }
    }

    public void deleteActiveProfile(String oldName) {
        String[] names = this.getActiveProfileNames();
        int matchPos = -1;
        int idx = 0;
        while (matchPos == -1 && idx < names.length) {
            if (names[idx].equalsIgnoreCase(oldName)) {
                matchPos = idx;
                names[idx] = null;
            }
            ++idx;
        }
        if (matchPos >= 0) {
            RemoteSystemsPreferencePage.setActiveProfiles(names);
        }
    }

    public void addActiveProfile(String newName) {
        String[] names = this.getActiveProfileNames();
        String[] newNames = new String[names.length + 1];
        int idx = 0;
        while (idx < names.length) {
            newNames[idx] = names[idx];
            ++idx;
        }
        newNames[names.length] = newName;
        RemoteSystemsPreferencePage.setActiveProfiles(newNames);
    }

    public int getActiveProfilePosition(String profileName) {
        String[] names = this.getActiveProfileNames();
        int matchPos = -1;
        int idx = 0;
        while (matchPos == -1 && idx < names.length) {
            if (names[idx].equalsIgnoreCase(profileName)) {
                matchPos = idx;
            }
            ++idx;
        }
        return matchPos;
    }

    public String[] getConnectionNamesOrder(String profileName) {
        String[] allConnectionNamesOrder = RemoteSystemsPreferencePage.getConnectionNamesOrder();
        profileName = String.valueOf(profileName) + ".";
        int profileNameLength = profileName.length();
        Vector<String> v = new Vector<String>();
        int idx = 0;
        while (idx < allConnectionNamesOrder.length) {
            if (allConnectionNamesOrder[idx].startsWith(profileName)) {
                v.addElement(allConnectionNamesOrder[idx].substring(profileNameLength));
            }
            ++idx;
        }
        String[] names = new String[v.size()];
        int idx2 = 0;
        while (idx2 < names.length) {
            names[idx2] = (String)v.elementAt(idx2);
            ++idx2;
        }
        return names;
    }

    public String[] getConnectionNamesOrder(IHost[] realityConnectionList, String profileName) {
        if (realityConnectionList == null) {
            return new String[0];
        }
        String[] realityNames = new String[realityConnectionList.length];
        int idx = 0;
        while (idx < realityConnectionList.length) {
            realityNames[idx] = realityConnectionList[idx].getAliasName();
            ++idx;
        }
        String[] names = this.resolveOrderPreferenceVersusReality(realityNames, this.getConnectionNamesOrder(profileName));
        return names;
    }

    public void setConnectionNamesOrder(String[] names) {
        boolean debug = false;
        if (debug) {
            int idx = 0;
            while (idx < names.length) {
                System.out.println("   '" + names[idx] + "'");
                ++idx;
            }
            System.out.println();
        }
        RemoteSystemsPreferencePage.setConnectionNamesOrder(names);
    }

    public void setConnectionNamesOrder() {
        ISystemRegistry sr = RSEUIPlugin.getTheSystemRegistry();
        IHost[] conns = sr.getHosts();
        String[] names = new String[conns.length];
        int idx = 0;
        while (idx < names.length) {
            names[idx] = String.valueOf(conns[idx].getSystemProfileName()) + "." + conns[idx].getAliasName();
            ++idx;
        }
        this.setConnectionNamesOrder(names);
    }

    public String[] resolveOrderPreferenceVersusReality(String[] reality, String[] ordered) {
        Vector<String> finalList = new Vector<String>();
        int idx = 0;
        while (idx < ordered.length) {
            if (this.find(reality, ordered[idx])) {
                finalList.addElement(ordered[idx]);
            }
            ++idx;
        }
        idx = 0;
        while (idx < reality.length) {
            if (!this.find(ordered, reality[idx])) {
                finalList.addElement(reality[idx]);
            }
            ++idx;
        }
        String[] resolved = new String[finalList.size()];
        int idx2 = 0;
        while (idx2 < finalList.size()) {
            resolved[idx2] = (String)finalList.elementAt(idx2);
            ++idx2;
        }
        return resolved;
    }

    private boolean find(String[] haystack, String needle) {
        int idx = 0;
        while (idx < haystack.length) {
            if (haystack[idx].equals(needle)) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    public String getDefaultUserId(String systemType) {
        return RemoteSystemsPreferencePage.getUserIdPreference(systemType);
    }

    public void setDefaultUserId(String systemType, String userId) {
        RemoteSystemsPreferencePage.setUserIdPreference(systemType, userId);
    }

    public String getUserId(String key) {
        String uid = null;
        this.userIdsPerKey = this.getUserIdsPerKey();
        uid = (String)this.userIdsPerKey.get(key);
        return uid;
    }

    public void setUserId(String key, String userId) {
        if (key != null && userId != null) {
            this.userIdsPerKey = this.getUserIdsPerKey();
            this.userIdsPerKey.put(key, userId);
            this.setUserIdsPerKey();
        }
    }

    public void clearUserId(String key) {
        this.userIdsPerKey = this.getUserIdsPerKey();
        if (this.userIdsPerKey.containsKey(key)) {
            this.userIdsPerKey.remove(key);
            this.setUserIdsPerKey();
        }
    }

    private Hashtable getUserIdsPerKey() {
        if (this.userIdsPerKey == null) {
            this.userIdsPerKey = RemoteSystemsPreferencePage.getUserIdsPerKey();
        }
        return this.userIdsPerKey;
    }

    private void setUserIdsPerKey() {
        RemoteSystemsPreferencePage.setUserIdsPerKey(this.userIdsPerKey);
    }

    public boolean getQualifyConnectionNames() {
        return RemoteSystemsPreferencePage.getQualifyConnectionNamesPreference();
    }

    public boolean getShowFilterPools() {
        return RemoteSystemsPreferencePage.getShowFilterPoolsPreference();
    }

    public boolean getRememberState() {
        return RemoteSystemsPreferencePage.getRememberStatePreference();
    }

    public boolean getShowNewConnectionPrompt() {
        return RemoteSystemsPreferencePage.getShowNewConnectionPromptPreference();
    }

    public boolean getCascadeUserActions() {
        return RemoteSystemsPreferencePage.getCascadeUserActionsPreference();
    }

    public boolean getVerifyConnection() {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        store.setDefault("org.eclipse.rse.preferences.verify.connection", true);
        return store.getBoolean("org.eclipse.rse.preferences.verify.connection");
    }

    public void setQualifyConnectionNames(boolean set) {
        RemoteSystemsPreferencePage.setQualifyConnectionNamesPreference(set);
    }

    public void setShowFilterPools(boolean show) {
        boolean prevValue = this.getShowFilterPools();
        RemoteSystemsPreferencePage.setShowFilterPoolsPreference(show);
        if (show != prevValue) {
            RSEUIPlugin.getTheSystemRegistry().setShowFilterPools(show);
        }
    }

    public void setRememberState(boolean remember) {
        RemoteSystemsPreferencePage.setRememberStatePreference(remember);
    }

    public void setShowNewConnectionPrompt(boolean show) {
        RemoteSystemsPreferencePage.setShowNewConnectionPromptPreference(show);
    }

    public void setCascadeUserActions(boolean cascade) {
        RemoteSystemsPreferencePage.setCascadeUserActionsPreference(cascade);
    }

    public void setVerifyConnection(boolean verify) {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        store.setValue("org.eclipse.rse.preferences.verify.connection", verify);
        RSEUIPlugin.getDefault().savePluginPreferences();
    }

    public String[] getFolderHistory() {
        return RemoteSystemsPreferencePage.getFolderHistory();
    }

    public void setFolderHistory(String[] history) {
        RemoteSystemsPreferencePage.setFolderHistory(history);
    }

    public String[] getWidgetHistory(String key) {
        return RemoteSystemsPreferencePage.getWidgetHistory(key);
    }

    public void setWidgetHistory(String key, String[] history) {
        RemoteSystemsPreferencePage.setWidgetHistory(key, history);
    }
}

