/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.SystemRemoteObjectMatcher;
import org.eclipse.rse.ui.propertypages.SystemRemotePropertyPageNode;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.internal.dialogs.IPropertyPageContributor;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;
import org.osgi.framework.Bundle;

public class SystemPropertyPageExtension
implements IPropertyPageContributor {
    private String name;
    private String id;
    private ImageDescriptor image = null;
    private SystemRemoteObjectMatcher matcher = null;
    private IConfigurationElement element = null;
    private IWorkbenchPropertyPage object = null;
    private boolean atTop = false;
    private HashMap filterProperties;
    private static final String TAG_FILTER = "filter";
    static /* synthetic */ Class class$0;

    public SystemPropertyPageExtension(IConfigurationElement element) {
        this.element = element;
        this.id = element.getAttribute("id");
        this.name = element.getAttribute("name");
        this.image = this.getPluginImage(element, element.getAttribute("icon"));
        String sAtTop = element.getAttribute("first");
        if (sAtTop != null && sAtTop.equals("1")) {
            this.atTop = true;
        }
        String categoryfilter = element.getAttribute("typecategoryfilter");
        String namefilter = element.getAttribute("namefilter");
        String typefilter = element.getAttribute("typefilter");
        String subtypefilter = element.getAttribute("subtypefilter");
        String subsubtypefilter = element.getAttribute("subsubtypefilter");
        String subsystemfilter = element.getAttribute("subsystemconfigurationid");
        String subsystemCategoryFilter = element.getAttribute("subsystemconfigurationCategory");
        String systypes = element.getAttribute("systemTypes");
        this.filterProperties = null;
        IConfigurationElement[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            this.processChildElement(children[i]);
            ++i;
        }
        this.matcher = new SystemRemoteObjectMatcher(subsystemfilter, subsystemCategoryFilter, categoryfilter, systypes, namefilter, typefilter, subtypefilter, subsubtypefilter);
    }

    private void processChildElement(IConfigurationElement element) {
        String tag = element.getName();
        if (tag.equals(TAG_FILTER)) {
            String key = element.getAttribute("name");
            String value = element.getAttribute("value");
            if (key == null || value == null) {
                return;
            }
            if (this.filterProperties == null) {
                this.filterProperties = new HashMap();
            }
            this.filterProperties.put(key, value);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public ImageDescriptor getImage() {
        return this.image;
    }

    public boolean isAtTop() {
        return this.atTop;
    }

    public void setAtTop(boolean atTop) {
        this.atTop = atTop;
    }

    public String getCategoryFilter() {
        return this.matcher.getCategoryFilter();
    }

    public String getNameFilter() {
        return this.matcher.getNameFilter();
    }

    public String getTypeFilter() {
        return this.matcher.getTypeFilter();
    }

    public String getSubTypeFilter() {
        return this.matcher.getSubTypeFilter();
    }

    public String getSubSubTypeFilter() {
        return this.matcher.getSubSubTypeFilter();
    }

    public String getSubSystemFactoryId() {
        return this.matcher.getSubSystemFactoryId();
    }

    public String getSubSystemFactoryCategoryFilter() {
        return this.matcher.getSubSystemFactoryCategoryFilter();
    }

    public String getSystemTypesFilter() {
        return this.matcher.getSystemTypesFilter();
    }

    protected ImageDescriptor getPluginImage(IConfigurationElement element, String fileName) {
        URL path = this.getBundle(element).getEntry("/");
        URL fullPathString = null;
        try {
            fullPathString = new URL(path, fileName);
            return ImageDescriptor.createFromURL((URL)fullPathString);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    protected Bundle getBundle(IConfigurationElement element) {
        String nameSpace = element.getDeclaringExtension().getNamespace();
        return Platform.getBundle((String)nameSpace);
    }

    public boolean appliesTo(ISystemRemoteElementAdapter adapter, Object element) {
        boolean matches = this.matcher.appliesTo(adapter, element);
        if (!matches) {
            return false;
        }
        if (this.filterProperties == null) {
            return true;
        }
        IActionFilter filter = null;
        Object testObject = element;
        if (testObject instanceof IActionFilter) {
            filter = (IActionFilter)testObject;
        } else if (testObject instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)testObject;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.IActionFilter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            filter = (IActionFilter)iAdaptable.getAdapter((Class)clazz);
        }
        if (filter != null) {
            return this.testCustom(testObject, filter);
        }
        return true;
    }

    private boolean testCustom(Object object, IActionFilter filter) {
        if (this.filterProperties == null) {
            return false;
        }
        Iterator iter = this.filterProperties.keySet().iterator();
        while (iter.hasNext()) {
            String value;
            String key = (String)iter.next();
            if (filter.testAttribute(object, key, value = (String)this.filterProperties.get(key))) continue;
            return false;
        }
        return true;
    }

    public IWorkbenchPropertyPage getPropertyPage() {
        try {
            this.object = (IWorkbenchPropertyPage)this.element.createExecutableExtension("class");
        }
        catch (Exception exc) {
            SystemBasePlugin.logError("Unable to start remote property page extension " + this.id, exc);
        }
        return this.object;
    }

    public String toString() {
        return this.id;
    }

    public boolean contributePropertyPages(PropertyPageManager manager, Object object) {
        boolean added = false;
        SystemRemotePropertyPageNode node = new SystemRemotePropertyPageNode(this, object);
        manager.addToRoot((IPreferenceNode)node);
        return added;
    }

    public boolean isApplicableTo(Object object) {
        return true;
    }

    public IWorkbenchPropertyPage createPage(Object element) {
        IWorkbenchPropertyPage ppage = this.getPropertyPage();
        if (ppage != null) {
            if (element instanceof IAdaptable) {
                ppage.setElement((IAdaptable)element);
            }
            ppage.setTitle(this.name);
        }
        return ppage;
    }

    public boolean canAdapt() {
        return false;
    }
}

