/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core;

import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.model.IHost;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;

public class SystemRemoteObjectMatcher {
    public static final String STAR_SYMBOL = "%ast.";
    public static final String STAR_SYMBOL2 = "%ast;";
    public static final int STAR_SYMBOL_LEN = 5;
    private String categoryfilter;
    private String subsystemfilter;
    private String subsystemCategoryFilter;
    private String systypesfilter;
    private String namefilter;
    private String typefilter;
    private String subtypefilter;
    private String subsubtypefilter;
    private String categoryfilterpart;
    private String subsystemfilterpart;
    private String subsystemCategoryFilterpart;
    private String namefilterpart;
    private String typefilterpart;
    private String subtypefilterpart;
    private String subsubtypefilterpart;
    private boolean allSSFCategories = false;
    private boolean allCategories = false;
    private boolean allNames = false;
    private boolean allTypes = false;
    private boolean allSubTypes = false;
    private boolean allSubSubTypes = false;
    private boolean allSubSystems = false;
    private boolean allSystemTypes = false;
    private boolean genericSSFCategoriesStart = false;
    private boolean genericCategoriesStart = false;
    private boolean genericNamesStart = false;
    private boolean genericTypesStart = false;
    private boolean genericSubTypesStart = false;
    private boolean genericSubSubTypesStart = false;
    private boolean genericSubSystemStart = false;
    private boolean genericSSFCategoriesEnd = false;
    private boolean genericCategoriesEnd = false;
    private boolean genericNamesEnd = false;
    private boolean genericTypesEnd = false;
    private boolean genericSubTypesEnd = false;
    private boolean genericSubSubTypesEnd = false;
    private boolean genericSubSystemEnd = false;

    public SystemRemoteObjectMatcher(String subsystemFactoryId, String categoryFilter, String nameFilter, String typeFilter, String subtypeFilter, String subsubtypeFilter) {
        this(subsystemFactoryId, null, categoryFilter, null, nameFilter, typeFilter, subtypeFilter, subsubtypeFilter);
    }

    public SystemRemoteObjectMatcher(String subsystemFactoryId, String subsystemFactoryCategoryFilter, String categoryFilter, String systemTypes, String nameFilter, String typeFilter, String subtypeFilter, String subsubtypeFilter) {
        this.subsystemCategoryFilter = subsystemFactoryCategoryFilter;
        this.subsystemfilter = subsystemFactoryId;
        this.systypesfilter = systemTypes;
        this.categoryfilter = categoryFilter;
        this.namefilter = nameFilter;
        this.typefilter = typeFilter;
        this.subtypefilter = subtypeFilter;
        this.subsubtypefilter = subsubtypeFilter;
        if (this.systypesfilter == null || this.systypesfilter.length() == 0) {
            this.systypesfilter = "*";
        }
        if (this.subsystemCategoryFilter == null || this.subsystemCategoryFilter.length() == 0) {
            this.subsystemCategoryFilter = "*";
        }
        if (this.categoryfilter == null) {
            this.categoryfilter = "*";
        }
        if (this.namefilter == null) {
            this.namefilter = "*";
        }
        if (this.typefilter == null) {
            this.typefilter = "*";
        }
        if (this.subtypefilter == null) {
            this.subtypefilter = "*";
        }
        if (this.subsubtypefilter == null) {
            this.subsubtypefilter = "*";
        }
        if (this.subsystemfilter == null) {
            this.subsystemfilter = "*";
        }
        this.allSSFCategories = this.subsystemCategoryFilter.equals("*");
        this.allCategories = this.categoryfilter.equals("*");
        this.allSystemTypes = this.systypesfilter.equals("*");
        this.allNames = this.namefilter.equals("*");
        this.allTypes = this.typefilter.equals("*");
        this.allSubTypes = this.subtypefilter.equals("*");
        this.allSubSubTypes = this.subsubtypefilter.equals("*");
        this.allSubSystems = this.subsystemfilter.equals("*");
        this.genericSSFCategoriesStart = !this.allSSFCategories && this.startsWithAsterisk(this.subsystemCategoryFilter);
        this.genericCategoriesStart = !this.allCategories && this.startsWithAsterisk(this.categoryfilter);
        this.genericNamesStart = !this.allNames && this.startsWithAsterisk(this.namefilter);
        this.genericTypesStart = !this.allTypes && this.startsWithAsterisk(this.typefilter);
        this.genericSubTypesStart = !this.allSubTypes && this.startsWithAsterisk(this.subtypefilter);
        this.genericSubSubTypesStart = !this.allSubSubTypes && this.startsWithAsterisk(this.subsubtypefilter);
        this.genericSubSystemStart = !this.allSubSystems && this.startsWithAsterisk(this.subsystemfilter);
        this.genericSSFCategoriesEnd = !this.allSSFCategories && this.endsWithAsterisk(this.subsystemCategoryFilter);
        this.genericCategoriesEnd = !this.allCategories && this.endsWithAsterisk(this.categoryfilter);
        this.genericNamesEnd = !this.allNames && this.endsWithAsterisk(this.namefilter);
        this.genericTypesEnd = !this.allTypes && this.endsWithAsterisk(this.typefilter);
        this.genericSubTypesEnd = !this.allSubTypes && this.endsWithAsterisk(this.subtypefilter);
        this.genericSubSubTypesEnd = !this.allSubSubTypes && this.endsWithAsterisk(this.subsubtypefilter);
        boolean bl = this.genericSubSystemEnd = !this.allSubSystems && this.endsWithAsterisk(this.subsystemfilter);
        if (this.genericSSFCategoriesStart) {
            this.subsystemCategoryFilterpart = this.stripLeadingAsterisk(this.subsystemCategoryFilter);
        }
        if (this.genericCategoriesStart) {
            this.categoryfilterpart = this.stripLeadingAsterisk(this.categoryfilter);
        }
        if (this.genericNamesStart) {
            this.namefilterpart = this.stripLeadingAsterisk(this.namefilter);
        }
        if (this.genericTypesStart) {
            this.typefilterpart = this.stripLeadingAsterisk(this.typefilter);
        }
        if (this.genericSubTypesStart) {
            this.subtypefilterpart = this.stripLeadingAsterisk(this.subtypefilter);
        }
        if (this.genericSubSubTypesStart) {
            this.subsubtypefilterpart = this.stripLeadingAsterisk(this.subsubtypefilter);
        }
        if (this.genericSubSystemStart) {
            this.subsystemfilterpart = this.stripLeadingAsterisk(this.subsystemfilter);
        }
        if (this.genericSSFCategoriesEnd) {
            this.subsystemCategoryFilterpart = this.stripTrailingAsterisk(this.subsystemCategoryFilter);
        }
        if (this.genericCategoriesEnd) {
            this.categoryfilterpart = this.stripTrailingAsterisk(this.categoryfilter);
        }
        if (this.genericNamesEnd) {
            this.namefilterpart = this.stripTrailingAsterisk(this.namefilter);
        }
        if (this.genericTypesEnd) {
            this.typefilterpart = this.stripTrailingAsterisk(this.typefilter);
        }
        if (this.genericSubTypesEnd) {
            this.subtypefilterpart = this.stripTrailingAsterisk(this.subtypefilter);
        }
        if (this.genericSubSubTypesEnd) {
            this.subsubtypefilterpart = this.stripTrailingAsterisk(this.subsubtypefilter);
        }
        if (this.genericSubSystemEnd) {
            this.subsystemfilterpart = this.stripTrailingAsterisk(this.subsystemfilter);
        }
        this.subsystemCategoryFilter = this.resolveSymbols(this.subsystemCategoryFilter);
        this.categoryfilter = this.resolveSymbols(this.categoryfilter);
        this.namefilter = this.resolveSymbols(this.namefilter);
        this.typefilter = this.resolveSymbols(this.typefilter);
        this.subtypefilter = this.resolveSymbols(this.subtypefilter);
        this.subsubtypefilter = this.resolveSymbols(this.subsubtypefilter);
        this.subsystemfilter = this.resolveSymbols(this.subsystemfilter);
    }

    protected boolean startsWithAsterisk(String name) {
        return name.startsWith("*");
    }

    protected boolean endsWithAsterisk(String name) {
        return name.endsWith("*");
    }

    protected String stripLeadingAsterisk(String name) {
        return this.resolveSymbols(name.substring(1));
    }

    protected String stripTrailingAsterisk(String name) {
        return this.resolveSymbols(name.substring(0, name.length() - 1));
    }

    protected String resolveSymbols(String name) {
        boolean hasSymbols;
        if (name.startsWith("%%ast.") || name.startsWith("%%ast;")) {
            name = name.substring(1);
        }
        int symbolLength = 5;
        int symbolIndex = name.indexOf(STAR_SYMBOL);
        if (symbolIndex == -1) {
            symbolIndex = name.indexOf(STAR_SYMBOL2);
        }
        boolean hadSymbols = hasSymbols = symbolIndex != -1;
        boolean debug = false;
        if (hasSymbols && debug) {
            System.out.println("Before: " + name);
        }
        while (hasSymbols) {
            String part1;
            if (symbolIndex == 0) {
                name = name.length() > symbolLength ? "*" + name.substring(symbolLength) : "*";
            } else if (symbolIndex + symbolLength < name.length()) {
                part1 = name.substring(0, symbolIndex);
                String part2 = name.substring(symbolIndex + symbolLength);
                name = String.valueOf(part1) + "*" + part2;
            } else {
                part1 = name.substring(0, symbolIndex);
                name = String.valueOf(part1) + "*";
            }
            symbolIndex = name.indexOf(STAR_SYMBOL);
            if (symbolIndex == -1) {
                symbolIndex = name.indexOf(STAR_SYMBOL2);
            }
            boolean bl = hasSymbols = symbolIndex != -1;
        }
        if (hadSymbols && debug) {
            System.out.println("After: " + name);
        }
        return name;
    }

    public String getSubSystemFactoryCategoryFilter() {
        return this.subsystemCategoryFilter;
    }

    public String getSystemTypesFilter() {
        return this.systypesfilter;
    }

    public String getCategoryFilter() {
        return this.categoryfilter;
    }

    public String getNameFilter() {
        return this.namefilter;
    }

    public String getTypeFilter() {
        return this.typefilter;
    }

    public String getSubTypeFilter() {
        return this.subtypefilter;
    }

    public String getSubSubTypeFilter() {
        return this.subsubtypefilter;
    }

    public String getSubSystemFactoryId() {
        return this.subsystemfilter;
    }

    public boolean appliesTo(ISystemRemoteElementAdapter adapter, Object element) {
        boolean applies = true;
        boolean subsystemMatch = true;
        if (!this.allSubSystems) {
            String subsystem = adapter.getSubSystemFactoryId(element);
            if (subsystem == null) {
                subsystemMatch = false;
            } else if (!this.genericSubSystemStart && !this.genericSubSystemEnd) {
                subsystemMatch = subsystem.equals(this.subsystemfilter);
            } else if (this.genericSubSystemStart) {
                subsystemMatch = subsystem.endsWith(this.subsystemfilterpart);
            } else if (this.genericSubSystemEnd) {
                subsystemMatch = subsystem.startsWith(this.subsystemfilterpart);
            }
        }
        if (!subsystemMatch) {
            return false;
        }
        boolean ssfCategoryMatch = true;
        if (!this.allSSFCategories) {
            ISubSystem subsystem = adapter.getSubSystem(element);
            if (subsystem == null) {
                ssfCategoryMatch = true;
            } else {
                String ssfCategory = subsystem.getSubSystemConfiguration().getCategory();
                if (ssfCategory == null) {
                    ssfCategory = "";
                }
                if (!this.genericSSFCategoriesStart && !this.genericSSFCategoriesEnd) {
                    ssfCategoryMatch = ssfCategory.equals(this.subsystemCategoryFilter);
                } else if (this.genericSSFCategoriesStart) {
                    ssfCategoryMatch = ssfCategory.endsWith(this.subsystemCategoryFilterpart);
                } else if (this.genericSSFCategoriesEnd) {
                    ssfCategoryMatch = ssfCategory.startsWith(this.subsystemCategoryFilterpart);
                }
            }
        }
        if (!ssfCategoryMatch) {
            return false;
        }
        boolean systemTypesMatch = true;
        if (!this.allSystemTypes) {
            ISubSystem subsystem = adapter.getSubSystem(element);
            String[] values = this.tokenize(this.systypesfilter);
            if (subsystem == null) {
                if (!(element instanceof IHost)) {
                    systemTypesMatch = false;
                } else {
                    String connSysType = ((IHost)element).getSystemType();
                    systemTypesMatch = false;
                    int idx = 0;
                    while (!systemTypesMatch && idx < values.length) {
                        if (connSysType.equals(values[idx])) {
                            systemTypesMatch = true;
                        }
                        ++idx;
                    }
                }
            } else {
                systemTypesMatch = false;
                int idx = 0;
                while (!systemTypesMatch && idx < values.length) {
                    if (subsystem.getHost().getSystemType().equals(values[idx])) {
                        systemTypesMatch = true;
                    }
                    ++idx;
                }
            }
        }
        if (!systemTypesMatch) {
            return false;
        }
        boolean nameMatch = true;
        boolean caseSensitive = false;
        ISubSystem subsystem = adapter.getSubSystem(element);
        if (subsystem != null) {
            caseSensitive = subsystem.getSubSystemConfiguration().isCaseSensitive();
        }
        if (!this.allNames) {
            String name = adapter.getName(element);
            String theNameFilter = this.namefilter;
            String theNameFilterPart = this.namefilterpart;
            if (name == null) {
                nameMatch = false;
            } else {
                if (!caseSensitive) {
                    name = name.toLowerCase();
                    theNameFilter = theNameFilter.toLowerCase();
                    theNameFilterPart = theNameFilterPart.toLowerCase();
                }
                if (!this.genericNamesStart && !this.genericNamesEnd) {
                    nameMatch = name.equals(theNameFilter);
                } else if (this.genericNamesStart) {
                    nameMatch = name.endsWith(theNameFilterPart);
                } else if (this.genericNamesEnd) {
                    nameMatch = name.startsWith(theNameFilterPart);
                }
            }
        }
        if (!nameMatch) {
            return false;
        }
        boolean catMatch = true;
        if (!this.allCategories) {
            String cat = adapter.getRemoteTypeCategory(element);
            if (cat == null) {
                catMatch = false;
            } else if (!this.genericCategoriesStart && !this.genericCategoriesEnd) {
                catMatch = cat.equals(this.categoryfilter);
            } else if (this.genericCategoriesStart) {
                catMatch = cat.endsWith(this.categoryfilterpart);
            } else if (this.genericCategoriesEnd) {
                catMatch = cat.startsWith(this.categoryfilterpart);
            }
        }
        if (!catMatch) {
            return false;
        }
        boolean typeMatch = true;
        if (!this.allTypes) {
            String type = adapter.getRemoteType(element);
            if (type == null) {
                typeMatch = false;
            } else if (!this.genericTypesStart && !this.genericTypesEnd) {
                typeMatch = type.equals(this.typefilter);
            } else if (this.genericTypesStart) {
                typeMatch = type.endsWith(this.typefilterpart);
            } else if (this.genericTypesEnd) {
                typeMatch = type.startsWith(this.typefilterpart);
            }
        }
        if (!typeMatch) {
            return false;
        }
        boolean subtypeMatch = true;
        if (!this.allSubTypes) {
            String subtype = adapter.getRemoteSubType(element);
            if (subtype == null) {
                subtypeMatch = false;
            } else if (!this.genericSubTypesStart && !this.genericSubTypesEnd) {
                subtypeMatch = subtype.equals(this.subtypefilter);
            } else if (this.genericSubTypesStart) {
                subtypeMatch = subtype.endsWith(this.subtypefilterpart);
            } else if (this.genericSubTypesEnd) {
                subtypeMatch = subtype.startsWith(this.subtypefilterpart);
            }
        }
        if (!subtypeMatch) {
            return false;
        }
        boolean subsubtypeMatch = true;
        if (!this.allSubSubTypes) {
            String subsubtype = adapter.getRemoteSubSubType(element);
            if (subsubtype == null) {
                subsubtypeMatch = false;
            } else if (!this.genericSubSubTypesStart && !this.genericSubSubTypesEnd) {
                subsubtypeMatch = subsubtype.equals(this.subsubtypefilter);
            } else if (this.genericSubSubTypesStart) {
                subsubtypeMatch = subsubtype.endsWith(this.subsubtypefilterpart);
            } else if (this.genericSubSubTypesEnd) {
                subsubtypeMatch = subsubtype.startsWith(this.subsubtypefilterpart);
            }
        }
        if (!subsubtypeMatch) {
            return false;
        }
        return applies;
    }

    private String[] tokenize(String input) {
        StringTokenizer tokens = new StringTokenizer(input, ";");
        Vector<String> v = new Vector<String>();
        while (tokens.hasMoreTokens()) {
            v.addElement(tokens.nextToken());
        }
        String[] stringArray = new String[v.size()];
        int idx = 0;
        while (idx < v.size()) {
            stringArray[idx] = (String)v.elementAt(idx);
            ++idx;
        }
        return stringArray;
    }
}

