/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core;

import java.io.File;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.SystemResourceConstants;
import org.eclipse.rse.core.SystemResourceHelpers;
import org.eclipse.rse.core.SystemResourceListener;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.filters.ISystemFilterPool;
import org.eclipse.rse.filters.ISystemFilterPoolManager;
import org.eclipse.rse.internal.model.SystemProfileManager;
import org.eclipse.rse.model.IHost;
import org.eclipse.rse.model.ISystemHostPool;
import org.eclipse.rse.model.ISystemProfile;

public class SystemResourceManager
implements SystemResourceConstants {
    private static IProject remoteSystemsProject = null;
    private static IProject remoteSystemsTempFilesProject = null;
    private static boolean initDone = false;
    private static boolean firstTime = false;
    private static SystemResourceHelpers helpers = null;
    private static SystemResourceListener listener = null;

    public static void turnOffResourceEventListening() {
        if (listener != null) {
            listener.turnOffResourceEventListening();
        }
    }

    public static void turnOnResourceEventListening() {
        if (listener != null) {
            listener.turnOnResourceEventListening();
        }
    }

    public static void ensureOnResourceEventListening() {
        if (listener != null) {
            listener.ensureOnResourceEventListening();
        }
    }

    public static void startResourceEventListening() {
        listener = SystemResourceListener.getListener(remoteSystemsProject);
        listener.turnOnResourceEventListening();
        IWorkspace ws = remoteSystemsProject.getWorkspace();
        int eventMask = 1;
        ws.addResourceChangeListener((IResourceChangeListener)listener, eventMask);
    }

    public static void endResourceEventListening() {
        if (listener != null) {
            IWorkspace ws = remoteSystemsProject.getWorkspace();
            ws.removeResourceChangeListener((IResourceChangeListener)listener);
            listener = null;
        }
    }

    public static void addResourceChangeListener(IResourceChangeListener l) {
        if (listener != null) {
            listener.addResourceChangeListener(l);
        }
    }

    public static void removeResourceChangeListener(IResourceChangeListener l) {
        if (listener != null) {
            listener.removeResourceChangeListener(l);
        }
    }

    public static IProject getRemoteSystemsProject() {
        if (remoteSystemsProject == null) {
            remoteSystemsProject = SystemBasePlugin.getWorkspaceRoot().getProject("RemoteSystemsConnections");
            if (!initDone) {
                remoteSystemsProject = SystemResourceManager.createRemoteSystemsProjectInternal(remoteSystemsProject);
            }
        }
        return remoteSystemsProject;
    }

    public static IProject getRemoteSystemsTempFilesProject() {
        if (remoteSystemsTempFilesProject == null) {
            remoteSystemsTempFilesProject = SystemBasePlugin.getWorkspaceRoot().getProject("RemoteSystemsTempFiles");
        }
        return remoteSystemsTempFilesProject;
    }

    protected static IProject createRemoteSystemsProjectInternal(IProject proj) {
        if (!proj.exists()) {
            try {
                proj.create(null);
                proj.open(null);
                IProjectDescription description = proj.getDescription();
                String[] newNatures = new String[]{"org.eclipse.rse.ui.remotesystemsnature"};
                description.setNatureIds(newNatures);
                proj.setDescription(description, null);
                firstTime = true;
            }
            catch (Exception e) {
                SystemBasePlugin.logError("error creating remote systems project", e);
            }
        } else if (!proj.isOpen()) {
            try {
                proj.open(null);
            }
            catch (Exception e) {
                SystemBasePlugin.logError("error opening remote systems project", e);
            }
        }
        try {
            SystemResourceManager.getResourceHelpers().getOrCreateFolder((IContainer)proj, "TypeFilters");
        }
        catch (Exception e) {
            SystemBasePlugin.logError("error opening/creating types folder", e);
        }
        initDone = true;
        return proj;
    }

    public static boolean isFirstTime() {
        boolean firsttime = firstTime;
        firstTime = false;
        return firsttime;
    }

    public static IFolder[] getProfileFolders() {
        IProject proj = SystemResourceManager.getRemoteSystemsProject();
        IFolder[] allFolders = SystemResourceManager.getResourceHelpers().listFolders((IContainer)proj);
        Vector<IFolder> v = new Vector<IFolder>();
        int idx = 0;
        while (idx < allFolders.length) {
            String saveFileName = SystemProfileManager.getSaveFileName(allFolders[idx].getName());
            IFile saveFile = SystemResourceManager.getResourceHelpers().getFile((IContainer)allFolders[idx], saveFileName);
            boolean saveFileExists = SystemResourceManager.getResourceHelpers().fileExists(saveFile);
            if (saveFileExists) {
                v.addElement(allFolders[idx]);
            }
            ++idx;
        }
        return SystemResourceManager.getResourceHelpers().convertToFolderArray(v);
    }

    public static String[] deduceProfileNames() {
        IFolder[] folders = SystemResourceManager.getProfileFolders();
        String[] names = new String[folders.length];
        int idx = 0;
        while (idx < names.length) {
            names[idx] = folders[idx].getName();
            ++idx;
        }
        return names;
    }

    public static IFolder getProfileFolder(ISystemProfile profile) {
        return SystemResourceManager.getProfileFolder(profile.getName());
    }

    public static IFolder getProfileFolder(String profileName) {
        return SystemResourceManager.getResourceHelpers().getOrCreateFolder((IContainer)SystemResourceManager.getRemoteSystemsProject(), profileName);
    }

    protected static IFolder getUserActionsFolder(String profileName) {
        return SystemResourceManager.getResourceHelpers().getOrCreateFolder((IContainer)SystemResourceManager.getProfileFolder(profileName), "UserActions");
    }

    public static IFolder getUserActionsFolder(ISystemProfile profile, ISubSystemConfiguration ssFactory) {
        return SystemResourceManager.getUserActionsFolder(profile.getName(), ssFactory);
    }

    public static IFolder getUserActionsFolder(String profileName, ISubSystemConfiguration ssFactory) {
        IFolder parentFolder = SystemResourceManager.getUserActionsFolder(profileName);
        String folderName = SystemResourceManager.getFolderName(ssFactory);
        return SystemResourceManager.getResourceHelpers().getOrCreateFolder((IContainer)parentFolder, folderName);
    }

    public static boolean testUserActionsFolder(String profileName, ISubSystemConfiguration ssFactory) {
        IFolder parentFolder = SystemResourceManager.getUserActionsFolder(profileName);
        String folderName = SystemResourceManager.getFolderName(ssFactory);
        return SystemResourceManager.getResourceHelpers().getFolder((IContainer)parentFolder, folderName).exists();
    }

    public static IFolder getUserActionsFolder(String profileName, String factoryId) {
        IFolder parentFolder = SystemResourceManager.getUserActionsFolder(profileName);
        return SystemResourceManager.getResourceHelpers().getOrCreateFolder((IContainer)parentFolder, factoryId);
    }

    protected static IFolder getCompileCommandsFolder(String profileName) {
        return SystemResourceManager.getResourceHelpers().getOrCreateFolder((IContainer)SystemResourceManager.getProfileFolder(profileName), "CompileCommands");
    }

    public static IFolder getCompileCommandsFolder(ISystemProfile profile, ISubSystemConfiguration ssFactory) {
        return SystemResourceManager.getCompileCommandsFolder(profile.getName(), ssFactory);
    }

    public static IFolder getCompileCommandsFolder(String profileName, ISubSystemConfiguration ssFactory) {
        IFolder parentFolder = SystemResourceManager.getCompileCommandsFolder(profileName);
        String folderName = SystemResourceManager.getFolderName(ssFactory);
        return SystemResourceManager.getResourceHelpers().getOrCreateFolder((IContainer)parentFolder, folderName);
    }

    public static IFolder getCompileCommandsFolder(String profileName, String factoryId) {
        IFolder parentFolder = SystemResourceManager.getCompileCommandsFolder(profileName);
        return SystemResourceManager.getResourceHelpers().getOrCreateFolder((IContainer)parentFolder, factoryId);
    }

    public static void renameFolder(IFolder folder, String newName) {
        SystemResourceManager.getResourceHelpers().renameResource((IResource)folder, newName);
    }

    public static void deleteFolder(IFolder folder) {
        SystemResourceManager.getResourceHelpers().deleteResource((IResource)folder);
    }

    public static void renameFile(IFolder folder, String oldName, String newName) {
        SystemResourceManager.getResourceHelpers().renameResource((IResource)SystemResourceManager.getResourceHelpers().getFile((IContainer)folder, oldName), newName);
    }

    public static void deleteFile(IFolder folder, String fileName) {
        SystemResourceManager.getResourceHelpers().deleteResource((IResource)SystemResourceManager.getResourceHelpers().getFile((IContainer)folder, fileName));
    }

    public static String getProfileName(ISystemHostPool pool) {
        return pool.getName();
    }

    public static String getProfileName(ISystemFilterPoolManager mgr) {
        return mgr.getName();
    }

    public static String getFolderName(ISystemFilterPool pool) {
        return pool.getName();
    }

    public static String getFolderName(IHost conn) {
        return conn.getAliasName();
    }

    public static String getFolderName(ISubSystemConfiguration ssFactory) {
        return ssFactory.getId();
    }

    public static String getFolderPath(IFolder folder) {
        return SystemResourceManager.getResourceHelpers().getFolderPath(folder);
    }

    public static String getFolderPathWithTerminator(IFolder folder) {
        return SystemResourceManager.addPathTerminator(SystemResourceManager.getResourceHelpers().getFolderPath(folder));
    }

    protected static SystemResourceHelpers getResourceHelpers() {
        if (helpers == null) {
            helpers = SystemResourceHelpers.getResourceHelpers();
        }
        return helpers;
    }

    public static String addPathTerminator(String path) {
        if (!path.endsWith(File.separator)) {
            path = String.valueOf(path) + File.separatorChar;
        }
        return path;
    }

    public static boolean testIfResourceInUse(IResource resource) {
        return SystemResourceHelpers.testIfResourceInUse(resource);
    }

    public static IFolder getTypeFiltersFolder() {
        return SystemResourceManager.getResourceHelpers().getFolder((IContainer)SystemResourceManager.getRemoteSystemsProject(), "TypeFilters");
    }

    public static IFolder getTypeFiltersFolder(ISubSystemConfiguration ssFactory) {
        IFolder parentFolder = SystemResourceManager.getTypeFiltersFolder();
        String folderName = SystemResourceManager.getFolderName(ssFactory);
        return SystemResourceManager.getResourceHelpers().getOrCreateFolder((IContainer)parentFolder, folderName);
    }

    public static IFolder getTypeFiltersFolder(String ssFactoryId) {
        IFolder parentFolder = SystemResourceManager.getTypeFiltersFolder();
        return SystemResourceManager.getResourceHelpers().getOrCreateFolder((IContainer)parentFolder, ssFactoryId);
    }
}

