/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core.comm;

import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.comm.ISystemCommunicationsDaemonHandler;
import org.eclipse.rse.core.comm.ISystemCommunicationsDaemonListener;
import org.eclipse.rse.core.comm.SystemCommunicationsDaemonEvent;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.actions.DisplaySystemMessageAction;
import org.eclipse.rse.ui.actions.SystemStartCommunicationsDaemonAction;
import org.eclipse.swt.widgets.Display;

public class SystemCommunicationsDaemon
extends Thread {
    private static final String THREAD_NAME = "RSE daemon";
    private static Map handlers = new Hashtable(50);
    private static List _listeners = new Vector(10);
    private static int _nextKey = -805306368;
    private static SystemCommunicationsDaemon inst = null;
    private boolean halt = false;
    private ServerSocket serverSocket;
    private boolean displayErrors = true;
    private static SystemStartCommunicationsDaemonAction _startAction;

    private SystemCommunicationsDaemon() {
    }

    public static synchronized SystemCommunicationsDaemon getInstance() {
        if (inst == null) {
            inst = new SystemCommunicationsDaemon();
        }
        return inst;
    }

    private void halt() {
        this.halt = true;
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
                if (inst != null) {
                    inst.join(5000L);
                }
            }
            catch (IOException e) {
                SystemBasePlugin.logError("RSE Communications daemon: Unable to close socket", e);
            }
            catch (InterruptedException e) {
                SystemBasePlugin.logError("SystemCommunicationsDaemon.halt", e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Socket socket = null;
        InputStream in = null;
        this.setName(THREAD_NAME);
        int port = RSEUIPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.rse.preferences.daemon.port");
        try {
            block10: {
                try {
                    this.serverSocket = new ServerSocket(port);
                    SystemCommunicationsDaemon.fireStateChangeEvent(1);
                    while (!this.halt) {
                        socket = this.serverSocket.accept();
                        in = socket.getInputStream();
                        byte[] buffer = new byte[4];
                        in.read(buffer);
                        int requestKey = buffer[0] << 24;
                        requestKey |= buffer[1] << 24 >>> 8;
                        requestKey |= buffer[2] << 24 >>> 16;
                        ISystemCommunicationsDaemonHandler handler = (ISystemCommunicationsDaemonHandler)handlers.get(new Integer(requestKey |= buffer[3] << 24 >>> 24));
                        if (handler != null) {
                            new CommunicationHandlerThread(handler, socket, requestKey).start();
                            continue;
                        }
                        SystemBasePlugin.logWarning("SystemCommunicationsDaemon: Handler not found for key " + requestKey);
                        socket.close();
                    }
                }
                catch (IOException e) {
                    if (!this.halt) {
                        SystemBasePlugin.logError("CommunicationsDaemon, IOException occured during communications daemon request", e);
                        SystemCommunicationsDaemon.fireStateChangeEvent(3);
                        if (this.displayErrors) {
                            SystemMessage msg = RSEUIPlugin.getPluginMessage("RSEC2201");
                            msg.makeSubstitution((Object)new Integer(port));
                            Display.getDefault().asyncExec((Runnable)new DisplaySystemMessageAction(msg));
                        }
                        if (_startAction != null) {
                            _startAction.setActionLabelToStart();
                        }
                        break block10;
                    }
                    SystemCommunicationsDaemon.fireStateChangeEvent(2);
                }
            }
            Object var7_11 = null;
            this.serverSocket = null;
            inst = null;
            return;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.serverSocket = null;
            inst = null;
            throw throwable;
        }
    }

    public synchronized void startDaemon() {
        this.startDaemon(true);
    }

    public synchronized void startDaemon(boolean displayErrors) {
        if (!this.isRunning()) {
            SystemBasePlugin.logDebugMessage("CommunicationsDaemon.startDaemon()", "Starting iSeries Communications Daemon");
            if (_startAction != null) {
                _startAction.setActionLabelToStop();
            }
            SystemCommunicationsDaemon daemon = SystemCommunicationsDaemon.getInstance();
            daemon.displayErrors = displayErrors;
            daemon.start();
        } else {
            SystemBasePlugin.logDebugMessage("CommunicationsDaemon.startDaemon()", "Daemon already started");
        }
    }

    public synchronized void stopDaemon() {
        if (this.isRunning()) {
            if (_startAction != null) {
                _startAction.setActionLabelToStart();
            }
            SystemBasePlugin.logDebugMessage("RSE CommunicationsDaemon.stopDaemon()", "Stopping iSeries Communications Daemon");
            SystemCommunicationsDaemon.getInstance().halt();
            inst = null;
        } else {
            SystemBasePlugin.logDebugMessage("RSE CommunicationsDaemon.stopDaemon()", "Daemon already stopped");
        }
    }

    public synchronized int getPort() {
        if (this.isRunning()) {
            return this.serverSocket.getLocalPort();
        }
        return 0;
    }

    public synchronized boolean isRunning() {
        return this.serverSocket != null;
    }

    public static boolean isAutoStart() {
        return RSEUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.rse.preferences.daemon.autostart");
    }

    public boolean addCommunicationsDaemonHandler(ISystemCommunicationsDaemonHandler handler, int requestKey) {
        Integer key = new Integer(requestKey);
        if (!handlers.containsKey(key)) {
            handlers.put(key, handler);
            return true;
        }
        return false;
    }

    public void removeCommunicationsDaemonHandler(int requestKey) {
        handlers.remove(new Integer(requestKey));
    }

    public static void setAction(SystemStartCommunicationsDaemonAction action) {
        _startAction = action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNextKey() {
        int key;
        Map map = handlers;
        synchronized (map) {
            key = _nextKey;
            _nextKey = _nextKey == -1 ? -805306368 : ++_nextKey;
        }
        return key;
    }

    public static void addDaemonListener(ISystemCommunicationsDaemonListener listener) {
        if (!_listeners.contains(listener)) {
            _listeners.add(listener);
        }
    }

    public static void removeDaemonListener(ISystemCommunicationsDaemonListener listener) {
        _listeners.remove(listener);
    }

    private static void fireStateChangeEvent(int newstate) {
        if (_listeners.size() > 0) {
            SystemCommunicationsDaemonEvent event = new SystemCommunicationsDaemonEvent(newstate);
            int i = 0;
            while (i < _listeners.size()) {
                ((ISystemCommunicationsDaemonListener)_listeners.get(i)).daemonStateChanged(event);
                ++i;
            }
        }
    }

    protected class CommunicationHandlerThread
    extends Thread {
        private ISystemCommunicationsDaemonHandler _handler;
        private Socket _socket;
        private int _requestKey;

        protected CommunicationHandlerThread(ISystemCommunicationsDaemonHandler handler, Socket socket, int requestKey) {
            this._handler = handler;
            this._socket = socket;
            this._requestKey = requestKey;
        }

        public void run() {
            this._handler.handleRequest(this._socket, this._requestKey);
        }
    }
}

