/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.filters;

import java.util.Iterator;
import java.util.List;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.filters.ISystemFilter;
import org.eclipse.rse.filters.ISystemFilterContainer;
import org.eclipse.rse.filters.ISystemFilterContainerReference;
import org.eclipse.rse.filters.ISystemFilterPool;
import org.eclipse.rse.filters.ISystemFilterReference;
import org.eclipse.rse.filters.SystemFilterReference;

public class SystemFilterContainerReferenceCommonMethods {
    private ISystemFilterContainerReference parentRef = null;
    private ISystemFilterReference[] referencedFilters = null;

    public SystemFilterContainerReferenceCommonMethods(ISystemFilterContainerReference parentRef) {
        this.parentRef = parentRef;
    }

    public String getName() {
        ISystemFilterContainer parent = this.parentRef.getReferencedSystemFilterContainer();
        String name = null;
        name = parent instanceof ISystemFilterPool ? ((ISystemFilterPool)parent).getName() : ((ISystemFilter)parent).getName();
        return name;
    }

    public boolean hasFilters() {
        return this.getFilterCount() > 0;
    }

    public int getFilterCount() {
        int count = 0;
        ISystemFilterContainer parent = this.parentRef.getReferencedSystemFilterContainer();
        List mofList = null;
        mofList = parent instanceof ISystemFilterPool ? ((ISystemFilterPool)parent).getFilters() : ((ISystemFilter)parent).getNestedFilters();
        if (mofList != null) {
            count = mofList.size();
        }
        return count;
    }

    public ISystemFilterReference[] getSystemFilterReferences(ISubSystem subSystem) {
        ISystemFilterContainer parent = this.parentRef.getReferencedSystemFilterContainer();
        List mofList = null;
        mofList = parent instanceof ISystemFilterPool ? ((ISystemFilterPool)parent).getFilters() : ((ISystemFilter)parent).getNestedFilters();
        boolean needToReGen = this.compareFilters(mofList);
        if (needToReGen) {
            this.referencedFilters = this.generateFilterReferences(subSystem, mofList);
        }
        return this.referencedFilters;
    }

    private boolean compareFilters(List newFilters) {
        boolean mustReGen = false;
        if (newFilters == null) {
            return this.referencedFilters != null;
        }
        if (this.referencedFilters == null) {
            return true;
        }
        if (newFilters.size() != this.referencedFilters.length) {
            return true;
        }
        Iterator i = newFilters.iterator();
        int idx = 0;
        while (!mustReGen && idx < this.referencedFilters.length) {
            ISystemFilter newFilter = (ISystemFilter)i.next();
            if (this.referencedFilters[idx].getReferencedFilter() != newFilter) {
                mustReGen = true;
            }
            ++idx;
        }
        return mustReGen;
    }

    private ISystemFilterReference[] generateFilterReferences(ISubSystem subSystem, List newFilters) {
        if (newFilters == null) {
            return null;
        }
        ISystemFilterReference[] oldRefs = this.referencedFilters;
        ISystemFilterReference[] refs = new ISystemFilterReference[newFilters.size()];
        Iterator i = newFilters.iterator();
        int idx = 0;
        while (i.hasNext()) {
            ISystemFilter filter = (ISystemFilter)i.next();
            boolean foundOldOne = false;
            if (oldRefs != null) {
                int o = 0;
                while (o < oldRefs.length && !foundOldOne) {
                    ISystemFilterReference oRef = oldRefs[o];
                    if (oRef.getReferencedFilter() == filter) {
                        refs[idx++] = oRef;
                        foundOldOne = true;
                    }
                    ++o;
                }
            }
            if (foundOldOne) continue;
            refs[idx++] = this.generateFilterReference(subSystem, filter);
        }
        return refs;
    }

    public ISystemFilterReference generateFilterReference(ISubSystem subSystem, ISystemFilter filter) {
        return SystemFilterReference.createSystemFilterReference(subSystem, this.parentRef, filter, false);
    }

    public ISystemFilterReference generateAndRecordFilterReference(ISubSystem subSystem, ISystemFilter filter) {
        this.getSystemFilterReferences(subSystem);
        ISystemFilterReference sfr = this.getExistingSystemFilterReference(subSystem, filter);
        if (sfr == null) {
            sfr = this.generateFilterReference(subSystem, filter);
            int currLength = 0;
            if (this.referencedFilters != null) {
                currLength = this.referencedFilters.length;
            }
            int newLength = currLength + 1;
            ISystemFilterReference[] newRefs = new ISystemFilterReference[newLength];
            int idx = 0;
            while (idx < currLength) {
                newRefs[idx] = this.referencedFilters[idx];
                ++idx;
            }
            newRefs[newLength - 1] = sfr;
            this.referencedFilters = newRefs;
        }
        return sfr;
    }

    public ISystemFilterReference getExistingSystemFilterReference(ISubSystem subSystem, ISystemFilter filter) {
        ISystemFilterReference ref = null;
        ISystemFilterReference[] refs = this.referencedFilters;
        if (refs != null && refs.length > 0) {
            int idx = 0;
            while (ref == null && idx < refs.length) {
                ISystemFilterReference aref = refs[idx];
                if (aref.getReferencedFilter() == filter && aref.getSubSystem() == subSystem) {
                    ref = aref;
                }
                ++idx;
            }
        }
        return ref;
    }
}

