/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.model;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.core.SystemPreferencesManager;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.model.RSEModelObject;
import org.eclipse.rse.model.IHost;
import org.eclipse.rse.model.ISystemHostPool;
import org.eclipse.rse.model.ISystemProfile;
import org.eclipse.rse.ui.RSEUIPlugin;

public class Host
extends RSEModelObject
implements IHost,
IAdaptable {
    protected static final String SYSTEM_TYPE_EDEFAULT = null;
    private boolean ucId = true;
    private boolean userIdCaseSensitive = true;
    private ISystemHostPool pool;
    protected String previousUserIdKey;
    protected String systemType = SYSTEM_TYPE_EDEFAULT;
    protected static final String ALIAS_NAME_EDEFAULT = null;
    protected String aliasName = ALIAS_NAME_EDEFAULT;
    protected static final String HOST_NAME_EDEFAULT = null;
    protected String hostName = HOST_NAME_EDEFAULT;
    protected static final String DESCRIPTION_EDEFAULT = null;
    protected String description = DESCRIPTION_EDEFAULT;
    protected static final String DEFAULT_USER_ID_EDEFAULT = null;
    protected String defaultUserId = DEFAULT_USER_ID_EDEFAULT;
    protected static final boolean PROMPTABLE_EDEFAULT = false;
    protected boolean promptable = false;
    protected static final boolean OFFLINE_EDEFAULT = false;
    protected boolean offline = false;
    protected ISystemProfile _profile;

    protected Host(ISystemProfile profile) {
        this._profile = profile;
    }

    public void setHostPool(ISystemHostPool pool) {
        this.pool = pool;
        this.previousUserIdKey = this.getPreferencesKey();
    }

    public ISystemHostPool getHostPool() {
        return this.pool;
    }

    public IConnectorService[] getConnectorServices() {
        return RSEUIPlugin.getTheSystemRegistry().getConnectorServices(this);
    }

    public ISubSystem[] getSubSystems() {
        return RSEUIPlugin.getTheSystemRegistry().getSubSystems(this);
    }

    public void deletingHost() {
        String oldUserId = null;
        if (this.previousUserIdKey != null) {
            oldUserId = Host.getLocalDefaultUserId(this.previousUserIdKey);
        }
        if (oldUserId != null) {
            SystemPreferencesManager prefMgr = Host.getPreferencesManager();
            prefMgr.clearUserId(this.previousUserIdKey);
        }
    }

    public void renamingSystemProfile(String oldName, String newName) {
        String userIdValue = null;
        if (this.previousUserIdKey != null) {
            userIdValue = Host.getLocalDefaultUserId(this.previousUserIdKey);
        }
        String newKey = this.getPreferencesKey(newName, this.getAliasName());
        if (userIdValue != null && userIdValue.length() > 0) {
            SystemPreferencesManager prefMgr = Host.getPreferencesManager();
            prefMgr.clearUserId(this.previousUserIdKey);
            prefMgr.setUserId(newKey, userIdValue);
        }
        this.previousUserIdKey = newKey;
    }

    public ISystemProfile getSystemProfile() {
        return this._profile;
    }

    public String getSystemProfileName() {
        if (this.pool == null) {
            return null;
        }
        ISystemProfile profile = this.pool.getSystemProfile();
        if (profile != null) {
            return profile.getName();
        }
        return null;
    }

    public void setAliasName(String newName) {
        this.getAliasName();
        String userIdValue = null;
        if (this.previousUserIdKey != null) {
            userIdValue = Host.getLocalDefaultUserId(this.previousUserIdKey);
        }
        this.setAliasNameGen(newName);
        String newKey = this.getPreferencesKey(this.getSystemProfileName(), newName);
        if (userIdValue != null && userIdValue.length() > 0) {
            SystemPreferencesManager prefMgr = Host.getPreferencesManager();
            prefMgr.clearUserId(this.previousUserIdKey);
            prefMgr.setUserId(newKey, userIdValue);
        }
        this.previousUserIdKey = newKey;
    }

    public void setSystemType(String systemType) {
        if (systemType != null) {
            boolean forceUC = systemType.equals("iSeries");
            boolean caseSensitiveUID = systemType.equals("Unix") || systemType.equals("Linux") || systemType.equals("Local") && !System.getProperty("os.name").toLowerCase().startsWith("windows");
            this.setForceUserIdToUpperCase(forceUC);
            this.setUserIdCaseSensitive(caseSensitiveUID);
        }
        this.setSystemTypeGen(systemType);
    }

    public void setHostName(String name) {
        if (name != null) {
            name = name.toUpperCase();
        }
        this.setHostNameGen(name);
    }

    public void setDefaultUserId(String newId) {
        if (newId != null && this.ucId) {
            newId = newId.toUpperCase();
        }
        if (newId == null || newId.length() == 0) {
            this.clearLocalDefaultUserId();
        } else {
            String key = this.getPreferencesKey();
            if (key != null) {
                SystemPreferencesManager prefMgr = Host.getPreferencesManager();
                prefMgr.setUserId(key, newId);
            }
        }
    }

    public String getDefaultUserId() {
        SystemPreferencesManager prefMgr;
        String uid = this.getLocalDefaultUserId();
        if ((uid == null || uid.length() == 0) && (uid = (prefMgr = Host.getPreferencesManager()).getDefaultUserId(this.getSystemType())) != null && this.ucId) {
            uid = uid.toUpperCase();
        }
        return uid;
    }

    protected static String getLocalDefaultUserId(String key) {
        String uid = null;
        if (key != null && key.length() > 0) {
            SystemPreferencesManager prefMgr = Host.getPreferencesManager();
            uid = prefMgr.getUserId(key);
        }
        return uid;
    }

    public String getLocalDefaultUserId() {
        return Host.getLocalDefaultUserId(this.getPreferencesKey());
    }

    public void clearLocalDefaultUserId() {
        if (this.previousUserIdKey != null) {
            Host.getPreferencesManager().clearUserId(this.previousUserIdKey);
        }
    }

    protected static SystemPreferencesManager getPreferencesManager() {
        return SystemPreferencesManager.getPreferencesManager();
    }

    protected String getPreferencesKey() {
        if (this.getSystemProfileName() == null || this.getAliasName() == null) {
            return null;
        }
        return this.getPreferencesKey(this.getSystemProfileName());
    }

    protected String getPreferencesKey(String profileName) {
        String connectionName = this.getAliasName();
        if (connectionName == null) {
            return null;
        }
        return this.getPreferencesKey(profileName, connectionName);
    }

    protected String getPreferencesKey(String profileName, String connectionName) {
        return String.valueOf(profileName) + "." + connectionName;
    }

    public void setForceUserIdToUpperCase(boolean force) {
        this.ucId = force;
    }

    public void setUserIdCaseSensitive(boolean caseSensitive) {
        this.userIdCaseSensitive = caseSensitive;
    }

    public boolean getForceUserIdToUpperCase() {
        return this.ucId;
    }

    public boolean getUserIdCaseSensitive() {
        return this.userIdCaseSensitive;
    }

    public boolean compareUserIds(String userId1, String userId2) {
        if (userId1 == null) {
            userId1 = "";
        }
        if (userId2 == null) {
            userId2 = "";
        }
        if (this.userIdCaseSensitive) {
            return userId1.equals(userId2);
        }
        return userId1.equalsIgnoreCase(userId2);
    }

    public String toString() {
        if (this.getAliasName() == null) {
            return this.toStringGen();
        }
        return this.getAliasName();
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    public String getSystemType() {
        return this.systemType;
    }

    public String getName() {
        return this.getAliasName();
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String newDescription) {
        this.description = newDescription;
    }

    public boolean isPromptable() {
        return this.promptable;
    }

    public void setPromptable(boolean newPromptable) {
        this.promptable = newPromptable;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setOffline(boolean newOffline) {
        this.offline = newOffline;
    }

    public void setSystemTypeGen(String newSystemType) {
        this.systemType = newSystemType;
    }

    public void setAliasNameGen(String newAliasName) {
        this.aliasName = newAliasName;
    }

    public void setHostNameGen(String newHostName) {
        this.hostName = newHostName;
    }

    public String getDefaultUserIdGen() {
        return this.defaultUserId;
    }

    public void setDefaultUserIdGen(String newDefaultUserId) {
        this.defaultUserId = newDefaultUserId;
    }

    public String toStringGen() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (systemType: ");
        result.append(this.systemType);
        result.append(", aliasName: ");
        result.append(this.aliasName);
        result.append(", hostName: ");
        result.append(this.hostName);
        result.append(", description: ");
        result.append(this.description);
        result.append(", defaultUserId: ");
        result.append(this.defaultUserId);
        result.append(", promptable: ");
        result.append(this.promptable);
        result.append(", offline: ");
        result.append(this.offline);
        result.append(')');
        return result.toString();
    }

    public boolean commit() {
        return RSEUIPlugin.getThePersistenceManager().commit(this.getSystemProfile());
    }
}

