/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.model;

import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.filters.ISystemFilterPool;
import org.eclipse.rse.filters.ISystemFilterPoolManager;
import org.eclipse.rse.internal.model.RSEModelObject;
import org.eclipse.rse.model.IHost;
import org.eclipse.rse.model.ISystemProfile;
import org.eclipse.rse.model.ISystemProfileManager;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;

public class SystemProfile
extends RSEModelObject
implements ISystemProfile,
IAdaptable {
    protected static final String NAME_EDEFAULT = null;
    private ISystemProfileManager mgr;
    private boolean active;
    protected String name = NAME_EDEFAULT;
    protected static final boolean DEFAULT_PRIVATE_EDEFAULT = false;
    protected boolean defaultPrivate = false;

    protected SystemProfile() {
    }

    public void setProfileManager(ISystemProfileManager mgr) {
        this.mgr = mgr;
    }

    public ISystemProfileManager getProfileManager() {
        return this.mgr;
    }

    public IHost createHost(String systemType, String connectionName, String hostName, String description) throws Exception {
        return RSEUIPlugin.getTheSystemRegistry().createHost(this.getName(), systemType, connectionName, hostName, description);
    }

    public IHost[] getHosts() {
        return RSEUIPlugin.getTheSystemRegistry().getHostsByProfile(this);
    }

    public ISystemFilterPool[] getFilterPools() {
        ISubSystemConfiguration[] ssFactories = RSEUIPlugin.getTheSystemRegistry().getSubSystemConfigurations();
        Vector<ISystemFilterPool> poolsVector = new Vector<ISystemFilterPool>();
        int idx = 0;
        while (idx < ssFactories.length) {
            ISystemFilterPoolManager poolMgr = ssFactories[idx].getFilterPoolManager(this);
            ISystemFilterPool[] pools = poolMgr.getSystemFilterPools();
            int ydx = 0;
            while (ydx < pools.length) {
                poolsVector.add(pools[ydx]);
                ++ydx;
            }
            ++idx;
        }
        ISystemFilterPool[] allPools = new ISystemFilterPool[poolsVector.size()];
        int idx2 = 0;
        while (idx2 < allPools.length) {
            allPools[idx2] = (ISystemFilterPool)poolsVector.elementAt(idx2);
            ++idx2;
        }
        return allPools;
    }

    public ISystemFilterPool[] getFilterPools(ISubSystemConfiguration ssf) {
        ISystemFilterPoolManager poolMgr = ssf.getFilterPoolManager(this);
        return poolMgr.getSystemFilterPools();
    }

    public boolean isActive() {
        return this.active;
    }

    protected void setActive(boolean active) {
        this.active = active;
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    public String toString() {
        String name = this.getName();
        if (name != null) {
            return name;
        }
        return this.toStringGen();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return SystemResources.RESID_MODELOBJECTS_PROFILE_DESCRIPTION;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String toStringGen() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(", defaultPrivate: ");
        result.append(this.defaultPrivate);
        result.append(')');
        return result.toString();
    }

    public boolean isDefaultPrivate() {
        return this.defaultPrivate;
    }

    public void setDefaultPrivate(boolean newDefaultPrivate) {
        this.defaultPrivate = newDefaultPrivate;
    }

    public boolean commit() {
        return RSEUIPlugin.getThePersistenceManager().commit(this);
    }
}

