/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.persistence;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.core.SystemResourceManager;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.filters.ISystemFilter;
import org.eclipse.rse.filters.ISystemFilterPool;
import org.eclipse.rse.filters.ISystemFilterPoolManager;
import org.eclipse.rse.filters.ISystemFilterPoolManagerProvider;
import org.eclipse.rse.internal.filters.SystemFilterPoolManager;
import org.eclipse.rse.internal.persistence.SaveRSEDOMJob;
import org.eclipse.rse.internal.persistence.dom.RSEDOMExporter;
import org.eclipse.rse.internal.persistence.dom.RSEDOMImporter;
import org.eclipse.rse.logging.Logger;
import org.eclipse.rse.model.IHost;
import org.eclipse.rse.model.ISystemHostPool;
import org.eclipse.rse.model.ISystemProfile;
import org.eclipse.rse.model.ISystemProfileManager;
import org.eclipse.rse.persistence.IRSEPersistenceManager;
import org.eclipse.rse.persistence.IRSEPersistenceProvider;
import org.eclipse.rse.persistence.dom.RSEDOM;
import org.eclipse.rse.ui.RSEUIPlugin;

public class RSEPersistenceManager
implements IRSEPersistenceManager {
    public static final int STATE_NONE = 0;
    public static final int STATE_IMPORTING = 1;
    public static final int STATE_EXPORTING = 2;
    private Map loadedProviders = new HashMap(10);
    private int _currentState = 0;
    private RSEDOMExporter _exporter = RSEDOMExporter.getInstance();
    private RSEDOMImporter _importer = RSEDOMImporter.getInstance();

    public void registerRSEPersistenceProvider(String id, IRSEPersistenceProvider provider) {
        this.loadedProviders.put(id, provider);
    }

    public IRSEPersistenceProvider getRSEPersistenceProvider(String id) {
        IRSEPersistenceProvider provider = (IRSEPersistenceProvider)this.loadedProviders.get(id);
        if (provider == null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] providerCandidates = registry.getConfigurationElementsFor("org.eclipse.rse.ui", "persistenceProviders");
            int j = 0;
            while (j < providerCandidates.length) {
                IConfigurationElement providerCandidate = providerCandidates[j];
                if (providerCandidate.getName().equals("persistenceProvider")) {
                    String candidateId = providerCandidate.getAttribute("id");
                    if (candidateId != null) {
                        if (candidateId.equals(id)) {
                            try {
                                provider = (IRSEPersistenceProvider)providerCandidate.createExecutableExtension("class");
                            }
                            catch (CoreException e) {
                                RSEUIPlugin.logError("Exception loading persistence provider", e);
                            }
                        }
                    } else {
                        RSEUIPlugin.logError("Missing id attribute in persistenceProvider element");
                    }
                } else {
                    RSEUIPlugin.logError("Invalid element in persistenceProviders extension point");
                }
                ++j;
            }
            if (provider == null) {
                RSEUIPlugin.logError("Persistence provider not found.");
            }
            this.loadedProviders.put(id, provider);
        }
        return provider;
    }

    public IRSEPersistenceProvider getRSEPersistenceProvider() {
        IRSEPersistenceProvider provider = this.getRSEPersistenceProvider("org.eclipse.rse.persistence.SerializingProvider");
        return provider;
    }

    public boolean restore(ISystemProfileManager profileManager) {
        return this.load(profileManager);
    }

    protected ISystemProfile restoreProfile(ISystemProfileManager mgr, String name) throws Exception {
        return null;
    }

    public boolean commit(ISystemProfileManager profileManager) {
        ISystemProfile[] profiles = profileManager.getSystemProfiles();
        int idx = 0;
        while (idx < profiles.length) {
            try {
                this.commit(profiles[idx]);
            }
            catch (Exception exc) {
                exc.printStackTrace();
                System.out.println("Error saving profile " + profiles[idx] + ": " + exc.getClass().getName() + " " + exc.getMessage());
                return false;
            }
            ++idx;
        }
        return true;
    }

    public boolean restore(ISystemHostPool connectionPool) {
        return false;
    }

    protected IHost restoreHost(ISystemHostPool hostPool, String connectionName) throws Exception {
        return null;
    }

    public boolean commit(ISystemHostPool connectionPool) {
        if (connectionPool.isDirty()) {
            this.commit(connectionPool.getSystemProfile());
            connectionPool.setDirty(false);
        }
        return false;
    }

    public boolean commit(ISystemFilterPoolManager filterPoolManager) {
        if (filterPoolManager.isDirty()) {
            this.commit(filterPoolManager.getSystemProfile());
            filterPoolManager.setDirty(false);
        }
        return false;
    }

    public boolean commit(ISystemFilterPool filterPool) {
        if (filterPool.isDirty()) {
            this.commit(filterPool.getSystemFilterPoolManager().getSystemProfile());
            filterPool.setDirty(false);
        }
        return false;
    }

    public boolean restore(ISystemFilterPool filterPool) {
        System.out.println("restore filterpool");
        return false;
    }

    public boolean commit(ISystemFilter filter) {
        System.out.println("commit filter");
        return false;
    }

    public ISystemFilterPool restoreFilterPool(String name) {
        System.out.println("restore filter pool " + name);
        return null;
    }

    public boolean commit(ISubSystem subSystem) {
        if (subSystem.isDirty()) {
            try {
                ISystemProfileManager mgr = RSEUIPlugin.getTheSystemRegistry().getSystemProfileManager();
                this.commit(mgr);
                subSystem.setDirty(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    public ISystemFilterPoolManager restoreFilterPoolManager(ISystemProfile profile, Logger logger, ISystemFilterPoolManagerProvider caller, String name) {
        SystemFilterPoolManager mgr = SystemFilterPoolManager.createManager(profile);
        mgr.initialize(logger, caller, name);
        return mgr;
    }

    public boolean commit(ISystemProfile profile) {
        if (profile != null) {
            return this.save(profile, false);
        }
        return false;
    }

    public boolean load(ISystemProfileManager profileManager) {
        boolean successful = true;
        if (this.isExporting() || this.isImporting()) {
            successful = false;
        } else {
            this._currentState = 1;
            IProject project = SystemResourceManager.getRemoteSystemsProject();
            try {
                if (!project.isSynchronized(1)) {
                    project.refreshLocal(1, null);
                }
                IResource[] folders = project.members();
                int f = 0;
                while (f < folders.length) {
                    if (folders[f] instanceof IFolder) {
                        IFolder folder = (IFolder)folders[f];
                        IResource[] members = folder.members();
                        int i = 0;
                        while (i < members.length) {
                            IResource member = members[i];
                            if (member instanceof IFile && member.getFileExtension().equals("rsedom")) {
                                String name = member.getName();
                                String domName = member.getName().substring(0, name.length() - 7);
                                RSEDOM dom = this.importRSEDOM(profileManager, domName);
                                if (dom != null) {
                                    ISystemProfile restoredProfile = this._importer.restoreProfile(profileManager, dom);
                                    if (restoredProfile == null) {
                                        successful = false;
                                    }
                                } else {
                                    successful = false;
                                }
                            }
                            ++i;
                        }
                    }
                    ++f;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this._currentState = 0;
        }
        return successful;
    }

    public boolean save(ISystemProfile profile, boolean force) {
        boolean result = false;
        if (!this.isImporting() && !this.isExporting()) {
            RSEDOM dom = this.exportRSEDOM(profile, force);
            if (dom.needsSave() && !dom.saveScheduled()) {
                SaveRSEDOMJob job = new SaveRSEDOMJob(this, dom, this.getRSEPersistenceProvider());
                job.schedule();
                dom.markSaveScheduled();
            } else {
                System.out.println("no save required");
                result = true;
            }
        }
        return result;
    }

    public boolean isExporting() {
        return this._currentState == 2;
    }

    public boolean isImporting() {
        return this._currentState == 1;
    }

    public void setState(int state) {
        this._currentState = state;
    }

    public RSEDOM exportRSEDOM(ISystemProfile profile, boolean force) {
        RSEDOM dom = null;
        this._currentState = 2;
        dom = this._exporter.createRSEDOM(profile, force);
        return dom;
    }

    public RSEDOM importRSEDOM(ISystemProfileManager profileManager, String domName) {
        RSEDOM dom = null;
        IRSEPersistenceProvider provider = this.getRSEPersistenceProvider();
        if (provider != null) {
            dom = provider.loadRSEDOM(profileManager, domName, null);
        } else {
            RSEUIPlugin.logError("Persistence provider is not available.");
        }
        return dom;
    }

    public boolean commit(IHost host) {
        return this.commit(host.getSystemProfile());
    }
}

