/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.references;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.rse.references.ISystemBasePersistableReferenceManager;
import org.eclipse.rse.references.ISystemBasePersistableReferencedObject;
import org.eclipse.rse.references.ISystemBasePersistableReferencingObject;

public class SystemPersistableReferenceManager
implements ISystemBasePersistableReferenceManager {
    protected static final String NAME_EDEFAULT = null;
    private ISystemBasePersistableReferencingObject[] listAsArray = null;
    public static boolean debug = true;
    public static HashMap EMPTY_MAP = new HashMap();
    protected String name = NAME_EDEFAULT;
    protected List referencingObjectList = null;

    protected SystemPersistableReferenceManager() {
    }

    protected List internalGetList() {
        return this.getReferencingObjectList();
    }

    protected void invalidateCache() {
        this.listAsArray = null;
    }

    public ISystemBasePersistableReferencingObject[] getReferencingObjects() {
        if (this.listAsArray == null || this.listAsArray.length != this.internalGetList().size()) {
            List list = this.internalGetList();
            this.listAsArray = new ISystemBasePersistableReferencingObject[list.size()];
            Iterator i = list.iterator();
            int idx = 0;
            while (i.hasNext()) {
                this.listAsArray[idx++] = (ISystemBasePersistableReferencingObject)i.next();
            }
        }
        return this.listAsArray;
    }

    public void setReferencingObjects(ISystemBasePersistableReferencingObject[] objects, boolean deReference) {
        this.listAsArray = objects;
        if (deReference) {
            this.removeAndDeReferenceAllReferencingObjects();
        } else {
            this.removeAllReferencingObjects();
        }
        List list = this.internalGetList();
        int idx = 0;
        while (idx < objects.length) {
            list.add(objects[idx]);
            ++idx;
        }
    }

    public int addReferencingObject(ISystemBasePersistableReferencingObject object) {
        List list = this.internalGetList();
        list.add(object);
        this.invalidateCache();
        return this.getReferencingObjectCount();
    }

    public int removeReferencingObject(ISystemBasePersistableReferencingObject object) {
        List list = this.internalGetList();
        list.remove(object);
        this.invalidateCache();
        return this.getReferencingObjectCount();
    }

    public int removeAndDeReferenceReferencingObject(ISystemBasePersistableReferencingObject object) {
        object.removeReference();
        return this.removeReferencingObject(object);
    }

    public void removeAllReferencingObjects() {
        this.internalGetList().clear();
    }

    public void removeAndDeReferenceAllReferencingObjects() {
        ISystemBasePersistableReferencingObject[] objs = this.getReferencingObjects();
        int idx = 0;
        while (idx < objs.length) {
            objs[idx].removeReference();
            ++idx;
        }
        this.removeAllReferencingObjects();
    }

    public int getReferencingObjectCount() {
        return this.internalGetList().size();
    }

    public int getReferencingObjectPosition(ISystemBasePersistableReferencingObject object) {
        List list = this.internalGetList();
        int position = -1;
        boolean match = false;
        Iterator i = list.iterator();
        int idx = 0;
        while (!match && i.hasNext()) {
            ISystemBasePersistableReferencingObject curr = (ISystemBasePersistableReferencingObject)i.next();
            if (curr == object) {
                match = true;
                position = idx;
                continue;
            }
            ++idx;
        }
        return position;
    }

    public void moveReferencingObjectPosition(int newPosition, ISystemBasePersistableReferencingObject object) {
        this.internalGetList();
    }

    public boolean isReferenced(ISystemBasePersistableReferencedObject object) {
        return this.getReferencedObject(object) != null;
    }

    public ISystemBasePersistableReferencingObject getReferencedObject(ISystemBasePersistableReferencedObject object) {
        List list = this.internalGetList();
        ISystemBasePersistableReferencingObject match = null;
        Iterator i = list.iterator();
        int idx = 0;
        while (match == null && i.hasNext()) {
            ISystemBasePersistableReferencingObject curr = (ISystemBasePersistableReferencingObject)i.next();
            if (curr.getReferencedObjectName().equals(object.getReferenceName())) {
                match = curr;
                continue;
            }
            ++idx;
        }
        return match;
    }

    public String toString() {
        return this.getName();
    }

    public boolean resolveReferencesAfterRestore() {
        return false;
    }

    public void save(IFolder folder, String fileName) throws Exception {
    }

    public static ISystemBasePersistableReferenceManager restore(IFolder folder, String fileName) throws Exception {
        SystemPersistableReferenceManager mgr = new SystemPersistableReferenceManager();
        return mgr;
    }

    public static String addPathTerminator(String path) {
        if (!path.endsWith(File.separator)) {
            path = String.valueOf(path) + File.separatorChar;
        }
        return path;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public List getReferencingObjectList() {
        if (this.referencingObjectList == null) {
            this.referencingObjectList = new ArrayList();
        }
        return this.referencingObjectList;
    }

    public String toStringGen() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(')');
        return result.toString();
    }
}

