/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.persistence;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.core.SystemResourceManager;
import org.eclipse.rse.model.ISystemProfileManager;
import org.eclipse.rse.persistence.IRSEPersistenceProvider;
import org.eclipse.rse.persistence.dom.RSEDOM;

public class PropertyFileProvider
implements IRSEPersistenceProvider {
    public boolean saveRSEDOM(RSEDOM dom, IProgressMonitor monitor) {
        String profileName = dom.getName();
        IFolder profileFolder = this.getFolder(profileName, monitor);
        System.out.println("saving to " + profileFolder.getFullPath().toString() + "...");
        return true;
    }

    public RSEDOM loadRSEDOM(ISystemProfileManager profileManager, String profileName, IProgressMonitor monitor) {
        RSEDOM dom = null;
        IFolder profileFolder = this.getFolder(profileName, monitor);
        if (profileFolder.exists()) {
            System.out.println("loading from " + profileFolder.getFullPath().toString() + "...");
        }
        return dom;
    }

    private IFolder getFolder(String profileName, IProgressMonitor monitor) {
        IFolder profileFolder;
        IProject project = SystemResourceManager.getRemoteSystemsProject();
        try {
            project.refreshLocal(2, monitor);
        }
        catch (Exception exception) {}
        IFolder providerFolder = project.getFolder("org.eclipse.rse.dom.properties");
        if (!providerFolder.exists()) {
            try {
                providerFolder.create(true, true, monitor);
            }
            catch (Exception exception) {}
        }
        if (!(profileFolder = providerFolder.getFolder(profileName)).exists()) {
            try {
                profileFolder.create(true, true, monitor);
            }
            catch (Exception exception) {}
        }
        return profileFolder;
    }
}

