/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.persistence;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.core.SystemResourceManager;
import org.eclipse.rse.model.ISystemProfileManager;
import org.eclipse.rse.persistence.IRSEPersistenceProvider;
import org.eclipse.rse.persistence.dom.RSEDOM;

public class SerializingProvider
implements IRSEPersistenceProvider {
    public RSEDOM loadRSEDOM(ISystemProfileManager profileManager, String domName, IProgressMonitor monitor) {
        RSEDOM dom = null;
        IFile profileFile = this.getProfileFile(domName, monitor);
        if (profileFile.exists()) {
            System.out.println("loading " + profileFile.getLocation().toOSString() + "...");
            try {
                InputStream iStream = profileFile.getContents();
                ObjectInputStream inStream = new ObjectInputStream(iStream);
                dom = (RSEDOM)inStream.readObject();
                inStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    profileFile.delete(true, false, monitor);
                }
                catch (Exception exception) {
                    e.printStackTrace();
                }
            }
        }
        return dom;
    }

    protected IFile getProfileFile(String domName, IProgressMonitor monitor) {
        IProject project = SystemResourceManager.getRemoteSystemsProject();
        try {
            project.refreshLocal(2, monitor);
        }
        catch (Exception exception) {}
        IFolder folder = project.getFolder(domName);
        if (!folder.exists()) {
            try {
                folder.create(true, true, monitor);
            }
            catch (Exception exception) {}
        }
        return folder.getFile(String.valueOf(domName) + ".rsedom");
    }

    public boolean saveRSEDOM(RSEDOM dom, IProgressMonitor monitor) {
        IFile profileFile = this.getProfileFile(dom.getName(), monitor);
        File osFile = profileFile.getLocation().toFile();
        System.out.println("saving " + osFile.getAbsolutePath() + "...");
        try {
            FileOutputStream oStream = new FileOutputStream(osFile);
            ObjectOutputStream outStream = new ObjectOutputStream(oStream);
            outStream.writeObject(dom);
            outStream.close();
            profileFile.getParent().refreshLocal(1, monitor);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

