/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.ui.IRSESystemTypeConstants;
import org.eclipse.rse.ui.RSEAdapter;
import org.osgi.framework.Bundle;

public class RSESystemTypeAdapter
extends RSEAdapter
implements IRSESystemTypeConstants {
    public ImageDescriptor getImageDescriptor(Object object) {
        return this.getImage(object, "icon");
    }

    public ImageDescriptor getLiveImageDescriptor(Object object) {
        return this.getImage(object, "iconLive");
    }

    private ImageDescriptor getImage(Object object, String propertyKey) {
        if (object != null && object instanceof IRSESystemType) {
            IRSESystemType sysType = (IRSESystemType)object;
            String property = sysType.getProperty(propertyKey);
            if (property != null) {
                return RSESystemTypeAdapter.getImage(property, sysType.getDefiningBundle());
            }
            return null;
        }
        return null;
    }

    public static ImageDescriptor getImage(String value, Bundle definingBundle) {
        URL url = RSESystemTypeAdapter.getUrl(value, definingBundle);
        return url == null ? null : ImageDescriptor.createFromURL((URL)url);
    }

    public static URL getUrl(String value, Bundle definingBundle) {
        block3: {
            try {
                if (value != null) {
                    return new URL(value);
                }
            }
            catch (MalformedURLException malformedURLException) {
                if (definingBundle == null) break block3;
                return Platform.find((Bundle)definingBundle, (IPath)new Path(value));
            }
        }
        return null;
    }

    public String getLabel(Object object) {
        if (object != null && object instanceof IRSESystemType) {
            return ((IRSESystemType)object).getName();
        }
        return super.getLabel(object);
    }

    public String getDescription(Object object) {
        if (object != null && object instanceof IRSESystemType) {
            return ((IRSESystemType)object).getDescription();
        }
        return super.getDescription(object);
    }

    public boolean isEnableOffline(Object object) {
        if (object != null && object instanceof IRSESystemType) {
            String property = ((IRSESystemType)object).getProperty("enableOffline");
            if (property != null) {
                return Boolean.valueOf(property);
            }
            return false;
        }
        return false;
    }

    public boolean isEnabled(Object object) {
        return true;
    }

    public void setIsEnabled(Object object, boolean isEnabled) {
    }

    public String getDefaultUserId(Object object) {
        return "";
    }

    public void setDefaultUserId(Object object, String defaultUserId) {
    }
}

