/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui;

import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rse.core.ISystemViewSupplier;
import org.eclipse.rse.core.SystemBasePlugin;
import org.eclipse.rse.core.SystemPropertyPageExtension;
import org.eclipse.rse.core.SystemResourceManager;
import org.eclipse.rse.core.comm.ISystemKeystoreProvider;
import org.eclipse.rse.core.comm.SystemCommunicationsDaemon;
import org.eclipse.rse.core.comm.SystemKeystoreProviderManager;
import org.eclipse.rse.core.internal.subsystems.SubSystemConfigurationProxy;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.ISubSystemConfigurationProxy;
import org.eclipse.rse.internal.model.SystemProfileManager;
import org.eclipse.rse.internal.model.SystemRegistry;
import org.eclipse.rse.internal.persistence.RSEPersistenceManager;
import org.eclipse.rse.model.ISystemProfileManager;
import org.eclipse.rse.model.ISystemRegistry;
import org.eclipse.rse.model.SystemResourceChangeEvent;
import org.eclipse.rse.model.SystemStartHere;
import org.eclipse.rse.persistence.IRSEPersistenceManager;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageFile;
import org.eclipse.rse.ui.IRSEUIRegistry;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.actions.ISystemDynamicPopupMenuExtension;
import org.eclipse.rse.ui.actions.SystemDynamicPopupMenuExtensionManager;
import org.eclipse.rse.ui.actions.SystemShowPreferencesPageAction;
import org.eclipse.rse.ui.internal.RSESystemTypeAdapterFactory;
import org.eclipse.rse.ui.internal.RSEUIRegistry;
import org.eclipse.rse.ui.propertypages.RemoteSystemsPreferencePage;
import org.eclipse.rse.ui.propertypages.SystemCommunicationsPreferencePage;
import org.eclipse.rse.ui.view.SubsystemFactoryAdapterFactory;
import org.eclipse.rse.ui.view.SystemViewAdapterFactory;
import org.eclipse.rse.ui.view.team.SystemTeamViewResourceAdapterFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class RSEUIPlugin
extends SystemBasePlugin {
    public static final String PLUGIN_ID = "org.eclipse.rse.ui";
    public static final String HELPPREFIX = "org.eclipse.rse.ui.";
    public static final boolean INCLUDE_LOCAL_YES = true;
    public static final boolean INCLUDE_LOCAL_NO = false;
    private static RSEUIPlugin inst = null;
    private static SystemMessageFile messageFile = null;
    private static SystemMessageFile defaultMessageFile = null;
    private String enabledSystemTypes;
    private ISystemRegistry _systemRegistry = null;
    private IRSEPersistenceManager _persistenceManager = null;
    private ISubSystemConfigurationProxy[] subsystemFactories = null;
    private static String machineName = null;
    private static String machineIP = null;
    private Vector viewSuppliers = new Vector();
    private SystemViewAdapterFactory svaf;
    private SystemTeamViewResourceAdapterFactory svraf;
    private SystemShowPreferencesPageAction[] showPrefPageActions = null;
    private boolean dontShowLocalConnection;
    private boolean dontShowProfilePageInitially;
    static /* synthetic */ Class class$0;

    public RSEUIPlugin() {
        if (inst == null) {
            inst = this;
        }
    }

    public static RSEUIPlugin getDefault() {
        return inst;
    }

    public void initializeDefaultPreferences() {
        String productId = null;
        IProduct product = Platform.getProduct();
        if (product != null) {
            productId = product.getId();
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] extensions = registry.getConfigurationElementsFor(PLUGIN_ID, "rseConfigDefaults");
        boolean showNewConnPromptPref = false;
        this.dontShowLocalConnection = false;
        this.dontShowProfilePageInitially = false;
        if (extensions != null && extensions.length > 0) {
            int idx = 0;
            while (idx < extensions.length) {
                IConfigurationElement extension = extensions[idx];
                String configProductId = extension.getAttribute("productId");
                if (productId.equals(configProductId)) {
                    String showProfileInitially;
                    String showNewConn = extension.getAttribute("showNewConnectionPrompt");
                    if (showNewConn != null) {
                        showNewConnPromptPref = showNewConn.equals("true");
                    }
                    if ((showNewConn = extension.getAttribute("showLocalConnection")) != null) {
                        this.dontShowLocalConnection = showNewConn.equals("false");
                    }
                    this.enabledSystemTypes = extension.getAttribute("enableSystemTypes");
                    if (this.enabledSystemTypes != null && this.enabledSystemTypes.length() == 0) {
                        this.enabledSystemTypes = null;
                    }
                    if ((showProfileInitially = extension.getAttribute("showProfilePage")) != null) {
                        this.dontShowProfilePageInitially = showProfileInitially.equals("false");
                    }
                }
                ++idx;
            }
        }
        RemoteSystemsPreferencePage.initDefaults(this.getPreferenceStore(), showNewConnPromptPref);
        SystemCommunicationsPreferencePage.initDefaults(this.getPreferenceStore());
    }

    public boolean getShowProfilePageInitially() {
        return !this.dontShowProfilePageInitially;
    }

    protected void initializeImageRegistry() {
        String path = RSEUIPlugin.getIconPath();
        this.putImageInRegistry("org.eclipse.rse.ui.newprofile_wizBannerIcon", String.valueOf(path) + "/full/wizban/newprofile_wiz.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.newconnection_wizBannerIcon", String.valueOf(path) + "/full/wizban/newconnection_wiz.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.newfilterpool_wizBannerIcon", String.valueOf(path) + "/full/wizban/newfilterpool_wiz.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.newfilter_wizBannerIcon", String.valueOf(path) + "/full/wizban/newfilter_wiz.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.newfile_wizBannerIcon", String.valueOf(path) + "/full/wizban/newfile_wiz.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.newfolder_wizBannerIcon", String.valueOf(path) + "/full/wizban/newfolder_wiz.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.user_action_new_objIcon", String.valueOf(path) + "/full/obj16/user_action_new_obj.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.user_action_objIcon", String.valueOf(path) + "/full/obj16/user_action_obj.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.user_action_ibm_objIcon", String.valueOf(path) + "/full/obj16/user_action_ibm_obj.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.user_action_ibm_user_objIcon", String.valueOf(path) + "/full/obj16/user_action_ibm_user_obj.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.user_type_new_objIcon", String.valueOf(path) + "/full/obj16/user_type_new_obj.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.user_type_objIcon", String.valueOf(path) + "/full/obj16/user_type_obj.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.user_type_ibm_objIcon", String.valueOf(path) + "/full/obj16/user_type_ibm_obj.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.user_type_ibm_user_objIcon", String.valueOf(path) + "/full/obj16/user_type_ibm_user_obj.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.compcmd_new_objIcon", String.valueOf(path) + "/full/obj16/compcmd_new_obj.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.compcmd_user_objIcon", String.valueOf(path) + "/full/obj16/compcmd_user_obj.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.compcmd_ibm_objIcon", String.valueOf(path) + "/full/obj16/compcmd_ibm_obj.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.compcmd_ibmuser_objIcon", String.valueOf(path) + "/full/obj16/compcmd_ibmuser_obj.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.systemprofileIcon", String.valueOf(path) + "/full/obj16/systemprofile.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.systemprofile_activeIcon", String.valueOf(path) + "/full/obj16/systemprofile_active.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.systemconnectionIcon", String.valueOf(path) + "/full/obj16/systemconnection.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.systemconnectionliveIcon", String.valueOf(path) + "/full/obj16/systemconnectionlive.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.systemfilterpoolIcon", String.valueOf(path) + "/full/obj16/systemfilterpool.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.systemfilterIcon", String.valueOf(path) + "/full/obj16/systemfilter.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.systemfilterstringIcon", String.valueOf(path) + "/full/obj16/systemfilterstring.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.systemfolderIcon", String.valueOf(path) + "/full/obj16/systemfolder.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.systemrootdriveIcon", String.valueOf(path) + "/full/obj16/systemrootdrive.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.systemrootdriveopenIcon", String.valueOf(path) + "/full/obj16/systemrootdriveopen.gif");
        this.putImageInRegistry("org.eclipse.rse.ui./full/obj16/systemenvvar.gifIcon", String.valueOf(path) + "/full/obj16/systemenvvar.gif");
        this.putImageInRegistry("org.eclipse.rse.ui./full/obj16/systemenvvarlibpath.gifIcon", String.valueOf(path) + "/full/obj16/systemenvvarlibpath.gif");
        this.putImageInRegistry("org.eclipse.rse.ui./full/obj16/systemenvvarpath.gifIcon", String.valueOf(path) + "/full/obj16/systemenvvarpath.gif");
        this.putImageInRegistry("org.eclipse.rse.ui./full/obj16/systemprocess.gifIcon", String.valueOf(path) + "/full/obj16/systemprocess.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.newIcon", String.valueOf(path) + "/full/ctool16/new.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.newprofile_wizIcon", String.valueOf(path) + "/full/ctool16/newprofile_wiz.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.newconnection_wizIcon", String.valueOf(path) + "/full/ctool16/newconnection_wiz.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.newfilterpool_wizIcon", String.valueOf(path) + "/full/ctool16/newfilterpool_wiz.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.newfilterpoolref_wizIcon", String.valueOf(path) + "/full/ctool16/newfilterpoolref_wiz.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.newfilter_wizIcon", String.valueOf(path) + "/full/ctool16/newfilter_wiz.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.lockIcon", String.valueOf(path) + "/full/elcl16/lock.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.upIcon", String.valueOf(path) + "/full/elcl16/up.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.downIcon", String.valueOf(path) + "/full/elcl16/down.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.moveIcon", String.valueOf(path) + "/full/elcl16/move.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.clearIcon", String.valueOf(path) + "/full/elcl16/clear.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.clearallIcon", String.valueOf(path) + "/full/elcl16/clearall.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.clearselectedIcon", String.valueOf(path) + "/full/elcl16/clearselected.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.deletereferenceIcon", String.valueOf(path) + "/full/elcl16/deletereference.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.renameIcon", String.valueOf(path) + "/full/elcl16/rename.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.runIcon", String.valueOf(path) + "/full/elcl16/run.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.stopIcon", String.valueOf(path) + "/full/elcl16/stop.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.compileIcon", String.valueOf(path) + "/full/elcl16/compile.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.makeProfileActiveIcon", String.valueOf(path) + "/full/elcl16/makeProfileActive.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.makeProfileInActiveIcon", String.valueOf(path) + "/full/elcl16/makeProfileInActive.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.editfilterIcon", String.valueOf(path) + "/full/elcl16/editfilter.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.selectprofileIcon", String.valueOf(path) + "/full/elcl16/selectprofile.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.selectpoolIcon", String.valueOf(path) + "/full/elcl16/selectpool.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.workwithfilterpoolsIcon", String.valueOf(path) + "/full/elcl16/workwithfilterpools.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.workwithuseractionsIcon", String.valueOf(path) + "/full/elcl16/workwithuseractions.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.workwithnamedtypesIcon", String.valueOf(path) + "/full/elcl16/workwithnamedtypes.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.workwithcompilecmdsIcon", String.valueOf(path) + "/full/elcl16/workwithcompilecmds.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.newfile_wizIcon", String.valueOf(path) + "/full/ctool16/newfile_wiz.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.newfolder_wizIcon", String.valueOf(path) + "/full/ctool16/newfolder_wiz.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.xtrctarchv_tskIcon", String.valueOf(path) + "/full/elcl16/xtrctarchv_tsk.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.xtrctarchvto_tskIcon", String.valueOf(path) + "/full/elcl16/xtrctarchvto_tsk.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.combine_tskIcon", String.valueOf(path) + "/full/elcl16/combine_tsk.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.convertarchive_tskIcon", String.valueOf(path) + "/full/elcl16/convertarchive_tsk.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.errorIcon", String.valueOf(path) + "/full/obj16/error.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.infoIcon", String.valueOf(path) + "/full/obj16/info.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.systeminfoIcon", String.valueOf(path) + "/full/obj16/systeminfo.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.systemcancelIcon", String.valueOf(path) + "/full/obj16/systemcancel.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.systemhelpIcon", String.valueOf(path) + "/full/obj16/systemhelp.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.systememptyIcon", String.valueOf(path) + "/full/obj16/systemempty.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.systemokIcon", String.valueOf(path) + "/full/obj16/systemok.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.warningIcon", String.valueOf(path) + "/full/obj16/warning.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.systemshellIcon", String.valueOf(path) + "/full/obj16/systemshell.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.systemshellliveIcon", String.valueOf(path) + "/full/obj16/systemshelllive.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.removeshellIcon", String.valueOf(path) + "/full/elcl16/removeshell.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.exportshelloutputIcon", String.valueOf(path) + "/full/elcl16/exportshelloutput.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.exportshellhistoryIcon", String.valueOf(path) + "/full/elcl16/exportshellhistory.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.systemblankIcon", String.valueOf(path) + "/full/obj16/systemblank.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.system_searchIcon", String.valueOf(path) + "/full/obj16/system_search.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.systemsearchresultIcon", String.valueOf(path) + "/full/obj16/systemsearchresult.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.systemshowintableIcon", String.valueOf(path) + "/full/elcl16/systemshowintable.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.monitor_viewIcon", String.valueOf(path) + "/full/elcl16/monitor_view.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.system_perspIcon", String.valueOf(path) + "/full/obj16/system_persp.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.searchremoveselectedIcon", String.valueOf(path) + "/full/elcl16/searchremoveselected.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.searchremoveallIcon", String.valueOf(path) + "/full/elcl16/searchremoveall.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.arrowup_objIcon", String.valueOf(path) + "/full/obj16/arrowup_obj.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.arrowdown_objIcon", String.valueOf(path) + "/full/obj16/arrowdown_obj.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.connectorservice_objIcon", String.valueOf(path) + "/full/obj16/connectorservice_obj.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.service_objIcon", String.valueOf(path) + "/full/obj16/service_obj.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.launcher_config_objIcon", String.valueOf(path) + "/full/obj16/launcher_config_obj.gif");
        this.putImageInRegistry("org.eclipse.rse.ui.properties_objIcon", String.valueOf(path) + "/full/obj16/properties_obj.gif");
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        messageFile = this.getMessageFile("systemmessages.xml");
        defaultMessageFile = this.getDefaultMessageFile("systemmessages.xml");
        SystemResourceManager.getRemoteSystemsProject();
        try {
            SystemStartHere.getSystemProfileManager();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IAdapterManager manager = Platform.getAdapterManager();
        SubsystemFactoryAdapterFactory ssfaf = new SubsystemFactoryAdapterFactory();
        ssfaf.registerWithManager(manager);
        RSESystemTypeAdapterFactory rseSysTypeFactory = new RSESystemTypeAdapterFactory();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.core.IRSESystemType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)rseSysTypeFactory, (Class)clazz);
        this.svaf = new SystemViewAdapterFactory();
        this.svaf.registerWithManager(manager);
        this.svraf = new SystemTeamViewResourceAdapterFactory();
        this.svraf.registerWithManager(manager);
        ISystemRegistry registry = this.getSystemRegistry();
        SystemResourceManager.startResourceEventListening();
        SystemCommunicationsDaemon daemon = SystemCommunicationsDaemon.getInstance();
        if (SystemCommunicationsDaemon.isAutoStart()) {
            daemon.startDaemon(false);
        }
        this.registerArchiveHandlers();
        this.registerDynamicPopupMenuExtensions();
        this.registerKeystoreProviders();
        if (SystemResourceManager.isFirstTime() && !this.dontShowLocalConnection) {
            registry.createLocalHost(null, SystemResources.TERM_LOCAL, RSEUIPlugin.getLocalMachineName());
        }
    }

    public SystemViewAdapterFactory getSystemViewAdapterFactory() {
        return this.svaf;
    }

    public void restart() {
        if (this._systemRegistry != null) {
            int idx;
            this.disconnectAll(false);
            this._systemRegistry.fireEvent(new SystemResourceChangeEvent("dummy", 91, null));
            this.closeViews();
            ISubSystemConfigurationProxy[] proxies = this.getSystemRegistry().getSubSystemConfigurationProxies();
            if (proxies != null) {
                idx = 0;
                while (idx < proxies.length) {
                    proxies[idx].reset();
                    ++idx;
                }
            }
            SystemProfileManager.clearDefault();
            SystemStartHere.getSystemProfileManager();
            ((SystemRegistry)this._systemRegistry).reset();
            if (proxies != null) {
                idx = 0;
                while (idx < proxies.length) {
                    proxies[idx].restore();
                    ++idx;
                }
            }
            this._systemRegistry.fireEvent(new SystemResourceChangeEvent(this._systemRegistry, 82, null));
            this.openViews();
        }
    }

    public void closeViews() {
        int idx = 0;
        while (idx < this.viewSuppliers.size()) {
            try {
                ((ISystemViewSupplier)this.viewSuppliers.elementAt(idx)).closeViews();
            }
            catch (Exception exception) {}
            ++idx;
        }
    }

    public void openViews() {
        int idx = 0;
        while (idx < this.viewSuppliers.size()) {
            try {
                ((ISystemViewSupplier)this.viewSuppliers.elementAt(idx)).openViews();
            }
            catch (Exception exception) {}
            ++idx;
        }
    }

    public IProject getRemoteSystemsProject() {
        return SystemResourceManager.getRemoteSystemsProject();
    }

    public void stop(BundleContext context) throws Exception {
        this.disconnectAll(true);
        SystemResourceManager.endResourceEventListening();
        SystemCommunicationsDaemon daemon = SystemCommunicationsDaemon.getInstance();
        daemon.stopDaemon();
        super.stop(context);
    }

    protected void disconnectAll(boolean doSave) {
        ISubSystemConfigurationProxy[] proxies;
        if (this.isSystemRegistryActive() && (proxies = this.getSystemRegistry().getSubSystemConfigurationProxies()) != null) {
            int idx = 0;
            while (idx < proxies.length) {
                if (proxies[idx].isSubSystemConfigurationActive()) {
                    ISubSystemConfiguration ssf = proxies[idx].getSubSystemConfiguration();
                    try {
                        ssf.disconnectAllSubSystems();
                    }
                    catch (Exception exc) {
                        RSEUIPlugin.logError("Error disconnecting for " + ssf.getId(), exc);
                    }
                    if (doSave) {
                        // empty if block
                    }
                }
                ++idx;
            }
        }
    }

    public static String getQualifiedHostName(String hostName) {
        try {
            InetAddress address = InetAddress.getByName(hostName);
            return address.getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return hostName;
        }
    }

    public ISubSystemConfigurationProxy[] getSubSystemConfigurationProxies() {
        if (this.subsystemFactories != null) {
            return this.subsystemFactories;
        }
        IConfigurationElement[] factoryPlugins = this.getSubSystemConfigurationPlugins();
        if (factoryPlugins != null) {
            Vector<SubSystemConfigurationProxy> v = new Vector<SubSystemConfigurationProxy>();
            int idx = 0;
            while (idx < factoryPlugins.length) {
                SubSystemConfigurationProxy ssf = new SubSystemConfigurationProxy(factoryPlugins[idx]);
                v.addElement(ssf);
                ++idx;
            }
            if (v.size() != 0) {
                this.subsystemFactories = new ISubSystemConfigurationProxy[v.size()];
                idx = 0;
                while (idx < v.size()) {
                    this.subsystemFactories[idx] = (ISubSystemConfigurationProxy)v.elementAt(idx);
                    ++idx;
                }
            }
        }
        return this.subsystemFactories;
    }

    private IConfigurationElement[] getSubSystemConfigurationPlugins() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] subsystemFactoryExtensions = registry.getConfigurationElementsFor(PLUGIN_ID, "subsystemConfiguration");
        return subsystemFactoryExtensions;
    }

    public boolean isSystemRegistryActive() {
        return this._systemRegistry != null;
    }

    public IRSEPersistenceManager getPersistenceManager() {
        if (this._persistenceManager == null) {
            this._persistenceManager = new RSEPersistenceManager();
        }
        return this._persistenceManager;
    }

    public ISystemRegistry getSystemRegistry() {
        if (this._systemRegistry == null) {
            String logfilePath = this.getStateLocation().toOSString();
            this._systemRegistry = SystemRegistry.getSystemRegistry(logfilePath);
            ISubSystemConfigurationProxy[] proxies = this.getSubSystemConfigurationProxies();
            if (proxies != null) {
                this._systemRegistry.setSubSystemConfigurationProxies(proxies);
            }
        }
        return this._systemRegistry;
    }

    public static ISystemRegistry getTheSystemRegistry() {
        return RSEUIPlugin.getDefault().getSystemRegistry();
    }

    public static IRSEPersistenceManager getThePersistenceManager() {
        return RSEUIPlugin.getDefault().getPersistenceManager();
    }

    public static ISystemProfileManager getTheSystemProfileManager() {
        return SystemProfileManager.getSystemProfileManager();
    }

    public static boolean isTheSystemRegistryActive() {
        if (inst == null) {
            return false;
        }
        return RSEUIPlugin.getDefault().isSystemRegistryActive();
    }

    public SystemPropertyPageExtension[] getPropertyPageExtensions() {
        SystemPropertyPageExtension[] propertyPageExtensions = null;
        IConfigurationElement[] propertyPagePlugins = this.getPropertyPagePlugins();
        if (propertyPagePlugins != null) {
            Vector<SystemPropertyPageExtension> v = new Vector<SystemPropertyPageExtension>();
            int idx = 0;
            while (idx < propertyPagePlugins.length) {
                SystemPropertyPageExtension sppe = new SystemPropertyPageExtension(propertyPagePlugins[idx]);
                v.addElement(sppe);
                ++idx;
            }
            propertyPageExtensions = new SystemPropertyPageExtension[v.size()];
            boolean foundFirst = false;
            int idx2 = 0;
            while (!foundFirst && idx2 < v.size()) {
                if (((SystemPropertyPageExtension)v.elementAt(idx2)).isAtTop()) {
                    propertyPageExtensions[0] = (SystemPropertyPageExtension)v.elementAt(idx2);
                    foundFirst = true;
                }
                ++idx2;
            }
            int ppIdx = foundFirst ? 1 : 0;
            int idx3 = 0;
            while (idx3 < v.size()) {
                if (!((SystemPropertyPageExtension)v.elementAt(idx3)).isAtTop()) {
                    propertyPageExtensions[ppIdx++] = (SystemPropertyPageExtension)v.elementAt(idx3);
                }
                ++idx3;
            }
        }
        return propertyPageExtensions;
    }

    private IConfigurationElement[] getPropertyPagePlugins() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] propertyPageExtensions = registry.getConfigurationElementsFor(PLUGIN_ID, "propertyPages");
        return propertyPageExtensions;
    }

    private IConfigurationElement[] getPreferencePageActionPlugins() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] prefPageExtensions = registry.getConfigurationElementsFor(PLUGIN_ID, "remoteSystemsViewPreferencesActions");
        return prefPageExtensions;
    }

    public SystemShowPreferencesPageAction[] getShowPreferencePageActions() {
        IConfigurationElement[] showPrefPagePlugins;
        if (this.showPrefPageActions == null && (showPrefPagePlugins = this.getPreferencePageActionPlugins()) != null) {
            Vector<SystemShowPreferencesPageAction> v = new Vector<SystemShowPreferencesPageAction>();
            int idx = 0;
            while (idx < showPrefPagePlugins.length) {
                String heldId;
                String tooltip;
                String label;
                String nameSpace;
                Bundle bundle;
                ImageDescriptor id;
                String iconFile;
                String prefPageCategory;
                SystemShowPreferencesPageAction action = new SystemShowPreferencesPageAction();
                String prefPageId = showPrefPagePlugins[idx].getAttribute("preferencePageId");
                if (prefPageId != null && prefPageId.length() > 0) {
                    action.setPreferencePageID(prefPageId);
                }
                if ((prefPageCategory = showPrefPagePlugins[idx].getAttribute("preferencePageCategory")) != null && prefPageCategory.length() > 0) {
                    action.setPreferencePageCategory(prefPageCategory);
                }
                if ((iconFile = showPrefPagePlugins[idx].getAttribute("icon")) != null && iconFile.length() > 0 && (id = RSEUIPlugin.getPluginImage(bundle = Platform.getBundle((String)(nameSpace = showPrefPagePlugins[idx].getDeclaringExtension().getNamespace())), iconFile)) != null) {
                    action.setImageDescriptor(id);
                }
                if ((label = showPrefPagePlugins[idx].getAttribute("label")) != null && label.length() > 0) {
                    action.setText(label);
                }
                if ((tooltip = showPrefPagePlugins[idx].getAttribute("tooltip")) != null && tooltip.length() > 0) {
                    action.setToolTipText(tooltip);
                }
                if ((heldId = showPrefPagePlugins[idx].getAttribute("helpContextId")) != null && heldId.length() > 0) {
                    action.setHelp(heldId);
                }
                v.addElement(action);
                ++idx;
            }
            this.showPrefPageActions = new SystemShowPreferencesPageAction[v.size()];
            idx = 0;
            while (idx < v.size()) {
                this.showPrefPageActions[idx] = (SystemShowPreferencesPageAction)v.elementAt(idx);
                ++idx;
            }
        }
        return this.showPrefPageActions;
    }

    public URL getMessageFileDTD() {
        URL result = this.getBundle().getEntry("/messageFile.dtd");
        return result;
    }

    public SystemMessageFile getMessageFile(String messageFileName) {
        return RSEUIPlugin.loadMessageFile(this.getBundle(), messageFileName);
    }

    public SystemMessageFile getDefaultMessageFile(String messageFileName) {
        return RSEUIPlugin.loadDefaultMessageFile(this.getBundle(), messageFileName);
    }

    public static SystemMessageFile getPluginMessageFile() {
        return messageFile;
    }

    public static SystemMessage getPluginMessage(String msgId) {
        SystemMessage msg = RSEUIPlugin.getMessage(messageFile, msgId);
        if (msg == null) {
            msg = RSEUIPlugin.getMessage(defaultMessageFile, msgId);
        }
        return msg;
    }

    public static SystemMessage getPluginMessage(String msgId, Object[] subsVars) {
        SystemMessage msg = RSEUIPlugin.getMessage(messageFile, msgId);
        if (msg == null) {
            msg = RSEUIPlugin.getMessage(defaultMessageFile, msgId);
        }
        if (msg != null && subsVars != null && subsVars.length > 0 && msg.getNumSubstitutionVariables() > 0) {
            msg.makeSubstitution(subsVars);
        }
        return msg;
    }

    public static SystemMessage getPluginMessage(String msgId, Object subsVar) {
        SystemMessage msg = RSEUIPlugin.getMessage(messageFile, msgId);
        if (msg == null) {
            msg = RSEUIPlugin.getMessage(defaultMessageFile, msgId);
        }
        if (msg != null && subsVar != null && msg.getNumSubstitutionVariables() > 0) {
            msg.makeSubstitution(subsVar);
        }
        return msg;
    }

    public static String getLocalMachineName() {
        if (machineName == null) {
            try {
                machineName = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exc) {
                machineName = "";
                RSEUIPlugin.logWarning("Exception getting local hostname: " + exc.getClass().getName() + ": " + exc.getMessage());
            }
        }
        return machineName;
    }

    public static String getLocalMachineIPAddress() {
        if (machineIP == null) {
            try {
                machineIP = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception exc) {
                machineIP = "";
                RSEUIPlugin.logWarning("Exception getting local hostname: " + exc.getClass().getName() + ": " + exc.getMessage());
            }
        }
        return machineIP;
    }

    public void registerViewSupplier(ISystemViewSupplier vs) {
        this.viewSuppliers.add(vs);
    }

    public void unRegisterViewSupplier(ISystemViewSupplier vs) {
        if (this.viewSuppliers.contains(vs)) {
            this.viewSuppliers.remove(vs);
        }
    }

    protected void registerArchiveHandlers() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] systemTypeExtensions = registry.getConfigurationElementsFor(PLUGIN_ID, "archivehandlers");
        int i = 0;
        while (i < systemTypeExtensions.length) {
            String ext = systemTypeExtensions[i].getAttribute("fileNameExtension");
            if (ext.startsWith(".")) {
                ext = ext.substring(1);
            }
            String handlerType = systemTypeExtensions[i].getAttribute("class");
            try {
                String nameSpace = systemTypeExtensions[i].getDeclaringExtension().getNamespace();
                Bundle bundle = Platform.getBundle((String)nameSpace);
                if (bundle.getState() != 1) {
                    Class handler = bundle.loadClass(handlerType);
                    ArchiveHandlerManager.getInstance().setRegisteredHandler(ext, handler);
                }
            }
            catch (ClassNotFoundException e) {
                RSEUIPlugin.logError("Cound not find archive handler class", e);
            }
            ++i;
        }
    }

    protected void registerDynamicPopupMenuExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] systemTypeExtensions = registry.getConfigurationElementsFor(PLUGIN_ID, "dynamicPopupMenuExtensions");
        int i = 0;
        while (i < systemTypeExtensions.length) {
            try {
                String nameSpace = systemTypeExtensions[i].getDeclaringExtension().getNamespace();
                String menuExtensionType = systemTypeExtensions[i].getAttribute("class");
                Bundle bundle = Platform.getBundle((String)nameSpace);
                if (bundle.getState() != 1) {
                    Class menuExtension = bundle.loadClass(menuExtensionType);
                    ISystemDynamicPopupMenuExtension extension = (ISystemDynamicPopupMenuExtension)menuExtension.getConstructors()[0].newInstance(null);
                    SystemDynamicPopupMenuExtensionManager.getInstance().registerMenuExtension(extension);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    protected void registerKeystoreProviders() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] systemTypeExtensions = registry.getConfigurationElementsFor(PLUGIN_ID, "keystoreProviders");
        int i = 0;
        while (i < systemTypeExtensions.length) {
            try {
                String nameSpace = systemTypeExtensions[i].getDeclaringExtension().getNamespace();
                String keystoreProviderType = systemTypeExtensions[i].getAttribute("class");
                Bundle bundle = Platform.getBundle((String)nameSpace);
                if (bundle.getState() != 1) {
                    Class keystoreProvider = bundle.loadClass(keystoreProviderType);
                    ISystemKeystoreProvider extension = (ISystemKeystoreProvider)keystoreProvider.getConstructors()[0].newInstance(null);
                    SystemKeystoreProviderManager.getInstance().registerKeystoreProvider(extension);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public IRSEUIRegistry getRegistry() {
        return RSEUIRegistry.getDefault();
    }
}

