/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.actions;

import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.model.IHost;
import org.eclipse.rse.model.SystemResourceChangeEvent;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.swt.widgets.Shell;

public class SystemClearAllPasswordsAction
extends SystemBaseAction {
    public SystemClearAllPasswordsAction(Shell shell) {
        super(SystemResources.ACTION_CLEARPASSWORD_ALL_LABEL, SystemResources.ACTION_CLEARPASSWORD_ALL_TOOLTIP, shell);
        this.allowOnMultipleSelection(false);
        this.setContextMenuGroup("group.connection");
    }

    public boolean checkObjectType(Object selectedObject) {
        if (!(selectedObject instanceof IHost)) {
            return false;
        }
        IHost conn = (IHost)selectedObject;
        ISubSystem[] subsystems = conn.getSubSystems();
        boolean anyOk = false;
        int i = 0;
        while (i < subsystems.length) {
            ISubSystem subsystem = subsystems[i];
            IConnectorService system = subsystem.getConnectorService();
            boolean bl = anyOk = !system.isConnected() && system.isPasswordCached();
            if (anyOk) {
                return true;
            }
            ++i;
        }
        return anyOk;
    }

    public void run() {
        IHost conn = (IHost)this.getFirstSelection();
        ISubSystem[] subsystems = conn.getSubSystems();
        int i = 0;
        while (i < subsystems.length) {
            ISubSystem ss = subsystems[i];
            try {
                IConnectorService system = ss.getConnectorService();
                if (system.isPasswordCached()) {
                    system.getUserId();
                    system.clearPasswordCache(true);
                    RSEUIPlugin.getTheSystemRegistry().fireEvent(new SystemResourceChangeEvent(ss, 86, (Object)ss.getHost()));
                }
            }
            catch (Exception exception) {}
            ++i;
        }
    }
}

