/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.actions;

import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.filters.ISystemFilterPoolReference;
import org.eclipse.rse.filters.ISystemFilterReference;
import org.eclipse.rse.filters.ISystemFilterStringReference;
import org.eclipse.rse.model.IHost;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.actions.SystemBaseWizardAction;
import org.eclipse.rse.ui.wizards.SystemNewConnectionWizard;
import org.eclipse.swt.widgets.Shell;

public class SystemNewConnectionAction
extends SystemBaseWizardAction {
    private IHost currConn;
    private boolean fromPopupMenu = true;
    private ISelectionProvider sp = null;
    private String[] restrictSystemTypesTo;
    private String defaultConnectionName;
    private String defaultHostName;

    public SystemNewConnectionAction(Shell shell, boolean fromPopupMenu, ISelectionProvider sp) {
        this(shell, fromPopupMenu, true, sp);
    }

    public SystemNewConnectionAction(Shell shell, boolean fromPopupMenu, boolean wantIcon, ISelectionProvider sp) {
        this(shell, SystemResources.ACTION_NEWCONN_LABEL, SystemResources.ACTION_NEWCONN_TOOLTIP, fromPopupMenu, wantIcon, sp);
    }

    public SystemNewConnectionAction(Shell shell, String label, String tooltip, boolean fromPopupMenu, boolean wantIcon, ISelectionProvider sp) {
        super(label, tooltip, wantIcon ? RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.newconnection_wizIcon") : null, shell);
        this.setContextMenuGroup("group.new");
        this.fromPopupMenu = fromPopupMenu;
        this.sp = sp;
        this.setHelp("org.eclipse.rse.ui.actn0000");
    }

    protected IWizard createWizard() {
        SystemNewConnectionWizard newConnWizard = new SystemNewConnectionWizard();
        if (!this.fromPopupMenu && this.sp != null) {
            this.setSelection(this.sp.getSelection());
        }
        newConnWizard.setCurrentlySelectedConnection(this.currConn);
        if (this.restrictSystemTypesTo != null) {
            newConnWizard.restrictSystemTypes(this.restrictSystemTypesTo);
        }
        if (this.defaultHostName != null) {
            newConnWizard.setHostName(this.defaultHostName);
        }
        if (this.defaultConnectionName != null) {
            newConnWizard.setConnectionName(this.defaultConnectionName);
        }
        return newConnWizard;
    }

    public void setCurrentConnection(IHost conn) {
        this.currConn = conn;
    }

    public void restrictSystemType(String systemType) {
        this.restrictSystemTypesTo = new String[1];
        this.restrictSystemTypesTo[0] = systemType;
    }

    public void restrictSystemTypes(String[] systemTypes) {
        this.restrictSystemTypesTo = systemTypes;
    }

    public void setConnectionName(String name) {
        this.defaultConnectionName = name;
    }

    public void setHostName(String name) {
        this.defaultHostName = name;
    }

    public boolean updateSelection(IStructuredSelection selection) {
        boolean enable = super.updateSelection(selection);
        if (enable) {
            Object firstSelection = this.getFirstSelection();
            IHost conn = null;
            if (firstSelection != null) {
                if (firstSelection instanceof IHost) {
                    conn = (IHost)firstSelection;
                } else if (firstSelection instanceof ISubSystem) {
                    conn = ((ISubSystem)firstSelection).getHost();
                } else if (firstSelection instanceof ISystemFilterPoolReference) {
                    ISystemFilterPoolReference sfpr = (ISystemFilterPoolReference)firstSelection;
                    ISubSystem ss = (ISubSystem)sfpr.getProvider();
                    conn = ss.getHost();
                } else if (firstSelection instanceof ISystemFilterReference) {
                    ISystemFilterReference sfr = (ISystemFilterReference)firstSelection;
                    ISubSystem ss = (ISubSystem)sfr.getProvider();
                    conn = ss.getHost();
                } else if (firstSelection instanceof ISystemFilterStringReference) {
                    ISystemFilterStringReference sfsr = (ISystemFilterStringReference)firstSelection;
                    ISubSystem ss = (ISubSystem)sfsr.getProvider();
                    conn = ss.getHost();
                }
            }
            this.setCurrentConnection(conn);
        }
        return enable;
    }
}

