/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.actions;

import java.util.Iterator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.model.ISystemContainer;
import org.eclipse.rse.model.ISystemRegistry;
import org.eclipse.rse.model.ISystemResourceChangeListener;
import org.eclipse.rse.model.SystemResourceChangeEvent;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.swt.widgets.Shell;

public class SystemRefreshAction
extends SystemBaseAction {
    private IStructuredSelection _selection = null;

    public SystemRefreshAction(Shell parent) {
        super(SystemResources.ACTION_REFRESH_LABEL, SystemResources.ACTION_REFRESH_TOOLTIP, RSEUIPlugin.getDefault().getImageDescriptorFromIDE("elcl16/refresh_nav.gif"), parent);
        this.allowOnMultipleSelection(true);
        this.setContextMenuGroup("group.build");
        this.setHelp("org.eclipse.rse.ui.actn0017");
        this.setAvailableOffline(true);
    }

    public boolean updateSelection(IStructuredSelection selection) {
        boolean enable = true;
        this._selection = selection;
        return enable;
    }

    public void run() {
        ISystemRegistry sr = RSEUIPlugin.getTheSystemRegistry();
        if (this._selection != null) {
            Iterator iter = this._selection.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (obj instanceof ISystemContainer) {
                    ((ISystemContainer)obj).markStale(true);
                }
                sr.fireEvent(new SystemResourceChangeEvent(obj, 82, obj));
            }
        } else if (this.viewer != null && this.viewer instanceof ISystemResourceChangeListener) {
            sr.fireEvent((ISystemResourceChangeListener)this.viewer, new SystemResourceChangeEvent(sr, 83, null));
        } else {
            sr.fireEvent(new SystemResourceChangeEvent(sr, 83, null));
        }
    }
}

