/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.actions;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rse.model.IHost;
import org.eclipse.rse.ui.SystemResources;
import org.eclipse.rse.ui.actions.SystemBaseDialogAction;
import org.eclipse.rse.ui.dialogs.SystemSelectConnectionDialog;
import org.eclipse.swt.widgets.Shell;

public class SystemSelectConnectionAction
extends SystemBaseDialogAction {
    private boolean multiSelect;
    private boolean showPropertySheetInitialState;
    private boolean showPropertySheet;
    private String message;
    private boolean showNewConnectionPrompt = true;
    private String[] systemTypes;
    private String systemType;
    private IHost defaultConn;
    private Object result;

    public SystemSelectConnectionAction(Shell shell) {
        super(SystemResources.ACTION_SELECTCONNECTION_LABEL, SystemResources.ACTION_SELECTCONNECTION_TOOLTIP, (ImageDescriptor)null, shell);
    }

    public void setDefaultConnection(IHost conn) {
        this.defaultConn = conn;
    }

    public void setSystemTypes(String[] systemTypes) {
        this.systemTypes = systemTypes;
    }

    public void setSystemType(String systemType) {
        this.systemType = systemType;
    }

    public void setShowNewConnectionPrompt(boolean show) {
        this.showNewConnectionPrompt = show;
    }

    public void setInstructionLabel(String message) {
        this.message = message;
    }

    public void setShowPropertySheet(boolean show) {
        this.showPropertySheet = show;
    }

    public void setShowPropertySheet(boolean show, boolean initialState) {
        this.showPropertySheet = show;
        this.showPropertySheetInitialState = initialState;
    }

    public void setMultipleSelectionMode(boolean multiple) {
        this.multiSelect = multiple;
    }

    public IHost getSystemConnection() {
        if (this.result instanceof IHost) {
            return (IHost)this.result;
        }
        if (this.result instanceof IHost[]) {
            return ((IHost[])this.result)[0];
        }
        return null;
    }

    protected Dialog createDialog(Shell shell) {
        SystemSelectConnectionDialog selectDlg = new SystemSelectConnectionDialog(shell);
        if (this.defaultConn != null) {
            selectDlg.setDefaultConnection(this.defaultConn);
        }
        if (this.systemTypes != null) {
            selectDlg.setSystemTypes(this.systemTypes);
        } else if (this.systemType != null) {
            selectDlg.setSystemType(this.systemType);
        }
        selectDlg.setShowNewConnectionPrompt(this.showNewConnectionPrompt);
        if (this.message != null) {
            selectDlg.setInstructionLabel(this.message);
        }
        if (this.showPropertySheet) {
            selectDlg.setShowPropertySheet(this.showPropertySheet, this.showPropertySheetInitialState);
        }
        selectDlg.setMultipleSelectionMode(this.multiSelect);
        return selectDlg;
    }

    protected Object getDialogValue(Dialog dlg) {
        SystemSelectConnectionDialog selectDlg = (SystemSelectConnectionDialog)dlg;
        this.result = selectDlg.getOutputObject();
        return this.result;
    }
}

